#include <allegro.h>
#include <time.h> 
#include <string.h> 
#include <stdlib.h> 
#include "data.h"

#define for if( false ) {} else for

#define T_UP            1
#define T_RIGHT         2
#define T_DOWN          4
#define T_LEFT          8

#define UP              0
#define RIGHT           1
#define DOWN            2
#define LEFT            3

#define TILESIZE        32
#define MOVEMENT        8
#define SPOTSIZE        256
#define MAXIMUM         200
#define SMALL_MAP       2
#define CIRCLE_HEIGHT   40

#define PARALLEL_MAX    6

#define MAZE_WIDTH      61
#define MAZE_HEIGHT     51

#define D_MAZE_MIN      11
#define D_MAZE_MAX      239

#define START           11

//  classes

class D_MAZE
{
    //  variables
private:
    enum {D_MAZE_UP , D_MAZE_DOWN , D_MAZE_LEFT , D_MAZE_RIGHT};
    int  *mazeArray;

public:
    int mazeWidth;
    int mazeHeight;

    //  functions
public:
    D_MAZE( int w , int h , int t );        
    ~D_MAZE();    
    int getValue( int x , int y );
    void putValue( int x , int y , int c );
    D_MAZE  * makeCopy();

private:
    int random( int u );
    int squareRoot( int x , int y );
    void createMaze( int x , int y );
    void clearMaze();
    int funk( int k );
    void fixMaze();
};

class Point
{
public:
    int x;
    int y;
    int frame;
};

class Input
{
public:
    int up;
    int down;
    int left;
    int right;
};

//  Global Variables

RGB_MAP         rgb_table;
COLOR_MAP       light_table;
COLOR_MAP       trans_table;

BITMAP          *buffer , 
                *buffer1 , 
                *buffer2 , 
                *map1 , 
                *map2 , 
                *spotlight , 
                *parallax[ PARALLEL_MAX ];

DATAFILE        *data;

D_MAZE          *maze;

Point           player , 
                maiden , 
                monster , 
                parallel_axis_l[ 2 ] , 
                parallel_axis_r[ 2 ];

Input           input[ 2 ];

bool            tiedup , 
                sound_on ,
                showmap ,
                joy_enabled;

int             count ,
                counter ,
                *mapper ,
                style;

volatile int    timer , 
                framecounter ,
                lava;

//  Function Prototypes

int main();
void gameloop();
int initAll();
void deleteAll();
void inc_timer();
void inc_framecounter();
void inc_lava();
int distance( int x , int y );
void initSprite( BITMAP  *bmp );
void drawMaze( BITMAP  *bmp , int q );
void drawParallax( BITMAP  *bmp , int p );
void drawAll();
void drawScreen( BITMAP  *bmp );
bool hit_wall( int x , int y );
void do_move( int dir , Point &pt );
void move_maiden();
int random( int u );
void picFill( BITMAP  * source , BITMAP  * dest , int sx , int sy , int dx , int dy , int w , int h );
void drawWindow( BITMAP  *bmp , int x , int y , int x2 , int y2 );
void drawBorder( BITMAP  *bmp , int x , int y , int x2 , int y2 );
bool doYesOrNo( BITMAP  *bmp , char  * tx1 , char  * tx2 );
void doMessage( BITMAP  *bmp , int amount , ... );



//  main menu loop
int main()
{
    bool done = false;
    BITMAP  * under;
    int y[ 5 ] = { 160 , 220 , 280 , 340 , 400 } , p , h;
    char text[ 5 ][ 80 ] = { "Play Game" , "2 Player" , "How to Play" , "Credits" , "Quit Game" };

    if ( initAll() < 0 ) return  - 1;

    p = 0;
    h = ( text_height( ( FONT* )data[ MY_FONT ].dat ) - TILESIZE ) / 2;

    under = create_bitmap( TILESIZE , TILESIZE );
    blit( buffer , under , 100 , y[ p ] + h , 0 , 0 , TILESIZE , TILESIZE );

    while ( !done )
    {
        picFill( ( BITMAP *  )data[ BGROUND ].dat , buffer , 0 , 0 , 0 , 0 , SCREEN_W , SCREEN_H );

        for ( int i = -2; i < 3; i++ )
        {
            for ( int j = -2; j < 3; j++ )
            {
                textout_centre( buffer , ( FONT* )data[ MY_FONT3 ].dat , "The Monster and" , SCREEN_W / 2 + i , 20 + j , 32 );
                textout_centre( buffer , ( FONT* )data[ MY_FONT3 ].dat , "the Maiden" , SCREEN_W / 2 + i , 80 + j , 32 );
            }
        }

        textout_centre( buffer , ( FONT* )data[ MY_FONT3 ].dat , "The Monster and" , SCREEN_W / 2 , 20 , 10 );
        textout_centre( buffer , ( FONT* )data[ MY_FONT3 ].dat , "the Maiden" , SCREEN_W / 2 , 80 , 10 );

        for ( int i = 0; i < 5; i++  )
        {
            textout( buffer , ( FONT* )data[ MY_FONT ].dat , text[ i ] , 280 , y[ i ] , 255 );
        }

        draw_sprite( buffer , ( BITMAP *  )data[ ARROW ].dat , SCREEN_H / 2 , y[ p ] + h );

        drawScreen( buffer );


        if ( key[ KEY_UP ] )
        {
            while ( key[ KEY_UP ] ) {}
            blit( under , buffer , 0 , 0 , 100 , y[ p ] + h , TILESIZE , TILESIZE );

            p-- ;
            if ( p < 0 ) p = 4;

            blit( buffer , under , 100 , y[ p ] + h , 0 , 0 , TILESIZE , TILESIZE );
        }

        if ( key[ KEY_DOWN ] )
        {
            while ( key[ KEY_DOWN ] ) {}
            blit( under , buffer , 0 , 0 , 100 , y[ p ] + h , TILESIZE , TILESIZE );

            p++ ;
            if ( p > 4 ) p = 0;

            blit( buffer , under , 100 , y[ p ] + h , 0 , 0 , TILESIZE , TILESIZE );
        }

        if ( key[ KEY_ENTER ] )
        {
            while ( key[ KEY_ENTER ] ) {}
            switch ( p )
            {
            case 0:
                {
                    gameloop();
                } break;
            case 1:
                {
                    if ( style == 0 )
                    {
                        style = 1;
                        strcpy( text[ 1 ] , "1 Player" );
                    }
                    else
                    {
                        style = 0;
                        strcpy( text[ 1 ] , "2 Player" );
                    }
                } break;
            case 2:
                {
                    doMessage( buffer , 8 , 
                        "The Monster and the Maiden" , 
                        "   " , 
                        "The Hero:" , 
                        "The hero must search the labrynth" , 
                        "for the maiden. If the hero can" , 
                        "successfully find the maiden and" , 
                        "return her to the starting point" , 
                        "then the hero wins." );

                    doMessage( buffer , 11 , 
                        "The Monster and the Maiden" , 
                        "   " , 
                        "The Monster:" , 
                        "The monster must also search the" , 
                        "labrynth for the maiden. If the" , 
                        "monster can find the maiden or" , 
                        "the monster runs into the hero" , 
                        "then the monster wins." , 
                        "" , 
                        "( Note: The monster only has to" , 
                        "touch to maiden / player to win )" );


                    doMessage( buffer , 15 , 
                        "The Monster and the Maiden" , 
                        "" ,
                        "1 Player:" ,  
                        "Arrow Keys or" , 
                        "Joystick (if installed)" , 
                        "" , 
                        "2 Players:" ,  
                        "Player: Arrow Keys" , 
                        "Monster: W,A,S,Z or" , 
                        "Joystick (if installed)" , 
                        "" , 
                        "F2 Toggles Map" , 
                        "F3 Toggles Sound" , 
                        "" , 
                        "Esc Quits" );
 
                } break;
            case 3:
                {
                    doMessage( buffer , 5 , 
                        "The Monster and the Maiden" , 
                        "   " , 
                        "Daniel Harmon" , 
                        "Email: dl_harmon @ yahoo.com" , 
                        "Web Site: agdn.cjb.net" );
                } break;
            case 4:
                {
                    if ( doYesOrNo( buffer , "Are you sure that" , "you want to Quit?" ) )
                    {
                        fade_out( 1 );
                        done = true;
                    }
                } break;
            }            
        }

        if ( key[ KEY_ESC ] )
        {
            if ( doYesOrNo( buffer , "Are you sure that" , "you want to Quit?" ) )
            {
                fade_out( 3 );
                done = true;
            }
        }
    }

    while ( key[ KEY_ESC ] ) {}

    destroy_bitmap( under );

    deleteAll();

    set_gfx_mode( GFX_TEXT , 0 , 0 , 0 , 0 );

    return 1;
}
END_OF_MAIN();

int joystick_value( int dir )
{
    if ( joy_enabled )
    {
        switch ( dir )
        {
        case UP:
            {
                return joy[0].stick[0].axis[1].d1;
            }
        case DOWN:
            {
                return joy[0].stick[0].axis[1].d2;
            }
        case LEFT:
            {
                return joy[0].stick[0].axis[0].d1;
            }
        case RIGHT:
            {
                return joy[0].stick[0].axis[0].d2;
            }
        }
    }

    return 0;
}

int new_direction( int x , int y , int dir )
{
    int xx[ 4 ][ 3 ] = { {    0 ,   -1 ,     1 } , {   -1 ,  0 ,    0 } , {  0 ,   -1 ,     1 } , {     1 ,  0 ,    0 } } ,
        yy[ 4 ][ 3 ] = { {    1 ,    0 ,     0 } , {    0 , -1 ,    1 } , { -1 ,    0 ,     0 } , {     0 , -1 ,    1 } } ,
         d[ 4 ][ 3 ] = { { DOWN , LEFT , RIGHT } , { LEFT , UP , DOWN } , { UP , LEFT , RIGHT } , { RIGHT , UP , DOWN } } ,
         p = dir / 2;

    
        if ( maze->getValue( x - xx[ p ][ 0 ] , y - yy[ p ][ 0 ] ) == 0 )
        {
            if ( maze->getValue( x + xx[ p ][ 1 ] , y + yy[ p ][ 1 ] ) == 0 &&
                 maze->getValue( x + xx[ p ][ 2 ] , y + yy[ p ][ 2 ] ) == 0 )
            {
                return d[ p ][ 0 ] * 2;
            }
            if ( maze->getValue( x + xx[ p ][ 1 ] , y + yy[ p ][ 1 ] ) != 0 &&
                 maze->getValue( x + xx[ p ][ 2 ] , y + yy[ p ][ 2 ] ) == 0 )
            {
                return d[ p ][ 1 ] * 2;
            }
            if ( maze->getValue( x + xx[ p ][ 1 ] , y + yy[ p ][ 1 ] ) == 0 &&
                 maze->getValue( x + xx[ p ][ 2 ] , y + yy[ p ][ 2 ] ) != 0 )
            {
                return d[ p ][ 2 ] * 2;
            }
            if ( maze->getValue( x + xx[ p ][ 1 ] , y + yy[ p ][ 1 ] ) != 0 &&
                 maze->getValue( x + xx[ p ][ 2 ] , y + yy[ p ][ 2 ] ) != 0 )
            {
                if ( getpixel( map2 , x + xx[ p ][ 1 ] , y + yy[ p ][ 1 ] ) == 0 &&
                     getpixel( map2 , x + xx[ p ][ 2 ] , y + yy[ p ][ 2 ] ) == 12 )
                {
                    return d[ p ][ 1 ] * 2;
                }
                if ( getpixel( map2 , x + xx[ p ][ 1 ] , y + yy[ p ][ 1 ] ) == 12 &&
                     getpixel( map2 , x + xx[ p ][ 2 ] , y + yy[ p ][ 2 ] ) == 0 )
                {
                    return d[ p ][ 2 ] * 2;
                }
                
                if ( mapper[ x + xx[ p ][ 1 ] + ( y + yy[ p ][ 1 ] ) * MAZE_WIDTH ] <
                     mapper[ x + xx[ p ][ 2 ] + ( y + yy[ p ][ 2 ] ) * MAZE_WIDTH ] )
                {
                    return d[ p ][ 1 ] * 2;
                }
                if ( mapper[ x + xx[ p ][ 1 ] + ( y + yy[ p ][ 1 ] ) * MAZE_WIDTH ] >
                     mapper[ x + xx[ p ][ 2 ] + ( y + yy[ p ][ 2 ] ) * MAZE_WIDTH ] )
                {
                    return d[ p ][ 2 ] * 2;
                }

                if ( random( 2 ) == 0 )
                {
                    return d[ p ][ 1 ] * 2;
                }
                else
                {
                    return d[ p ][ 2 ] * 2;
                }
            }
        }
        else
        {
            if ( maze->getValue( x + xx[ p ][ 1 ] , y + yy[ p ][ 1 ] ) != 0 &&
                 maze->getValue( x + xx[ p ][ 2 ] , y + yy[ p ][ 2 ] ) == 0 )
            {
                if ( getpixel( map2 , x + xx[ p ][ 0 ] , y + yy[ p ][ 0 ] ) == 12 &&
                     getpixel( map2 , x + xx[ p ][ 1 ] , y + yy[ p ][ 1 ] ) == 0 )
                {
                    return d[ p ][ 1 ] * 2;
                }
                if ( getpixel( map2 , x + xx[ p ][ 0 ] , y + yy[ p ][ 0 ] ) == 0 &&
                     getpixel( map2 , x + xx[ p ][ 1 ] , y + yy[ p ][ 1 ] ) == 12 )
                {
                    return dir;
                }
                if ( mapper[ x + xx[ p ][ 0 ] + ( y + yy[ p ][ 0 ] ) * MAZE_WIDTH ] <
                     mapper[ x + xx[ p ][ 1 ] + ( y + yy[ p ][ 1 ] ) * MAZE_WIDTH ] )
                {
                    return dir;
                }
                if ( mapper[ x + xx[ p ][ 0 ] + ( y + yy[ p ][ 0 ] ) * MAZE_WIDTH ] >
                     mapper[ x + xx[ p ][ 1 ] + ( y + yy[ p ][ 1 ] ) * MAZE_WIDTH ] )
                {
                    return d[ p ][ 1 ] * 2;
                }

                if ( random( 2 ) == 0 )
                {
                    return dir;
                }
                else
                {
                    return d[ p ][ 1 ] * 2;
                }
            }
            if ( maze->getValue( x + xx[ p ][ 1 ] , y + yy[ p ][ 1 ] ) == 0 &&
                 maze->getValue( x + xx[ p ][ 2 ] , y + yy[ p ][ 2 ] ) != 0 )
            {
                if ( getpixel( map2 , x + xx[ p ][ 0 ] , y + yy[ p ][ 0 ] ) == 12 &&
                     getpixel( map2 , x + xx[ p ][ 2 ] , y + yy[ p ][ 2 ] ) == 0 )
                {
                    return d[ p ][ 2 ] * 2;
                }
                if ( getpixel( map2 , x + xx[ p ][ 0 ] , y + yy[ p ][ 0 ] ) == 0 &&
                     getpixel( map2 , x + xx[ p ][ 2 ] , y + yy[ p ][ 2 ] ) == 12 )
                {
                    return dir;
                }
                if ( mapper[ x + xx[ p ][ 0 ] + ( y + yy[ p ][ 0 ] ) * MAZE_WIDTH ] <
                     mapper[ x + xx[ p ][ 2 ] + ( y + yy[ p ][ 2 ] ) * MAZE_WIDTH ] )
                {
                    return dir;
                }
                if ( mapper[ x + xx[ p ][ 0 ] + ( y + yy[ p ][ 0 ] ) * MAZE_WIDTH ] >
                     mapper[ x + xx[ p ][ 2 ] + ( y + yy[ p ][ 2 ] ) * MAZE_WIDTH ] )
                {
                    return d[ p ][ 2 ] * 2;
                }
                if ( random( 2 ) == 0 )
                {
                    return dir;
                }
                else
                {
                    return d[ p ][ 2 ] * 2;
                }
            }
            if ( maze->getValue( x + xx[ p ][ 1 ] , y + yy[ p ][ 1 ] ) != 0 &&
                 maze->getValue( x + xx[ p ][ 2 ] , y + yy[ p ][ 2 ] ) != 0 )
            {
                if ( getpixel( map2 , x + xx[ p ][ 0 ] , y + yy[ p ][ 0 ] ) == 0 &&
                     getpixel( map2 , x + xx[ p ][ 1 ] , y + yy[ p ][ 1 ] ) == 12 &&
                     getpixel( map2 , x + xx[ p ][ 2 ] , y + yy[ p ][ 2 ] ) == 12 )
                {
                    return dir;
                }
                if ( getpixel( map2 , x + xx[ p ][ 0 ] , y + yy[ p ][ 0 ] ) == 12 &&
                     getpixel( map2 , x + xx[ p ][ 1 ] , y + yy[ p ][ 1 ] ) == 0 &&
                     getpixel( map2 , x + xx[ p ][ 2 ] , y + yy[ p ][ 2 ] ) == 12 )
                {
                    return d[ p ][ 1 ] * 2;
                }
                if ( getpixel( map2 , x + xx[ p ][ 0 ] , y + yy[ p ][ 0 ] ) == 12 &&
                     getpixel( map2 , x + xx[ p ][ 1 ] , y + yy[ p ][ 1 ] ) == 12 &&
                     getpixel( map2 , x + xx[ p ][ 2 ] , y + yy[ p ][ 2 ] ) == 0 )
                {
                    return d[ p ][ 2 ] * 2;
                }
                if ( getpixel( map2 , x + xx[ p ][ 0 ] , y + yy[ p ][ 0 ] ) == 0 &&
                     getpixel( map2 , x + xx[ p ][ 1 ] , y + yy[ p ][ 1 ] ) == 0 &&
                     getpixel( map2 , x + xx[ p ][ 2 ] , y + yy[ p ][ 2 ] ) == 12 )
                {
                    if ( mapper[ x + xx[ p ][ 0 ] + ( y + yy[ p ][ 0 ] ) * MAZE_WIDTH ] <
                        mapper[ x + xx[ p ][ 1 ] + ( y + yy[ p ][ 1 ] ) * MAZE_WIDTH ] )
                    {
                        return dir;
                    }
                    if ( mapper[ x + xx[ p ][ 0 ] + ( y + yy[ p ][ 0 ] ) * MAZE_WIDTH ] >
                        mapper[ x + xx[ p ][ 1 ] + ( y + yy[ p ][ 1 ] ) * MAZE_WIDTH ] )
                    {
                        return d[ p ][ 1 ] * 2;
                    }
                    if ( random( 2 ) == 0 )
                    {
                        return dir;
                    }
                    else
                    {
                        return d[ p ][ 1 ] * 2;
                    }
                }
                if ( getpixel( map2 , x + xx[ p ][ 0 ] , y + yy[ p ][ 0 ] ) == 0 &&
                     getpixel( map2 , x + xx[ p ][ 1 ] , y + yy[ p ][ 1 ] ) == 12 &&
                     getpixel( map2 , x + xx[ p ][ 2 ] , y + yy[ p ][ 2 ] ) == 0 )
                {
                    if ( mapper[ x + xx[ p ][ 0 ] + ( y + yy[ p ][ 0 ] ) * MAZE_WIDTH ] <
                        mapper[ x + xx[ p ][ 2 ] + ( y + yy[ p ][ 2 ] ) * MAZE_WIDTH ] )
                    {
                        return dir;
                    }
                    if ( mapper[ x + xx[ p ][ 0 ] + ( y + yy[ p ][ 0 ] ) * MAZE_WIDTH ] >
                        mapper[ x + xx[ p ][ 2 ] + ( y + yy[ p ][ 2 ] ) * MAZE_WIDTH ] )
                    {
                        return d[ p ][ 2 ] * 2;
                    }
                    if ( random( 2 ) == 0 )
                    {
                        return dir;
                    }
                    else
                    {
                        return d[ p ][ 2 ] * 2;
                    }
                }
                if ( getpixel( map2 , x + xx[ p ][ 0 ] , y + yy[ p ][ 0 ] ) == 12 &&
                     getpixel( map2 , x + xx[ p ][ 1 ] , y + yy[ p ][ 1 ] ) == 0 &&
                     getpixel( map2 , x + xx[ p ][ 2 ] , y + yy[ p ][ 2 ] ) == 0 )
                {
                    if ( mapper[ x + xx[ p ][ 1 ] + ( y + yy[ p ][ 1 ] ) * MAZE_WIDTH ] <
                         mapper[ x + xx[ p ][ 2 ] + ( y + yy[ p ][ 2 ] ) * MAZE_WIDTH ] )
                    {
                        return d[ p ][ 1 ] * 2;
                    }
                    if ( mapper[ x + xx[ p ][ 1 ] + ( y + yy[ p ][ 1 ] ) * MAZE_WIDTH ] >
                        mapper[ x + xx[ p ][ 2 ] + ( y + yy[ p ][ 2 ] ) * MAZE_WIDTH ] )
                    {
                        return d[ p ][ 2 ] * 2;
                    }
                    if ( random( 2 ) == 0 )
                    {
                        return d[ p ][ 1 ] * 2;
                    }
                    else
                    {
                        return d[ p ][ 2 ] * 2;
                    }
                }
                if ( ( mapper[ x + xx[ p ][ 0 ] + ( y + yy[ p ][ 0 ] ) * MAZE_WIDTH ] !=
                       mapper[ x + xx[ p ][ 1 ] + ( y + yy[ p ][ 1 ] ) * MAZE_WIDTH ] ) ||
                     ( mapper[ x + xx[ p ][ 0 ] + ( y + yy[ p ][ 0 ] ) * MAZE_WIDTH ] !=
                       mapper[ x + xx[ p ][ 2 ] + ( y + yy[ p ][ 2 ] ) * MAZE_WIDTH ] ) ||
                     ( mapper[ x + xx[ p ][ 1 ] + ( y + yy[ p ][ 1 ] ) * MAZE_WIDTH ] !=
                       mapper[ x + xx[ p ][ 2 ] + ( y + yy[ p ][ 2 ] ) * MAZE_WIDTH ] ) )
                {
                    int l = 0;

                    if ( mapper[ x + xx[ p ][ 0 ] + ( y + yy[ p ][ 0 ] ) * MAZE_WIDTH ] < 
                         mapper[ x + xx[ p ][ 1 ] + ( y + yy[ p ][ 1 ] ) * MAZE_WIDTH ] )
                    {
                        l = 1;
                    }
                    if ( mapper[ x + xx[ p ][ l ] + ( y + yy[ p ][ l ] ) * MAZE_WIDTH ] < 
                         mapper[ x + xx[ p ][ 2 ] + ( y + yy[ p ][ 2 ] ) * MAZE_WIDTH ] )
                    {
                        l = 2;
                    }
                    switch( l )
                    {
                    case 0:
                        return dir; break;
                    case 1:
                        return d[ p ][ 1 ] * 2; break;
                    case 2:
                        return d[ p ][ 2 ] * 2; break;
                    }
                }


                switch( random( 3 ) )
                {
                case 0:
                    return dir; break;
                case 1:
                    return d[ p ][ 1 ] * 2; break;
                case 2:
                    return d[ p ][ 2 ] * 2; break;
                }
            }
        }

    return dir;
}

void pacman()
{
    if ( monster.x % TILESIZE == 0 && monster.y % TILESIZE == 0 )
    {
        monster.frame = new_direction( monster.x / TILESIZE , monster.y / TILESIZE , monster.frame );
    }

    switch ( monster.frame / 2 )
    {
    case LEFT :
            {
                if ( !hit_wall( monster.x - MOVEMENT , monster.y ) )
                {
                    monster.x -= MOVEMENT;
                    parallel_axis_l[ 1 ].x += MOVEMENT / 2;
                    parallel_axis_r[ 1 ].x += MOVEMENT / 2;
                    if ( framecounter % 3 == 0 )
                        monster.frame++ ;
                    if ( monster.frame < 6 || monster.frame > 7 ) monster.frame = 6;
                }
            } break;
    case RIGHT :
            {
                if ( !hit_wall( monster.x + MOVEMENT , monster.y ) )
                {
                    monster.x += MOVEMENT;
                    parallel_axis_l[ 1 ].x -= MOVEMENT / 2;
                    parallel_axis_r[ 1 ].x -= MOVEMENT / 2;
                    if ( framecounter % 3 == 0 )
                        monster.frame++ ;
                    if ( monster.frame < 2 || monster.frame > 3 ) monster.frame = 2;
                }
            } break;
    case UP :
            {
                if ( !hit_wall( monster.x , monster.y - MOVEMENT ) )
                {
                    monster.y -= MOVEMENT;
                    parallel_axis_l[ 1 ].y += MOVEMENT / 2;
                    parallel_axis_r[ 1 ].y += MOVEMENT / 2;
                    if ( framecounter % 3 == 0 )
                        monster.frame++ ;
                    if ( monster.frame > 1 ) monster.frame = 0;
                }
            } break;
    case DOWN :
            {
                if ( !hit_wall( monster.x , monster.y + MOVEMENT ) )
                {
                    monster.y += MOVEMENT;
                    parallel_axis_l[ 1 ].y -= MOVEMENT / 2;
                    parallel_axis_r[ 1 ].y -= MOVEMENT / 2;
                    if ( framecounter % 3 == 0 )
                        monster.frame++ ;
                    if ( monster.frame < 4 || monster.frame > 5 ) monster.frame = 4;
                }
            } break;
    }

    if ( mapper[ monster.x + monster.y * MAZE_WIDTH ] != counter )
    {
        mapper[ monster.x + monster.y * MAZE_WIDTH ] = counter++;
    }
}

void poll_input()
{
    for ( int i = 0; i < 2; i++ )
    {
        input[ i ].up    = 0;
        input[ i ].down  = 0;
        input[ i ].left  = 0;
        input[ i ].right = 0;
    }
   
    if ( joy_enabled )
    {
        poll_joystick();
    }

    if ( style == 0 )
    {
        if ( key[ KEY_UP    ] ) input[ 0 ].up    = 1;
        if ( key[ KEY_DOWN  ] ) input[ 0 ].down  = 1;
        if ( key[ KEY_LEFT  ] ) input[ 0 ].left  = 1;
        if ( key[ KEY_RIGHT ] ) input[ 0 ].right = 1;

        if ( key[ KEY_W ] || joystick_value( UP    ) ) input[ 1 ].up    = 1;
        if ( key[ KEY_Z ] || joystick_value( DOWN  ) ) input[ 1 ].down  = 1;
        if ( key[ KEY_A ] || joystick_value( LEFT  ) ) input[ 1 ].left  = 1;
        if ( key[ KEY_S ] || joystick_value( RIGHT ) ) input[ 1 ].right = 1;
    }
    else
    {
        if ( key[ KEY_UP    ] || joystick_value( UP    ) ) input[ 0 ].up    = 1;
        if ( key[ KEY_DOWN  ] || joystick_value( DOWN  ) ) input[ 0 ].down  = 1;
        if ( key[ KEY_LEFT  ] || joystick_value( LEFT  ) ) input[ 0 ].left  = 1;
        if ( key[ KEY_RIGHT ] || joystick_value( RIGHT ) ) input[ 0 ].right = 1;
    }
}

//  main loop
void gameloop()
{
    bool done = false , 
         move = false , 
         f2k = false ,
         f3k = false;
    int angle1 = random( 256 ) , angle2 = random( 256 );

    maze  =  new D_MAZE( MAZE_WIDTH , MAZE_HEIGHT , 1 );

    clear_bitmap( map1 );
    clear_bitmap( map2 );
    rect( map1 , 0 , 0 , MAZE_WIDTH - 1 , MAZE_HEIGHT - 1 , 156 );
    rect( map2 , 0 , 0 , MAZE_WIDTH - 1 , MAZE_HEIGHT - 1 , 156 );

    player.x = START * TILESIZE;
    player.y = START * TILESIZE;
    player.frame = 4;

    parallel_axis_l[ 0 ].x = 
    parallel_axis_l[ 0 ].y = 
    parallel_axis_l[ 1 ].x = 
    parallel_axis_l[ 1 ].y = 0;

    monster.x = ( maze->mazeWidth - START - 1 ) * TILESIZE;
    monster.y = ( maze->mazeHeight - START - 1 ) * TILESIZE;
    monster.frame = 4;

    while ( !done)
    {
        maiden.x = random( maze->mazeWidth - START * 2 ) + START;
        maiden.y = random( maze->mazeHeight - START * 2 ) + START;
        maiden.frame = 4;

        if ( key[ KEY_ESC ] ||
             (  maze->getValue( maiden.x , maiden.y ) != 0 &&
                maiden.x > START + 8 && 
                maiden.y > START + 8 &&
                maiden.x < MAZE_WIDTH - START - 8 &&
                maiden.y < MAZE_HEIGHT - START - 8 ) ) done = true;
    }
    done = false;

    maiden.x *= TILESIZE;
    maiden.y *= TILESIZE;

    tiedup = true;

    clear_bitmap( buffer );

    if ( sound_on )
    {
        play_midi( (MIDI*)data[ MUSIC ].dat , TRUE );
    }

    while ( !done )
    {
        drawAll();

        if ( timer  ==  1 )
        {
            timer = 0;

            if ( random( 100 ) > 80 )
            {                
                if ( random( 2 )  ==  0 )
                {
                    angle1 = angle1 - ( random( 10 ) + 1 );
                }
                else
                {
                    angle1 = angle1 + ( random( 10 ) + 1 );
                }
            }
            
            parallel_axis_l[ 0 ].x = parallel_axis_l[ 0 ].x + fixtoi( fcos( itofix( angle1 ) ) );
            parallel_axis_l[ 0 ].y = parallel_axis_l[ 0 ].y + fixtoi( fsin( itofix( angle1 ) ) );        
            parallel_axis_l[ 1 ].x = parallel_axis_l[ 1 ].x + fixtoi( fcos( itofix( angle1 ) ) );
            parallel_axis_l[ 1 ].y = parallel_axis_l[ 1 ].y + fixtoi( fsin( itofix( angle1 ) ) );

            if ( random( 100 ) > 80 )
            {                
                if ( random( 2 )  ==  0 )
                {
                    angle2 = angle2 - ( random( 10 ) + 1 );
                }
                else
                {
                    angle2 = angle2 + ( random( 10 ) + 1 );
                }
            }

            parallel_axis_r[ 0 ].x = parallel_axis_r[ 0 ].x - fixtoi( fcos( itofix( angle2 ) ) );
            parallel_axis_r[ 0 ].y = parallel_axis_r[ 0 ].y - fixtoi( fsin( itofix( angle2 ) ) );        
            parallel_axis_r[ 1 ].x = parallel_axis_r[ 1 ].x - fixtoi( fcos( itofix( angle2 ) ) );
            parallel_axis_r[ 1 ].y = parallel_axis_r[ 1 ].y - fixtoi( fsin( itofix( angle2 ) ) );

            if ( key[ KEY_F2 ] )
            {
                if ( !f2k )
                {
                    f2k = true;
                    if ( showmap )
                    {
                        showmap = false;
                    }
                    else
                    {
                        showmap = true;
                    }
                }
            }
            else
            {
                f2k = false;
            }

            if ( key[ KEY_F3 ] )
            {
                if ( !f3k )
                {
                    f3k = true;
                    if ( sound_on )
                    {
                        sound_on = false;
                        play_midi( NULL , TRUE ); 
                    }
                    else
                    {
                        sound_on = true;
                        play_midi( (MIDI*)data[ MUSIC ].dat , TRUE );                    
                    }
                }
            }
            else
            {
                f3k = false;
            }

            poll_input();

            //  move player
            if ( input[ 0 ].left )
            {
                if ( !hit_wall( player.x - MOVEMENT , player.y ) )
                {
                    move = true;
                    player.x -= MOVEMENT;
                    parallel_axis_l[ 0 ].x += MOVEMENT / 2;
                    parallel_axis_r[ 0 ].x += MOVEMENT / 2;
                    if ( framecounter % 3 == 0 )
                        player.frame++ ;
                    if ( player.frame < 6 || player.frame > 7 ) player.frame = 6;
                }
            }
            if ( input[ 0 ].right )
            {
                if ( !hit_wall( player.x + MOVEMENT , player.y ) )
                {
                    move = true;
                    player.x += MOVEMENT;
                    parallel_axis_l[ 0 ].x -= MOVEMENT / 2;
                    parallel_axis_r[ 0 ].x -= MOVEMENT / 2;
                    if ( framecounter % 3 == 0 )
                        player.frame++ ;
                    if ( player.frame < 2 || player.frame > 3 ) player.frame = 2;
                }
            }
            if ( input[ 0 ].up )
            {
                if ( !hit_wall( player.x , player.y - MOVEMENT ) )
                {
                    move = true;
                    player.y -= MOVEMENT;
                    parallel_axis_l[ 0 ].y += MOVEMENT / 2;
                    parallel_axis_r[ 0 ].y += MOVEMENT / 2;
                    if ( framecounter % 3 == 0 )
                        player.frame++ ;
                    if ( player.frame > 1 ) player.frame = 0;
                }
            }
            if ( input[ 0 ].down )
            {
                if ( !hit_wall( player.x , player.y + MOVEMENT ) )
                {
                    move = true;
                    player.y += MOVEMENT;
                    parallel_axis_l[ 0 ].y -= MOVEMENT / 2;
                    parallel_axis_r[ 0 ].y -= MOVEMENT / 2;
                    if ( framecounter % 3 == 0 )
                        player.frame++ ;
                    if ( player.frame < 4 || player.frame > 5 ) player.frame = 4;
                }
            }

            if ( style == 1 )
            {
                pacman();
            }
            else
            {
                //  move monster
                if ( input[ 1 ].left )
                {
                    if ( !hit_wall( monster.x - MOVEMENT , monster.y ) )
                    {
                        monster.x -= MOVEMENT;
                        parallel_axis_l[ 1 ].x += MOVEMENT / 2;
                        parallel_axis_r[ 1 ].x += MOVEMENT / 2;
                        if ( framecounter % 3 == 0 )
                            monster.frame++ ;
                        if ( monster.frame < 6 || monster.frame > 7 ) monster.frame = 6;
                    }
                }
                if ( input[ 1 ].right )
                {
                    if ( !hit_wall( monster.x + MOVEMENT , monster.y ) )
                    {
                        monster.x += MOVEMENT;
                        parallel_axis_l[ 1 ].x -= MOVEMENT / 2;
                        parallel_axis_r[ 1 ].x -= MOVEMENT / 2;
                        if ( framecounter % 3 == 0 )
                            monster.frame++ ;
                        if ( monster.frame < 2 || monster.frame > 3 ) monster.frame = 2;
                    }
                }
                if ( input[ 1 ].up )
                {
                    if ( !hit_wall( monster.x , monster.y - MOVEMENT ) )
                    {
                        monster.y -= MOVEMENT;
                        parallel_axis_l[ 1 ].y += MOVEMENT / 2;
                        parallel_axis_r[ 1 ].y += MOVEMENT / 2;
                        if ( framecounter % 3 == 0 )
                            monster.frame++ ;
                        if ( monster.frame > 1 ) monster.frame = 0;
                    }
                }
                if ( input[ 1 ].down )
                {
                    if ( !hit_wall( monster.x , monster.y + MOVEMENT ) )
                    {
                        monster.y += MOVEMENT;
                        parallel_axis_l[ 1 ].y -= MOVEMENT / 2;
                        parallel_axis_r[ 1 ].y -= MOVEMENT / 2;
                        if ( framecounter % 3 == 0 )
                            monster.frame++ ;
                        if ( monster.frame < 4 || monster.frame > 5 ) monster.frame = 4;
                    }
                }
            }
            if ( tiedup )
            {
                if ( ABS( player.x - maiden.x ) < TILESIZE && ABS( player.y - maiden.y ) < TILESIZE )
                {
                    tiedup = false;
                }
            }
            else
            {
                if ( move )
                {
                    move_maiden();
                    move = false;
                }
                if ( maiden.x / TILESIZE - START < 1 && maiden.y / TILESIZE - START < 1 &&
                     player.x / TILESIZE - START < 1 && player.y / TILESIZE - START < 1 )
                {
                    drawAll();
                    textout_centre( buffer , ( FONT* )data[ MY_FONT ].dat , "The Maiden is Safe!" , SCREEN_W / 2 , SCREEN_H / 2 , 255 );
                    textout_centre( buffer , font , "Press Enter to Continue" , SCREEN_W / 2 , 440 , 255 );
                    drawScreen( buffer );
                    
                    while ( !key[ KEY_ENTER ] ) {}
                    while ( key[ KEY_ENTER ] ) {}                       

                    fade_out( 3 );
                    done = true;
                }
            }

            if ( ABS( monster.x - player.x ) < TILESIZE && ABS( monster.y - player.y ) < TILESIZE ) 
            {
                drawAll();
                textout_centre( buffer , ( FONT* )data[ MY_FONT ].dat , "The Player is Dead!" , SCREEN_W / 2 , SCREEN_H / 2 , 255 );
                textout_centre( buffer , ( FONT* )data[ MY_FONT2 ].dat , "Press Enter to Continue" , SCREEN_W / 2 , 440 , 255 );
                drawScreen( buffer );
                while ( !key[ KEY_ENTER ] ) {}
                while ( key[ KEY_ENTER ] ) {}   
                fade_out( 3 );
                done = true;
            }

            if ( ABS( monster.x - maiden.x ) < TILESIZE && ABS( monster.y - maiden.y ) < TILESIZE )
            {
                drawAll();
                textout_centre( buffer , ( FONT* )data[ MY_FONT ].dat , "The Maiden is Dead!" , SCREEN_W / 2 , SCREEN_H / 2 , 255 );
                textout_centre( buffer , ( FONT* )data[ MY_FONT2 ].dat , "Press Enter to Continue" , SCREEN_W / 2 , 440 , 255 );
                drawScreen( buffer );
                while ( !key[ KEY_ENTER ] ) {}
                while ( key[ KEY_ENTER ] ) {}   
                fade_out( 3 );
                done = true;
            }
        }

        if ( key[ KEY_ESC ] )
        {
            if ( doYesOrNo( buffer , "Are you sure that" , "you want to Quit?" ) )
            {
                fade_out( 3 );
                done = true;
            }
        }
    }

    if ( sound_on )
    {
        play_midi( NULL , FALSE );
    }


    acquire_screen();
    clear_bitmap( screen );
    release_screen();

    set_palette( ( RGB *  )data[ MY_PAL ].dat );

    while ( key[ KEY_ESC ] ) {}

    delete maze;

}

//  initialize allegro and the data
int initAll()
{
    allegro_init();
    install_keyboard();
    install_timer();
    install_mouse();
	
    if ( install_sound( DIGI_AUTODETECT , MIDI_AUTODETECT , NULL ) !=  0 ) 
    {
        allegro_message( "Unable initialize sound module\n % s\n" , allegro_error );
        return  - 1;
    }

    if ( set_gfx_mode( GFX_AUTODETECT , 640 , 480 , 0 , 0 )!= 0 )
    {
        allegro_message( "Unable initialize graphics module\n % s\n" , allegro_error );
        return  - 1;
    }

    data = load_datafile( "data.dat" );

    set_palette( ( RGB *  )data[ MY_PAL ].dat );

    create_rgb_table( &rgb_table , ( RGB *  )data[ MY_PAL ].dat , NULL );
    rgb_map  =  &rgb_table;
    create_light_table( &light_table , ( RGB *  )data[ MY_PAL ].dat , 0 , 0 , 0 , NULL );
    create_trans_table( &trans_table , ( RGB *  )data[ MY_PAL ].dat , 128 , 128 , 128 , NULL );


    buffer = create_bitmap( SCREEN_W , SCREEN_H );
    clear_bitmap( buffer );

    buffer1  =  create_bitmap( SPOTSIZE , SPOTSIZE );
    clear_bitmap( buffer1 );

    buffer2  =  create_bitmap( SPOTSIZE , SPOTSIZE );
    clear_bitmap( buffer2 );

    map1  =  create_bitmap( MAZE_WIDTH , MAZE_HEIGHT );
    clear_to_color( map1 , 0 );
    rect( map1 , 0 , 0 , MAZE_WIDTH - 1 , MAZE_HEIGHT - 1 , 255 );

    mapper = new int[ MAZE_WIDTH * MAZE_HEIGHT ];
    counter = 0;
    for ( int i = 0; i < MAZE_WIDTH * MAZE_HEIGHT; i++ )
    {
        mapper[ i ] = 0;
    }

    map2  =  create_bitmap( MAZE_WIDTH , MAZE_HEIGHT );
    clear_to_color( map2 , 0 );
    rect( map2 , 0 , 0 , MAZE_WIDTH - 1 , MAZE_HEIGHT - 1 , 255 );

    for ( int k = 0; k < PARALLEL_MAX; k++  )
    {
        parallax[ k ] = create_bitmap( SPOTSIZE , SPOTSIZE );
        for ( int i = 0; i < 4; i++  )
        {
            for ( int j = 0; j < 4; j++  )
            {
                blit( ( BITMAP *  )data[ LAVA01 + k ].dat , parallax[ k ] , 0 , 0 , i * 64 , j * 64 , 64 , 64 );
            }
        }
    }

    spotlight  =  create_bitmap( SPOTSIZE , SPOTSIZE );
    clear_bitmap( spotlight );

    for( int i = 0; i < 256; i++  )
    {
        circlefill( spotlight , SPOTSIZE / 2 , SPOTSIZE / 2 , SPOTSIZE / 2 - i / 4 , i );
    }
    color_map  =  &light_table;

	LOCK_VARIABLE( timer );
	LOCK_FUNCTION( inc_timer );
 	install_int( inc_timer , 40 );

	LOCK_VARIABLE( framecounter );
	LOCK_FUNCTION( inc_framecounter );
 	install_int( inc_framecounter , 40 );

	LOCK_VARIABLE( lava );
	LOCK_FUNCTION( inc_lava );
 	install_int( inc_lava , 200 );

    srand ( ( int )time( NULL ) );
    text_mode(  - 1 );

    lava = 0;
    style = 0;
    timer = 0;
    showmap = false;
    sound_on = true;

    // install joystick, you might want to do some error checking here
    if ( install_joystick(JOY_TYPE_AUTODETECT) == 0 )
    {
        joy_enabled = true;
    }
    else
    {
        joy_enabled = false;
    }

    return 0;
}

//  free all memory used
void deleteAll()
{
    destroy_bitmap( buffer );
    destroy_bitmap( buffer1 );
    destroy_bitmap( buffer2 );
    destroy_bitmap( map1 );
    destroy_bitmap( map2 );
    destroy_bitmap( spotlight );
    for ( int k = 0; k < PARALLEL_MAX; k++  )
    {
        destroy_bitmap( parallax[ k ] );
    }
    unload_datafile( data );
    delete mapper;
}

void inc_timer()
{
    timer = 1;
}
END_OF_FUNCTION( inc_timer );

void inc_framecounter()
{
    framecounter = ( framecounter + 1 ) % 60;
}
END_OF_FUNCTION( inc_framecounter );

void inc_lava()
{
    lava++ ;
    if ( lava > 3 ) lava = 0;
}
END_OF_FUNCTION( inc_lava );

//  a more accurate way to do sqrt()
int distance( int x , int y )
{
    return fixtoi( fhypot( itofix( x ) , itofix( y ) ) );
}

int random( int u )
{
    return ( rand() % u );
}

void drawMaze( BITMAP  *bmp , int q )
{
    int x , y;

    if ( q  ==  0 )
    {
        x = player.x;
        y = player.y;
    }
    else
    {
        x = monster.x;
        y = monster.y;
    }

    for ( int i =  - 5; i < 6; i++  )    
    {
        for ( int j =  - 5; j < 6; j++  )
        {
            int p = maze->getValue( i + x / TILESIZE , j + y / TILESIZE );
            if ( p!= 0 )
            {
                masked_blit( ( BITMAP* )data[ TILE000 + p ].dat , bmp , 0 , 0 , SPOTSIZE / 2 + i * TILESIZE - x % TILESIZE - 16 , SPOTSIZE / 2 + j * TILESIZE - y % TILESIZE - 16 , TILESIZE , TILESIZE );
            }
            if ( i + x / TILESIZE == START && j + y / TILESIZE == START )
            {
                masked_blit( ( BITMAP* )data[ X_1 ].dat , bmp , 0 , 0 , SPOTSIZE / 2 + i * TILESIZE - x % TILESIZE - 16 , SPOTSIZE / 2 + j * TILESIZE - y % TILESIZE - 16 , TILESIZE , TILESIZE );
            }
            if ( i + x / TILESIZE == MAZE_WIDTH - START - 1 && j + y / TILESIZE == MAZE_HEIGHT - START - 1)
            {
                masked_blit( ( BITMAP* )data[ X_2 ].dat , bmp , 0 , 0 , SPOTSIZE / 2 + i * TILESIZE - x % TILESIZE - 16 , SPOTSIZE / 2 + j * TILESIZE - y % TILESIZE - 16 , TILESIZE , TILESIZE );
            }
        }
    }
    
    if ( q  ==  0 )
    {
        masked_blit( ( BITMAP *  )data[ PL1 ].dat , bmp , ( player.frame % 2 ) * TILESIZE , ( player.frame / 2 ) * TILESIZE , SPOTSIZE / 2 - 16 , SPOTSIZE / 2 - 16 , TILESIZE , TILESIZE );
        if ( !tiedup )
        {
            masked_blit( ( BITMAP *  )data[ PL2 ].dat , bmp , ( maiden.frame % 2 ) * TILESIZE , ( maiden.frame / 2 ) * TILESIZE , SPOTSIZE / 2 - 16 + ( maiden.x - player.x ) , SPOTSIZE / 2 - 16 + ( maiden.y - player.y ) , TILESIZE , TILESIZE );
        }
        else
        {
            masked_blit( ( BITMAP *  )data[ STAKE ].dat , bmp , 0 , 0 , SPOTSIZE / 2 - 16 + ( maiden.x - player.x ) , SPOTSIZE / 2 - 16 + ( maiden.y - player.y ) - 20 , TILESIZE , 44 );
        }
        masked_blit( ( BITMAP *  )data[ PL3 ].dat , bmp , ( monster.frame % 2 ) * TILESIZE , ( monster.frame / 2 ) * TILESIZE , SPOTSIZE / 2 - 16 + ( monster.x - player.x ) , SPOTSIZE / 2 - 16 + ( monster.y - player.y ) , TILESIZE , TILESIZE );
    }
    else
    {
        masked_blit( ( BITMAP *  )data[ PL3 ].dat , bmp , ( monster.frame % 2 ) * TILESIZE , ( monster.frame / 2 ) * TILESIZE , SPOTSIZE / 2 - 16 , SPOTSIZE / 2 - 16 , TILESIZE , TILESIZE );
        if ( !tiedup )
        {
            masked_blit( ( BITMAP *  )data[ PL2 ].dat , bmp , ( maiden.frame % 2 ) * TILESIZE , ( maiden.frame / 2 ) * TILESIZE , SPOTSIZE / 2 - 16 + ( maiden.x - monster.x ) , SPOTSIZE / 2 - 16 + ( maiden.y - monster.y ) , TILESIZE , TILESIZE );
        }
        else
        {
            masked_blit( ( BITMAP *  )data[ STAKE ].dat , bmp , 0 , 0 , SPOTSIZE / 2 - 16 + ( maiden.x - monster.x ) , SPOTSIZE / 2 - 16 + ( maiden.y - monster.y ) - 20 , TILESIZE , 44 );
        }
        masked_blit( ( BITMAP *  )data[ PL1 ].dat , bmp , ( player.frame % 2 ) * TILESIZE , ( player.frame / 2 ) * TILESIZE , SPOTSIZE / 2 - 16 + ( player.x - monster.x ) , SPOTSIZE / 2 - 16 + ( player.y - monster.y ) , TILESIZE , TILESIZE );
    }
}



void drawParallax( BITMAP  *bmp , int p )
{
    int w , h , x , y , 
        clava[ 4 ] = {0 , 1 , 2 , 1};
    BITMAP  * tmp;


    if ( parallel_axis_r[ p ].x < 0 ) parallel_axis_r[ p ].x += SPOTSIZE;
    if ( parallel_axis_r[ p ].x >= SPOTSIZE ) parallel_axis_r[ p ].x -= SPOTSIZE;
    if ( parallel_axis_r[ p ].y < 0 ) parallel_axis_r[ p ].y += SPOTSIZE;
    if ( parallel_axis_r[ p ].y >= SPOTSIZE ) parallel_axis_r[ p ].y -= SPOTSIZE;

    x = parallel_axis_r[ p ].x;
    y = parallel_axis_r[ p ].y;

    w = SPOTSIZE - x;
    h = SPOTSIZE - y;

    tmp = parallax[ clava[ lava ] + 3 ];

    blit( tmp , bmp , 0 , 0 , x , y , w , h );
    blit( tmp , bmp , 0 , tmp->h - y , x , 0 , w , tmp->h - h );

    blit( tmp , bmp , tmp->w - x , 0 , 0 , y , tmp->w - w , h );
    blit( tmp , bmp , tmp->w - x , tmp->h - y , 0 , 0 , tmp->w - w , tmp->h - h );

    if ( parallel_axis_l[ p ].x < 0 ) parallel_axis_l[ p ].x += SPOTSIZE;
    if ( parallel_axis_l[ p ].x >= SPOTSIZE ) parallel_axis_l[ p ].x -= SPOTSIZE;
    if ( parallel_axis_l[ p ].y < 0 ) parallel_axis_l[ p ].y += SPOTSIZE;
    if ( parallel_axis_l[ p ].y >= SPOTSIZE ) parallel_axis_l[ p ].y -= SPOTSIZE;


    x = parallel_axis_l[ p ].x;
    y = parallel_axis_l[ p ].y;

    w = SPOTSIZE - x;
    h = SPOTSIZE - y;

    tmp = parallax[ clava[ lava ] ];

    masked_blit( tmp , bmp , 0 , 0 , x , y , w , h );
    masked_blit( tmp , bmp , 0 , tmp->h - y , x , 0 , w , tmp->h - h );

    masked_blit( tmp , bmp , tmp->w - x , 0 , 0 , y , tmp->w - w , h );
    masked_blit( tmp , bmp , tmp->w - x , tmp->h - y , 0 , 0 , tmp->w - w , tmp->h - h );

}

//  draw everything
void drawAll()
{
    clear_bitmap( buffer );

    drawParallax( buffer1 , 0 );
    drawMaze( buffer1 , 0 );

    drawParallax( buffer2 , 1 );
    drawMaze( buffer2 , 1 );

    putpixel( map1 , ( player.x + 16 ) / TILESIZE , ( player.y + 28 ) / TILESIZE , 13 );
    putpixel( map2 , ( monster.x + 16 ) / TILESIZE , ( monster.y + 28 ) / TILESIZE , 13 );

    putpixel( map1 , ( maiden.x + 16 ) / TILESIZE , ( maiden.y + 28 ) / TILESIZE , 12 );

    if ( showmap )
    {
        masked_blit( buffer1 , buffer , 0 , 0 , 480 - SPOTSIZE / 2 , CIRCLE_HEIGHT , SPOTSIZE , SPOTSIZE );
        draw_trans_sprite( buffer , spotlight , 480 - SPOTSIZE / 2 , CIRCLE_HEIGHT );

        masked_blit( buffer2 , buffer , 0 , 0 , 160 - SPOTSIZE / 2 , CIRCLE_HEIGHT , SPOTSIZE , SPOTSIZE );
        draw_trans_sprite( buffer , spotlight , 160 - SPOTSIZE / 2 , CIRCLE_HEIGHT );

        masked_stretch_blit( map1 , buffer , 0 , 0 , MAZE_WIDTH , MAZE_HEIGHT , 480 - ( MAZE_WIDTH * SMALL_MAP ) / 2 , SCREEN_H - 1 - MAZE_HEIGHT * SMALL_MAP , MAZE_WIDTH * SMALL_MAP , MAZE_HEIGHT * SMALL_MAP );
        masked_stretch_blit( map2 , buffer , 0 , 0 , MAZE_WIDTH , MAZE_HEIGHT , 160 - ( MAZE_WIDTH * SMALL_MAP ) / 2 , SCREEN_H - 1 - MAZE_HEIGHT * SMALL_MAP , MAZE_WIDTH * SMALL_MAP , MAZE_HEIGHT * SMALL_MAP );
    }
    else
    {
        masked_blit( buffer1 , buffer , 0 , 0 , 480 - SPOTSIZE / 2 , CIRCLE_HEIGHT + 60 , SPOTSIZE , SPOTSIZE );
        draw_trans_sprite( buffer , spotlight , 480 - SPOTSIZE / 2 , CIRCLE_HEIGHT + 60 );

        masked_blit( buffer2 , buffer , 0 , 0 , 160 - SPOTSIZE / 2 , CIRCLE_HEIGHT + 60 , SPOTSIZE , SPOTSIZE );
        draw_trans_sprite( buffer , spotlight , 160 - SPOTSIZE / 2 , CIRCLE_HEIGHT + 60 );
    }

    drawScreen( buffer );

    putpixel( map1 , ( player.x + 16 ) / TILESIZE , ( player.y + 28 ) / TILESIZE , 10 );
    putpixel( map2 , ( monster.x + 16 ) / TILESIZE , ( monster.y + 28 ) / TILESIZE , 12 );
}

void drawScreen( BITMAP  *bmp )
{
//    textprintf( bmp , font , 0 ,  0 , 15 , "    Hero: %d , %d   %d , %d " , player.x / TILESIZE , player.y / TILESIZE , player.x % TILESIZE , player.y % TILESIZE );
//    textprintf( bmp , font , 0 , 10 , 15 , " Monster: %d , %d   %d , %d " , monster.x / TILESIZE , monster.y / TILESIZE , monster.x % TILESIZE , monster.y % TILESIZE );
    
    acquire_screen();
    blit( bmp , screen , 0 , 0 , 0 , 0 , SCREEN_W , SCREEN_H );
    release_screen();
}

//  check if where the player is if he hits a wall
bool hit_wall( int x , int y )
{
	int x1 , y1;

	for ( int i = 8; i < 24; i++  )
	{
		for ( int j = 16; j < TILESIZE; j++  )
		{
			x1 = ( x + i ) / TILESIZE;
			y1 = ( y + j ) / TILESIZE;

			if ( maze->getValue( x1 , y1 )  ==  0 )
				 return true;
		}
	}

	return false;
}

void move_maiden()
{
    if ( player.x < maiden.x )
    {
        if ( !hit_wall( maiden.x - MOVEMENT , maiden.y ) )
        {
            maiden.x -= MOVEMENT;
            if ( distance( ABS( player.x - maiden.x ) , ABS( player.y - maiden.y ) ) < TILESIZE )
            {
                maiden.x += MOVEMENT;
            }
            else
            {
                maiden.frame++ ;
                if ( maiden.frame < 6 || maiden.frame > 7 ) maiden.frame = 6;
            }
        }
    }
    if ( player.x > maiden.x )
    {
        if ( !hit_wall( maiden.x + MOVEMENT , maiden.y ) )
        {
            maiden.x += MOVEMENT;
            if ( distance( ABS( player.x - maiden.x ) , ABS( player.y - maiden.y ) ) < TILESIZE )
            {
                maiden.x -= MOVEMENT;
            }
            else
            {
                maiden.frame++ ;
                if ( maiden.frame < 2 || maiden.frame > 3 ) maiden.frame = 2;
            }
        }
    }
    if ( player.y < maiden.y )
    {
        if ( !hit_wall( maiden.x , maiden.y - MOVEMENT ) )
        {
            maiden.y -= MOVEMENT;
            if ( distance( ABS( player.x - maiden.x ) , ABS( player.y - maiden.y ) ) < TILESIZE )
            {
                maiden.y += MOVEMENT;
            }
            else
            {
                maiden.frame++ ;
                if ( maiden.frame < 0 || maiden.frame > 1 ) maiden.frame = 0;
            }
        }
    }
    if ( player.y > maiden.y )
    {
        if ( !hit_wall( maiden.x , maiden.y + MOVEMENT ) )
        {
            maiden.y += MOVEMENT;
            if ( distance( ABS( player.x - maiden.x ) , ABS( player.y - maiden.y ) ) < TILESIZE )
            {
                maiden.y -= MOVEMENT;
            }
            else
            {
                maiden.frame++ ;
                if ( maiden.frame < 4 || maiden.frame > 5 ) maiden.frame = 4;
            }
        }
    }
}

void picFill( BITMAP  * source , BITMAP  * dest , int sx , int sy , int dx , int dy , int w , int h )
{
    int aw , ah , pw , ph , x , y , l;
    aw = pw = source->w;
    ah = ph = source->h;

    x = w / pw + 1;
    y = h / ph + 1;
    l = h;

    for ( int i = 0; i < x; i++  )
    {
        pw = aw;
        if ( pw > w ) pw = w;
        w -= pw;
        h = l;
        for ( int j = 0; j < y; j++  )
        {
            ph = ah;
            if ( ph > h ) ph = h;
            h -= ph;
            blit( source , dest , 0 , 0 , dx + aw * i , dy + ah * j , pw , ph );
        }
    }
}

void drawWindow( BITMAP  *bmp , int x , int y , int x2 , int y2 )
{
    picFill( ( BITMAP *  )data[ BGROUND ].dat , bmp , 0 , 0 , x , y , x2 - x , y2 - y );
    drawBorder( bmp , x , y , x2 , y2 );
}

void drawBorder( BITMAP  *bmp , int x , int y , int x2 , int y2 )
{
    hline( bmp , x , y , x2 , 7 );
    vline( bmp , x , y , y2 , 7 );
    hline( bmp , x , y2 , x2 , 8 );
    vline( bmp , x2 , y , y2 , 8 );    
}

bool doYesOrNo( BITMAP  *bmp , char  * tx1 , char  * tx2 )
{
    int w , w2 , h;

    w = text_length( ( FONT* )data[ MY_FONT ].dat , tx1 );
    w2 = text_length( ( FONT* )data[ MY_FONT ].dat , tx2 );

    if ( w2 > w ) w = w2;

    w = w + 20;
    h = text_height( ( FONT* )data[ MY_FONT ].dat ) * 6;

    drawWindow( bmp , SCREEN_W / 2 - w / 2 , SCREEN_H / 2 - h / 2 , SCREEN_W / 2 + w / 2 , SCREEN_H / 2 + h / 2 );

    textout_centre( bmp , ( FONT* )data[ MY_FONT ].dat , tx1 , SCREEN_W / 2 , SCREEN_H / 2 - h / 2 + text_height( ( FONT* )data[ MY_FONT ].dat ) , 255 );
    textout_centre( bmp , ( FONT* )data[ MY_FONT ].dat , tx2 , SCREEN_W / 2 , SCREEN_H / 2 - h / 2 + 2 * text_height( ( FONT* )data[ MY_FONT ].dat ) , 255 );
    textout_centre( bmp , ( FONT* )data[ MY_FONT ].dat , "Y<es> , N<o>" , SCREEN_W / 2 , SCREEN_H / 2 - h / 2 + 4 * text_height( ( FONT* )data[ MY_FONT ].dat ) , 255 );

    drawScreen( bmp );

    while ( true )
    {
        if ( key[ KEY_Y ] ) return true;
        if ( key[ KEY_N ] ) return false;
    }
}

void doMessage( BITMAP  *bmp , int amount , ... )
{
    int w , w2 , h;
    char text[ 15 ][ 80 ];
	va_list marker;

    if ( amount > 14 ) amount = 14;

    w = 0;

    va_start( marker , amount );
   
	for ( int i = 0; i < amount; i++  )
    {
		strcpy( text[ i ] , va_arg( marker , char  *  ) );

        w2 = text_length( ( FONT* )data[ MY_FONT2 ].dat , text[ i ] );
			
		if ( w2 > w ) 
        {
            w = w2;
        }
	}

	va_end( marker );  

    w = w + 20;
    h = text_height( ( FONT* )data[ MY_FONT2 ].dat ) * ( amount + 2 );

    drawWindow( bmp , ( SCREEN_W - w ) / 2 , ( SCREEN_H - h ) / 2 , ( SCREEN_W + w ) / 2 , ( SCREEN_H + h ) / 2 );

    for ( int i = 0; i < amount; i++  )
    {
        textout_centre( bmp , ( FONT* )data[ MY_FONT2 ].dat , text[ i ] , SCREEN_W / 2 , ( SCREEN_H - h ) / 2 + ( i + 1 ) * text_height( ( FONT* )data[ MY_FONT2 ].dat ) , 255 );
    }

    drawScreen( bmp );

    while ( true )
    {
        if ( key[ KEY_ENTER ] ) 
        {
            while ( key[ KEY_ENTER ] ) {}
            return;
        }
    }    
}


/*  constructor with inputed widht and height specifications */
D_MAZE::D_MAZE( int w , int h , int type )
{
    if ( w % 2  ==  0 ) w = w - 1;
    if ( h % 2  ==  0 ) h = h - 1;

    if ( w < D_MAZE_MIN ) w = D_MAZE_MIN;
    if ( h < D_MAZE_MIN ) h = D_MAZE_MIN;

    if ( w > D_MAZE_MAX ) w = D_MAZE_MAX;
    if ( h > D_MAZE_MAX ) h = D_MAZE_MAX;

    this->mazeWidth = w;
    this->mazeHeight = h;
    this->mazeArray = new int[ this->mazeWidth * this->mazeHeight ];

    this->clearMaze();
    this->createMaze( START , START );

    if ( type  ==  1 ) this->fixMaze();
}

/*  basic deconstructor */
D_MAZE::~D_MAZE()
{
    if ( this->mazeArray ) delete this->mazeArray;
}

/*  This functions just resets the maze. The before the maze
    is created , it is a solid mass of walls */ 
void D_MAZE::clearMaze()
{
    for ( int i = 0; i < ( this->mazeWidth * this->mazeHeight ); i++  )
    {
        this->mazeArray[ i ] = 0;
    }
}

D_MAZE  *D_MAZE::makeCopy()
{
    D_MAZE  *temp  =  new D_MAZE( this->mazeWidth , this->mazeHeight , 0 );

    temp->mazeWidth = this->mazeWidth;
    temp->mazeHeight = this->mazeHeight;

    for ( int i = 0; i < ( this->mazeWidth * this->mazeHeight ); i++  )
    {
        temp->mazeArray[ i ] = this->mazeArray[ i ];
    }

    return temp;

}

/*  Just a little random number functions. This random number
    function should be compatable with DJPPP , MINGW , and MSVC */
int D_MAZE::random( int u )
{
    return ( rand()  %  u );
}

int D_MAZE::squareRoot( int x , int y )
{
    return fixtoi( fhypot( itofix( x ) , itofix( y ) ) );
}

/*  This creates the maze from a clean slate. When I first made
    this function , I had had a random number for each direction.
    That made for a messy maze. Sometimes there would be a series
    of straight lines. So I changed it to a random order instead. */
void D_MAZE::createMaze( int x , int y )
{
    int p[ 4 ] , k[ 4 ] = {0 , 0 , 0 , 0} , num = 90;

    putValue( x , y , 15 );

    p[ 0 ] = random( 4 );
    k[ p[ 0 ] ] = 1;

    do
    {
        p[ 1 ] = random( 4 );
    } while ( k[ p[ 1 ] ]  ==  k[ p[ 0 ] ] );

    k[ p[ 1 ] ] = 1;

    do
    {
        p[ 2 ] = random( 4 );
    } while ( k[ p[ 2 ] ]  ==  k[ p[ 0 ] ] || k[ p[ 2 ] ]  ==  k[ p[ 1 ] ] );
    k[ p[ 2 ] ] = 1;

    do
    {
        p[ 3 ] = random( 4 );
    } while ( k[ p[ 3 ] ]  ==  k[ p[ 0 ] ] || k[ p[ 3 ] ]  ==  k[ p[ 1 ] ] || k[ p[ 3 ] ]  ==  k[ p[ 2 ] ] );
    k[ p[ 3 ] ] = 1;

    for ( int i = 0; i < 4; i++  )
    {
        if ( p[ i ]  ==  0 && x > START )
        {
            if ( getValue( x - 2 , y )  ==  0 )
            {
                putValue( x - 1 , y , 15 );
                this->createMaze( x - 2 , y );
            }
            else
            {
                if ( this->random( 100 ) > num )
                {
                    this->putValue( x - 1 , y , 15 );
                    this->putValue( x - 2 , y , 15 );
                }
            }
        }

        if ( p[ i ]  ==  1 && y > START )
        {
            if ( getValue( x , y - 2 )  ==  0 )
            {
                putValue( x , y - 1 , 15 );
                this->createMaze( x , y - 2 );
            }
            else
            {
                if ( this->random( 100 ) > num )
                {
                    this->putValue( x , y - 1 , 15 );
                    this->putValue( x , y - 2 , 15 );
                }
            }
        }

        if ( p[ i ]  ==  2 && x < ( this->mazeWidth - START - 1 ) )
        {
            if ( getValue( x + 2 , y )  ==  0 )
            {
                putValue( x + 1 , y , 15 );
                this->createMaze( x + 2 , y );
            }
            else
            {
                if ( this->random( 100 ) > num )
                {
                    this->putValue( x + 1 , y , 15 );
                    this->putValue( x + 2 , y , 15 );
                }
            }
        }

        if ( p[ i ]  ==  3 && y < ( this->mazeHeight - START - 1 ) )
        {
            if ( getValue( x , y + 2 )  ==  0 )
            {
                putValue( x , y + 1 , 15 );
                this->createMaze( x , y + 2 );
            }
            else
            {
                if ( this->random( 100 ) > num )
                {
                    this->putValue( x , y + 1 , 15 );
                    this->putValue( x , y + 2 , 15 );
                }
            }
        }
    }

}

/*  returns the value at the specified point */
int D_MAZE::getValue( int x , int y )
{
    return this->mazeArray[ x + y * this->mazeWidth ];
}

/*  changes the value at the specified point */
void D_MAZE::putValue( int x , int y , int c )
{
    this->mazeArray[ x + y * this->mazeWidth ] = c;
}


int D_MAZE::funk( int k )
{
    if ( k  ==  ( T_UP                              ) ) return  1;
    if ( k  ==  ( T_RIGHT                           ) ) return  2;
    if ( k  ==  ( T_DOWN                            ) ) return  3;
    if ( k  ==  ( T_LEFT                            ) ) return  4;
    if ( k  ==  ( T_UP     +  T_RIGHT               ) ) return  5;
    if ( k  ==  ( T_UP     +  T_DOWN                ) ) return  6;
    if ( k  ==  ( T_UP     +  T_LEFT                ) ) return  7;
    if ( k  ==  ( T_RIGHT  +  T_DOWN                ) ) return  8;
    if ( k  ==  ( T_RIGHT  +  T_LEFT                ) ) return  9;
    if ( k  ==  ( T_DOWN   +  T_LEFT                ) ) return 10;
    if ( k  ==  ( T_UP     +  T_RIGHT  +  T_LEFT    ) ) return 11;
    if ( k  ==  ( T_UP     +  T_RIGHT  +  T_DOWN    ) ) return 12;
    if ( k  ==  ( T_RIGHT  +  T_DOWN   +  T_LEFT    ) ) return 13;
    if ( k  ==  ( T_UP     +  T_DOWN   +  T_LEFT    ) ) return 14;
    
    return 15;
}

void D_MAZE::fixMaze()
{
    int sum;

    D_MAZE  * temp  =  this->makeCopy();

    for ( int i = 0; i < temp->mazeWidth; i++  )
    {
        for ( int j = 0; j < temp->mazeHeight; j++  )
        {
            if ( temp->getValue( i , j )  ==  15 )
            {
                sum = 0;
                if ( temp->getValue( i , j - 1 )  ==  15 ) sum = sum + T_UP;
                if ( temp->getValue( i + 1 , j )  ==  15 ) sum = sum + T_RIGHT;
                if ( temp->getValue( i , j + 1 )  ==  15 ) sum = sum + T_DOWN;
                if ( temp->getValue( i - 1 , j )  ==  15 ) sum = sum + T_LEFT;

                this->putValue( i , j , funk( sum ) );                
            }
        }
    }

    delete temp;
}
