#include "main.h"
#include "pyr.h"

#define CARD_WIDTH		70
#define CARD_HEIGHT		95

PopupStruct MyP[2];

DButton Button[3];
DATAFILE *data;
BITMAP *card_spr[MAX_CARD];
int tp,paus=0; 
SELECT sel;
DECK game_deck,main_deck;
int tm,hi,round,current_round,oround;

volatile int x = 0;

void inc_time()
{
	tm++;	
}

void inc_x(void)
{
	if (paus==0)
	x++;
	inc_time();
}

END_OF_FUNCTION(inc_x);

void my_menu()
{
	MyP[0].Create("New Game","---","Quit",END);
	MyP[1].Create("Help","---","About",END);
}

void show_time(DBitmap &bmp)
{
	char msg[80];
	sprintf(msg,"Time:%d Sec",tm);
	bmp.Text(msg,20,400);
	sprintf(msg,"Best Time:%d Sec",hi);
	bmp.Text(msg,20,420);
}

void shuffle_deck(DECK &game_deck,DECK &main_deck)    // Make sure it is a random stack of Cards
{
	int i,j[MAX_CARD],dn,p,z=0,o=0;
	int yy[28]={0,1,1,2,2,2,3,3,3,3,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,6};
	int xx[28]={                      290,
			                      254,    326,
	                          218,    290,    362,
		                  182,    254,    326,    398,
			          146,    218,    290,    362,    434,
				  110,    182,    254,    326,    398,    470,
	           74,    146,    218,    290,    362,    434,    506};

	for (i=0; i<MAX_CARD; i++)
		j[i]=0;

	for (i=0; i<MAX_CARD; i++)
	{
		dn=0;
		while (!dn)
		{
			p=Random(MAX_CARD);
			if (j[p]==0) 
			{
				j[p]=1;
				copy_card(main_deck.card[p],game_deck.card[i]);
				if (i<28)
				{
					game_deck.card[i].px=game_deck.card[i].x=xx[i];
					game_deck.card[i].py=game_deck.card[i].y=50+yy[i]*35;
				}
				else
				{
					game_deck.card[i].px=game_deck.card[i].x=228;
					game_deck.card[i].py=game_deck.card[i].y=375;
//					if (game_deck.card[i].value==13)
//					{
//						game_deck.card[i].flag=1;
//					}
				}
				dn=1;
			}
		}
    }
	tp=28;
	game_deck.card[tp].px=game_deck.card[tp].x=352;
	game_deck.card[tp].py=game_deck.card[tp].y=375;
	sel.number=100;
	sel.x=0;
	sel.y=0;
} 

void flip_deck()
{
	int i;
	for (i=28; i<MAX_CARD; i++)
	{
		game_deck.card[i].px=game_deck.card[i].x=228;
	}
}


void copy_card(CARD &frm,CARD &to)
{
	to.flag		=	frm.flag;
	to.sl		=	frm.sl;
	to.px		=	frm.px;
	to.py		=	frm.py;
	to.x		=	frm.x;
	to.y		=	frm.y;
	to.number	=	frm.number;
	to.suit		=	frm.suit;
	to.value	=	frm.value;
}

void init_cards(DECK &main_deck)
{
	int i,j,u,c,w;

	int cx[13][13]={29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,		// ACE
		            29,29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,		// 2
			        29,29,29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,		// 3
				    13,45,13,45, 0, 0, 0, 0, 0, 0, 0, 0, 0,		// 4
					13,45,29,13,45, 0, 0, 0, 0, 0, 0, 0, 0,		// 5
	                13,45,13,45,13,45, 0, 0, 0, 0, 0, 0, 0,		// 6
		            13,45,29,13,45,13,45, 0, 0, 0, 0, 0, 0,		// 7
			        13,45,29,13,45,29,13,45, 0, 0, 0, 0, 0,		// 8
				    13,45,13,45,29,13,45,13,45, 0, 0, 0, 0,		// 9
					13,45,29,13,45,13,45,29,13,45, 0, 0, 0,		// 10
	                0,0,0,0,0,0,0,0,0,0,0,0,0,					// JACK
		            0,0,0,0,0,0,0,0,0,0,0,0,0,					// QUEEN
			        0,0,0,0,0,0,0,0,0,0,0,0,0};					// KING
	int cy[13][13]={42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,		// ACE
		            27,57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,		// 2
			        12,42,72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,		// 3
				    12,12,72,72, 0, 0, 0, 0, 0, 0, 0, 0, 0,		// 4
					12,12,42,72,72, 0, 0, 0, 0, 0, 0, 0, 0,		// 5
	                12,12,42,42,72,72, 0, 0, 0, 0, 0, 0, 0,		// 6
		            12,12,27,42,42,72,72, 0, 0, 0, 0, 0, 0,		// 7
			        12,12,27,42,42,57,72,72, 0, 0, 0, 0, 0,		// 8
				    12,12,32,32,42,52,52,72,72, 0, 0, 0, 0,		// 9
					12,12,22,32,32,52,52,62,72,72, 0, 0, 0,		// 10
	                0,0,0,0,0,0,0,0,0,0,0, 0, 0,				// JACK
		            0,0,0,0,0,0,0,0,0,0,0,0, 0,					// QUEEN
			        0,0,0,0,0,0,0,0,0,0,0,0,0};					// KING

	for (i=0; i<4; i++)
	{
		for (j=1; j<14; j++)
		{
			u=(i*13)+j-1;
			main_deck.card[u].flag=0;
			main_deck.card[u].sl=0;
			main_deck.card[u].x=0;
			main_deck.card[u].y=0;
			main_deck.card[u].px=0;
			main_deck.card[u].px=0;
			main_deck.card[u].number=u;	
			main_deck.card[u].suit=i;
			main_deck.card[u].value=j;

			card_spr[u]=create_bitmap(CARD_WIDTH,CARD_HEIGHT);
			clear(card_spr[u]);
  
			for (w=0; w<j; w++)
			{
				if (j<=10)
				{
					if (j==1 && i==1)
					{
						draw_sprite(card_spr[u],(BITMAP*)data[ACESPADE].dat,11,24);
					}
					else
					{
						draw_sprite(card_spr[u],(BITMAP*)data[i+SUIT1].dat,cx[j-1][w],cy[j-1][w]);
					}
				}
				else
				{	
					if (j==11)
					{
						draw_sprite(card_spr[u],(BITMAP*)data[R_JACK1+i].dat,11,11);
					}
					if (j==12)
					{		
						draw_sprite(card_spr[u],(BITMAP*)data[R_QUEEN1+i].dat,11,11);
					}
					if (j==13)
					{	
						draw_sprite(card_spr[u],(BITMAP*)data[R_KING1+i].dat,11,11);
					}
				}
		
				c=2;
		
				if (i==0 || i==2) {c=55;}
				if (j==1)
				{
					textout(card_spr[u],font,"A", 2,2,c);
					textout(card_spr[u],font,"A", CARD_WIDTH-10,CARD_HEIGHT-10,c);
				}
				if (j==2)
				{
					textout(card_spr[u],font,"2", 2,2,c);
					textout(card_spr[u],font,"2", CARD_WIDTH-10,CARD_HEIGHT-10,c);
				}
				if (j==3)
				{
					textout(card_spr[u],font,"3", 2,2,c);
					textout(card_spr[u],font,"3", CARD_WIDTH-10,CARD_HEIGHT-10,c);
				}
				if (j==4)
				{
					textout(card_spr[u],font,"4", 2,2,c);
					textout(card_spr[u],font,"4", CARD_WIDTH-10,CARD_HEIGHT-10,c);
				}
				if (j==5)
				{
					textout(card_spr[u],font,"5", 2,2,c);
					textout(card_spr[u],font,"5", CARD_WIDTH-10,CARD_HEIGHT-10,c);
				}
				if (j==6)
				{
					textout(card_spr[u],font,"6", 2,2,c);
					textout(card_spr[u],font,"6", CARD_WIDTH-10,CARD_HEIGHT-10,c);
				}
				if (j==7)
				{
					textout(card_spr[u],font,"7", 2,2,c);
					textout(card_spr[u],font,"7", CARD_WIDTH-10,CARD_HEIGHT-10,c);
				}
				if (j==8)
				{
					textout(card_spr[u],font,"8", 2,2,c);
					textout(card_spr[u],font,"8", CARD_WIDTH-10,CARD_HEIGHT-10,c);
				}
				if (j==9)
				{
					textout(card_spr[u],font,"9", 2,2,c);
					textout(card_spr[u],font,"9", CARD_WIDTH-10,CARD_HEIGHT-10,c);
				}
				if (j==10)
				{
					textout(card_spr[u],font,"10", 2,2,c);
					textout(card_spr[u],font,"10", CARD_WIDTH-18,CARD_HEIGHT-10,c);
				}
				if (j==11)
				{
					textout(card_spr[u],font,"J", 2,2,c);
					textout(card_spr[u],font,"J", CARD_WIDTH-10,CARD_HEIGHT-10,c);
				}
				if (j==12)
				{
					textout(card_spr[u],font,"Q", 2,2,c);
					textout(card_spr[u],font,"Q", CARD_WIDTH-10,CARD_HEIGHT-10,c);
				}
				if (j==13)
				{
					textout(card_spr[u],font,"K", 2,2,c);
					textout(card_spr[u],font,"K", CARD_WIDTH-10,CARD_HEIGHT-10,c);
				}
			}
		}
	}
}

void draw_card(DBitmap &bmp,CARD &cd)
{
	if (cd.flag!=1)
	{
		if (cd.sl==0)
		{
			bmp.Grab_S((BITMAP*)data[MAINCARD].dat,cd.x,cd.y);
//			bmp.Grab_S((BITMAP*)data[MAINCARD].dat,0,0,cd.x,cd.y,CARD_WIDTH,CARD_HEIGHT);
		}
		else
		{
			bmp.Grab_S((BITMAP*)data[CARD2].dat,cd.x,cd.y);
//			bmp.Grab_S((BITMAP*)data[CARD2].dat,0,0,cd.x,cd.y,CARD_WIDTH,CARD_HEIGHT);
		}
		
		bmp.Grab_S(card_spr[cd.number],cd.x,cd.y);
	}
}


void draw_pyramid(DBitmap &bmp)
{
	int i,lx,ly;
	i=text_height(font);

	bmp.Rect_Fill(3,i*2+21,636,476,35);

	bmp.Grab((BITMAP*)data[FACE_DOWN].dat,0,0,228,375,CARD_WIDTH,CARD_HEIGHT);

	for (i=0; i<tp+1; i++)
	{
		if (sel.number!=i)			
			draw_card(bmp,game_deck.card[i]);
	}

	if (tp==51)
	{
		bmp.Grab((BITMAP*)data[CARD3].dat,0,0,228,375,CARD_WIDTH,CARD_HEIGHT);
	}



	if (sel.number!=100)
	{
		game_deck.card[sel.number].x=mouse_x-sel.x;
		game_deck.card[sel.number].y=mouse_y-sel.y;

		if (game_deck.card[sel.number].x<3)
		{
			lx=3-game_deck.card[sel.number].x;
			game_deck.card[sel.number].x=3;
		}
		if (game_deck.card[sel.number].y<37)
		{
			ly=37-game_deck.card[sel.number].y;
			game_deck.card[sel.number].y=37;
		}

		if (game_deck.card[sel.number].x>567)
		{
			lx=567-game_deck.card[sel.number].x;
			game_deck.card[sel.number].x=567;
		}
		if (game_deck.card[sel.number].y>382)
		{
			ly=382-game_deck.card[sel.number].y;
			game_deck.card[sel.number].y=382;
		}


		position_mouse(game_deck.card[sel.number].x+sel.x,game_deck.card[sel.number].y+sel.y);

		draw_card(bmp,game_deck.card[sel.number]);
	}
}

void next_card()
{
	int dn=0;
	if (tp==51)
	{
		if (current_round<round)
		{
			current_round++;
			tp=27;
			flip_deck();
		}
	}
	else
	{
		while (!dn)
		{
			tp++;
			game_deck.card[tp].px=game_deck.card[tp].x=352;
			game_deck.card[tp].py=game_deck.card[tp].y=375;
			if (game_deck.card[tp].flag==0 || tp==51)
			{
				dn=1;
			}
		}
	}
}


int unblocked(int i)
{
//return(1);

  switch (i+1)
    {
  case  1: {
            if (game_deck.card[1].flag>0 && game_deck.card[2].flag>0) return(1);
           } break;


  case  2: {
            if (game_deck.card[3].flag>0 && game_deck.card[4].flag>0) return(1);
           } break;
  case  3: {
            if (game_deck.card[4].flag>0 && game_deck.card[5].flag>0) return(1);
           } break;


  case  4: {
            if (game_deck.card[6].flag>0 && game_deck.card[7].flag>0) return(1);
           } break;
  case  5: {
            if (game_deck.card[7].flag>0 && game_deck.card[8].flag>0) return(1);
           } break;
  case  6: {
            if (game_deck.card[8].flag>0 && game_deck.card[9].flag>0) return(1);
           } break;


  case  7: {
            if (game_deck.card[10].flag>0 && game_deck.card[11].flag>0) return(1);
           } break;
  case  8: {
            if (game_deck.card[11].flag>0 && game_deck.card[12].flag>0) return(1);
           } break;
  case  9: {
            if (game_deck.card[12].flag>0 && game_deck.card[13].flag>0) return(1);
           } break;
  case 10: {
            if (game_deck.card[13].flag>0 && game_deck.card[14].flag>0) return(1);
           } break;


  case 11: {
            if (game_deck.card[15].flag>0 && game_deck.card[16].flag>0) return(1);
           } break;
  case 12: {
            if (game_deck.card[16].flag>0 && game_deck.card[17].flag>0) return(1);
           } break;
  case 13: {
            if (game_deck.card[17].flag>0 && game_deck.card[18].flag>0) return(1);
           } break;
  case 14: {
            if (game_deck.card[18].flag>0 && game_deck.card[19].flag>0) return(1);
           } break;
  case 15: {
            if (game_deck.card[19].flag>0 && game_deck.card[20].flag>0) return(1);
           } break;


  case 16: {
            if (game_deck.card[21].flag>0 && game_deck.card[22].flag>0) return(1);
           } break;
  case 17: {
            if (game_deck.card[22].flag>0 && game_deck.card[23].flag>0) return(1);
           } break;
  case 18: {
            if (game_deck.card[23].flag>0 && game_deck.card[24].flag>0) return(1);
           } break;
  case 19: {
            if (game_deck.card[24].flag>0 && game_deck.card[25].flag>0) return(1);
           } break;
  case 20: {
            if (game_deck.card[25].flag>0 && game_deck.card[26].flag>0) return(1);
           } break;
  case 21: {
            if (game_deck.card[26].flag>0 && game_deck.card[27].flag>0) return(1);
           } break;
  case 22: {
            return(1);
           } break;
  case 23: {
            return(1);
           } break;
  case 24: {
            return(1);
           } break;
  case 25: {
            return(1);
           } break;
  case 26: {
            return(1);
           } break;
  case 27: {
            return(1);
           } break;
  case 28: {
            return(1);
           } break;
  default: return(1);
	  break;
    }  // end switch

return(0);
}

void do_match()
{
	int i;
	if (game_deck.card[sel.number].value==13)
	{
		game_deck.card[sel.number].sl=0;
		game_deck.card[sel.number].flag=1;
	}
	else
	{
		for (i=0; i<MAX_CARD; i++)
		{
			if (game_deck.card[i].sl==1)
			{
				game_deck.card[i].sl=0;
				game_deck.card[i].flag=1;
			}
		}
	}
}

void check_match()
{
	int i,x1,y1,x2,y2,h=100;

	x1=game_deck.card[sel.number].x;
	y1=game_deck.card[sel.number].y;
	unsel();
	for (i=0; i<tp+1; i++)
	{
		if (i!=sel.number)
		{
			x2=game_deck.card[i].x;
			y2=game_deck.card[i].y;
			if ( 
				(unblocked(i) && game_deck.card[i].flag!=1) &&
			    ( 
					(x1            >= x2 && 
					 x1            <= x2+CARD_WIDTH && 
					 y1            >= y2 && 
					 y1            <= y2+CARD_HEIGHT) ||
				    (x1+CARD_WIDTH >= x2 && 
					 x1+CARD_WIDTH <= x2+CARD_WIDTH && 
					 y1            >= y2 && 
					 y1            <= y2+CARD_HEIGHT) ||
			        (x1+CARD_WIDTH >= x2 && 
					 x1+CARD_WIDTH <= x2+CARD_WIDTH && 
					 y1+CARD_HEIGHT>= y2 && 
					 y1+CARD_HEIGHT<= y2+CARD_HEIGHT) ||
			        (x1            >= x2 && 
					 x1            <= x2+CARD_WIDTH && 
					 y1+CARD_HEIGHT>= y2 && 
					 y1+CARD_HEIGHT<= y2+CARD_HEIGHT) ) )
			{
				if (game_deck.card[i].value+game_deck.card[sel.number].value==13)
				{
					h=i;
				}
			}
		}
		if (game_deck.card[sel.number].value==13)
		{
			game_deck.card[sel.number].sl=1;
		}

		if (game_deck.card[i].flag==0 && h!=i && h>=28)
		{
			h=100;
		}
	}

	if (h!=100)
	{
		game_deck.card[sel.number].sl=1;
		game_deck.card[h].sl=1;
	}

}

void unsel()
{
	int i;
	for (i=0; i<52; i++)
	{
		game_deck.card[i].sl=0;
	}
}

void check_high_score(DBitmap &bmp,int tm)
{
	char msg[20];
	if (tm<hi || hi==0)
	{
		sprintf(msg,"Time %d",tm);
		hi=tm;
		save_high_score(hi);
		Info_Box(bmp,"High Score","Ok","You have the Best Score",msg,END);
		round=oround;
		current_round=0;
	}
}

int load_high_score()
{
	FILE *fileptr;
	int h;

	if ((fileptr=fopen("pyramid.hs","r"))==NULL)
    {
        return 0;
	} 

	fscanf(fileptr,"%d\n",&h);
	fclose(fileptr);

	return h;
}

void  save_high_score(int h)
{
	FILE *fileptr;

	if ((fileptr=fopen("pyramid.hs","w"))==NULL)
    {
    } 
	else
	{
		fprintf(fileptr,"%d\n",h);
		fclose(fileptr);
	}
}


void mouse_click(int x,int y)
{
	int i,x1,y1,h=100,x2,y2;

	for (i=0; i<tp+1; i++)
	{
		x1=game_deck.card[i].x;
		y1=game_deck.card[i].y;
		if (x>=x1 && x<=x1+70 && y>=y1 && y<=y1+CARD_HEIGHT && unblocked(i) && game_deck.card[i].flag==0)
		{
				h=i;
				x2=x1;
				y2=y1;
		}
	}

	if (h<100)
	{
		sel.number=h;
		sel.x=x-x2;
		sel.y=y-y2;
		game_deck.card[sel.number].flag=2;
	}

}
void release_card()
{
	if (sel.number==tp+1) 
	{
		next_card();
	}

	if (sel.number!=100)
	{
		game_deck.card[sel.number].x=game_deck.card[sel.number].px;
		game_deck.card[sel.number].y=game_deck.card[sel.number].py;
	}

	unsel();
	if (game_deck.card[sel.number].flag==2)
	{
		game_deck.card[sel.number].flag=0;
	}

	sel.number=100;
	sel.x=0;
	sel.y=0;
}

void Init_All()
{
	int l;
	l=text_height(font);	

	srand((int)time(NULL));

	data=load_datafile("pyramid.dat");

	set_palette((RGB*)data[MY_PAL].dat);

	text_mode(-1);

	Title_Window(Screen,0,0,640,480,GAME_TITLE);
	Make_Window(Screen,2,l*2+20,638,478,DOWN);
//	Screen.Pic_Fill((BITMAP*)data[BACKGROUND].dat,3,l*2+21,637,477);

	Button[0].Create(4,l+10,50,l+4,"File");
	Button[1].Create(56,l+10,50,l+4,"Help");
	Button[2].Create(622,l+10,14,l+4,"X");
	Button[3].Create(228,375,CARD_WIDTH,CARD_HEIGHT,"",(BITMAP*)data[FACE_DOWN].dat);

	Mouse.Change(M_HAND);
	Mouse.Show();

}

void Draw_All()
{
		
	draw_pyramid(Screen);
	show_time(Screen);

	Button[0].Draw(Screen);
	Button[1].Draw(Screen);
	Button[2].Draw(Screen);

	Draw_Screen();

}

void Delete_All()
{
	int i;
	Button[0].Delete();
	Button[1].Delete();
	Button[2].Delete();
	Screen.Delete();
	unload_datafile(data);

	for (i=0; i<52; i++)
	{
		destroy_bitmap(card_spr[i]);
	}
}


int Which_Button()
{
	if (Button[0].Pressed()) return 0;
	if (Button[1].Pressed()) return 1;
	if (Button[2].Pressed()) return 2;
	if (Button[3].Pressed()) return 3;

	return 100;
}

int main()
{
	int dn=0,p,l,mouse_state=UP,mtype=M_HAND;




	install_dlib(640,480);

	COLOR_TITLE=CARD_WIDTH;

	COLOR_TOP=15;
	COLOR_LIGHT=9;
	COLOR_DARK=4;
	COLOR_BOTTOM=1;

	COLOR_TEXT_UP=15;
	COLOR_TEXT_DOWN=1;

	MOUSE_WHITE=15;
	MOUSE_BLACK=2;

	Mouse.Show();



	Init_All();
	my_menu();

	init_cards(main_deck);
	shuffle_deck(game_deck,main_deck);

	LOCK_VARIABLE(x);
	LOCK_FUNCTION(inc_x);

 	install_int(inc_x, 1000);

	hi=load_high_score();
	tm=0;

	do
	{
		if (mouse_y<text_height(font)*2+20 && mtype==M_HAND)
		{
			Mouse.Change(M_NORMAL);
			mtype=M_NORMAL;
		}
		if (mouse_y>text_height(font)*2+20 && mtype==M_NORMAL)
		{
			Mouse.Change(M_HAND);
			mtype=M_HAND;
		}

		if (key[KEY_ESC]) 
		{
			dn=1; 
		}
		
		Draw_All();


		if ((mouse_b & 1) && mouse_state==UP)
		{ 
			mouse_state=DOWN;
			mouse_click(mouse_x,mouse_y);
		}
		if ((mouse_b & 1) && mouse_state==DOWN)
		{ 
			check_match();
		}

		if (!(mouse_b & 1) && mouse_state==DOWN)
		{ 
			mouse_state=UP;
			do_match();
			release_card();
			if (game_deck.card[0].flag==1)
			{
				check_high_score(Screen,tm);
				tm=0;
				shuffle_deck(game_deck,main_deck);	
			}
		}

		if (Mouse.Click())
		{
			if (mouse_x>=228 && mouse_x<288 &&
				mouse_y>=375 && mouse_y<470)
				next_card();

			p=Which_Button();
			if (p==2)
			{
				if (Message(Screen,"Quit?","Ok","Cancel","Are you sure you","Want to Quit?",END)==0)
				{
					dn=1;
				}
			}
		}
		if (Mouse.Held())
		{
			p=Which_Button();
			if (p<100)
				Draw_All();
			if (p==0)
			{
				l=Popup(Screen,Button[0],MyP[0]);
				if (l==0)
				{
					if (Message(Screen,"New Game?","Yes","No","Are you sure you want","to Start a New Game?",END)==0)
					{
						tm=0;
						shuffle_deck(game_deck,main_deck);
						current_round=0;
						oround=round=100;
					}
				}				
				if (l==2)
				{
					if (Message(Screen,"Quit?","Ok","Cancel","Are you sure you","Want to Quit?",END)==0)
					{
						dn=1;
					}
				}				
			}
			if (p==1)
			{
				l=Popup(Screen,Button[1],MyP[1]);
				if (l==0)
				{
					Info_Box(Screen,"Help","Ok",
						"The Basic Idea of this Game",
						"is to Match 13 points.",
						"",
						"    ie:",
						"10 and a 3",
						"Ace and a Jack",
						"5 and an 8",
						"",
						"",
						"To Win the Game, Just",
						"Clear the pyramid",
						"",
						"",
						END);
				}				
				if (l==2)
				{
					about(2000);
				}				
			}
		}


	} while (!dn);

	Delete_All();

	set_gfx_mode(GFX_TEXT,0,0,0,0);
	uninstall_dlib();
	return 1;
}

END_OF_MAIN();