#include <allegro.h>
#include <dlgraph.h>
#include "data.h"


#define WHITE		2
#define BLACK		1

#undef UP
#undef DOWN
#undef LEFT
#undef RIGHT

#define UP			1
#define DOWN		2
#define LEFT		4
#define RIGHT		8
#define UPLEFT		16
#define UPRIGHT		32
#define DOWNLEFT	64
#define DOWNRIGHT	128

DMenu Menu;
PopupStruct Pop1,Pop2;
DATAFILE *data;
int sz=0,
	grid[8][8],
	move[8][8],
	player,
	typePlayer[3],
	style,
	movesleft;



void Init_All();
void newGame();
void drawBoard();
void drawPawns();
void checkOpenSpaces();
void convertSpaces(int x,int y);
void drawOpenSpaces();
void Draw_All();
void openScreen();
int countSquares(int color);
void computerPlayer();
void findBest(int &xx, int &yy);
int changeSpot(int x,int y);
void nextPlayer();
int main();

void Init_All()
{
	install_dlib(640,480);

	player=BLACK;

	COLOR_TITLE			=	165;
	COLOR_TOP			=	15;
	COLOR_LIGHT			=	7;
	COLOR_DARK			=	8;
	COLOR_BOTTOM		=	31;
	
	COLOR_TEXT_UP		=	15;
	COLOR_TEXT_DOWN		=	31;

	MOUSE_WHITE			=	15;
	MOUSE_BLACK			=	31;

	game_name("Reversability");
	
	set_window_title(GAME_TITLE);

	data=load_datafile("data.dat");
	install_d_font((FONT*)data[MY_FONT].dat);
	set_palette((RGB*)data[MY_PAL].dat);

	text_mode(-1);

	Menu.Create(2,BOTTOM_OF_TITLE+2,true,"File","Help",END);
	Pop1.Create("New Game","---","Quit",END);
	Pop2.Create("Help","---","About",END);

	Title_Window(Screen,NULL,0,0,SCREEN_W,SCREEN_H,GAME_TITLE);

}

void Delete_All()
{
	Menu.Delete();
	uninstall_dlib();
	unload_datafile(data);
}
/*
void choosePlayerTypes()
{
	int x,y,dn=0;
	DRadioGroup r1,r2;
	DButton b;

	x=320-256/2;y=240-122/2;

	b.Create(x+97,y+90,50,16,"Start");

	r1.Create(x+40,y+40,0,40,0,20,"Human","Computer","@@@");	
	r2.Create(x+140,y+40,0,40,1,20,"Human","Computer","@@@");

	
	typePlayer[0]=NULL;
	typePlayer[1]=HUMAN;
	typePlayer[2]=COMPUTER;

	Title_Window(Screen,x,y,x+256,y+122,"Choose Player Types");
	Screen.Text("Black",x+50,y+20);
	Screen.Text("White",x+150,y+20);

	while (!dn)
	{
		r1.Draw(Screen);
		r2.Draw(Screen);
		b.Draw(Screen);

		Draw_Screen();

		if (Mouse.Click())
		{
			r1.Check_Button();
			r2.Check_Button();
			if (b.Pressed()) dn=1;
		}

	}
	typePlayer[1]=r1.Which_Select();
	typePlayer[2]=r2.Which_Select();

	b.Delete();	
} 
*/
void choosePlayerTypes()
{
	OPPONENT_TYPE p;
	choosePlayerTypes("Black","White",p);
	typePlayer[0]=NULL;
	typePlayer[1]=p.p1;
	typePlayer[2]=p.p2;
} 



void newGame()
{
	int x,y;
	for (x=0; x<8; x++)
	{
		for (y=0; y<8; y++)
		{
			grid[x][y]=0;
		}
	}
	grid[3][3]=WHITE;
	grid[3][4]=BLACK;
	grid[4][3]=BLACK;
	grid[4][4]=WHITE;

	player=BLACK;
 
	checkOpenSpaces();	
	choosePlayerTypes();
}

void drawBoard()
{
	int j;

	Screen.Rect_Fill(320-sz/2,240-sz/2,320+sz/2,240+sz/2,102);
	for (j=0; j<9; j++)
	{
			Screen.H_Line(320-sz/2,320+sz/2,240-sz/2+j*sz/8-1,31);
			Screen.H_Line(320-sz/2,320+sz/2,240-sz/2+j*sz/8,31);	
			Screen.V_Line(320-sz/2+j*sz/8-1,240-sz/2,239+sz/2,31);
			Screen.V_Line(320-sz/2+j*sz/8,240-sz/2,239+sz/2,31);	
	}
}

void drawPawns()
{
	int x,y;
	for (x=0; x<8; x++)
	{
		for (y=0; y<8; y++)
		{
			if (grid[x][y]>0)
			draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_01+grid[x][y]-1].dat,120+50*x,40+50*y);
		}
	}
}

void clearMove()
{
	int x,y;

	for (x=0; x<8; x++)
	{
		for (y=0; y<8; y++)
		{		
			move[x][y]=0;
		}
	}
	movesleft=0;
}

void checkOpenSpaces()
{
	int x,y,i,j,op;

	op=WHITE;
	if (player==op) op=BLACK;

	clearMove();

	for (x=0; x<8; x++)
	{
		for (y=0; y<8; y++)
		{		
			if (grid[x][y]==0)
			{
				if (x<6 && grid[x+1][y]==op)
				{
					i=x+2;
					while (i<=7)
					{								
						if (grid[i][y]==player) 
						{
							move[x][y]+=RIGHT;
							i=7;
						}
						if (grid[i][y]==0)
							i=7;
						i++;
					}
				}
				if (x>1 && grid[x-1][y]==op)
				{
					i=x-2;
					while (i>=0)
					{								
						if (grid[i][y]==player) 
						{
							move[x][y]+=LEFT;
							i=0;
						}
						if (grid[i][y]==0)
							i=0;
						i--;
					}
				}

				
				if (y<6 && grid[x][y+1]==op)
				{
					i=y+2;
					while (i<=7)
					{								
						if (grid[x][i]==player) 
						{
							move[x][y]+=DOWN;
							i=7;
						}
						if (grid[x][i]==0)
							i=7;
						i++;
					}
				}
				if (y>1 && grid[x][y-1]==op)
				{
					i=y-2;
					while (i>=0)
					{								
						if (grid[x][i]==player) 
						{
							move[x][y]+=UP;
							i=0;
						}
						if (grid[x][i]==0)
							i=0;
						i--;
					}
				}


				if (x>1 && y>1 && grid[x-1][y-1]==op)
				{
					i=x-2;j=y-2;
					while (i>=0 && j>=0)
					{								
						if (grid[i][j]==player) 
						{
							move[x][y]+=UPLEFT;
							i=0;j=0;
						}
						if (grid[i][j]==0)
						{
							i=0;j=0;
						}
						i--;j--;
					}
				}

				if (x<6 && y>1 && grid[x+1][y-1]==op)
				{
					i=x+2;j=y-2;
					while (i<=7 && j>=0)
					{								
						if (grid[i][j]==player) 
						{
							move[x][y]+=UPRIGHT;
							i=7;j=0;
						}
						if (grid[i][j]==0)
						{
							i=7;j=0;
						}
						i++;j--;
					}
				}


				if (x>1 && y<6 && grid[x-1][y+1]==op)
				{
					i=x-2;j=y+2;
					while (i>=0 && j<=7)
					{								
						if (grid[i][j]==player) 
						{
							move[x][y]+=DOWNLEFT;
							i=0;j=7;
						}
						if (grid[i][j]==0)
						{
							i=0;j=7;
						}
						i--;j++;
					}
				}

				if (x<6 && y<6 && grid[x+1][y+1]==op)
				{
					i=x+2;j=y+2;
					while (i<=7 && j<=7)
					{								
						if (grid[i][j]==player) 
						{
							move[x][y]+=DOWNRIGHT;
							i=7;j=7;
						}
						if (grid[i][j]==0)
						{
							i=7;j=7;
						}
						i++;j++;
					}
				}

			}
		}
	}
	for (x=0; x<8; x++)
	{
		for (y=0; y<8; y++)
		{		
			if (move[x][y]>0)
			{
				movesleft++;
			}
		}
	}
}


void convertSpaces(int x,int y)
{
	int i,op,j,k;

	op=WHITE;
	if (player==op) op=BLACK;

	k=move[x][y];
	if (k>=DOWNRIGHT)
	{
		i=x+1;j=y+1;
		while (i<=7 && j<=7 && grid[i][j]!=player)
		{
			grid[i][j]=player;
			i++;j++;
		}
		k-=DOWNRIGHT;
	}
	if (k>=DOWNLEFT)
	{
		i=x-1;j=y+1;
		while (i>=0 && j<=7 && grid[i][j]!=player)
		{
			grid[i][j]=player;
			i--;j++;
		}
		k-=DOWNLEFT;
	}
	if (k>=UPRIGHT)
	{
		i=x+1;j=y-1;
		while (i<=7 && j>=0 && grid[i][j]!=0)
		{
			grid[i][j]=player;
			i++;j--;
		}
		k-=UPRIGHT;
	}
	if (k>=UPLEFT)
	{
		i=x-1;j=y-1;
		while (i>=0 && i>=0 && grid[i][j]!=player)
		{
			grid[i][j]=player;
			i--;j--;
		}
		k-=UPLEFT;
	}

	if (k>=RIGHT)
	{
		i=x+1;
		while (i<=7 && grid[i][y]!=player)
		{
			grid[i][y]=player;
			i++;
		}
		k-=RIGHT;
	}
	if (k>=LEFT)
	{
		i=x-1;
		while (i>=0 && grid[i][y]!=player)
		{
			grid[i][y]=player;
			i--;
		}
		k-=LEFT;
	}
	if (k>=DOWN)
	{
		i=y+1;
		while (i<=7 && grid[x][i]!=player)
		{
			grid[x][i]=player;
			i++;
		}
		k-=DOWN;
	}
	if (k>=UP)
	{
		i=y-1;
		while (i>=0 && grid[x][i]!=player)
		{
			grid[x][i]=player;
			i--;
		}
		k=0;
	}

}

void drawOpenSpaces()
{
	int x,y;
	
	for (x=0; x<8; x++)
	{
		for (y=0; y<8; y++)
		{	
			if (move[x][y]>0)
			{
				draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_03].dat,120+50*x,40+50*y);
			}
		}
	}
}

void Draw_All()
{
	char msg[80];
	Menu.Draw(Screen);
	drawBoard();
	drawPawns();
	drawOpenSpaces();
	draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_01+player-1].dat,10,200);
	sprintf(msg,"Black Pieces:%ld     White Pieces:%ld",countSquares(BLACK),countSquares(WHITE));
	
	Screen.Rect_Fill(120,448,520,468,COLOR_LIGHT);
	Screen.Text_C(msg,320,448);
	Draw_Screen();

}

void openScreen()
{
	int j;
	char msg[80];
	Menu.Draw(Screen);
	draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_01+player-1].dat,10,200);
	sprintf(msg,"Black Pieces:%ld     White Pieces:%ld",countSquares(BLACK),countSquares(WHITE));	
	Screen.Rect_Fill(120,448,520,468,COLOR_LIGHT);
	Screen.Text_C(msg,320,448);
	Draw_Screen();
	for (j=0; j<400; j++) 
	{
		sz=j;
		drawBoard();
		Draw_Screen();
		pause(3);
	}
}

int changeSpot(int x,int y)
{
	if (move[x][y]>0)
	{
		grid[x][y]=player;
		convertSpaces(x,y);
		return true;
	}
	return false;
}

int countSquares(int color)
{
	int x,y,c=0;
	for (x=0; x<8; x++)
	{
		for (y=0; y<8; y++)
		{
			if (grid[x][y]==color) c++;
		}
	}
	return c;
}

void computerPlayer()
{
	int x=0,y=0;
	
	checkOpenSpaces();
	Draw_All();
	rest(200);

	findBest(x,y);

	changeSpot(x,y);

}

void findBest(int &xx, int &yy)
{
	int x,y,oldgrid[8][8],cx,cy,i,j,l,cc;

	for (x=0; x<8; x++)
	{
		for (y=0; y<8; y++)
		{
			oldgrid[x][y]=grid[x][y];
		}
	}
	cc=countSquares(player);
	for (x=0; x<8; x++)
	{
		for (y=0; y<8; y++)
		{
			for (i=0; i<8; i++)
			{
				for (j=0; j<8; j++)
				{
					grid[i][j]=oldgrid[i][j];			
				}
			}
			if (move[x][y]>0)
			{
				changeSpot(x,y);
				l=countSquares(player);
				if (l>cc)
				{
					cc=l;
					cx=x;
					cy=y;
				}
			}
		}
	}
	for (x=0; x<8; x++)
	{
		for (y=0; y<8; y++)
		{
			grid[x][y]=oldgrid[x][y];
		}
	}
	xx=cx;yy=cy;
}

void nextPlayer()
{
	if (player==WHITE)
	{
		player=BLACK;
	}
	else
	{
		player=WHITE;
	}
}

bool gameOver()
{
	char msg[80];

	strcpy(msg,"Black won the Game!");
	if (countSquares(WHITE)>countSquares(BLACK))
	{
		strcpy(msg,"White won the Game!");
	}


	if (Message(Screen,"Game Over","Yes","No",
									msg,
									"Do you want to",
									"Play Again?",
									END)==0)
	{
		return true;
	}
	return false;
}

int main()
{
	int dn=false,p,l;
	style=0;

	Init_All();
	rest(50);
	sz=400;
	openScreen();
	Draw_All();
	Mouse.Show();
	newGame();


	do
	{
		if (typePlayer[player]==COMPUTER)
		{
			computerPlayer();
			nextPlayer();
			checkOpenSpaces();
		}
		if (Mouse.Click())
		{
			if (mouse_x>=120 && mouse_x<=520 &&
			    mouse_y>=40 && mouse_y<=440)
			{
				if (typePlayer[player]==HUMAN && 
					changeSpot((mouse_x-120)/50,(mouse_y-40)/50))
				{
					nextPlayer();
					checkOpenSpaces();
				}
			}
			else
			{
				p=Menu.Which_Pressed();
				if (p==2)
				{
					if (Message(Screen,"Are You Sure","Yes","No",
									"Do you want to Quit?",END)==0)
					{
						dn=1;
					}
				}
			}
		}
		if (Mouse.Held())
		{
			p=Menu.Which_Pressed();		
			if (p==0) 
			{
				Draw_All();
				l=Popup(Screen,Menu.Button[p],Pop1);
				if (l==0)
				{
					if (Message(Screen,"Are You Sure","Yes","No",
									"You want to Start",
									"a New Game?",END)==0)
					{
						newGame();
					}
				}
				if (l==2)
				{
					if (Message(Screen,"Are You Sure","Yes","No",
									"Do you want to Quit?",END)==0)
					{
						dn=1;
					}
				}
			}
			if (p==1) 
			{
				Draw_All();
				l=Popup(Screen,Menu.Button[p],Pop2);
				if (l==0)
				{
					Info_Box(Screen,"Help","Next",
						"Place a chip on a Green",
						"Lighted Square",
						"If the opponents chip",
						"is in between the one you",
						"just placed and another",
						"You reverse the color!",
						"----------------------------",
						"Get the most Squares to Win!",
						END);
				}
				if (l==2)
				{
					about(2000);
				}
			}
		}
		if (!movesleft) 
		{
			Draw_All();
			if (gameOver())
			{
				newGame();
			}
			else
			{
				dn=1;
			}

		}
		if (key[KEY_ESC]) dn=1;
		Draw_All();

	} while (!dn);

	Delete_All();
	return 1;
}

END_OF_MAIN();
