//#include <dlib.h>
#include <allegro.h>
#include <string.h>
#include <stdio.h>
#include "data.h"

#define for if( false ) {} else for

#define MAX_TILES   144

typedef struct TileObject
{
    int     x;
    int     y;
    int     l;
    int     r;
    int     u;
    bool    c;

} TileObject;

typedef struct SaveGame
{
    int     gt[ MAX_TILES ];
    bool    c[ MAX_TILES ];
    int     s, s1, s2;
    int     t;
    int     tl;
    bool    p;
} SaveGame;

typedef struct ScoreObject
{
    char    nam[ 4 ];
    long    points;
} ScoreObject;

ScoreObject     hs;
BITMAP          *tilebmp[ 43 ];
BITMAP          *buffer;
DATAFILE        *data;
int             gtile[ MAX_TILES ];
int             sel;
int             tleft;
int             sel1;
int             sel2;
int             kl;
bool            paused;
bool            gameover;
bool            solving;
volatile int timer = 0;


TileObject      tile[ MAX_TILES ] =
{
    { 320, 203, 144, 144, 144, false },     //0
    { 300, 186, 144,   2,   0, false },     // 1
    { 332, 186,   1, 144,   0, false },     // 2
    { 300, 228, 144,   4,   0, false },     // 3
    { 332, 228,   3, 144,   0, false },     // 4
    { 264, 148, 144,   6, 144, false },     // 5
    { 296, 148,   5,   7, 144, false },     // 6
    { 328, 148,   6,   8, 144, false },     // 7
    { 360, 148,   7, 144, 144, false },     // 8
    { 264, 190, 144,  10, 144, false },     // 9
    { 296, 190,   9,  11,   1, false },     // 10
    { 328, 190,  10,  12,   2, false },     // 11
    { 360, 190,  11, 144, 144, false },     // 12
    { 264, 232, 144,  14, 144, false },     // 13
    { 296, 232,  13,  15,   3, false },     // 14
    { 328, 232,  14,  16,   4, false },     // 15
    { 360, 232,  15, 144, 144, false },     // 16
    { 264, 274, 144,  18, 144, false },     // 17
    { 296, 274,  17,  19, 144, false },     // 18
    { 328, 274,  18,  20, 144, false },     // 19
    { 360, 274,  19, 144, 144, false },     // 20
    { 228, 110, 144,  22, 144, false },     // 21
    { 260, 110,  21,  23, 144, false },     // 22
    { 292, 110,  22,  24, 144, false },     // 23
    { 324, 110,  23,  25, 144, false },     // 24
    { 356, 110,  24,  26, 144, false },     // 25
    { 388, 110,  25, 144, 144, false },     // 26
    { 228, 152, 144,  28, 144, false },     // 27
    { 260, 152,  27,  29,   5, false },     // 28
    { 292, 152,  28,  30,   6, false },     // 29
    { 324, 152,  29,  31,   7, false },     // 30
    { 356, 152,  30,  32,   8, false },     // 31
    { 388, 152,  31, 144, 144, false },     // 32
    { 228, 194, 144,  34, 144, false },     // 33
    { 260, 194,  33,  35,   9, false },     // 34
    { 292, 194,  34,  36,  10, false },     // 35
    { 324, 194,  35,  37,  11, false },     // 36
    { 356, 194,  36,  38,  12, false },     // 37
    { 388, 194,  37, 144, 144, false },     // 38
    { 228, 236, 144,  40, 144, false },     // 39
    { 260, 236,  39,  41,  13, false },     // 40
    { 292, 236,  40,  42,  14, false },     // 41
    { 324, 236,  41,  43,  15, false },     // 42
    { 356, 236,  42,  44,  16, false },     // 43
    { 388, 236,  43, 144, 144, false },     // 44
    { 228, 278, 144,  46, 144, false },     // 45
    { 260, 278,  45,  47,  17, false },     // 46
    { 292, 278,  46,  48,  18, false },     // 47
    { 324, 278,  47,  49,  19, false },     // 48
    { 356, 278,  48,  50,  20, false },     // 49
    { 388, 278,  49, 144, 144, false },     // 50
    { 228, 320, 144,  52, 144, false },     // 51
    { 260, 320,  51,  53, 144, false },     // 52
    { 292, 320,  52,  54, 144, false },     // 53
    { 324, 320,  53,  55, 144, false },     // 54
    { 356, 320,  54,  56, 144, false },     // 55
    { 388, 320,  55, 144, 144, false },     // 56
    { 128,  72, 144,  58, 144, false },     // 57
    { 160,  72,  57,  59, 144, false },     // 58
    { 192,  72,  58,  60, 144, false },     // 59
    { 224,  72,  59,  61, 144, false },     // 60
    { 256,  72,  60,  62, 144, false },     // 61
    { 288,  72,  61,  63, 144, false },     // 62
    { 320,  72,  62,  64, 144, false },     // 63
    { 352,  72,  63,  65, 144, false },     // 64
    { 384,  72,  64,  66, 144, false },     // 65
    { 416,  72,  65,  67, 144, false },     // 66
    { 448,  72,  66,  68, 144, false },     // 67
    { 480,  72,  67, 144, 144, false },     // 68
    { 192, 114, 144,  70, 144, false },     // 69
    { 224, 114,  69,  71,  21, false },     // 70
    { 256, 114,  70,  72,  22, false },     // 71
    { 288, 114,  71,  73,  23, false },     // 72
    { 320, 114,  72,  74,  24, false },     // 73
    { 352, 114,  73,  75,  25, false },     // 74
    { 384, 114,  74,  76,  26, false },     // 75
    { 416, 114,  75, 144, 144, false },     // 76
    { 160, 156, 144,  78, 144, false },     // 77
    { 192, 156,  77,  79, 144, false },     // 78
    { 224, 156,  78,  80,  27, false },     // 79
    { 256, 156,  79,  81,  28, false },     // 80
    { 288, 156,  80,  82,  29, false },     // 81
    { 320, 156,  81,  83,  30, false },     // 82
    { 352, 156,  82,  84,  31, false },     // 83
    { 384, 156,  83,  85,  32, false },     // 84
    { 416, 156,  84,  86, 144, false },     // 85
    { 448, 156,  85, 144, 144, false },     // 86
    { 128, 198, 101,  88, 144, false },     // 87
    { 160, 198,  87,  89, 144, false },     // 88
    { 192, 198,  88,  90, 144, false },     // 89
    { 224, 198,  89,  91,  33, false },     // 90
    { 256, 198,  90,  92,  34, false },     // 91
    { 288, 198,  91,  93,  35, false },     // 92
    { 320, 198,  92,  94,  36, false },     // 93
    { 352, 198,  93,  95,  37, false },     // 94
    { 384, 198,  94,  96,  38, false },     // 95
    { 416, 198,  95,  97, 144, false },     // 96
    { 448, 198,  96,  98, 144, false },     // 97
    { 480, 198,  97,  99, 144, false },     // 98
    { 512, 219, 144, 100, 144, false },     // 99 special
    { 544, 219,  99, 144, 144, false },     // 100
    {  96, 219, 144, 144, 144, false },     // 101
    { 128, 240, 101, 103, 144, false },     // 102
    { 160, 240, 102, 104, 144, false },     // 103
    { 192, 240, 103, 105, 144, false },     // 104
    { 224, 240, 104, 106,  39, false },     // 105
    { 256, 240, 105, 107,  40, false },     // 106
    { 288, 240, 106, 108,  41, false },     // 107
    { 320, 240, 107, 109,  42, false },     // 108
    { 352, 240, 108, 110,  43, false },     // 109
    { 384, 240, 109, 111,  44, false },     // 110
    { 416, 240, 110, 112, 144, false },     // 111
    { 448, 240, 111, 113, 144, false },     // 112
    { 480, 240, 112,  99, 144, false },     // 113
    { 160, 282, 144, 115, 144, false },     // 114
    { 192, 282, 114, 116, 144, false },     // 115
    { 224, 282, 115, 117,  45, false },     // 116
    { 256, 282, 116, 118,  46, false },     // 117
    { 288, 282, 117, 119,  47, false },     // 118
    { 320, 282, 118, 120,  48, false },     // 119
    { 352, 282, 119, 121,  49, false },     // 120
    { 384, 282, 120, 122,  50, false },     // 121
    { 416, 282, 121, 123, 144, false },     // 122
    { 448, 282, 122, 144, 144, false },     // 123
    { 192, 324, 144, 125, 144, false },     // 124
    { 224, 324, 124, 126,  51, false },     // 125
    { 256, 324, 125, 127,  52, false },     // 126
    { 288, 324, 126, 128,  53, false },     // 127
    { 320, 324, 127, 129,  54, false },     // 128
    { 352, 324, 128, 130,  55, false },     // 129
    { 384, 324, 129, 131,  56, false },     // 130
    { 416, 324, 130, 144, 144, false },     // 131
    { 128, 366, 144, 133, 144, false },     // 132
    { 160, 366, 132, 134, 144, false },     // 133
    { 192, 366, 133, 135, 144, false },     // 134
    { 224, 366, 134, 136, 144, false },     // 135
    { 256, 366, 135, 137, 144, false },     // 136
    { 288, 366, 136, 138, 144, false },     // 137
    { 320, 366, 137, 139, 144, false },     // 138
    { 352, 366, 138, 140, 144, false },     // 139
    { 384, 366, 139, 141, 144, false },     // 140
    { 416, 366, 140, 142, 144, false },     // 141
    { 448, 366, 141, 143, 144, false },     // 142
    { 480, 366, 142, 144, 144, false }
};

unsigned short order[ MAX_TILES ] =
{ 
     68,  67,  66,  65,  64,  63,  62,  61,  60,  59,  58,  57, 
     76,  75,  74,  73,  72,  71,  70,  69,  86,  85,  84,  83, 
     82,  81,  80,  79,  78,  77, 100,  99,  98,  97,  96,  95, 
     94,  93,  92,  91,  90,  89,  88,  87, 113, 112, 111, 110, 
    109, 108, 107, 106, 105, 104, 103, 102, 101, 123, 122, 121, 
    120, 119, 118, 117, 116, 115, 114, 131, 130, 129, 128, 127, 
    126, 125, 124, 143, 142, 141, 140, 139, 138, 137, 136, 135, 
    134, 133, 132,  26,  25,  24,  23,  22,  21,  32,  31,  30, 
     29,  28,  27,  38,  37,  36,  35,  34,  33,  44,  43,  42, 
     41,  40,  39,  50,  49,  48,  47,  46,  45,  56,  55,  54, 
     53,  52,  51,   8,   7,   6,   5,  12,  11,  10,   9,  16, 
     15,  14,  13,  20,  19,  18,  17,   2,   1,   4,   3,   0
};

int random( int u );
void inc_timer( void );
void loadHighScore( ScoreObject *hs );
void saveHighScore( ScoreObject *hs );
void resetBoard();
void save_game();
void load_game();
void drawBoard( BITMAP *bitmap );
void initTiles();
void initAll();
void deleteAll();
void convertSeconds( int s, char *tx );
void convertTime( int t, char *tx );
void drawTime();
void drawAll();
void Draw_Screen();
bool opentile( int s );
bool match( int s1, int s2 );
void grabTile( int x, int y );
bool matches_left( int &s1, int &s2 );
bool show_hint();
bool solve( int p );
void high_score();
void showHighScore();
void newGame();
int main();

int random( int u )
{
    return ( rand() % u );
}


void inc_timer( void )
{
    if ( !( paused || gameover || solving ) )
    {
        timer++;
    }
}
END_OF_FUNCTION( inc_timer );

void loadHighScore( ScoreObject *hs )
{
    PACKFILE *pfile;

    pfile = pack_fopen( "mahjongg.hs", "rp" );

    if ( pfile )
    {
        for ( int i = 0; i < 4; i++ )
        {
            hs->nam[ i ] = pack_getc( pfile );
        }
        
        hs->points = pack_igetl( pfile );

        pack_fclose( pfile );
    }
    else
    {
        strcpy( hs->nam, "---" );
        hs->points = 54000;
    }
}

void saveHighScore( ScoreObject *hs )
{
    PACKFILE *pfile;

    pfile = pack_fopen( "mahjongg.hs", "wp" );

    if ( pfile )
    {
        for ( int i = 0; i < 4; i++ )
        {
            pack_putc( hs->nam[ i ], pfile );
        }

        pack_iputl( hs->points, pfile );

        pack_fclose( pfile );
    }
}

void resetBoard()
{
    int p, tt[ MAX_TILES ];
    int tr[ MAX_TILES ] = 
    {  
         0,  0,  0,  0,  1,  1,  1,  1,  2,  2,  2,  2, 
         3,  3,  3,  3,  4,  4,  4,  4,  5,  5,  5,  5, 
         6,  6,  6,  6,  7,  7,  7,  7,  8,  8,  8,  8, 
         9,  9,  9,  9, 10, 10, 10, 10, 11, 11, 11, 11, 
        12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 
        15, 15, 15, 15, 16, 16, 16, 16, 17, 17, 17, 17, 
        18, 18, 18, 18, 19, 19, 19, 19, 20, 20, 20, 20, 
        21, 21, 21, 21, 22, 22, 22, 22, 23, 23, 23, 23, 
        24, 24, 24, 24, 25, 25, 25, 25, 26, 26, 26, 26, 
        27, 27, 27, 27, 28, 28, 28, 28, 29, 29, 29, 29, 
        30, 30, 30, 30, 31, 31, 31, 31, 32, 32, 32, 32, 
        33, 33, 33, 33, 34, 35, 36, 37, 38, 39, 40, 41
    };


    for ( int i = 0; i < MAX_TILES; i++ )
    {
        tile[ i ].c = false;
        tt[ i ]     = 0;
        gtile[ i ]  = MAX_TILES;
    }

    for ( int i = 0; i < MAX_TILES; i++ )
    {
        do
        {
            p = random( MAX_TILES );
        } while ( tt[ p ]  !=  0 );
        
        tt[ p ] = 1;
        gtile[ i ] = tr[ p ];
    }

    for ( int i = 0; i < MAX_TILES; i++ )
    {
        tile[ i ].c = false;
    }

    sel         = MAX_TILES;
    sel1        = MAX_TILES;
    sel2        = MAX_TILES;
    timer       = 0;
    tleft       = MAX_TILES;
    paused      = false;
    gameover    = false;
}

void getData( SaveGame *sg )
{
    for ( int i = 0; i < MAX_TILES; i++ )
    {
        sg->gt[ i ] = gtile[ i ];
        sg->c[ i ] = tile[ i ].c;
    }
    sg->p   =   paused;
    sg->s   =   sel;
    sg->s1  =   sel1;
    sg->s2  =   sel2;
    sg->t   =   timer;
    sg->tl  =   tleft;

}


void putData( SaveGame *sg )
{
    for ( int i=0; i < MAX_TILES; i++ )
    {
        gtile[ i ] = sg->gt[ i ];
        tile[ i ].c = sg->c[ i ];
    }
    paused  =   sg->p;
    sel     =   sg->s;
    sel1    =   sg->s1;
    sel2    =   sg->s2;
    timer   =   sg->t;
    tleft   =   sg->tl;
}

bool solve( int p )
{
    int t;
    SaveGame sg;

    solving = true;
    getData( &sg );
    t = tleft;

    while ( show_hint() )
    {
        if ( p == 1 )
        {
            drawAll();
            rest( 50 );
        }
        tile[ sel1 ].c = true;
        tile[ sel2 ].c = true;
        t -= 2;
        
        if ( p == 1 )
        {
            drawAll();
            rest( 50 );
        }
        
        if ( key[ KEY_S ] )
        {
            return true;
        }
    }
    
    putData( &sg );    
    solving = false;    
    kl = 0;
    
    if ( t == 0 )
    {
        return true;
    }

    return false;
}

void newGame()
{
    do
    {
        resetBoard();
    } while ( !solve( 0 ) );

    timer = 0;
}

void save_game()
{
    if ( !gameover )
    {
        PACKFILE *pfile;

        pfile = pack_fopen( "savegame.svg", "wp" );

        if ( pfile )
        {
            for ( int i = 0; i < MAX_TILES; i++ )
            {
                pack_iputl( gtile[ i ], pfile );

                if ( tile[ i ].c )
                {
                    pack_iputl( 1, pfile );
                }
                else
                {
                    pack_iputl( 0, pfile );
                }

            }
            if ( paused )
            {
                pack_iputl( 1, pfile );
            }
            else
            {
                pack_iputl( 0, pfile );
            }

            pack_iputl( sel, pfile );
            pack_iputl( sel1, pfile );
            pack_iputl( sel2, pfile );
            pack_iputl( timer, pfile );
            pack_iputl( tleft, pfile );

            pack_fclose( pfile );

            text_mode( 0 );
            textout_centre( buffer, font, "Game Saved!", SCREEN_W / 2, SCREEN_H / 2 - 4, makecol( 255, 255, 255 ) );
            Draw_Screen();
            rest( 1500 );
            text_mode( -1 );
        }

    }
}


void load_game()
{
    if ( !gameover )
    {
        PACKFILE *pfile;

        pfile = pack_fopen( "savegame.svg", "rp" );

        if ( pfile )
        {
            for ( int i = 0; i < MAX_TILES; i++ )
            {
                gtile[ i ] = pack_igetl( pfile );

                tile[ i ].c = false;
                if ( pack_igetl(  pfile ) == 1 )
                {
                    tile[ i ].c = true;
                }
            }
            
            paused  = false;
            if ( pack_igetl( pfile ) == 1 )
            {
                paused = true;
            }
            sel     = pack_igetl( pfile );
            sel1    = pack_igetl( pfile );
            sel2    = pack_igetl( pfile );
            timer   = pack_igetl( pfile );
            tleft   = pack_igetl( pfile );

            pack_fclose( pfile );
        }
        else
        {
            text_mode( 0 );
            for ( int i = -1; i <= 1; i++ )
            {
                for ( int j = -1; j <= 1; j++ )
                {
                    textout_centre( buffer, font, "Error: Loading Saved Game!", i + SCREEN_W / 2, j + SCREEN_H / 2 - 4, makecol( 255, 255, 255 ) );
                }
            }
            Draw_Screen();
            rest( 1500 );
            text_mode( -1 );
        }
    }
}

void drawBoard( BITMAP *bitmap )
{
    for ( int i = 0; i < MAX_TILES; i++ )
    {
        if ( !tile[ order[ i ] ].c )
        {
            int p = order[ i ];
            draw_sprite( bitmap, tilebmp[ gtile[ p ] ], tile[ p ].x - 4, tile[ p ].y );
            if ( sel == p || sel1 == p || sel2 == p )
            {
                draw_sprite( bitmap, ( BITMAP* )data[ SELECT ].dat, tile[ p ].x - 4, tile[ p ].y );
            }
        }
    }
}

void initTiles()
{
    int x[ 43 ] =
    { 
        0, 1, 2, 3, 4, 5, 6, 7, 8,
        0, 1, 2, 3, 4, 5, 6, 7, 8,
        0, 1, 2, 3, 4, 5, 6, 7, 8,
        0, 1, 2, 3, 4, 5, 6,
        0, 1, 2, 3, 4, 5, 6, 7
    };
    int y[ 43 ] = 
    {   0, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 1, 1, 1, 1, 1, 1, 1, 1,
        2, 2, 2, 2, 2, 2, 2, 2, 2,
        3, 3, 3, 3, 3, 3, 3,
        4, 4, 4, 4, 4, 4, 4, 4
    };

    for ( int i = 0; i < 43; i++ )
    {
        tilebmp[ i ] =  create_bitmap( 36, 46 );
        blit( ( BITMAP* )data[ TILES ].dat, tilebmp[ i ], x[ i ] * 36, y[ i ] * 46, 0, 0, 36, 46 );
    }
}

void initAll()
{
    allegro_init();
    install_keyboard();
    install_timer();
    install_mouse();

#ifdef ALLEGRO_WINDOWS
    set_window_title( "Mahjongg" );
#endif

    set_color_depth( 16 );
    if ( set_gfx_mode( GFX_AUTODETECT , 640 , 480 , 0 , 0 ) !=  0 )
    {
        set_color_depth( 15 );
        if ( set_gfx_mode( GFX_AUTODETECT , 640 , 480 , 0 , 0 ) !=  0 )
        {
            allegro_message( "Unable initialize graphics module\n % s\n" , allegro_error );
            return;
        }
    }

    set_display_switch_mode( SWITCH_PAUSE );

    buffer = create_bitmap( SCREEN_W, SCREEN_H );
    clear_bitmap( buffer );

    data = load_datafile( "data.dat" );

    text_mode( -1 );

    LOCK_VARIABLE( timer );
    LOCK_FUNCTION( inc_timer );

    install_int( inc_timer, 1000 );

    initTiles();

    loadHighScore( &hs );

    srand((int)time(NULL));

    kl = 0;
}

void deleteAll()
{
    if ( data )
    {
        unload_datafile( data );
    }

    if ( buffer )
    {
        destroy_bitmap( buffer );
    }

    for ( int i = 0; i < 43; i++ )
    {
        destroy_bitmap( tilebmp[ i ] );
    }
}

void convertSeconds( int s, char *tx )
{
    if ( s < 10 )
    {
        sprintf( tx, "0%d", s );
    }
    else
    {
        sprintf( tx, "%d", s );
    }
}

void convertTime( int t, char *tx )
{
    char mh[ 4 ], mm[ 4 ], ms[ 4 ];
    int m, s, h, p;
   
    p = t;
    m = 0;
    s = 0;
    h = 0;

    h = p / 3600;
    convertSeconds( h, mh );

    if ( h > 0 ) 
        p -= h * 3600;
    
    m = p / 60;
    convertSeconds( m, mm );

    if ( m > 0 ) 
        p -= m * 60;

    s = p;
    convertSeconds( s, ms );

    sprintf( tx, "Time %s:%s:%s", mh, mm, ms );
}

void drawTime()
{
    char msg[ 80 ];

    textout_centre( buffer, font, "Game Stats", 84, 128, makecol( 255, 255, 255 ) );
    
    convertTime( timer, msg );
    textout_centre( buffer, font, msg, 84, 168, makecol( 255, 255, 255 ) );

    if ( tleft > 0 )
    {
        sprintf( msg, "Tiles Left: %d", tleft );
    }
    else
    {
        sprintf( msg, "Tiles Left: %d", 0 );
    }
    textout_centre( buffer, font, msg, 84, 148, makecol( 255, 255, 255 ) );
}

void draw_mouse( int x, int y )
{
    int c = makecol( 0, 255, 0 );

    triangle( buffer, x, y, x + 4, y + 12, x + 14, y + 16, c );
    triangle( buffer, x, y, x + 4, y + 12, x     , y + 20, c );
    line( buffer, x    , y     , x + 14, y + 16, 0 );
    line( buffer, x    , y     , x     , y + 20, 0 );
    line( buffer, x + 4, y + 12, x + 14, y + 16, 0 );
    line( buffer, x + 4, y + 12, x     , y + 20, 0 );
}

void drawAll()
{
    char msg[ 80 ];

    if ( !( paused || gameover ) )
    {
        clear_to_color( buffer, makecol( 96, 0, 96 ) );
    }

    textout_centre( buffer, (FONT*)data[ MY_FONT ].dat, "Mahjongg", SCREEN_W / 2, 24, makecol( 255, 255, 255 ) );

    if ( !paused && !gameover )
    {
        drawBoard( buffer );

        textout_centre( buffer, font, "Lowest Time", 84, 310, makecol( 255, 255, 255 ) );
        textout_centre( buffer, font, hs.nam, 84, 320, makecol( 255, 255, 255 ) );
        convertTime( hs.points, msg );
        textout_centre( buffer, font, msg, 84, 330, makecol( 255, 255, 255 ) );
        drawTime();


        textout_centre( buffer, font, "Daniel Harmon", SCREEN_W - 100, SCREEN_H - 60, makecol( 255, 255, 255 ) );
textout_centre( buffer, font, "http://agdn.cjb.net", SCREEN_W - 100, SCREEN_H - 50, makecol( 255, 255, 255 ) );
    }
    
    if ( kl == 1 )
    {
        text_mode( 0 );
        for ( int i = -1; i <= 1; i++ )
        {
            for ( int j = -1; j <= 1; j++ )
            {
                textout_centre( buffer, font, "No More Matches!", i + SCREEN_W / 2, j + SCREEN_H / 2, makecol( 0, 0, 0 ) );
            }
        }

        textout_centre( buffer, font, "No More Matches!", SCREEN_W / 2, SCREEN_H / 2, makecol( 255, 255, 255 ) );

        text_mode( -1 );
    }

    if ( paused || gameover )
    {
        draw_sprite( buffer, tilebmp[ gtile[ random( MAX_TILES ) ] ], 16 + random( 572 ), 40 + random( 360 ) );

        if ( paused )
        {
            text_mode( 0 );
            for ( int i = -1; i <= 1; i++ )
            {
                for ( int j = -1; j <= 1; j++ )
                {
                    textout_centre( buffer, font, "Game Paused!", i + SCREEN_W / 2, j + SCREEN_H / 2, makecol( 0, 0, 0 ) );
                }
            }
                    
            textout_centre( buffer, font, "Game Paused!", SCREEN_W / 2, SCREEN_H / 2, makecol( 255, 255, 255 ) );

            text_mode( -1 );
        }
    }
    else
    {
        if ( !solving )
        {
            draw_mouse( mouse_x, mouse_y );
        }
    }

    textout_centre( buffer, font, "F1            F2             F3          ", SCREEN_W / 2, SCREEN_H - 20, makecol( 255,   0,   0 ) );
    textout_centre( buffer, font, "F8        F9                TAB         Esc     ", SCREEN_W / 2, SCREEN_H - 10, makecol( 255,   0,   0 ) );

    textout_centre( buffer, font, "   New Game      Load Game      Save Game", SCREEN_W / 2, SCREEN_H - 20, makecol( 192, 192, 255 ) );
    textout_centre( buffer, font, "   Hint      Solve Puzzle       Pause       Quit", SCREEN_W / 2, SCREEN_H - 10, makecol( 192, 192, 255 ) );

    textout_centre( buffer, font, "            |              |             ", SCREEN_W / 2, SCREEN_H - 20, makecol( 255, 255, 255 ) );
    textout_centre( buffer, font, "        |                 |           |         ", SCREEN_W / 2, SCREEN_H - 10, makecol( 255, 255, 255 ) );

    Draw_Screen();
}

void Draw_Screen()
{
    acquire_bitmap( screen );
    blit( buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H );
    release_bitmap( screen );
}

bool opentile( int s )
{
    if ( tile[ s ].u == MAX_TILES || tile[ tile[ s ].u ].c )
    {
        if ( s != 99 )
        {
            if ( tile[ s ].l == MAX_TILES || tile[ tile[ s ].l ].c ) 
                return true;
            if ( tile[ s ].r == MAX_TILES || tile[ tile[ s ].r ].c ) 
                return true;
        }
        else
        {            
            if ( tile[ s ].r == MAX_TILES || tile[ tile[ s ].r ].c ) 
                return true;

            if ( ( tile[ 98 ].l == MAX_TILES || tile[ tile[ 98 ].l ].c ) &&
                 ( tile[ 113 ].l == MAX_TILES || tile[ tile[ 113 ].l ].c ) ) 
                 return true;
        }
    }
    return false;
}

bool match( int s1, int s2 )
{
    if ( s1 != MAX_TILES && s2 != MAX_TILES )
    {
        if ( ( gtile[ s2 ] == gtile[ s1 ] ) ||
             ( gtile[ s2 ] >= 34 && gtile[ s2 ] <= 37 && gtile[ s1 ] >= 34 && gtile[ s1 ] <= 37 ) ||
             ( gtile[ s2 ] >= 38 && gtile[ s2 ] <= 41 && gtile[ s1 ] >= 38 && gtile[ s1 ] <= 41 ) )
        {
            return true;
        }
    }

    return false;
}

void grabTile( int x, int y )
{
    int s = MAX_TILES;
    
    sel1 = MAX_TILES;
    sel2 = MAX_TILES;
    
    if ( sel == MAX_TILES )
    {
        for ( int i = 0; i < MAX_TILES; i++ )
        {
            int p = order[ i ];
            
            if ( !tile[ p ].c )
            {
                if ( x >= tile[ p ].x && y >= tile[ p ].y && 
                     x <= tile[ p ].x + 32 && y <= tile[ p ].y + 42 )
                {
                    if ( opentile( p ) )
                    {
                        sel = p;
                    }
                }
            }
        }
    }
    else
    {
        for ( int i=0; i<MAX_TILES; i++ )
        {
            int p = order[ i ];

            if ( !tile[ p ].c && sel != p )
            {
                if ( x >= tile[ p ].x && y >= tile[ p ].y &&
                     x <= tile[ p ].x + 32 && y <= tile[ p ].y + 42 )
                {
                    if ( opentile( p ) )
                        s=p;
                }
            }
        }
        if ( s == MAX_TILES ) 
        {
            sel = MAX_TILES;
        }
    }

    if ( match( s, sel ) )
    {
        tile[ sel ].c = true;
        tile[ s ].c = true;
        tleft -= 2;
        sel = MAX_TILES;
        s = MAX_TILES;
    }
}

bool matches_left( int &s1, int &s2 )
{
    sel1 = MAX_TILES;
    sel2 = MAX_TILES;
    
    while ( mouse_b & 1 ) {}
    
    for ( int i = 0; i < MAX_TILES; i++ )
    {
        int p = order[ i ];
        if ( !tile[ p ].c && opentile( p ) )
        {
            for ( int j = 0; j < MAX_TILES; j++ )
            {
                int q = order[ j ];
                if ( !tile[ q ].c && p != q && opentile( q ) && match( p, q ) )
                {
                    s1 = p;
                    s2 = q;
                    return true;
                }
            }
        }
    }

    kl = 1;
    
    return false;
}

bool show_hint()
{
    return matches_left( sel1, sel2 );
}

void high_score()
{
    int p = timer;
    int q = 0;

    clear_keybuf();

    if ( p < hs.points )
    {
        hs.points = p;
        strcpy( hs.nam, "---" );

        text_mode( 0 );
        for ( int i = -1; i <= 1; i++ )
        {
            for ( int j = -1; j <= 1; j++ )
            {
                textout_centre( buffer, font, "You are the Champion!", i + SCREEN_W / 2, j + SCREEN_H / 2 - 24, makecol( 0, 0, 0 ) );
                textout_centre( buffer, font, "Enter Your Initials:", i + SCREEN_W / 2, j + SCREEN_H / 2 - 12, makecol( 0, 0, 0 ) );
            }
        }

        textout_centre( buffer, font, "You are the Champion!", SCREEN_W / 2, SCREEN_H / 2 - 24, makecol( 255, 255, 255 ) );
        textout_centre( buffer, font, "Enter Your Initials:", SCREEN_W / 2, SCREEN_H / 2 - 12, makecol( 255, 255, 255 ) );

        do
        {
            for ( int i = -1; i <= 1; i++ )
            {
                for ( int j = -1; j <= 1; j++ )
                {
                    textprintf_centre( buffer, font, i + SCREEN_W / 2, j + SCREEN_H / 2 + 12, makecol( 0, 0, 0 ), "%s", hs.nam );
                }
            }

            textprintf_centre( buffer, font, SCREEN_W / 2, SCREEN_H / 2 + 12, makecol( 255, 255, 255 ), "%s", hs.nam );

            while ( !keypressed() )
            {
                Draw_Screen();
            }

            hs.nam[ q++ ] = readkey() & 0xFF;

        } while ( q < 3 );

        saveHighScore( &hs );
        text_mode( -1 );
    }
}

void showHighScore()
{
    char tx[ 20 ];
    convertTime( hs.points, tx );
}

int main()
{
    bool done = false;
    bool mbutton = false;
    int a,b;

    initAll();
    newGame();

    while ( !done )
    {
        if ( mouse_b & 1 )
        {
            mbutton = true;
        }
        else
        {
            if ( mbutton )
            {
                if ( !( paused || gameover ) )
                {
                    grabTile( mouse_x, mouse_y );

                    if ( tleft == 0 )
                    {
                        gameover = true;
                    }
                
                    matches_left( a, b );
                }
            }
            mbutton = false;
        }

        drawAll();

        if ( gameover && tleft == 0 )
        {
            tleft = -1;
            high_score();
        }

        if ( key[ KEY_F1 ] )
        {
            text_mode( 0 );
            for ( int i = -1; i <= 1; i++ )
            {
                for ( int j = -1; j <= 1; j++ )
                {
                    textout_centre( buffer, font, "Starting a New Game", i + SCREEN_W / 2, j + SCREEN_H / 2 - 12, makecol( 0, 0, 0 ) );
                    textout_centre( buffer, font, "will Quit Current Game!", i + SCREEN_W / 2, j + SCREEN_H / 2 - 4, makecol( 0, 0, 0 ) );
                    textout_centre( buffer, font, "Continue? ( Y or N )", i + SCREEN_W / 2, j + SCREEN_H / 2 + 12, makecol( 0, 0, 0 ) );
                }
            }

            textout_centre( buffer, font, "Starting a New Game", SCREEN_W / 2, SCREEN_H / 2 - 12, makecol( 255, 255, 255 ) );
            textout_centre( buffer, font, "will Quit Current Game!", SCREEN_W / 2, SCREEN_H / 2 - 4, makecol( 255, 255, 255 ) );
            textout_centre( buffer, font, "Continue? ( Y or N )", SCREEN_W / 2, SCREEN_H / 2 + 12, makecol( 255, 255, 255 ) );
            text_mode( -1 );

            Draw_Screen();
            
            while( !( key[ KEY_Y ] || key[ KEY_N ] ) ) {}
            if ( key[ KEY_Y ] )
            {
                newGame();
            }
        }

        if ( key[ KEY_F2 ] )
        {
            text_mode( 0 );
            for ( int i = -1; i <= 1; i++ )
            {
                for ( int j = -1; j <= 1; j++ )
                {
                    textout_centre( buffer, font, "Loading a Saved Game", i + SCREEN_W / 2, j + SCREEN_H / 2 - 12, makecol( 0, 0, 0 ) );
                    textout_centre( buffer, font, "will Quit Current Game!", i + SCREEN_W / 2, j + SCREEN_H / 2 - 4, makecol( 0, 0, 0 ) );
                    textout_centre( buffer, font, "Continue? ( Y or N )", i + SCREEN_W / 2, j + SCREEN_H / 2 + 12, makecol( 0, 0, 0 ) );
                }
            }

            textout_centre( buffer, font, "Loading a Saved Game", SCREEN_W / 2, SCREEN_H / 2 - 12, makecol( 255, 255, 255 ) );
            textout_centre( buffer, font, "will Quit Current Game!", SCREEN_W / 2, SCREEN_H / 2 - 4, makecol( 255, 255, 255 ) );
            textout_centre( buffer, font, "Continue? ( Y or N )", SCREEN_W / 2, SCREEN_H / 2 + 12, makecol( 255, 255, 255 ) );
            text_mode( -1 );

            Draw_Screen();
            
            while( !( key[ KEY_Y ] || key[ KEY_N ] ) ) {}
            if ( key[ KEY_Y ] )
            {
                load_game();
            }

        }

        if ( key[ KEY_F3 ] )
        {
            save_game();

        }

        if ( key[ KEY_F8 ] )
        {
            show_hint();
        }

        if ( key[ KEY_F9 ] )
        {
            solve( 1 );
        }

        if ( key[ KEY_TAB ] )
        {
            while ( key[ KEY_TAB ] ) {}
            paused = !paused;
        }
        
        if ( key[ KEY_ESC ] ) 
        {
            text_mode( 0 );
            for ( int i = -1; i <= 1; i++ )
            {
                for ( int j = -1; j <= 1; j++ )
                {
                    textout_centre( buffer, font, "Quit Current Game!", i + SCREEN_W / 2, j + SCREEN_H / 2 - 12, makecol( 0, 0, 0 ) );
                    textout_centre( buffer, font, "( Y or N )", i + SCREEN_W / 2, j + SCREEN_H / 2, makecol( 0, 0, 0 ) );
                }
            }

            textout_centre( buffer, font, "Quit Current Game!", SCREEN_W / 2, SCREEN_H / 2 - 12, makecol( 255, 255, 255 ) );
            textout_centre( buffer, font, "( Y or N )", SCREEN_W / 2, SCREEN_H / 2, makecol( 255, 255, 255 ) );
            
            Draw_Screen();
            
            while( !( key[ KEY_Y ] || key[ KEY_N ] ) ) {}
            if ( key[ KEY_Y ] )
            {
                done = true;
            }
            text_mode( -1 );
        }

    }

    deleteAll();
    
    return 1;
}

END_OF_MAIN();
