#include "cmas.h"

USHORT  show_stocking=0,st_select=10,
		show_santa=0,show_box=0;

PopupStruct MyP[2];

void init_box()
{
	int i,p,dn=0;
	for (i=0; i<20; i++)
	{
		dn=0;
		while (!dn)
		{
			p=Random(26);
			if (v[p]==0) {v[p]=1;dn=1;}
		}
	}
	for (i=0; i<6; i++)
	{
	    dn=0;
		while (!dn)
	    {
		    p=Random(26);
			if (v[p]==0) {v[p]=2;dn=1;}
		}
	}
}

void install_music()
{
    /* install sound drivers */
	if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL)!=0) {exit(1);}
    set_volume(128,128);
}

void play_song(int s)
{
	play_midi((MIDI*)music[M001+s].dat, FALSE);
}



void init_stockings(void)
{
	int i;
	st=0;
	for (i=0; i<6; i++)
	{
	stocking[i].x=0;
		stocking[i].y=0;
		stocking[i].state=IN_BOX;
		stocking[i].type=0;
	}
}

void draw_stockings()
{
	int i,h=0;
	for (i=0; i<6; i++)
	{
		if (stocking[i].state==ON_MANTEL)
		{
			if (i==st_select)
			{
				h=show_stocking;
			}
			else
			{
				h=0;
			}
			draw_sprite(Screen.Bitmap,(BITMAP*)game2[RABBIT1+h].dat, stocking[i].x, stocking[i].y);
		}
		if (stocking[i].state==IN_HAND)
		{
			draw_sprite(Screen.Bitmap,(BITMAP*)game2[RABBIT1].dat,mouse_x-12, mouse_y-8);
		}
	}

}

void init_ornaments(void)
{
	int i;
	or=0;
	for (i=0; i<MAX_ORNAMENTS; i++)
	{
		ornament[i].x=0;
		ornament[i].y=0;
		ornament[i].state=IN_BOX;
		ornament[i].type=Random(4);
	}
}

void draw_ornaments(void)
{
	int i;
	for (i=0; i<MAX_ORNAMENTS; i++)
	{
		if (ornament[i].state==ON_TREE)
			draw_sprite(Screen.Bitmap,(BITMAP*)game2[ORN1+ornament[i].type].dat, ornament[i].x, ornament[i].y);
		if (ornament[i].state==IN_HAND)
			draw_sprite(Screen.Bitmap,(BITMAP*)game2[ORN1+ornament[i].type].dat, mouse_x-12, mouse_y);
	}
}

void Draw_All()
{
	blit((BITMAP*)game1[BACK].dat, Screen.Bitmap, 0,0,0,0, 640, 480);

	Title_Box(Screen,0,0,640,F_H+2,GAME_TITLE);

	Button[0].Draw(Screen);
	Button[1].Draw(Screen);
	Button[2].Draw(Screen);
	Button[3].Draw(Screen);
	Button[4].Draw(Screen);

	draw_ornaments();
	draw_stockings();
	draw_santa();
	draw_gift2();

	Draw_Screen();
}


void release_ornaments(int x, int y)
{
         ornament[or].state=ON_TREE;
         ornament[or].x=x-12;
         ornament[or].y=y;
         or++;
         hand=EMPTY;
}
void release_stockings(int x, int y)
{
         stocking[st].state=ON_MANTEL;
         stocking[st].x=x-12;
         stocking[st].y=y-8;
         draw_sprite((BITMAP*)game1[HBACK].dat,(BITMAP*)game2[SOCKBACK].dat,x-12, y-8);
         st++;
         hand=EMPTY;
}

void get_box(int x, int y)
{
	hand=EMPTY;
	if (q<26) 
	{
		if (v[q]==1)
		{
			ornament[or].state=IN_HAND;
			hand=ORNAMENT;
		}
		if (v[q]==2)
		{
			stocking[st].state=IN_HAND;
			hand=STOCKING;
		}
		if (v[q]!=0) {q++;}
	}
}

void draw_gift2()
{
		draw_sprite(Screen.Bitmap,(BITMAP*)game2[BOX1+show_box].dat, 314,404);		
}

void draw_gift()
{
	int i,j[8]={1,2,3,4,3,2,1,0};

	for (i=0; i<8; i++)
	{
		show_box=j[i];	    
		Draw_All();
		pause(250);
		if (i==3) pause(500);
    }
	
	show_box=0;

}

void draw_rabbit(int x, int y)
{
	int i,p=0,tx,ty;

	for (i=0; i<6; i++)
	{
	if (stocking[i].state==ON_MANTEL)
		if (x>stocking[i].x+5  &&
			x<stocking[i].x+53 &&
	        y>stocking[i].y+15 &&
		    y<stocking[i].y+104) {p=i;}
	}
	tx=stocking[p].x;
	ty=stocking[p].y;
	
	st_select=p;
	for (i=0; i<8; i++)
	{
	    show_stocking=i;
		Draw_All();
		pause(200);
		if (i>=5 && i<=7) pause(300);
		if (i==5) pause(400);
    }
	st_select=10;	
}

void draw_santa()
{
	draw_sprite(Screen.Bitmap,(BITMAP*)game2[SANTA01+show_santa].dat, 441,364);
}


void draw_jack()
{
	int i,j[22]={1,2,3,2,1,2,3,4,5,6,7,8,
            7,6,11,10,9,10,11,5,4,1};
	
	for (i=0; i<22; i++)    
	{		
		show_santa=j[i]-1;	    
		Draw_All();
		pause(100);
    }
	
	show_santa=0;
}

void draw_hole()
{
	int dn=0;
	acquire_screen();
	blit((BITMAP*)game1[MBACK].dat, screen, 0, 0, 0, 0, 640, 480);
	release_screen();
	while (!dn)
	{
		if (key[KEY_SPACE]) 
		{
			dn=1;
		}
		if (mouse_b & 1) 
		{
		    while (mouse_b & 1) {};
			dn=1;
		}
	}
	acquire_screen();
	blit((BITMAP*)game1[BACK].dat, screen, 0, 0, 0, 0, 640, 480);
	release_screen();
}

void fly()
{
    int dn=0,x,y;
    BITMAP *temp;

    temp = create_bitmap(115,214);

    x=-65;y=105;


	while (!dn)
	{
		blit((BITMAP*)game1[WIN1].dat, temp, 0, 0, 0, 0, 115, 214);
		draw_sprite(temp,(BITMAP*)game2[SLED].dat, x, y);
		draw_sprite(temp,(BITMAP*)game1[WIN2].dat, 0, 0);

		x=x+5;
		y=y-2;

		if (x==100) 
		{
			dn=1;
		}

		blit(temp,Screen.Bitmap, 0, 0, 506, 47, 115, 214);
		Draw_Screen();
		pause(100);


	}	
	destroy_bitmap(temp);
	acquire_screen();
	blit((BITMAP*)game1[WIN1].dat, screen, 0, 0, 506, 47, 115, 214);
	release_screen();
}

int hitwall(int x, int y)
{
	int i,j;
	for (i=x+8; i<x+16; i++)
	for (j=y+8; j<y+16; j++)
	if (getpixel((BITMAP*)game1[SBACK].dat,i,j)==169) 
	{	
		return(1);
	}

	return(0);
}

void play_maze()
{
	int x,y,dn=0,dir=0,ox,oy,p;

	DButton But;
	But.Create(640-text_length((FONT*)game1[MY_FONT].dat,"Done")-8,2,
				text_length((FONT*)game1[MY_FONT].dat,"Done")+4,F_H-2,"Done");

	x=y=ox=oy=20;
	play_midi((MIDI*)music[A_FROSTY].dat, TRUE);
	position_mouse(20,20);
	blit((BITMAP*)game1[SBACK].dat, Screen.Bitmap, 0, 0, 0, 0, 640, 480);
	draw_sprite(Screen.Bitmap,(BITMAP*)game2[WOOD1+dir].dat, x, y);
	Mouse.Hide();

	while (!dn)
	{
		p=0;
		if (Mouse.Click())
		{
			if (But.Pressed()) dn=1;
		}

		if (key[KEY_LEFT]) 
		{
			x=x-5;
            if (hitwall(x,y)==1) 
			{
				x=ox;p=1;
			}
        }
		if (key[KEY_RIGHT]) 
		{
			x=x+5;
            if (hitwall(x,y)==1) 
			{
				x=ox;p=1;
			}
		}
		if (key[KEY_UP]) 
		{
			y=y-5;
            if (hitwall(x,y)==1) 
			{
				y=oy;p=1;
			}
        }
		if (key[KEY_DOWN]) 
		{
			y=y+5;
            if (hitwall(x,y)==1) 
			{
				y=oy;p=1;
			}
        }

		if (mouse_x<x) 
		{
			x=x-5;
            if (hitwall(x,y)==1) 
			{
				x=ox;p=1;
			}
        }
		if (mouse_x>x)
		{
			x=x+5;
            if (hitwall(x,y)==1) 
			{
				x=ox;p=1;
			}
		}
		if (mouse_y<y)
		{
			y=y-5;
            if (hitwall(x,y)==1) 
			{
				y=oy;p=1;
			}
        }
		if (mouse_y>y) 
		{
			y=y+5;
            if (hitwall(x,y)==1) 
			{
				y=oy;p=1;
			}
        }

		if (p==1)
		{
			position_mouse(x,y);
		}

		ox=x;oy=y;
		if (key[KEY_ESC])  
		{	
			dn=1;
			while (key[KEY_ESC])  {}
		}

		if (getpixel((BITMAP*)game1[SBACK].dat,x,y)==160) {dn=1;}
		if (Random(100)>95) {dir++;if (dir==4) {dir=0;}}
		blit((BITMAP*)game1[SBACK].dat, Screen.Bitmap, 0, 0, 0, 0, 640, 480);
		draw_sprite(Screen.Bitmap,(BITMAP*)game2[WOOD1+dir].dat, x, y);

		But.Draw(Screen);
		Draw_Screen();
	} // end done

	Mouse.Show();
	stop_midi();
}

void play_memory()
{
	int i,dn=0,p,q=99,t=0,x,y,o[2]={0,0},z=0,
		ax[16]={190,260,330,400,190,260,330,400,190,260,330,400,190,260,330,400},
	    ay[16]={105,105,105,105,175,175,175,175,245,245,245,245,315,315,315,315},
		sq[16]={9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
		aq[16]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

//clear(Screen.Bitmap);
	set_mouse_range(119,34,520,430);
	play_midi((MIDI*)music[A_MEMORY].dat, TRUE);


	for (i=0; i<8; i++)
    {
		while (!dn)
		{
			p=Random(16);
			if (sq[p]==9) {sq[p]=i;dn=1;}
		}
		dn=0;
		while (!dn)
		{
			p=Random(16);
			if (sq[p]==9) {sq[p]=i;dn=1;}
		}
		dn=0;
    }


	dn=0;

	while (!dn)
	{
		rectfill(Screen.Bitmap, 109,24,530,445,32);
		rectfill(Screen.Bitmap, 114,29,525,440,109);

		for (i=0; i<16; i++)
			if (aq[i]<2)
		    {
				rectfill(Screen.Bitmap,ax[i],ay[i],ax[i]+49,ay[i]+49,104);
				if (aq[i]==0)
				    draw_sprite(Screen.Bitmap,(BITMAP*)game2[M_BLANK].dat, ax[i]+3,ay[i]+3);
		        else
					draw_sprite(Screen.Bitmap,(BITMAP*)game2[M_1+sq[i]].dat, ax[i]+3,ay[i]+3);
		    }
    
		if (z==8) {dn=1;}

		if (key[KEY_ESC])  
		{
			dn=1;
            while (key[KEY_ESC])  {}
        }

		if (mouse_b & 1) 
		{
			x=mouse_x;y=mouse_y;
            while (mouse_b & 1) {}

			for (i=0; i<16; i++)
		    if (aq[i]==0)
		    if (x>ax[i] && x<ax[i]+49 && y>ay[i] && y<ay[i]+49) 
			{
				aq[i]=1;q=i;o[t]=q;t++;
				rectfill(Screen.Bitmap,ax[i],ay[i],ax[i]+49,ay[i]+49,104);
				draw_sprite(Screen.Bitmap,(BITMAP*)game2[M_1+sq[i]].dat, ax[i]+3,ay[i]+3);
			}
        }

		if (t>1) 
		{
            if (sq[o[0]]==sq[o[1]]) 
			{
				aq[o[0]]=2;aq[o[1]]=2;z++;
			}
            else 
			{
				aq[o[0]]=0;aq[o[1]]=0;
			}
            t=0;
			pause(750);
        }

		Draw_Screen();

	} // end dn
	set_mouse_range(0,0,640,480);

	stop_midi();
}

void play_sledgame()
{
	int i,dn,x,sp,y,qq=0,t,l=0,score=0,type=0;
	int rx,ry,r;
	BITMAP *temp;
	char msg[80];

	temp=create_bitmap(640,480);
	clear(temp);

	set_mouse_range(0,190,10,364);
	play_midi((MIDI*)music[A_SLED].dat, TRUE);

	Mouse.Hide();

	for  (i=0; i<100; i++)
	{
		putpixel(temp,Random(640),Random(480),15);
		putpixel(temp,Random(640),Random(480),22);
	}

	rectfill(temp,0,200,640,480,16);

	while (!qq)
	{
		dn=0;x=0;sp=12;y=300;r=0;

		while (!dn)
		{
			blit(temp,Screen.Bitmap,0,0,0,0,640,480);

			if (x>0)  
			{
				draw_sprite(Screen.Bitmap,(BITMAP*)game1[TREES].dat,x-640,100);
			}

            draw_sprite(Screen.Bitmap,(BITMAP*)game1[TREES].dat,x,100);

			if (r==0) 
			{
				r=1;rx=0;ry=285+Random(150);t=Random(8);
				type=0;
				if (Random(10)==2) type=1;
			}
			if (r==1)
			{
				if (type==0)
				{
					draw_sprite(Screen.Bitmap,(BITMAP*)game2[M_1+t].dat,rx,ry);
				}
				else
				{
					draw_sprite(Screen.Bitmap,(BITMAP*)game2[ROCK].dat,rx,ry);
				}
			}

			draw_sprite(Screen.Bitmap,(BITMAP*)game2[SNOOPY].dat,400,y);

			y=mouse_y;

			if (mouse_b & 1) 
			{
				dn=1;qq=1;
			}

			x=x+sp;
			if (x>639) 
			{
				x=x-640;
			}
			rx=rx+sp;
			if (rx>639) {r=0;}

			if ((rx+44)>400    && rx<559 &&
				(ry+44)>(y+76) && ry<y+115) 
			{
				r=0;
				if (type==0)
				{
					l++;
					score+=10;
				    play_sample((SAMPLE *)game2[SAMPLE_YEAH].dat, 128, 128, 1000, FALSE);
				}
				else
				{
					dn=1;qq=1;
				    play_sample((SAMPLE *)game2[SAMPLE_BOING].dat, 128, 128, 1000, FALSE);
				}
			}

			if (l==150) {dn=1;}



			if (key[KEY_ESC]) 
			{
				dn=1;qq=1;
                while (key[KEY_ESC])  {}
            }
			rectfill(Screen.Bitmap,0,0,100,20,0);
			sprintf(msg,"Score:%d",score);
			Screen.Text(msg,10,2);
			Draw_Screen();
			pause(25);
		}
	}
	set_mouse_range(0,0,640,480);
	position_mouse(320,240);
	stop_midi();
	Mouse.Show();
}



void set_black()
{

    static RGB black = { 0,  0,  0  };
    vsync();

    set_color(31, &black);
	set_color(234, &black);

}

void play_coloring_book()
{

	int dn=0,co=15,x,y,p;
	DButton But;
	But.Create(640-text_length((FONT*)game1[MY_FONT].dat,"Done")-8,2,
				text_length((FONT*)game1[MY_FONT].dat,"Done")+4,F_H-2,"Done");


	blit((BITMAP*)game1[PAINT1+Random(5)].dat,Screen.Bitmap,0,0,0,0,640,480);
	blit((BITMAP*)game1[COLOR_WHEEL].dat,Screen.Bitmap,0,0,0,0,14,194);

	while (!dn)
	{
		if (Mouse.Click())
		{
			if (But.Pressed()) dn=1;
		}
		if (mouse_b & 1) 
		{
			x=mouse_x;y=mouse_y;
			if (x<14 && y<194)
			{
				p=getpixel(Screen.Bitmap,x,y);
				if (p!=0) 
				{
					co=p;
					MOUSE_WHITE=co;
					Mouse.Change(M_NORMAL);
				}
			}
			else
			{
				if (getpixel(Screen.Bitmap,x,y)!=0) 
				{
					floodfill(Screen.Bitmap,x,y,co);
				}
			}
        }

		if (key[KEY_ESC]) 
		{
		dn=1;
        while (key[KEY_ESC])  {}
		}

		blit(Screen.Bitmap,Screen.Bitmap,0,0,0,0,640,480);
		But.Draw(Screen);
		Draw_Screen();
	}

	MOUSE_WHITE=15;
	Mouse.Change(M_NORMAL);
}

void Splash()
{
	int dn=0;
	blit((BITMAP*)game1[OPEN].dat,Screen.Bitmap,0,0,0,0,640,480);	

    while (!dn) 
	{		
		Draw_Screen();
		if (key[KEY_ESC])  
		{
			dn=1;
            while (key[KEY_ESC])  {}
        }
        if (mouse_b & 1) 
		{
			dn=1;
            while (mouse_b & 1) {}
		}
	}

}

void Init_All()
{

	COLOR_TITLE=12;
	COLOR_TOP=15;
	COLOR_LIGHT=7;
	COLOR_DARK=8;
	COLOR_BOTTOM=31;

	COLOR_TEXT_UP=15;
	COLOR_TEXT_DOWN=31;

	MOUSE_WHITE=15;
	MOUSE_BLACK=31;

	Button[0].Create(4,BOTTOM_OF_TITLE,50,F_H+4,"File");
	Button[1].Create(56,BOTTOM_OF_TITLE,50,F_H+4,"Help");

	Button[2].Create(320,BOTTOM_OF_TITLE,32,32," ",(BITMAP*)game1[BUT1].dat);
	Button[3].Create(354,BOTTOM_OF_TITLE,32,32," ",(BITMAP*)game1[BUT2].dat);
	Button[4].Create(388,BOTTOM_OF_TITLE,32,32," ",(BITMAP*)game1[BUT3].dat);
}

void Delete_All()
{
	Button[0].Delete();
	Button[1].Delete();
	Button[2].Delete();
	Button[3].Delete();
	Button[4].Delete();
}

void Redraw_Main()
{	
	Title_Box(Screen,0,0,640,F_H+2,"Christmas Fun");
}

void my_menu()
{
	int i,j;
	for (i=0; i<10; i++)
	{
		for (j=0; j<2; j++)
		{
			strcpy(MyP[j].text[i],"@@@");			
		}		
	}
	strcpy(MyP[0].text[0],"Volume +");
	strcpy(MyP[0].text[1],"Volume -");
	strcpy(MyP[0].text[2],"---");
	strcpy(MyP[0].text[3],"Quit");

	strcpy(MyP[1].text[0],"Help");
	strcpy(MyP[1].text[1],"---");
	strcpy(MyP[1].text[2],"About");

}

int Which_Button()
{
	if (Button[0].Pressed()) return 0;
	if (Button[1].Pressed()) return 1;
	if (Button[2].Pressed()) return 2;
	if (Button[3].Pressed()) return 3;
	if (Button[4].Pressed()) return 4;

	return 100;
}


int main(void)
{

	int done=0,p,quit=0,x,y,kk=0,ee=0,l;
	install_dlib(640,480);
	Mouse.Show();
	install_music();

	game_name("Christmas Fun");

	game1=load_datafile("data_1.dat");
	game2=load_datafile("data_2.dat");
	music=load_datafile("music.dat");

	install_d_font((FONT*)game1[MY_FONT].dat);

	set_pallete((RGB*)game1[MY_PAL].dat);
	set_black();

	my_menu();
	Init_All();
	Mouse.Change(M_NORMAL);

	Splash();
	Redraw_Main();


	while (!quit)
	{
		ap=0;pp=0;mouse_state=UP;mous_type=0,vol=180;
		hand=EMPTY;or=0;st=0;q=0;
		init_box();
		init_ornaments();
		init_stockings();

		while (!done)
		{


			if (hand==ORNAMENT || hand==STOCKING)
			{
				Mouse.Hide();
			}
			else
			{
				Mouse.Show();
			}

			Draw_All();

			if (midi_pos<0)
			{
				song=Random(M027-M001)+M001;
				play_song(song);
			}

			if (Mouse.Click())
			{
				x=mouse_x;
				y=mouse_y;
				ee=0;
				p=Which_Button();
				switch (p)
				{
				case 2:
					{
						play_sledgame();
					} break;
				case 3:
					{
						play_memory();
					} break;
				case 4:
					{
						play_coloring_book();
					} break;
				default:
					{
						switch(getpixel((BITMAP*)game1[HBACK].dat,x,y))
						{
						case 246:
							if (hand==EMPTY)  
							{
								draw_rabbit(x,y);
							}
							break;
						case 247:
							if (hand==EMPTY)
							{
								play_maze();
								Redraw_Main();
							}
							break;
						case 248:
							if (hand==EMPTY)
							{
								draw_jack();
							}
							break;
						case 249:
							if (hand==EMPTY)
							{
								draw_hole();
							}
							break;
						case 250:
							if (hand==EMPTY)
							{
								draw_gift();
							}
							break;
						case 251:
							if (hand==EMPTY)
							{
								get_box(x,y);
							}
							break;
						case 252:
							if (hand==STOCKING)
							{
								release_stockings(x,y);
							}
							break;
						case 253:
							if (hand==ORNAMENT)
							{
								release_ornaments(x,y);
							}
							break;
						default:break;
						}
					}
				}
			}
		if (Mouse.Held())
		{
			p=Which_Button();
			if (p==0)
			{
				l=Popup(Screen,Button[0],MyP[0]);
				if (l==0)
				{
					vol+=32;
					if (vol>255) vol=255;
					set_volume(vol,vol);
				}
				if (l==1)
				{
					vol-=32;
					if (vol<0) vol=0;
					set_volume(vol,vol);
				}								
				if (l==3)
				{
					if (Message(Screen,"Quit?","Ok","Cancel","Are you sure you","Want to Quit?","@@@")==0)
					{
						done=quit=kk=1;
					}
				}				
			}
			if (p==1)
			{
				l=Popup(Screen,Button[1],MyP[1]);
				if (l==0)
				{
					Info_Box(Screen,"Help","Ok",
						"Just click on various items",
						"in the room. Click on the box",
						"in front of Snoopy to get an",
						"ornament. Then hang it on the",
						"tree.",
						"@@@");
				}				
				if (l==2)
				{
					about(2000);
				}				
			}
		}


			if ((key[KEY_LCONTROL]) && (key[KEY_Q])) 
			{
				done=1;
				quit=1;
			}
		}
		
	}
	done=0;

	stop_midi();
	if (kk==1) 
	{
		fly();
		Screen.Clear();
		Draw_All();
	}


	unload_datafile(game1);
	unload_datafile(game2);
	unload_datafile(music);
	Delete_All();
	uninstall_dlib();
	
	return 0;
}

END_OF_MAIN();

