//#include "titans_object.h"

class explosion
	{
     private:
     	float x,y;
        CAnim frames;
        int damage;
        int exist;
        SAMPLE *sound;
        int dangerous;  //0 = not dangerous, 1 = is dangerous
	public:
    	void init(CAnim animation, SAMPLE *s);
        void create(float xx, float yy, int ddamage);
        void draw(BITMAP *backgr, float s_x, float s_y);
        int get_w(void);
        int get_h(void);
        int check_col(BITMAP *pic, float xx, float yy);
        int ret_damage(void);
	};

int explosion :: ret_damage(void)
	{
     return damage;
    }

int explosion :: check_col(BITMAP *pic, float xx, float yy)
	{
     int ret=-1;
     if(exist==1)
       {
     	if(check_pp_collision(frames.ret_frame(),pic,
        	(int)x,(int)y,
        	(int)xx,(int)yy))
       	   {
        	ret=1;
       	   }
        }
     return ret;
    }


int explosion :: get_w(void)
	{
     return frames.ret_frame()->w;
    }

int explosion :: get_h(void)
	{
     return frames.ret_frame()->h;
    }

void explosion::init(CAnim animation, SAMPLE *s)
	{
     exist=0;
     frames=animation;
     sound=s;
     dangerous=0;
    }

void explosion::create(float xx, float yy, int ddamage)
	{
     x=xx;
     y=yy;
     damage=ddamage;
     exist=1;
     dangerous=1;
     play_sample(sound,255,128,1000,FALSE);
    }

void explosion::draw(BITMAP *backgr, float s_x, float s_y)
	{
     int ret=0;
     if(exist==1)
       {
     	ret=frames.draw_anim(backgr,(int)x-(int)s_x,(int)y-(int)s_y,2,1,1);
        if(ret>24) //past frame 24 the explosion is just smoke
          dangerous=0;
       if(ret==1000) //a return of 1000 means the animation is done
          {
          exist=0;
          frames.set_frame(0);
          }
       }
    }

class explosion_set
	{
     private:
     	explosion expl[20];
        int next;
     public:
     	void init(CAnim animation, SAMPLE *s);
        void create_new(float xx, float yy, int damage);
        void draw_all(BITMAP *backgr, float s_x, float s_y);
        int get_w(void);
        int get_h(void);
        int check_col(BITMAP *pic, float xx, float yy);
        int ret_damage(int n);
	};

int explosion_set :: ret_damage(int n)
	{
     return expl[n].ret_damage();
    }

int explosion_set :: check_col(BITMAP *pic, float xx, float yy)
	{
     int ret=-1;
     for(int n=0; n<20 ; n++)
        {
        ret=-1;
        ret=expl[n].check_col(pic,xx,yy);
        if(ret==1)
          {
          ret=n; //will return the number of the explosion that hit
          break;
          }
        }
     return ret;
     }

int explosion_set :: get_w(void)
	{
     return expl[next].get_w();
    }

int explosion_set :: get_h(void)
	{
     return expl[next].get_h();
    }

void explosion_set :: init(CAnim animation, SAMPLE *s)
	{
     next=0;
     for(int n=0; n<20 ; n++)
        expl[n].init(animation,s);
    }

void explosion_set :: create_new(float xx, float yy, int damage)
	{
     expl[next].create(xx,yy,damage);
     next++;
     if(next>=19)
       next=0;
    }

void explosion_set :: draw_all(BITMAP *backgr, float s_x, float s_y)
	{
     for(int n=0; n<20 ; n++)
        expl[n].draw(backgr,s_x,s_y);
    }


