// a class to hold a single instance of a projectile
//it will handle all moving, drawing and collision detection for the projectile
class projectile
	{
     private:
     	float x,y;
        float dx,dy; //it's delta x and y for how much it will move each loop

        part_att att;//it's attributes to define how it acts
        int exist;   //1 = it does exist, 0 = it does not
        int angle;
        float speed;

     public:
        //initalizes projectile
     	void init(void);

        //fires it with the given attribute set starting at x,y moving dx,dy
        //each turn at given angle
        void fire(part_att a, float xx, float yy, float dxx, float dyy, int aangle);

        //moves the projectile for one loop
        void move(CLayer *main_layer);

        //draws it on bitmap 'backgr' in relation to screen position of s_x,s_y
        void draw(BITMAP *backgr, float s_x, float s_y);

        //returns the recoil amount
        float send_recoil(void);

        int check_coll(float px, float py, BITMAP *pic);
        void not_fired(int explod);
        int get_damage(void);
        int get_ammo_type(void);
    };

int projectile::get_ammo_type(void)
	{
     return att.ammo_type;
    }

int projectile::get_damage(void)   //returns the amount of damage the projectile does
	{
     return att.damage;
    }

void projectile::not_fired(int explod) //eliminate the projectile
	{
    if(att.explode==1 && explod==1 && exist==1)
     	att.expl->create_new(x-att.expl->get_w()/2,
                             y-att.expl->get_h()/2,att.damage);

     exist=0;
    }

int projectile::check_coll(float px, float py, BITMAP *pic)
	{
     int ret=0;
     //check to see if the projectile hit the bitmap 'pic' at (px,py).
     if(exist==1)
       {
        for(int n=0; n<(int)speed ; n++)
           {

     	   if(check_pp_collision(att.pic,pic,
              (int)x+(int)(n*dx),(int)y+(int)(n*dy),
              (int)px,(int)py) && exist==1)
              {
     	       ret= 1;
               break;
              }
           else
               ret= 0;
           }
        }
       return ret;
     }

float projectile::send_recoil(void)
	{
     return (att.recoil);
    }

void projectile::draw(BITMAP *backgr, float s_x, float s_y)
	{
     //draw it only is it exists
     if(exist==1)
       {
     	rotate_sprite(backgr,att.pic,(int)x-(int)s_x,
                      	(int)y-(int)s_y,itofix(angle));

//        if(x-s_x>700 || x-s_x <-50 || y-s_y >520 || y-s_y <-50)
//          not_fired(0);
       }
    }

void projectile::move(CLayer *main_layer)
	{
     //as long as it's not moving faster than the max speed (defined in it's
     //attribute set) speed it up
     float xx,yy;

     if(exist==1)
       {
        if(speed<att.max_speed)
       	   speed+=att.accel;  //speeds up proj

        //goes through the postion where the projectile will be from now to
        //next loop
     	for(xx=abval(x) ; xx<abval(x)+speed ; xx++)
        	for(yy=abval(y) ; yy<abval(y)+speed ; yy++)
                if(main_layer->coll(xx,yy)!=-1) //checks to see the tile type
                  //it is hitting (0 is no tile)
              	   //exist=0;
                   not_fired(1);

        //moves it in the x and y directions
        x+=dx*speed;
     	y+=dy*speed;
        if(att.grav==1)
          {
           dy+=(gravity/2)/speed;
          }
       }
    }

void projectile::init(void)
	{
     //starts off non-existant
     exist=0;
     speed=0;
    }

void projectile::fire(part_att a, float xx, float yy, float dxx, float dyy, int aangle)
	{
     att=a;
     //get starting position, compensating for shot's picture size
     x=xx-att.pic->w/2;
     y=yy-att.pic->h/2;
     dx=dxx;
     dy=dyy;
     exist=1;
     angle=aangle;
     speed=5;//default starting speed
    }
