//the enemy class is an object that is specifiically designed to be computer-
//controlled
class enemy : public object
	{
     private:
     	int dir;    //the direction of movement
        float target_x, target_y;//the x and y position of it's target (the player)

     protected:
        float lx,rx;     //it's left and right range of motion
        int weapon_no;  //the weapon that it holds
        int holding;    //the number of powerup it is holding (-1 is nothing)

     public:
        int pic_num;    //the picture it uses
        int exist;      //flag 0=not exist, 1=exist

     	void init2(int ddir);

        void patrol_norm(float lx, float rx, int shoot); //patrols between two x points
        void patrol_jump(float lx, float rx, int shoot); //same as above, but jumps too

        void draw_life(BITMAP*backgr, float s_x, float s_y);
        void check_hit(object *player);

        //sets gun angle to point at the object 'player'
        void get_target_angle(object *player);

        //fire a shot (only fire if the enemy is onscreen)
        void enim_fire(float s_x, float s_y);

        int die(void);

        float ret_lx(void);
        float ret_rx(void);
        void set_lx(float llx);
        void set_rx(float rrx);

        //saves and loads enemy info to file 'fp'
        void save_enim(FILE *fp);
        void load_emim(FILE *fp);

        int get_wep_no(void);

        void set_pic(BITMAP *bmp, int n);
        void set_arm_pic(BITMAP *bmp);
        void switch_dir(void);
        int check_die(void);
        int ret_holding(void);
        void set_holding(int n);
        void stop();
     };

void enemy::stop(void)
{
    x_speed=0;
    y_speed=0;
}

void enemy::set_holding(int n)
	{
     holding=n;
    }

int enemy::ret_holding(void)
	{
     return holding;
    }

int enemy::check_die(void)
	{
     //die() will have a chance to return a value that is the number of the
     //weapon that the enemy was holding when it died.
     int ret=-1;
     if(life<=0)
       {
        ret=-2;
        ret=die();
       }

     //it will then return that value to the main game loop to create a pickup
     return ret;
    }

void enemy::switch_dir(void)
	{
     //change direction
     if(dir==1)
       dir=2;
     else if(dir==2)
       dir=1;
    }

void enemy::set_pic(BITMAP *bmp, int n)
	{
     //set the enemy's picture
     pic=bmp;
     pic_jump=bmp;
     pic_num=n;
     current_pic=pic;
    }

void enemy::set_arm_pic(BITMAP *bmp)
	{
     arm_pic=bmp;
    }

int enemy::get_wep_no(void)
	{
     return weapon_no;
    }

//void enemy::save_emim(FILE *fp)
void enemy::save_enim(FILE *fp)
	{
     //saves all of the enemy's info into the file 'fp'
     //they are all saved as ints to conserve space
     fprintf(fp,"%d ",(int)x);
     fprintf(fp,"%d ",(int)y);
     fprintf(fp,"%d ",(int)lx);
     fprintf(fp,"%d ",(int)rx);
     fprintf(fp,"%d ",weapon_no);
     fprintf(fp,"%d ",life);
     fprintf(fp,"%d ",pic_num);
     fprintf(fp,"%d ",holding);
     fprintf(fp,"%d ",exist);
    }

//void enemy::load_enim(FILE *fp)
void enemy::load_emim(FILE *fp)
	{
     //loads all of the enemy's info from file 'fp'
     //some of the info must be loaded as ints into temp variables
     //and then converted into floats
     int xx,yy,llx,rrx;

     fscanf(fp,"%d",&xx);
     fscanf(fp,"%d",&yy);
     fscanf(fp,"%d",&llx);
     fscanf(fp,"%d",&rrx);
     fscanf(fp,"%d",&weapon_no);
     fscanf(fp,"%d",&life);
     fscanf(fp,"%d",&pic_num);
     fscanf(fp,"%d",&holding);
     fscanf(fp,"%d",&exist);

     x=(float)xx;
     y=(float)yy;
     lx=(float)llx;
     rx=(float)rrx;
    }

//returns and sets the range of motion for the enemy.
//lx is for left x, rx is for right x.
float enemy::ret_lx(void)
	{
     return lx;
    }
float enemy::ret_rx(void)
	{
     return rx;
    }
void enemy::set_lx(float llx)
	{
     lx=llx;
    }
void enemy::set_rx(float rrx)
	{
     rx=rrx;
    }

void enemy::enim_fire(float s_x, float s_y)
     {
      //if the enemy is onscreen, fire
     if(x-s_x >-40 && x-s_x<680 && y-s_y >-40 && y-s_y <520)
     	fire();  //(fire is defined in the object class)
     }

void enemy::get_target_angle(object *player)
	{
     float fAngle;  //a fixed number angle (fixed is a type defined in allegro)
     int iAngle;

     target_x=player->ret_x();
     target_y=player->ret_y();

     //gets the angle it needs to point at using the gwt_angle function
     //defined in the 'titans_maths.h' file
     fAngle = get_angle(x,y,player->ret_x(),player->ret_y());
     fAngle += M_PI/2;

     iAngle =(int)(fAngle * Rad2AllegroDeg); //converts angle in rads into an int in allegro degrees

     //decrease angle to the nearest ten to make the enemy less
     //accurate
     iAngle -= iAngle%10;


     //set the gun's angle based on which direction it is facing
     if(dir==1  && x < player -> ret_x())
       {
        //facing left, use the real angle
     	gun[wep].set_angle(iAngle);
       }
     else if(dir==2  && x > player -> ret_x())
       {
        //facing right, use 256 minus the real angle
     	gun[wep].set_angle(256-iAngle);
       }
    }

void enemy::check_hit(object *player)
	{
     //damage becomes the value returned by the function to check proj_col
     //it will check to see if any of the player's projectiles hit the object
     //passed to it: 'this'.
	 int damage=player->check_proj_col(this);

     //if damage is done
     if(damage>0 && life!=-1)
       {
        //enemy looses the life
        life-=damage;
       }
     }

void enemy::draw_life(BITMAP *backgr, float s_x, float s_y)
	{
     textprintf(backgr,font,(int)x-(int)s_x,(int)y-(int)s_y-10,10,"%d",life);
    }

void enemy::init2(int ddir)
	{
     dir=ddir;
     life=100;
     exist=1;
     pic_num=0;
     holding=-1;
    }

void enemy::patrol_norm(float lx, float rx, int shoot)
	{
     if(shoot==1)
       {
        if(dir==1  && x < target_x)
       	   enim_fire(target_x-320,target_y-240);
        if(dir==2  && x > target_x)
       	   enim_fire(target_x-320,target_y-240);
       }

     if(dir==1 && x<rx)
       {
        on_right();
       }
     else if(dir==1 && x>=rx)
       {
        dir=2;
       }

     if(dir==2 && x>lx)
       {
        on_left();
       }
     else if(dir==2 && x<=lx)
       {
        dir=1;
       }

    }

void enemy::patrol_jump(float lx, float rx, int shoot)
	{
     patrol_norm(lx,rx,shoot);
     on_jump();
    }

int enemy::die(void)
	{
     int ret=-2;    //ret of -2 means he did die
     exist=0;

     if(holding!=0)  //if he is holding a special pickup
       {
        ret=holding;
        if(holding==-1)
          ret=0;
       }
     else
       {

     	//create a random number between 0 and 100
     	int r=rand()%100;

     	//the the random number is less than 35 (a 35% chance)
     	//and the enemy is not holding the standard gun
     	if(r<35 && weapon_no!=-1)
      	   {
         	//return his weapon number
          	ret= weapon_no;
         	//the main loop will use this number to create a new powerup
         	}
       	else
           {
           ret =-2;  //he did die
           }
        }

     return ret;
    }

