#include <allegro.h>
#include <string>
#include <vector>
#include "ofuncs.h"

using std::string;
using std::vector;

Number_Opt::Number_Opt(int ival, int mav, int miv, int inc, string n) {
	val = ival;
	max_val = mav;
	min_val = miv;
	incr = inc;
	name = n;
}



void Number_Opt::display_opt(const int xp, const int yp, const int col) const {
	textprintf(screen, font, xp, yp, col, "%s %i", name.c_str(), val);
}



void Start_Opt::display_opt(const int xp, const int yp, const int col) const {
	textprintf(screen, font, xp, yp, col, "%s", name.c_str());
}



void Arena_Opt::increase() {
	ar_index++;
	int poo = ar_names.size();
	if(ar_index > (poo - 1))
		ar_index = (poo - 1);
}



void Arena_Opt::decrease() {
	ar_index--;
	if(ar_index < -1)
		ar_index = -1;
}



void Arena_Opt::display_opt(const int xp, const int yp, const int col) const {
	if(ar_index <= -1)
		textprintf(screen, font, xp, yp, col, "%s %s", name.c_str(), "No arena");
	else
		textprintf(screen, font, xp, yp, col, "%s %s", name.c_str(), ar_names[ar_index].c_str());
}



BITMAP * Arena_Opt::get_arena_pic(PALETTE p) const {
	BITMAP * atmp = load_bitmap((ar_names[ar_index]).c_str(), p);
//	BITMAP * atmp = load_bitmap("arena2.bmp", p);
	return atmp;
}



/* is_pushed()
 * debounced keyboard checking
 */
bool is_pushed(int the_key) {
	static bool keydown;
	
	if(!(key[KEY_UP] || key[KEY_DOWN] || key[KEY_LEFT] || key[KEY_RIGHT] || key[KEY_ENTER])) {
		keydown = 0;
	}	//but if a key is pressed, keydown isn't set to 1 until the press is registered.

	if(key[the_key] && !keydown) {
		keydown = 1;
		return 1;
	}
	else return 0;
}



void update(BITMAP * bg, BITMAP * c_pic, int c_pos, const vector<Option *>& ov) {
	clear(screen);
	blit(bg, screen, 0, 0, 0, 0, 320, 200);

	const int s_y = 90;
	const int y_i = 20;
	const int c_x = 30;
	const int o_x = 70;
	const int o_colr = 30;

	for(int i = 0; i < ov.size(); i++) {
		int temp_y = s_y + (y_i * i);
		ov[i]->display_opt(o_x, temp_y, o_colr);
	}

	draw_sprite(screen, c_pic, c_x, (c_pos * y_i) + s_y);
}