//main.cc

#include <allegro.h>
#include "caddat.h"
#include "modules.h"
#include "structs.h"

int main() {

	allegro_init();
	install_keyboard();
	install_timer();
	install_sound (DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
	set_gfx_mode(GFX_AUTODETECT, SCR_X, SCR_Y, 0, 0);

	DATAFILE * caddat;
	caddat = load_datafile("cad.dat");
	PALETTE * gpal = (PALETTE *)caddat[GPAL].dat;

	game_options options = optscreen(caddat, *gpal);
	game_stats stats = game(options, caddat, *gpal);
	endscreen(caddat, *gpal, stats);

	unload_datafile(caddat);
	allegro_exit();
	return 0;
}
END_OF_MAIN();