#include <vector>
#include <allegro.h>
#include <stdlib.h>
#include <time.h>

#include "modules.h"	//declaration of game()
#include "gfuncs.h"
#include "structs.h"
#include "Knave.h"
#include "Bonus_Gen.h"
#include "Bonus.h"
#include "Statbar.h"
#include "Jukebox.h"

using std::vector;

// TIMER FUNCTIONS AND COUNTER VARIABLES

volatile unsigned long target_cycles;
void draw_limiter (...)
{
	target_cycles++;
}
END_OF_FUNCTION (draw_limiter);

volatile int time_left;
void time_left_measurer(...)
{
	time_left--;
}
END_OF_FUNCTION (time_left_measurer);



game_stats game(game_options opts, DATAFILE * dat, PALETTE& pal) {

	game_stats stats;
	
	set_palette(pal);
	BITMAP * buffer = create_bitmap(SCR_X, SCR_Y);
	clear(buffer);

	BITMAP * arena;
	if(opts.blank_arena) {
		arena = create_bitmap(SCR_X, SCR_Y);
		clear(arena);
	}
	else arena = opts.arena;

	SAMPLE * cad_catch = (SAMPLE *)dat[SCATCH].dat;	//put this somewhere more sensible?

	Statbar statbar(dat);
	Bonus_Gen bgen(dat);
	Jukebox jbox(dat);

	vector<Bonus> bonuses;
	vector<Knave> knaves;
	if(opts.players >= 1)
		knaves.push_back(Knave(init_controls(0), init_sprites(2, dat), 0, 0, "Zombie Dave"));
	if(opts.players >= 2)
		knaves.push_back(Knave(init_controls(1), init_sprites(3, dat), K_LIM_X, 0, "Insincere Dave"));
	if(opts.players >= 3)
		knaves.push_back(Knave(init_controls(2), init_sprites(0, dat), 0, K_LIM_Y, "Skeletor"));
	if(opts.players >= 4)
		knaves.push_back(Knave(init_controls(3), init_sprites(1, dat), K_LIM_X, K_LIM_Y, "Burgers"));
	
	srand(time(NULL));	//seed rand
	knaves[int(rand() % knaves.size())].becad();	//random cad at start of game

	time_left = opts.game_time;

	LOCK_FUNCTION(time_left_measurer);
	LOCK_VARIABLE(time_left);
	install_int(time_left_measurer, 1000);	//1 second per update

	LOCK_FUNCTION(draw_limiter);
	LOCK_VARIABLE(target_cycles);
	install_int(draw_limiter, opts.MSPC);

	unsigned long cycles = 0;

	bool end_beeps_playing = 0;

	while(time_left > 0) {
	
		if(key[KEY_ESC]) {
			allegro_exit();
			exit(1);
		}

		if(jbox.not_playing() && jbox.is_on() && !end_beeps_playing) {
			jbox.rand_track();
			jbox.play();
		}

		if(time_left <= 3 && !end_beeps_playing) {
			end_beeps_playing = 1;
			jbox.play_end_beeps();
		}

		clear(buffer);
		draw_sprite(buffer, arena, 0, 0);
		draw_sprite(buffer, statbar.get_pic(time_left), 0, 180);

		for(int i = 0; i < knaves.size(); i++)
			draw_sprite(buffer, knaves[i].get_pic(), knaves[i].get_x_pos(), knaves[i].get_y_pos());
		for(int i = 0; i < bonuses.size(); i++)
			draw_sprite(buffer, bonuses[i].get_pic(), bonuses[i].get_x_pos(), bonuses[i].get_y_pos());

		blit(buffer, screen, 0, 0, 0, 0, SCR_X, SCR_Y);

		//'Game logic' loop
		while(cycles < target_cycles && !key[KEY_ESC]) {
			for(int i = 0; i < knaves.size(); i++) {
				knaves[i].dirs_from_keys();
				knaves[i].travel();
				knaves[i].fade_timer();				

				if(out_of_bounds(knaves[i]))
					knaves[i].stop();
				
				if(hit_wall(knaves[i], arena)) {
					if(!knaves[i].is_passing()) {
						if(knaves[i].is_in_wall()) {
							safe_tele (knaves[i], i, -1, knaves, bonuses, arena);
							knaves[i].freeze();
						}
						else
							knaves[i].stop();

						knaves[i].set_nin_wall();
					}
					else knaves[i].set_in_wall();
				}
				else knaves[i].set_nin_wall();

				for(int j = 0; knaves[i].is_cad() && j < knaves.size(); j++) {
					if((j != i) && collide_check(knaves[i], knaves[j]) && !knaves[j].is_invulnerable()) {
						knaves[i].decad();
						safe_tele(knaves[i], i, -1, knaves, bonuses, arena);
						knaves[j].becad();
						knaves[j].stop();
						play_sample(cad_catch, 255, 128, 1000, 0);
					}
				}
	
				for(int k = 0; k < bonuses.size(); k++) {
					if(collide_check(knaves[i], bonuses[k])) {
						handle_bonus(bonuses[k].get_form(), knaves, i, bonuses, bgen, arena);
						play_sample(bonuses[k].get_noise(), 255, 128, 1000, 0);
						bonuses.erase(bonuses.begin() + k);
						break;	//can only collect one bonus at once (and avoids a potential bug)
					}
				}

			} //end of knave loop

			for(int i = 0; i < bonuses.size(); i++) {
				if(bonuses[i].fade()) {
					bonuses.erase(bonuses.begin() + i);
					i--;	//so it doesn't miss one out
				}
			}

			if((rand() % opts.p_freq) > opts.p_freq - 2) {
				bonuses.push_back(make_bonus(bgen));
				int n = bonuses.size() - 1;
				safe_tele(bonuses[n], -1, n, knaves, bonuses, arena);
				//could result in -1 being passed, but should only be called when size() > 0
			}
			
			cycles++;
			cycle_palette(pal);	//unrelated
		}
	}

	remove_int(time_left_measurer);
	remove_int(draw_limiter);
	time_left = 0;
	draw_sprite(screen, statbar.get_pic(time_left), 0, 180);
	rest(3000);
	jbox.stop();

	for(int i = 0; i < knaves.size(); i++) {
		if(knaves[i].is_cad()) {
			stats.pic = knaves[i].get_n_pic();
			stats.name = knaves[i].get_name();
			break;
		}
	}
	destroy_bitmap(arena);
	return stats;
}