#include <allegro.h>
#include "Jukebox.h"
#include "caddat.h"
#include "modules.h"

using std::string;

void endscreen(DATAFILE * d, PALETTE& pal, game_stats stats) {
	BITMAP * bg = (BITMAP *)d[ENDSCREEN].dat;
	set_palette(pal);
	clear(screen);
	blit(bg, screen, 0, 0, 0, 0, 320, 200);
	draw_sprite(screen, stats.pic, 150, 40);
	textprintf_centre(screen, font, 160, 70, 30, "%s is the Cad", stats.name.c_str());
	
	Jukebox jbox(d);
	jbox.play_taunt();

	while(!(key[KEY_ESC] || key[KEY_SPACE])) {}
	jbox.stop();
}