#include "Statbar.h"

Statbar::Statbar(DATAFILE * d) {
	pic = create_bitmap(320, 20);

	the_bar = (BITMAP *)d[SBARPIC].dat;
	
	digit_map[0] = (BITMAP *)d[DIG0].dat;
	digit_map[1] = (BITMAP *)d[DIG1].dat;
	digit_map[2] = (BITMAP *)d[DIG2].dat;
	digit_map[3] = (BITMAP *)d[DIG3].dat;
	digit_map[4] = (BITMAP *)d[DIG4].dat;
	digit_map[5] = (BITMAP *)d[DIG5].dat;
	digit_map[6] = (BITMAP *)d[DIG6].dat;
	digit_map[7] = (BITMAP *)d[DIG7].dat;
	digit_map[8] = (BITMAP *)d[DIG8].dat;
	digit_map[9] = (BITMAP *)d[DIG9].dat;
}



void Statbar::make_pic() {
	clear(pic);
	draw_sprite(pic, the_bar, 0, 0);

	int cdx = dig_xs;
	for(int i = 0; i < no_of_ds; i++) {
		draw_sprite(pic, current_digit[i], cdx, dig_y);
		cdx += dig_xs;
	}
}



BITMAP * Statbar::get_pic(int tl) {
	calculate_digits(tl);
	make_pic();
	return pic;
}



void Statbar::calculate_digits(int tl) {
	int i = 0;
	for(float multiplier = 100; multiplier >= 1; multiplier /= 10) {
		for(int j = 9; j >= 0; j--) {
			if(tl >= (j * multiplier)) {
				current_digit[i] = digit_map[j];
				tl -= int((j * multiplier));	//get rid of the hundreds to check the tens, etc.
				break;
			}
		}
	i++;
	}
}