//Knave.cc
//Functions for the Knave class (Knave.h)

#include "Knave.h"

Knave::Knave(const control_set i_cset, const sprite_set i_sset, const int i_xp, const int i_yp, const string i_name) {
	set_controls(i_cset);

	k_sp = i_sset.ksp;
	c_sp = i_sset.csp;
	f_sp = i_sset.fsp;
	s_sp = i_sset.ssp;
	p_sp = i_sset.psp;
	r_sp = i_sset.rsp;
	i_sp = i_sset.isp;
	n_sp = i_sset.nsp;

	set_x_pos(i_xp);
	set_y_pos(i_yp);
	name = i_name;

	x_dir = y_dir = 0;
	cadhood = 0;
	b_type = 0;
	b_timer = -1;
	set_size(X_SIZE, Y_SIZE);
	set_nin_wall();
}



Knave::Knave(const int ix, const int iy) {
	//Only to be used for collision-checking purposes.
	//Don't try to access its sprites, keys, bonus stuff, name, direction
	//or anything at all except its position and size.

	set_x_pos(ix);
	set_y_pos(iy);
	set_size(X_SIZE, Y_SIZE);
	set_nin_wall();
}



void Knave::dirs_from_keys() {
	if (key[controls.up])     { x_dir =  0; y_dir = -1; return; }
	if (key[controls.down])   { x_dir =  0; y_dir =  1; return; }
	if (key[controls.left])   { x_dir = -1; y_dir =  0; return; }
	if (key[controls.right])  { x_dir =  1; y_dir =  0; return; }
}



BITMAP * Knave::get_pic() const {
	//could use a map here, but ordering is important
	//possibly have 'get sprite_map[type]' with ifs...

	if(b_type == INVISIBLE)    return n_sp;
	if(cadhood)                return c_sp;
	if(b_type == FROZEN)       return f_sp;
	if(b_type == INVULNERABLE) return i_sp;
	if(b_type == PASSING)      return p_sp;
	if(b_type == SPEEDY)       return s_sp;
	if(b_type == REVERSED)     return r_sp;
	/* if nothing */           return k_sp;
}



void Knave::stop() {
	set_x_pos(old_x_pos);
	set_y_pos(old_y_pos);
	x_dir = 0;
	y_dir = 0;

	if(get_x_pos() < 0) set_x_pos(0);
	if(get_x_pos() > K_LIM_X) set_x_pos(K_LIM_X);
	if(get_y_pos() < 0) set_y_pos(0);
	if(get_y_pos() > K_LIM_Y) set_y_pos(K_LIM_Y);
} 


void Knave::travel() {
	old_x_pos = get_x_pos();
	old_y_pos = get_y_pos();

	switch(b_type) {
		case FROZEN:
			break;			
		case REVERSED:
			ch_pos(-x_dir, -y_dir);
			break;
		case SPEEDY:
			ch_pos(x_dir * 2, y_dir * 2);
			break;
		default:
			ch_pos(x_dir, y_dir);
			break;
	}
}	



void Knave::set_controls (const control_set c) {
	controls.up    = c.up;
	controls.down  = c.down;
	controls.left  = c.left;
	controls.right = c.right;
}



void Knave::fade_timer() {
	if(b_timer > 0)
		b_timer--;

	if(b_timer == 0) {
		b_timer = -1;
		b_type = 0;
	}
}