#ifndef JUKEBOX_DEFINED
#define JUKEBOX_DEFINED

#include <stdlib.h>
#include <allegro.h>
#include <vector>
#include <map>
#include <string>
#include <algorithm>
#include "caddat.h"

using std::vector;
using std::map;
using std::string;
using std::find;

class Jukebox {
	vector<MIDI *> music;
	map<int, string> titles;
	MIDI * end_beeps;
	MIDI * taunt;
	int track;
	vector<int> played_tracks;

	int volume;
	bool on;

public:
	void play();
	void stop() { stop_midi; }
	void rand_track();
	void play_end_beeps();
	void play_taunt();

	string get_title(const int t) { return titles[t]; }	//might create titles[t]
	void vol_down() { volume -= 5; if(volume < 0) volume = 0; }
	void vol_up() { volume += 5; if(volume > 255) volume = 255; }
	bool not_playing() const { return (midi_pos < 0); }

	void turn_on() { on = 1; }
	void turn_off() { on = 0; }
	bool is_on() const { return on; }

	Jukebox(DATAFILE *);
};

#endif