//Displayable.h
//Displayable (virtual) class header

#ifndef DISPLAYABLE_DEFINED
#define DISPLAYABLE_DEFINED

#include <allegro.h>

class Displayable {
	int x_pos, y_pos;
	int x_size, y_size;

protected:
	void ch_pos(const int x, const int y) { x_pos += x; y_pos += y; }
	void set_size(const int x, const int y) { x_size = x; y_size = y; }

public:	
	int get_x_pos() const { return x_pos; }
	int get_y_pos() const { return y_pos; }
	int get_x_size() const { return x_size; }
	int get_y_size() const { return y_size; }

	void set_x_pos(const int newpos) {x_pos = newpos; }
	void set_y_pos(const int newpos) {y_pos = newpos; }
	void rteleport() { set_x_pos(rand() % (320 - x_size)); set_y_pos(rand() % (180 - y_size)); }
	void teleport(int newx, int newy) { set_x_pos(newx); set_y_pos(newy); }
	//teleport() can be achieved using set_pos, but it's more descriptive to separate them.
	//They're only inline, anyway.

	virtual BITMAP * get_pic() const = 0;
};

#endif