#ifndef BONUS_GEN_DEFINED
#define BONUS_GEN_DEFINED

#include <allegro.h>
#include <vector>
#include <map>
#include <stdlib.h>
#include <time.h>

#include "Bonus.h"

using std::vector;
using std::map;

class Bonus_Gen {
	enum { FREEZE, MORE, MTELE, PASSWALL, RCAD, REVERSE, SPEED, TELE, INVIS, INVULN, END_MARKER};
	static const int FORMS = END_MARKER;	//number of form types

	map<int, BITMAP *> sprite_map;
	map<int, SAMPLE *> sound_map;

public:
	int get_form_range() const { return FORMS; }
	BITMAP * find_sprite(int f) { return sprite_map[f]; }
	SAMPLE * find_noise(int f) { return sound_map[f]; }

	Bonus_Gen(DATAFILE *);
};

#endif