#include <vector>
#include <allegro.h>
#include <dir.h>
#include "caddat.h"
#include "modules.h"
#include "ofuncs.h"

using std::vector;
using std::string;

game_options optscreen(DATAFILE * d, PALETTE& pal) {
	BITMAP * bg = (BITMAP *)d[OSCREEN].dat;
	BITMAP * curs_pic = (BITMAP *)d[KNAVE0].dat;

	set_palette(pal);

	int cursor_pos = 0;
	
	vector<Option *> ovec;
	ovec.push_back(new Start_Opt());
	ovec.push_back(new Number_Opt(4, 4, 1, 1, "Players:"));
	ovec.push_back(new Number_Opt(60, 980, 20, 20, "Time:"));
	ovec.push_back(new Number_Opt(6, 10, 1, 1, "Speed:"));
	ovec.push_back(new Number_Opt(700, 2000, 100, 100, "Bonus frequency:"));
	ovec.push_back(new Arena_Opt());

	ffblk fart;		//from dir.h
	if(!findfirst("*.bmp", &fart, 0)) {
		static_cast<Arena_Opt*>(ovec[5])->add_ar_name(string(fart.ff_name));

		while(!findnext(&fart))
			static_cast<Arena_Opt*>(ovec[5])->add_ar_name(string(fart.ff_name));
	}
//	findclose(&fart);	//apparently it doesn't exist...
		
	int c_pos_max = ovec.size() - 1;	

	bool do_update = 1;

	for(;;) {
		if(key[KEY_ESC]) {
			allegro_exit();
			exit(1);
		}

		if(is_pushed(KEY_DOWN)) {
			cursor_pos++;
			if(cursor_pos > c_pos_max)
				cursor_pos = 0;
			do_update = 1;
		}

		if(is_pushed(KEY_UP)) {
			cursor_pos--;
			if(cursor_pos < 0)
				cursor_pos = c_pos_max;
			do_update = 1;
		}

		if(is_pushed(KEY_LEFT)) {
			ovec[cursor_pos]->decrease();
			do_update = 1;
		}
			
		if(is_pushed(KEY_RIGHT)) {	
			ovec[cursor_pos]->increase();
			do_update = 1;
		}

		if(do_update) {	
			update(bg, curs_pic, cursor_pos, ovec);
			do_update = 0;
		}

		if(is_pushed(KEY_ENTER) && cursor_pos == 0)	//slightly dodgy (as everything else here)
			break;
	}

	game_options opts;

	opts.players     = static_cast<Number_Opt*>(ovec[1])->get_val();
	opts.game_time   = static_cast<Number_Opt*>(ovec[2])->get_val();
	opts.MSPC        = static_cast<Number_Opt*>(ovec[3])->get_val();
	opts.p_freq      = static_cast<Number_Opt*>(ovec[4])->get_val();
	opts.blank_arena = static_cast<Arena_Opt*>(ovec[5])->blank_arena();
	if(!opts.blank_arena)
		opts.arena = static_cast<Arena_Opt*>(ovec[5])->get_arena_pic(pal);

	if(!opts.blank_arena) {
		BITMAP * cack = opts.arena;
		blit(cack, screen, 0, 0, 0, 0, 320, 200);
	}

	for(int i = 0; i < ovec.size(); i++)
		delete ovec[i];

	return opts;
}