//Options/title screen function prototypes

#ifndef OFUNCS_H_INC
#define OFUNCS_H_INC

#include <string>
#include <vector>
#include <allegro.h>

using std::string;
using std::vector;



class Option {
protected:
	string name;
public:
	virtual void increase() = 0;
	virtual void decrease()	= 0;
	virtual void display_opt(const int, const int, const int) const = 0;
};



class Start_Opt : public Option {
public:
	void display_opt(const int, const int, const int) const;
	void increase() {}
	void decrease() {}
	Start_Opt() { name = "Start"; }
};



class Number_Opt : public Option {
	int val;
	int max_val;
	int min_val;
	int incr;

public:
	void increase() { val += incr; if(val > max_val) val = max_val; }
	void decrease() { val -= incr; if(val < min_val) val = min_val; }
	void display_opt(const int, const int, const int) const;
	int get_val() const { return val; }
	Number_Opt(int, int, int, int, string);
};


class Arena_Opt : public Option {
	vector<string> ar_names;
	int ar_index;
	
public:
	void increase();
	void decrease();
	void add_ar_name(string nn) { ar_names.push_back(nn); }
	bool blank_arena() const { return ar_index == -1; }
	BITMAP * get_arena_pic(PALETTE p) const;
	void display_opt(const int, const int, const int) const;
	Arena_Opt() { name = "Arena:"; ar_index = -1; }
};



bool is_pushed(int);
void update(BITMAP *, BITMAP *, int, const vector<Option *>&);

#endif