//functions.cc
//functions for game.cc (Cad)

#include "gfuncs.h"
#include "structs.h"
#include "Displayable.h"
#include "caddat.h"

bool collide_check (const Displayable& a, const Displayable& b) {
	return((a.get_x_pos() - b.get_x_pos() <   b.get_x_size())   && \
	       (a.get_x_pos() - b.get_x_pos() > -(a.get_x_size()))  && \
	       (a.get_y_pos() - b.get_y_pos() <   b.get_y_size())   && \
	       (a.get_y_pos() - b.get_y_pos() > -(a.get_y_size())));
}



int hit_wall(const Displayable& ass, BITMAP * wall) {
	int x = ass.get_x_pos();
	int y = ass.get_y_pos();
	int xs = ass.get_x_size();
	int ys = ass.get_y_size();

	for(int i = 0; i < xs; i++) {
		for(int j = 0; j < ys; j++) {
			if(getpixel(wall, i + x, j + y) != 0)
				return 1;
		}
	}
	return 0;
}



bool out_of_bounds (const Displayable& turd) {
	return((turd.get_x_pos() < 0         || \
	        turd.get_x_pos() > K_LIM_X)  || \
	       (turd.get_y_pos() < 0         || \
	        turd.get_y_pos() > K_LIM_Y));
}



control_set init_controls (int set_no) {
	control_set dave;
	switch(set_no) {
		case 0:
			dave.up    = KEY_UP;
			dave.down  = KEY_DOWN;
			dave.left  = KEY_LEFT;
			dave.right = KEY_RIGHT;
			break;
		case 1:
			dave.up    = KEY_W;
			dave.down  = KEY_S;
			dave.left  = KEY_A;
			dave.right = KEY_D;
			break;
		case 2:
			dave.up    = KEY_8_PAD;
			dave.down  = KEY_5_PAD;
			dave.left  = KEY_4_PAD;
			dave.right = KEY_6_PAD;
			break;
		case 3:
			dave.up    = KEY_I;
			dave.down  = KEY_K;
			dave.left  = KEY_J;
			dave.right = KEY_L;
			break;
	}
	return dave;
}



sprite_set init_sprites (int set_no, DATAFILE * d) {
	sprite_set s;
	switch(set_no) {
		case 0:
			s.ksp = (BITMAP *)d[KNAVE0].dat;
			s.csp = (BITMAP *)d[CAD0].dat;
			s.fsp = (BITMAP *)d[FROZEN0].dat;
			s.ssp = (BITMAP *)d[SPEEDY0].dat;
			s.psp = (BITMAP *)d[PASSING0].dat;
			s.rsp = (BITMAP *)d[REVERSED0].dat;
			s.isp = (BITMAP *)d[INVULN0].dat;
			s.nsp = (BITMAP *)d[INVISIBLEKNAVE].dat;
			break;
		case 1:
			s.ksp = (BITMAP *)d[KNAVE1].dat;
			s.csp = (BITMAP *)d[CAD1].dat;
			s.fsp = (BITMAP *)d[FROZEN1].dat;
			s.ssp = (BITMAP *)d[SPEEDY1].dat;
			s.psp = (BITMAP *)d[PASSING1].dat;
			s.rsp = (BITMAP *)d[REVERSED1].dat;
			s.isp = (BITMAP *)d[INVULN1].dat;
			s.nsp = (BITMAP *)d[INVISIBLEKNAVE].dat;
			break;
		case 2:
			s.ksp = (BITMAP *)d[KNAVE2].dat;
			s.csp = (BITMAP *)d[CAD2].dat;
			s.fsp = (BITMAP *)d[FROZEN2].dat;
			s.ssp = (BITMAP *)d[SPEEDY2].dat;
			s.psp = (BITMAP *)d[PASSING2].dat;
			s.rsp = (BITMAP *)d[REVERSED2].dat;
			s.isp = (BITMAP *)d[INVULN2].dat;
			s.nsp = (BITMAP *)d[INVISIBLEKNAVE].dat;
			break;
		case 3:
			s.ksp = (BITMAP *)d[KNAVE3].dat;
			s.csp = (BITMAP *)d[CAD3].dat;
			s.fsp = (BITMAP *)d[FROZEN3].dat;
			s.ssp = (BITMAP *)d[SPEEDY3].dat;
			s.psp = (BITMAP *)d[PASSING3].dat;
			s.rsp = (BITMAP *)d[REVERSED3].dat;
			s.isp = (BITMAP *)d[INVULN3].dat;
			s.nsp = (BITMAP *)d[INVISIBLEKNAVE].dat;
			break;
	}
	return s;
}




Bonus make_bonus(Bonus_Gen& bgp) {
	int tf = int(rand() % bgp.get_form_range());
	BITMAP * b_sprite = bgp.find_sprite(tf);
	SAMPLE * b_noise = bgp.find_noise(tf);
	return Bonus(tf, b_sprite, b_noise);
}



void cycle_palette(PALETTE p) {
	static int palette_counter;
	palette_counter = (rand() % (CADPALEND - CADPALSTART)) + CADPALSTART;
	set_color(CADPALENTRY, p + palette_counter);	//dodgy pointer/array arithmetic
}



void handle_bonus(int f, vector<Knave>& kv, int kn, vector<Bonus>& bv, Bonus_Gen& bg, BITMAP * wall) {
	/*
	The handling is 'hard coded' for each number.
	Note: this function is a bit sad.
	Should really try to 'unify' the bonus type constants
	Make main and Bonus take them from Bonus_Gen?

	f is the form of the bonus
	kv is the knave vector
	kn is the index in kv of the knave who collected it.
	bv is the bonus vector (for MORE)
	bg is the bonus generator (for MORE)
	*/

	switch(f) {
		case 0:	//FREEZE
			for(int i = 0; i < kv.size(); i++) {
				if(i != kn)
					kv[i].freeze();
			}
			break;

		case 1:	//MORE
			for(int i = 0; i < 3; i++) {
				bv.push_back(make_bonus(bg));
				int n = bv.size() - 1;
				safe_tele(bv[n], -1, n, kv, bv, wall);
			}
			break;
		case 2:	//MTELE
			for(int i = 0; i < kv.size(); i++) {
				safe_tele(kv[i], i, -1, kv, bv, wall);
			}
			break;
		case 3: //PASSWALL
			kv[kn].passify();
			break;
		case 4:	//RCAD
			{	//so variables can't 'jump to other cases'
				bool allinvuln = 1;
				for(int i = 0; i < kv.size(); i++) {	//check not everyone is invulnerable
					if(!(kv[i].is_invulnerable()))
						allinvuln = 0;
				}
				if(!allinvuln) {	
					for(int i = 0; i < kv.size(); i++)
						kv[i].decad();

					int ncad;
					do {
						ncad = int(rand() % kv.size());
					} while(kv[ncad].is_invulnerable());
					kv[ncad].becad();		
				}
			}
			break;
		case 5:	//REVERSE
			for(int i = 0; i < kv.size(); i++) {
				if(i != kn)
					kv[i].muddle();
			}
			break;
		case 6:	//SPEED
			kv[kn].haste();
			break;
		case 7:	//TELE
			{
				safe_tele(kv[kn], kn, -1, kv, bv, wall);
				break;
			}
		case 8:	//INVIS
			kv[kn].vanish();
			break;
		case 9:  //INVULN
			kv[kn].deify();
			break;
	}
}



void safe_tele(Displayable& d, const int k_id, const int b_id, vector<Knave>& k, vector<Bonus>& b, BITMAP * wall) {
	//Teleports a Displayable so it doesn't hit any knaves, bonuses or parts of the wall.
	//Checks against all bonuses and knaves except the ones indicated by k_id and b_id.
	//So if x_id is < 0 (or otherwise 'out of range'), the thing is not an x.
	//goto might not be ideal, but it's a small function and it works.

	mrlabel:
	d.rteleport();	

	for(int i = 0; i < k.size(); i++) {
		if((i != k_id && collide_check(d, k[i])) || hit_wall(d, wall)) {
			goto mrlabel;
		}
		for(int j = 0; j < b.size(); j++) {
			if((j != b_id && collide_check(d, b[j])) || hit_wall(d, wall)) {
				goto mrlabel;
			}
		}
	}
}