//Knave.h
//Header for the Knave class.
//Functions in Knave.cc
//
//control_set and sprite_set defined in structs.h

#ifndef KNAVE_DEFINED
#define KNAVE_DEFINED

#include <allegro.h>
#include <string>
#include <stdlib.h>
#include "Displayable.h"
#include "structs.h"

//structs used by Knave
struct control_set {
	int up, down, left, right;
};



struct sprite_set {
	BITMAP * ksp;
	BITMAP * csp;
	BITMAP * fsp;
	BITMAP * ssp;
	BITMAP * psp;
	BITMAP * rsp;
	BITMAP * isp;
	BITMAP * nsp;
};



using std::string;

class Knave : public Displayable {
	static const int X_SIZE = 10, Y_SIZE = 10;
	static const int MAX_FROZEN = 350, MAX_SPEEDY = 350, \
	                 MAX_REVERSED = 500, MAX_INVULNERABLE = 500, \
	                 MAX_PASSING = 500, MAX_INVISIBLE = 250;
	
	enum { FROZEN = 1, PASSING = 2, REVERSED = 3, SPEEDY = 4, INVULNERABLE = 5, INVISIBLE = 6 };

	int x_dir, y_dir;
	int old_x_pos, old_y_pos;
	int b_timer;
	int b_type;	//as in the enum or 0 for no bonus
	bool cadhood;
	bool in_wall;

	control_set controls;
	BITMAP * k_sp, * c_sp, * f_sp, * s_sp, * p_sp, * r_sp, * i_sp, * n_sp;
	string name;

public:
	Knave(const control_set, const sprite_set, const int, const int, const string);
	Knave(const int, const int);	//only use for safe position-generating purposes

	bool is_cad() const { return cadhood; }
	bool is_invulnerable () const { return(b_type == INVULNERABLE); }
	bool is_passing() const { return(b_type == PASSING); }
	bool is_in_wall() const { return in_wall; }
	int get_b_timer() const { return b_timer; }
	int get_old_x_pos() const { return old_x_pos; }
	int get_old_y_pos() const { return old_y_pos; }
	string get_name() const { return name; }
	BITMAP * get_pic() const;
	BITMAP * get_n_pic() const { return k_sp; }

	void becad() { cadhood = 1; }
	void decad() { cadhood = 0; }
	void set_in_wall() { in_wall = 1; }
	void set_nin_wall() { in_wall = 0; }
	void fade_timer();
	void travel();
	void dirs_from_keys();
	void stop();
	void set_controls(const control_set);

	void freeze() { b_timer = MAX_FROZEN; b_type = FROZEN;}
	void passify() {b_timer = MAX_PASSING; b_type = PASSING; }
	void haste() { b_timer = MAX_SPEEDY; b_type = SPEEDY; }
	void deify() { b_timer = MAX_INVULNERABLE; b_type = INVULNERABLE; }
	void muddle() { b_timer = MAX_REVERSED; b_type = REVERSED; }
	void vanish() { b_timer = MAX_INVISIBLE; b_type = INVISIBLE; }
};

#endif