#include "Jukebox.h"

Jukebox::Jukebox(DATAFILE * d) {
	played_tracks.clear();
	track = -1;
	on = 1;
	volume = 255;
	int i = -1;

	i++;
	music.push_back((MIDI *)d[M_GNG5].dat);
	titles[i] = "Ghouls 'n Ghosts Stage 5";

	i++;
	music.push_back((MIDI *)d[M_BUMPUS].dat);
	titles[i] = "Conroy Bumpus Theme Tune";

	i++;
	music.push_back((MIDI *)d[M_CV2].dat);
	titles[i] = "Some Castlevania Thing";

	i++;
	music.push_back((MIDI *)d[M_FEVER].dat);
	titles[i] = "Fever";

	i++;
	music.push_back((MIDI *)d[M_FISHWORLD].dat);
	titles[i] = "Fish World";

	i++;
	music.push_back((MIDI *)d[M_MAP10].dat);
	titles[i] = "The Refuelling Base";

	i++;
	music.push_back((MIDI *)d[M_MAPLERAG].dat);
	titles[i] = "Maple Leaf Rag";

	i++;
	music.push_back((MIDI *)d[M_PORTTOWN].dat);
	titles[i] = "Port Town";

	i++;
	music.push_back((MIDI *)d[M_SPANFLEA].dat);
	titles[i] = "Spanish Flea";

	i++;
	music.push_back((MIDI *)d[M_VEGA].dat);
	titles[i] = "Vega's Stage";

	//Non-stage music

	end_beeps = (MIDI *)d[M_ENDBEEPS].dat;
	taunt = (MIDI *)d[M_E_POLKA].dat;
}



void Jukebox::play() {
	play_midi(music[track], FALSE);
}



/* rand_track()
 * Stores a list of numbers of tracks that have been played
 * and chooses a track not in that list.
 * If all tracks have been played, reset the list.
 */
void Jukebox::rand_track() {
	int ms = music.size();
	int ps = played_tracks.size();
	bool try_again_flag = 0;	

	if(ps >= ms) {
		played_tracks.clear();
		ps = played_tracks.size();
	}

	do {
		track = int(rand() % ms);
		for(int i = 0; i < ps; i++) {
			if(ps > 0) {
				if(played_tracks[i] == track) {
					try_again_flag = 1;
					break;
				}
			}
		}
	} while(try_again_flag);	//is ms > 1 needed (ps will be 0)?
	
	played_tracks.push_back(track);
}



void Jukebox::play_end_beeps() {
	play_midi(end_beeps, 0);
}



void Jukebox::play_taunt() {
	play_midi(taunt, 0);
}	