//PRAISE JESUS
//
///////  ///////  ///////

//BUMPER BLASTER
//SEE CREDITS SECTION OF SOURCE CODE FOR FULL CREDITS

///////  ///////  ///////

#include <math.h>
#include <allegro.h>
#include "shorts.h"
#include "pmask.h"
#include "structs.h"

///////  ///////  ///////

#define VIDEO_WIDTH	640
#define VIDEO_HEIGHT	480
#define VSYNC		TRUE

#define CHAIN_DEBUGGER	FALSE

int VIDEO_DEPTH;
int depth_attempt_order[]={32, 24, 16, 15, -1};
int depth_supported[10];
int video_good=FALSE;
int video_detected=FALSE;
int lang=0;

int open_good_news=FALSE;
int use_joy=FALSE;
int jp_enabled=FALSE;

///////  ///////  ///////

#define SWAP(x,y)	{float tmp=x; x=y; y=tmp;}

int max_music;
int max_sound;
int cur_music;

int has_sound;

int sound=TRUE;
int music=TRUE;

MIDI * midi[300];

SAMPLE * sfx[30];
char sfx_name[30][100];


int ZWIDTH, ZHEIGHT;
int ZHWIDTH, ZHHEIGHT;

///////  ///////  ///////

int map_size=0;
int reproduc=0;
int powerups=0;
int time_limit=5;
int check_points=15;

int ticks;
int max_powerups;
int cur_powerups;


int draw_hud=0;
int blinky=0;

PALETTE MASTER_PAL;

#define VIDEO_CARD1	GFX_AUTODETECT_FULLSCREEN
#define VIDEO_CARD2	GFX_AUTODETECT_WINDOWED
#define VIDEO_CARD3	GFX_AUTODETECT
int VIDEO_CARD=VIDEO_CARD1;

#define DESIRED_FPS	30
int LIMIT_FPS=TRUE;
int SHOW_FPS=FALSE;

int SHOW_FPS_PRESS;
int KEY_SHOW_FPS=KEY_F2;

int LIMIT_FPS_PRESS;
int KEY_LIMIT_FPS=KEY_F1;

int powerup_danger=5*DESIRED_FPS;

float X_LOOK[256];
float Y_LOOK[256];

#define PI	3.14159
float	PI128=PI/128;

///////  ///////  ///////
int PLAYING=0;
int MAP_CENTER_X, MAP_CENTER_Y;
int MAP_VBAR, MAP_HBAR;

player p[4];
power_type pwr[300];
cow_type cows[150];
int max_cows;
BITMAP * bumper_bmp[4];
BITMAP * half_bumper_bmp[4];

bubble_type bubs[300];
int max_bubbles=300;

BITMAP * bub_bmp[2];
BITMAP * half_bub_bmp[2];
PMASK * bub_mask[2];

BITMAP * title;
int title_x, title_y;

///////  ///////  ///////

int ctrl_flag[32];

short BTN[4][6][10];
int * joy_ptr[4][6][10];


#define	ACCEL	0
#define	BRAKE	1
#define	LF	2
#define RT	3
#define FIRE	4
#define SCR	5

#define FUP	1
#define FDN	2
#define FLF	4
#define FRT	8
#define FFR	16
#define FSCR	32

///////  ///////  ///////
BITMAP * cow;
BITMAP * half_cow;
PMASK * cow_mask;

BITMAP * arrow;
BITMAP * half_arrow;
//BITMAP * bg;
int bg;
BITMAP * apage;
BITMAP * zpage;	//for zooming out
int can_zoom;
BITMAP * world_bmp=NULL;
FONT * big_font;

#define MAX_TILES	300

BITMAP * tileset;
BITMAP * half_tileset;
BITMAP * btiles[MAX_TILES];
BITMAP * half_btiles[MAX_TILES];
PMASK * mtiles[MAX_TILES];

///////  ///////  ///////

int BLACK, LT_BLACK, BLUE, RED, GREEN, CYAN, WHITE, PURPLE, YELLOW, DK_BLUE;
int DK_RED, DK_GREEN, DK_CYAN, DK_WHITE, DK_PURPLE, DK_YELLOW;

int color_list[16];

///////  ///////  ///////

int get_joy_up(int p);
int get_joy_dn(int p);
int get_joy_lf(int p);
int get_joy_rt(int p);
int get_joy_fire(int p);

///////  ///////  ///////

void nullify_halves(void);
void load_halves(void);

void assign_joy_ptr(void);

int whos_playing(void);
void viewport_setup(void);

int get_next_player(int RESET);

char * what_char(int kp);

void install_mikes_joystick(void);
char control(short bv);
void update_local_ctrl_flags(void);
void sort_keys(void);

void audio_init(void);

void play_music(int m);
void handle_music();
void stop_music();

void play_sound(int s);


#define NEW_KEY_MAX	350

int find_angle(float x1, float y1, float x2, float y2);

void textout_centre_bold(BITMAP * bmp, FONT * f, char * m, int x, int y, int tc, int bc);

void show_endgame_screen(void);
void show_instructions(void);
void show_credits(void);

int game_paused(void);

void break_bub(int i);

void handle_cows(void);
void add_cow(void);
void attack_with_cows(int nplr);

void add_bubble(int owner, float x, float y, float d, int type);
void handle_bubbles(void);

void FLOOD_FILL(int x, int y, int c);

void do_map_work(void);
int map_is_bad(void);

void give_powerup(int plr, int n);
void spawn_flag(int n);

void handle_powerups(void);
void add_powerup(void);

void display_time(BITMAP * bmp, int x, int y, int t);

void physics(int i);

char map_collision(PMASK * p, int x, int y);
char map_collision2(int x, int y, int aw, int ah);

char bound_coll(int ax1, int ay1, int ax2, int ay2, int bx1, int by1, int bx2, int by2);

void setup_rotation_lut();
void draw_map2(BITMAP * bmp);

void center_map(void);
int get_map(int x, int y);
void set_map(int x, int y, int c);
void build_room_borders(void);

void draw_room(BITMAP * bmp, int pos_x, int pos_y, int x1, int y1, int w, int h);
void draw_room_zoomed(BITMAP * bmp, int pos_x, int pos_y, int x1, int y1, int w, int h);

int get_world_tile(int x, int y);
void set_world_tile(int x, int y, int t);
int get_wflag_tile(int x, int y);
void set_wflag_tile(int x, int y, int t);

int peek_map(int x, int y);
void poke_map(int x, int y, int c);

void import_tileset(char * filename);
void import_tileset2(BITMAP * in, int sz_x, int sz_y);

void setup_colors(void);
BITMAP * load_bitmap2(char * filename);
void change_image_to_current_palette(BITMAP * image, PALETTE imgpal);
void do_colors(void);

void install_video(void);
void load_video_settings(void);
void save_video_settings(void);
void detect_video_settings(void);
void show_video_detected(void);
void main_menu(void);

char * read_line(FILE * fp);
void load_languages(void);
void load_a_language(int n, char * name);
void select_language(void);
void change_controls(void);

char txt[2][1000][1000];

void config(void);
int setup_game(void);
void play_game(void);

void load_keys(void);
void save_keys(void);

int get_new_key(char * txt);

void save_gen_settings(void);
void load_gen_settings(void);

int get_wflag(int x, int y);
int get_world(int x, int y);

///////  ///////  ///////

volatile int timer_var;
volatile int fps;
volatile int frames;

int mmx, mmy;
int mouse_installed=FALSE;

void my_timer_handler()
{
	timer_var=TRUE;


	//install mouse before this timer proc
	get_mouse_mickeys(&mmx, &mmy);

}
END_OF_FUNCTION(my_timer_handler);

void my_fps_counter()
{
	fps=frames;
	frames=0;
}
END_OF_FUNCTION(my_fps_counter);

///////  ///////  ///////

void setup_rotation_lut(void)
{
	for (int i=0; i<256; i++)
	{
		X_LOOK[i] = (cos(i * PI / 128));
		Y_LOOK[i] = (sin(i * PI / 128));
	}
	return;
}

///////  ///////  ///////

int main(void)
{
	nullify_halves();

	setup_rotation_lut();
	load_languages();

	randomize_timer();

	set_uformat(U_ASCII);	//Thanks X-G!

	allegro_init();
	install_keyboard();
	install_mouse();

	install_timer();

	install_mikes_joystick();

	LOCK_VARIABLE(timer_var);
	LOCK_FUNCTION(my_timer_handler);
	install_int_ex(my_timer_handler, (SECS_TO_TIMER(1)/DESIRED_FPS));

	LOCK_VARIABLE(fps);
	LOCK_VARIABLE(frames);
	LOCK_FUNCTION(my_fps_counter);
	install_int_ex(my_fps_counter, SECS_TO_TIMER(1));



	audio_init();

	load_gen_settings();

	DATAFILE *d=load_datafile("comic.dat");
	if (!d){allegro_message("Couldn't Open FONT.DAT, some text may display incorrectly"); big_font=font;}
	else
	{
		big_font=(FONT*)d[0].dat;
	}

	install_video();

	if (!video_good){allegro_message(allegro_error);return(-1);}

	load_keys();
	
	title=load_bitmap2("gfx\\title.pcx");

	if (video_good)
	{
		for (int i=0; i<MAX_TILES; i++)
		{
			{

				btiles[i]=NULL;
			}
		}
		import_tileset("gfx\\tileset.pcx");
		p[0].bmp=load_bitmap2("gfx\\p1.pcx");
		p[0].mask=create_allegro_pmask(p[0].bmp);
		p[1].bmp=load_bitmap2("gfx\\p2.pcx");
		p[1].mask=create_allegro_pmask(p[1].bmp);
		p[2].bmp=load_bitmap2("gfx\\p3.pcx");
		p[2].mask=create_allegro_pmask(p[2].bmp);
		p[3].bmp=load_bitmap2("gfx\\p4.pcx");
		p[3].mask=create_allegro_pmask(p[3].bmp);

		bumper_bmp[0]=load_bitmap2("gfx\\p1.pcx");
		bumper_bmp[1]=load_bitmap2("gfx\\p2.pcx");
		bumper_bmp[2]=load_bitmap2("gfx\\p3.pcx");
		bumper_bmp[3]=load_bitmap2("gfx\\p4.pcx");

		main_menu();
	}

	while(FALSE)//!key[KEY_ESC])
	{
		clear_to_color(apage, bg);
		//blit(bg, apage, 0, 0, 0, 0, bg->w, bg->h);


		textprintf(apage, font, 10, 10, WHITE, "%d x %d @ %dbpp", VIDEO_WIDTH, VIDEO_HEIGHT, VIDEO_DEPTH);


		if (SHOW_FPS)
		{
			textprintf_right(apage, font, screen->w-1, 1, WHITE, "FPS: %d",fps);
		}


		int tx=5, ty=(text_height(font)+text_height(font)/2)*2;
		for (int i=0; i<2; i++)
		{
			textprintf(apage, font, tx, ty, WHITE, txt[lang][i]);
			ty+=text_height(font)+text_height(font)/2;
		}


		if (key[KEY_SHOW_FPS])
		{
			if (!SHOW_FPS_PRESS)
			{
				SHOW_FPS=!SHOW_FPS;
				SHOW_FPS_PRESS=TRUE;
			}
		}
		else
		{
			SHOW_FPS_PRESS=FALSE;
		}

		blit(apage,screen,0,0,0,0,VIDEO_WIDTH, VIDEO_HEIGHT);

		if (LIMIT_FPS)
		{
			while(!timer_var);
			timer_var=FALSE;
		}

		if (key[KEY_LIMIT_FPS])
		{
			if (!LIMIT_FPS_PRESS)
			{
				LIMIT_FPS=!LIMIT_FPS;
				LIMIT_FPS_PRESS=TRUE;
			}
		}
		else
		{
			LIMIT_FPS_PRESS=FALSE;
		}

		frames++;
	}

	uneat_bitmap(apage);

	save_gen_settings();
	allegro_exit();

	if (open_good_news)
	{system("start http://www.needhim.org");}	// I guess they dont have a spanish option on their site...

	return(0);
}
END_OF_MAIN();

///////  ///////  ///////

void install_video(void)
{
	load_video_settings();

	set_color_depth(VIDEO_DEPTH);
	if (set_gfx_mode(VIDEO_CARD, VIDEO_WIDTH, VIDEO_HEIGHT, 0, 0)!=0)
	{
		detect_video_settings();

		set_color_depth(VIDEO_DEPTH);
		if (set_gfx_mode(VIDEO_CARD, VIDEO_WIDTH, VIDEO_HEIGHT, 0, 0)!=0)
		{
			video_good=FALSE;
			return;
		}
	}

	if (lang==-1)
	{
		select_language();
	}

	if (video_detected)
	{
		show_video_detected();
	}

	apage=create_bitmap(VIDEO_WIDTH,VIDEO_HEIGHT);

	zpage=create_bitmap(VIDEO_WIDTH, VIDEO_HEIGHT);
	if (zpage){can_zoom=TRUE;} else {can_zoom=FALSE;}

	//bg=load_bitmap2("gfx\\bg.pcx");
	bg=makecol(58,110,165);
	if (!apage){sprintf(allegro_error,"Not enough memory to create a backbuffer."); video_good=FALSE; return;}
	do_colors();
	clear_to_color(screen, BLACK);
	clear_to_color(apage, BLACK);
	text_mode(-1);

}

void show_video_detected(void)
{
	int ok=FALSE;
	int in=VIDEO_DEPTH;
	while (!ok)
	{
		//clear_bitmap(screen);	/* not necessary since same text is being printed with just a different color */

		int tx=5, ty=5, tc=makecol(255,255,255), ta=text_height(font)+(text_height(font)/2);
		int selected=-1;

		textprintf(screen, font, tx, ty, tc, txt[lang][3]);  ty+=ta*2;
		textprintf(screen, font, tx, ty, tc, txt[lang][4]);  ty+=ta;
		textprintf(screen, font, tx, ty, tc, "%d x %d @ %dbpp", VIDEO_WIDTH, VIDEO_HEIGHT, in);  ty+=ta*3;

		textprintf(screen, font, tx, ty, tc, txt[lang][5]);  ty+=ta;
		textprintf(screen, font, tx, ty, tc, txt[lang][6]);  ty+=ta*2;

		textprintf(screen, font, tx, ty, tc, txt[lang][7], VIDEO_WIDTH, VIDEO_HEIGHT, VIDEO_DEPTH);  ty+=ta;
		int c=0;
		while (depth_attempt_order[c]>0)
		{
			if (depth_supported[c])
			{
				if (depth_attempt_order[c]==VIDEO_DEPTH){tc=makecol(0,255,0);selected=c;} else {tc=makecol(255,255,255);}
				textprintf(screen, font, tx, ty, tc, "- %dbpp", depth_attempt_order[c]);  ty+=ta;
			}
			c++;
		}
		tc=makecol(255,255,255);
		ty+=ta*2;

		textprintf(screen, font, tx, ty, tc, txt[lang][8]);

		
		int pressed=FALSE;
		while(!pressed)
		{
			if (key[KEY_ENTER])
			{
				ok=TRUE;
				while(key[KEY_ENTER]);
				pressed=TRUE;
			}

			if (key[KEY_DOWN])
			{
				int backup=VIDEO_DEPTH;

				selected++;
				int ok2=FALSE;

				while (!ok2)
				{
					if (depth_attempt_order[selected]==-1)
					{
						VIDEO_DEPTH=backup;
						ok2=TRUE;
					}
					else
					{
						if (!depth_supported[selected])
						{
							selected++;
						}
						else
						{
							VIDEO_DEPTH=depth_attempt_order[selected];
							ok2=TRUE;
						}
					}
				}

				while(key[KEY_DOWN]);
				pressed=TRUE;
			}

			if (key[KEY_UP])
			{
				int backup=VIDEO_DEPTH;

				selected--;
				int ok2=FALSE;

				while (!ok2)
				{
					if (selected<0)
					{
						VIDEO_DEPTH=backup;
						ok2=TRUE;
					}
					else
					{
						if (!depth_supported[selected])
						{
							selected--;
						}
						else
						{
							VIDEO_DEPTH=depth_attempt_order[selected];
							ok2=TRUE;
						}
					}
				}
				while(key[KEY_UP]);
				pressed=TRUE;
			}
		}

	}

	set_color_depth(VIDEO_DEPTH);
	if (set_gfx_mode(VIDEO_CARD, VIDEO_WIDTH, VIDEO_HEIGHT, 0, 0)!=0)
	{
		VIDEO_DEPTH=in;
		set_color_depth(VIDEO_DEPTH);
		if (set_gfx_mode(VIDEO_CARD, VIDEO_WIDTH, VIDEO_HEIGHT, 0, 0)==0)
		{
			char buffer[80];
			sprintf(buffer,"AN ERROR OCCURED WHILE SETTING THE VIDEO MODE, THE MODE DEFAULTED BACK TO %dBPP.",VIDEO_DEPTH);
			allegro_message(buffer);
			video_good=TRUE;
			save_video_settings();
		}
		else
		{
			video_good=FALSE;
		}
	}
	else
	{
		video_good=TRUE;
		save_video_settings();
	}	

}
void load_video_settings(void)
{
	set_config_file("settings.cfg");
	
	video_good=get_config_int("GENERAL", "video_good", FALSE);
	lang=get_config_int("GENERAL", "language", -1);


	char buffer[80];
	int c=0;
	while (depth_attempt_order[c]>0)
	{
		sprintf(buffer,"color_mode_%d",depth_attempt_order[c]);
		depth_supported[c]=get_config_int("COLOR_MODES", buffer, FALSE);
		c++;
	}

	VIDEO_DEPTH=get_config_int("COLOR_MODES", "video_depth", -1);

	if (!video_good || VIDEO_DEPTH==-1){detect_video_settings();}
}

void save_video_settings(void)
{
	set_config_file("settings.cfg");

	set_config_int("GENERAL", "video_good", video_good);
	set_config_int("GENERAL", "language", lang);

	char buffer[80];
	int c=0;
	while (depth_attempt_order[c]>0)
	{
		sprintf(buffer,"color_mode_%d",depth_attempt_order[c]);
		set_config_int("COLOR_MODES", buffer, depth_supported[c]);
		c++;
	}

	set_config_int("COLOR_MODES", "video_depth", VIDEO_DEPTH);

	flush_config_file();
}

void detect_video_settings(void)
{
	allegro_message("ATTEMPTING TO DETECT VIDEO SETTINGS");

	video_detected=TRUE;
	video_good=FALSE;

	int ok=TRUE;
	int c=0;

	VIDEO_DEPTH=-1;
	
	while (depth_attempt_order[c]>0)
	{
		set_color_depth(depth_attempt_order[c]);
		if (set_gfx_mode(VIDEO_CARD, VIDEO_WIDTH, VIDEO_HEIGHT, 0, 0)==0)
		{
			video_good=TRUE;
			depth_supported[c]=TRUE;
			if (VIDEO_DEPTH==-1){VIDEO_DEPTH=depth_attempt_order[c];}
		}
		else
		{
			depth_supported[c]=FALSE;
		}

		c++;
	}

	save_video_settings();
}

void do_colors(void)
{
	generate_332_palette(MASTER_PAL);
	if (VIDEO_DEPTH==8){set_palette(MASTER_PAL);}

	set_mouse_sprite(NULL);
	show_mouse(NULL);

	BLACK=makecol(0,0,0);
	BLUE=makecol(0,0,255);
	RED=makecol(255,0,0);
	GREEN=makecol(0,255,0);
	CYAN=makecol(0,255,255);
	WHITE=makecol(255,255,255);
	PURPLE=makecol(255,0,255);
	YELLOW=makecol(255,255,0);
	DK_BLUE=makecol(0,0,128);
	DK_RED=makecol(128,0,0);
	DK_GREEN=makecol(0,128,0);
	DK_CYAN=makecol(0,160,160);
	DK_WHITE=makecol(192,192,192);
	DK_PURPLE=makecol(128,0,128);
	DK_YELLOW=makecol(128,128,0);

	LT_BLACK=makecol(64,64,64);

	gui_fg_color=BLACK;
	gui_bg_color=WHITE;
	gui_mg_color=LT_BLACK;

	color_list[0]=LT_BLACK;
	color_list[1]=BLACK;
	color_list[2]=BLUE;
	color_list[3]=DK_BLUE;
	color_list[4]=RED;
	color_list[5]=DK_RED;
	color_list[6]=GREEN;
	color_list[7]=DK_GREEN;
	color_list[8]=CYAN;
	color_list[9]=DK_CYAN;
	color_list[10]=WHITE;
	color_list[11]=DK_WHITE;
	color_list[12]=PURPLE;
	color_list[13]=DK_PURPLE;
	color_list[14]=YELLOW;
	color_list[15]=DK_YELLOW;

	return;
}

char * read_line(FILE * fp)
{
	static char buffer[1000];
	if (!fp){return(NULL);}

	memset(buffer,0,1000);

	char in=0;
	int pos=0;
	while(in!='\n' && pos<1000)
	{
		in=getc(fp);
		if (in!='\n')
		{
			buffer[pos]=in;
		}
		pos++;
	}

	return(buffer);
}

void load_languages(void)
{
	load_a_language(0, "english.txt");
	load_a_language(1, "spanish.txt");
}

void load_a_language(int n, char * name)
{
	FILE * fp=fopen(name,"rt");

	if (!fp)
	{
		char buffer[80];
		sprintf(buffer,"Couldn't load language: %s!",name);
		allegro_message(buffer);
		return;
	}

	char * input=NULL;
	int ok=TRUE;
	int track=0;
	while (ok)
	{
		input=read_line(fp);
		memcpy(txt[n][track], input, 1000);
		if (input[0]=='_'){ok=FALSE;}
		track++;
	}

	fclose(fp);
	return;
}

void select_language(void)
{
	if (lang!=0 && lang!=1)
	{lang=0;}

	BITMAP * f[10];
	int cnt=0;
	f[0]=load_bitmap2("gfx\\usa000.pcx");
	f[1]=load_bitmap2("gfx\\usa001.pcx");
	f[2]=load_bitmap2("gfx\\usa002.pcx");
	f[3]=load_bitmap2("gfx\\usa003.pcx");
	f[4]=load_bitmap2("gfx\\usa004.pcx");

	f[5]=load_bitmap2("gfx\\mex000.pcx");
	f[6]=load_bitmap2("gfx\\mex001.pcx");
	f[7]=load_bitmap2("gfx\\mex002.pcx");
	f[8]=load_bitmap2("gfx\\mex003.pcx");
	f[9]=load_bitmap2("gfx\\mex004.pcx");

	if (video_good)
	{
		BITMAP * b=create_bitmap(VIDEO_WIDTH, VIDEO_HEIGHT);
		set_trans_blender(0,0,0, 50);

		if (b)
		{
			int ok=TRUE;

			int x1,y1,x2,y2;

			y1=b->h/2;
			y2=y1;
			y1-=f[0]->h/2;
			y2-=f[5]->h/2;

			x1=b->w/4;
			x2=(b->w/2)+x1;

			x1-=f[0]->w/2;
			x2-=f[5]->w/2;

			int tx1=x1+(f[0]->w/2);
			int ty1=y1+(f[0]->h)+4;

			int tx2=x2+(f[5]->w/2);
			int ty2=y2+(f[5]->h)+4;


			int slow_to=3;
			int slow_cnt=0;

			if (lang==0)
			{
				position_mouse(x1+f[0]->w/2, y1+f[0]->h/2);
			}
			else
			{
				position_mouse(x2+f[5]->w/2, y2+f[5]->h/2);
			}

			while (ok)
			{
				clear_bitmap(b);

				slow_cnt++;
				if (slow_cnt==slow_to)
				{
					slow_cnt=0;
					cnt++;
					if (cnt>4)
					{
						cnt=0;
					}
				}

				textprintf_centre(b, big_font, b->w/2, 5, makecol(255,255,255), txt[lang][2]);	//select a language

				if (lang==0)
				{
					draw_sprite(b, f[cnt], x1, y1);
					textprintf_centre(b, big_font, tx1, ty1, makecol(255,255,255), txt[lang][0]);

					draw_trans_sprite(b, f[cnt+5], x2, y2);
					textprintf_centre(b, big_font, tx2, ty2, makecol(127,127,127), txt[lang][1]);

					if (mouse_x>x2 && mouse_y>y2 && mouse_x<(x2+f[5]->w) && mouse_y<(y2+f[5]->h))
					{
						lang=1;
					}
				}
				else
				{
					draw_trans_sprite(b, f[cnt], x1, y1);
					textprintf_centre(b, big_font, tx1, ty1, makecol(127,127,127), txt[lang][0]);

					draw_sprite(b, f[cnt+5], x2, y2);
					textprintf_centre(b, big_font, tx2, ty2, makecol(255,255,255), txt[lang][1]);

					if (mouse_x>x1 && mouse_y>y1 && mouse_x<(x1+f[0]->w) && mouse_y<(y1+f[0]->h))
					{
						lang=0;
					}
				}


				draw_sprite(b, mouse_sprite, mouse_x, mouse_y);
				blit(b,screen,0,0,0,0,VIDEO_WIDTH, VIDEO_HEIGHT);

				while(!timer_var);
				timer_var=FALSE;

				if (key[KEY_ESC])
				{
					ok=FALSE;
				}

				if (mouse_b & 1)
				{
					while (mouse_b & 1);
					save_video_settings();
					ok=FALSE;
				}
			}
			clear_bitmap(screen);
			draw_trans_sprite(screen, b, 0, 0);
			destroy_bitmap(b);
		}
	}
}

BITMAP * load_bitmap2(char * filename)
{
	PALETTE pal;
	BITMAP * bmp=load_bitmap(filename, pal);

	if (!bmp)
	{
		video_good=FALSE;
		sprintf(allegro_error,"Couldn't Open: %s.  Execution Halted.", filename);
		return(NULL);
	}

	if (VIDEO_DEPTH==8)
	{
		change_image_to_current_palette(bmp, pal);
	}

	return(bmp);
}

///////  ///////  ///////

//Function dedicated to my God -- He loves me!
void change_image_to_current_palette(BITMAP * image, PALETTE imgpal)
{
        int size_x, size_y;
        BITMAP * temp=NULL;

        size_x=image->w;
        size_y=image->h;

        temp=create_bitmap(size_x, size_y);
        if (!temp){return;}

        int srcclr;
        int newclr;
        for (int x=0; x<size_x; x++)
        {
                for (int y=0; y<size_y; y++)
                {

                        srcclr=getpixel(image,x,y);
                        newclr=makecol8((imgpal[srcclr].r*4),(imgpal[srcclr].g*4),(imgpal[srcclr].b*4));
                        putpixel(temp,x,y,newclr);
                }
        }


        blit(temp,image,0,0,0,0,size_x,size_y);
        uneat_bitmap(temp);


        return;

}

///////  ///////  ///////

void show_instructions(void)
{
	clear_to_color(apage, bg);

	int y=15;
	int ya=text_height(big_font);
	int ys=text_height(big_font)/2;

	textprintf_centre(apage, big_font, 320, y, WHITE, "-- %s --", txt[lang][12]); y+=ya*2;

	int p=58;
	int x=96;

	//draw flags
	textprintf(apage, big_font, x, y, WHITE, txt[lang][p]); p++; y+=ya;
	draw_sprite(apage, btiles[5], 11, y);
	draw_sprite(apage, btiles[6], 53, y);
	textprintf(apage, big_font, x, y, WHITE, txt[lang][p]); p++; y+=ya;
	textprintf(apage, big_font, x, y, WHITE, txt[lang][p]); p++; y+=ya+ys;

	//draw ships
	textprintf(apage, big_font, x, y, WHITE, txt[lang][p]); p++; y+=ya;
	draw_sprite(apage, bumper_bmp[0], 11, y-(ya+((ys/2)*lang)));
	draw_sprite(apage, bumper_bmp[1], 53, y-(ya+((ys/2)*lang)));

	if (lang==1){y+=ys;}
	textprintf(apage, big_font, x, y, WHITE, txt[lang][p]); p++; y+=ya;
	if (lang==0){y+=ys;}

	//draw speed up
	textprintf(apage, big_font, x, y, WHITE, txt[lang][p]); p++; y+=ya;
	draw_sprite(apage, btiles[12], 32, y-(ys+(ys*lang)));
	textprintf(apage, big_font, x, y, WHITE, txt[lang][p]); p++; y+=ya+ys;

	//draw speed down
	textprintf(apage, big_font, x, y, WHITE, txt[lang][p]); p++; y+=ya;
	draw_sprite(apage, btiles[11], 32, y-(ya/2));
	textprintf(apage, big_font, x, y, WHITE, txt[lang][p]); p++; y+=ya+ys;

	//draw swap
	textprintf(apage, big_font, x, y, WHITE, txt[lang][p]); p++; y+=ya;
	draw_sprite(apage, btiles[13], 32, y-(ya/2));
	textprintf(apage, big_font, x, y, WHITE, txt[lang][p]); p++; y+=ya+ys;

	//draw misc powerups
	draw_sprite(apage, btiles[7], 11, y);
	draw_sprite(apage, btiles[8], 53, y);
	textprintf(apage, big_font, x, y, WHITE, txt[lang][p]); p++; y+=ya;
	textprintf(apage, big_font, x, y, WHITE, txt[lang][p]); p++; y+=ya;
	draw_sprite(apage, btiles[9], 11, y-(ya/2));
	draw_sprite(apage, btiles[10], 53, y-(ya/2));
	textprintf(apage, big_font, x, y, WHITE, txt[lang][p]); p++; y+=ya+ys;

	textprintf_centre(apage, big_font, 320, y, WHITE, txt[lang][51]); y+=ya;

	while (key[KEY_ENTER]);
	while (!key[KEY_ENTER])
	{
		vsync();
		blit(apage,screen,0,0,0,0,VIDEO_WIDTH, VIDEO_HEIGHT);
	}
	while (key[KEY_ENTER]);
}


void show_credits(void)
{
	play_midi(midi[1], TRUE);

	clear_to_color(apage, bg);

	int y=15;
	int ya=text_height(big_font);//+text_height(big_font)/2;
	int ys=text_height(big_font);///2;

	textprintf_centre(apage, big_font, 320, y, WHITE, "-- %s --", txt[lang][46]); y+=ya*2;

	textprintf_centre(apage, big_font, 320, y, WHITE, txt[lang][47]); y+=ya;
	textprintf_centre(apage, big_font, 320, y, WHITE, "JESUS CHRIST"); y+=ya;
	textprintf_centre(apage, big_font, 320, y, WHITE, "X-G for unicode support"); y+=ya;	
	textprintf_centre(apage, big_font, 320, y, WHITE, "%cMarianita%c for covering my friday shift.", 34, 34); y+=ya;
	textprintf_centre(apage, big_font, 320, y, WHITE, "orz for PMASK", 34, 34); y+=ya+ys;

	textprintf_centre(apage, big_font, 320, y, WHITE, txt[lang][50]); y+=ya;
	textprintf_centre(apage, big_font, 320, y, WHITE, "Janiess & Owen Sallee"); y+=ya+ys;

	textprintf_centre(apage, big_font, 320, y, WHITE, txt[lang][49]); y+=ya;
	textprintf_centre(apage, big_font, 320, y, WHITE, "Louis Erstad", 34, 34); y+=ya;
	textprintf_centre(apage, big_font, 320, y, WHITE, "Pascal Gross", 34, 34); y+=ya+ys;

	textprintf_centre(apage, big_font, 320, y, WHITE, txt[lang][48]); y+=ya;
	textprintf_centre(apage, big_font, 320, y, WHITE, "Michael Jensen", 34, 34); y+=ya+ys;

	textprintf_centre(apage, big_font, 320, y, WHITE, txt[lang][51]); y+=ya;

	while (key[KEY_ENTER]);
	while (!key[KEY_ENTER])
	{
		vsync();
		blit(apage,screen,0,0,0,0,VIDEO_WIDTH, VIDEO_HEIGHT);
	}
	while (key[KEY_ENTER]);

	int m=2+(rand()%4);
	play_midi(midi[m], FALSE);
	cur_music=m;

	return;
}

///////  ///////  ///////

void main_menu(void)
{
	int ok=TRUE;
	//BITMAP * bg=load_bitmap2("gfx\\bg.bmp");


	title_x=(apage->w/2)-(title->w/2);
	title_y=25;

	int h=text_height(big_font);
	int lx=text_length(big_font, txt[lang][9]);
	int mx=text_length(big_font, txt[lang][10])/2;
	int mx2=text_length(big_font, txt[lang][12])/2;
	int rx=text_length(big_font, txt[lang][11]);

	int gnx1=160-text_length(big_font,txt[lang][45])/2;
	int gnx2=160+text_length(big_font,txt[lang][45])/2;

	int cdx1=480-text_length(big_font,txt[lang][46])/2;
	int cdx2=480+text_length(big_font,txt[lang][46])/2;


	play_midi(midi[2], FALSE);
	cur_music=2;

	while (ok)
	{
		if (use_joy){poll_joystick();}

		handle_music();
		clear_to_color(apage, bg);
		blit(title, apage, 0, 0, title_x, title_y, title->w, title->h);
		//draw_sprite(apage, bg, x, 10);


		textprintf(apage, big_font, 50, 400, DK_WHITE, txt[lang][9]);
		if (mouse_x>50 && mouse_y>400 && (mouse_x<(50+lx)) && mouse_y<(400+h))
		{
			textprintf(apage, big_font, 50, 400, WHITE, txt[lang][9]);

			if (mouse_b & 1)
			{
				while (mouse_b & 1);
				
				if (setup_game())
				{
					play_game();
				}
			}
		}

		textprintf_centre(apage, big_font, 250, 400, DK_WHITE, txt[lang][10]);
		if (mouse_x>(250-mx) && mouse_x<(250+mx) && mouse_y>400 && mouse_y<(400+h))
		{
			textprintf_centre(apage, big_font, 250, 400, WHITE, txt[lang][10]);

			if (mouse_b & 1)
			{
				while (mouse_b & 1);
				
				config();
			}
		}

		textprintf_centre(apage, big_font, 400, 400, DK_WHITE, txt[lang][12]);
		if (mouse_x>(400-mx2) && mouse_x<(400+mx2) && mouse_y>400 && mouse_y<(400+h))
		{
			textprintf_centre(apage, big_font, 400, 400, WHITE, txt[lang][12]);

			if (mouse_b & 1)
			{
				while (mouse_b & 1);
				
				show_instructions();
			}
		}

		textprintf_right(apage, big_font, 589, 400, DK_WHITE, txt[lang][11]);
		if (mouse_x>(589-rx) && mouse_x<589 && mouse_y>400 && mouse_y<(400+h))
		{
			textprintf_right(apage, big_font, 589, 400, WHITE, txt[lang][11]);

			if (mouse_b & 1)
			{
				while (mouse_b & 1);
				
				ok=FALSE;
			}
		}

		textprintf(apage, big_font, gnx1, 430, DK_WHITE, txt[lang][45]);
		if (mouse_x>gnx1 && mouse_x<gnx2 && mouse_y>430 && mouse_y<(430+h))
		{
			textprintf(apage, big_font, gnx1, 430, WHITE, txt[lang][45]);

			if (mouse_b & 1)
			{
				while (mouse_b & 1);
				open_good_news=TRUE;
				ok=FALSE;
			}
		}


		textprintf(apage, big_font, cdx1, 430, DK_WHITE, txt[lang][46]);
		if (mouse_x>cdx1 && mouse_x<cdx2 && mouse_y>430 && mouse_y<(430+h))
		{
			textprintf(apage, big_font, cdx1, 430, WHITE, txt[lang][46]);

			if (mouse_b & 1)
			{
				while (mouse_b & 1);
				
				show_credits();
			}
		}



		draw_sprite(apage, mouse_sprite, mouse_x, mouse_y);
		vsync();
		blit(apage,screen,0,0,0,0,VIDEO_WIDTH, VIDEO_HEIGHT);
		while(!timer_var);
		timer_var=FALSE;

		if (key[KEY_ESC])
		{
			ok=FALSE;
		}
	}
}

void load_keys(void)
{
	set_config_file("settings.cfg");

	for (int i=0; i<4; i++)
	{
		for (int j=0; j<6; j++)
		{
			for (int k=0; k<10; k++)
			{
				BTN[i][j][k]=-1;
			}
		}
	}

	char other_keys[50];
	char c[]={'A','B','L','R','F','S'};
	for (int p=0; p<4; p++)
	{
		for (int i=0; i<6; i++)
		{
			for (int j=0; j<10; j++)
			{
				sprintf(other_keys, "P%d%c%d",p, c[i],j);
				BTN[p][i][j]=get_config_int("NCONTROLS", other_keys, -1);
			}
		}
	}				

	BTN[0][0][0]=get_config_int("NCONTROLS", "P0A0", KEY_W);
	BTN[0][1][0]=get_config_int("NCONTROLS", "P0B0", KEY_S);
	BTN[0][2][0]=get_config_int("NCONTROLS", "P0L0", KEY_A);
	BTN[0][3][0]=get_config_int("NCONTROLS", "P0R0", KEY_D);
	BTN[0][4][0]=get_config_int("NCONTROLS", "P0F0", KEY_TAB);
	BTN[0][5][0]=get_config_int("NCONTROLS", "P0S0", KEY_TILDE);

	BTN[1][0][0]=get_config_int("NCONTROLS", "P1A0", KEY_UP);
	BTN[1][1][0]=get_config_int("NCONTROLS", "P1B0", KEY_DOWN);
	BTN[1][2][0]=get_config_int("NCONTROLS", "P1L0", KEY_LEFT);
	BTN[1][3][0]=get_config_int("NCONTROLS", "P1R0", KEY_RIGHT);
	BTN[1][4][0]=get_config_int("NCONTROLS", "P1F0", KEY_RSHIFT);
	BTN[1][5][0]=get_config_int("NCONTROLS", "P1S0", KEY_BACKSPACE);


	save_keys();
}

void save_keys(void)
{
	sort_keys();
	set_config_file("settings.cfg");

	char other_keys[50];
	char c[]={'A','B','L','R','F','S'};

	for (int p=0; p<4; p++)
	{
		for (int i=0; i<6; i++)
		{
			for (int j=0; j<10; j++)
			{
				sprintf(other_keys, "P%d%c%d",p, c[i],j);

				if (BTN[p][i][j]==-1)	//only save the -1s if they need to be saved...
				{
					if (get_config_int("NCONTROLS", other_keys, -1)!=-1)
					{
						set_config_int("NCONTROLS", other_keys, -1);
					}
				}
				else
				{
					set_config_int("NCONTROLS", other_keys, BTN[p][i][j]);
				}
			}
		}
	}		

	flush_config_file();
}

void config(void)
{
	int ok=TRUE;

	while (ok)
	{
		clear_to_color(apage, bg);
		blit(title, apage, 0, 0, title_x, title_y, title->w, title->h);
		//blit(bg, apage, 0, 0, 0, 0, bg->w, bg->h);
		
		int tx=15;
		int ty=30;
		int ta=text_height(big_font)+text_height(big_font)/2;
		textprintf_centre(apage, big_font, 319, ty, WHITE, "-- %s --", txt[lang][10]); ty+=ta*2;

		int clr=DK_WHITE;
		
		if (mouse_y>ty && mouse_y<(ty+ta))
		{
			clr=WHITE;
			if (mouse_b & 1)
			{
				while (mouse_b & 1);
				video_good=FALSE;
				save_video_settings();
				video_good=TRUE;
				
				clear_to_color(screen, bg);
				//blit(bg, apage, 0, 0, 0, 0, bg->w, bg->h);
				textprintf_centre(screen, big_font, 319, 20, WHITE, txt[lang][21]);
				rest(2500);
			}
		}
		else {clr=DK_WHITE;}

		textprintf(apage, big_font, tx, ty, clr, txt[lang][13]); ty+=ta; //video


		if (mouse_y>ty && mouse_y<(ty+ta))
		{
			clr=WHITE;
			if (mouse_b & 1)
			{
				while (mouse_b &1);
				
				select_language();
			}
		}
		else {clr=DK_WHITE;}

		textprintf(apage, big_font, tx, ty, clr, txt[lang][14]); ty+=ta; //language


		if (has_sound)
		{
			if (mouse_y>ty && mouse_y<(ty+ta))
			{
				clr=WHITE;
				if (mouse_b & 1)
				{
					while (mouse_b & 1);
					sound=!sound;
				}	
			}
			else {clr=DK_WHITE;}
		}
		else
		{
			clr=DK_WHITE;
			sound=FALSE;
		}

		if (sound)
		{
			textprintf(apage, big_font, tx, ty, clr, txt[lang][15]); ty+=ta;
		}
		else
		{
			textprintf(apage, big_font, tx, ty, clr, txt[lang][16]); ty+=ta;
		}


		if (has_sound)
		{
			if (mouse_y>ty && mouse_y<(ty+ta))
			{
				clr=WHITE;
				if (mouse_b & 1)
				{
					while (mouse_b & 1);
					music=!music;
					if (music)
					{
						handle_music();
					}
					else
					{
						stop_music();
					}
				}
			}
			else {clr=DK_WHITE;}
		}
		else
		{
			clr=DK_WHITE;
			music=FALSE;
		}

		if (music)
		{
			textprintf(apage, big_font, tx, ty, clr, txt[lang][17]); ty+=ta;
		}
		else
		{
			textprintf(apage, big_font, tx, ty, clr, txt[lang][18]); ty+=ta;
		}


		if (mouse_y>ty && mouse_y<(ty+ta))
		{
			clr=WHITE;
			if (mouse_b & 1)
			{
				while (mouse_b & 1);
				change_controls();
			}
		}
		else {clr=DK_WHITE;}

		textprintf(apage, big_font, tx, ty, clr, txt[lang][19]); ty+=ta; //keyboard


		if (mouse_y>ty && mouse_y<(ty+ta))
		{
			clr=WHITE;

			if (mouse_b & 1)
			{
				while (mouse_b & 1);
				ok=FALSE;
			}
		}
		else {clr=DK_WHITE;}
		textprintf(apage, big_font, tx, ty, clr, txt[lang][20]); ty+=ta; //back


		draw_sprite(apage, mouse_sprite, mouse_x, mouse_y);
		vsync();
		blit(apage,screen,0,0,0,0,VIDEO_WIDTH, VIDEO_HEIGHT);
		while(!timer_var);
		timer_var=FALSE;


	}

}

void change_controls(void)
{
	set_trans_blender(0, 0, 0, 128);

	int ok=TRUE;
	int selected=0;
	while(ok)
	{
		handle_music();
		clear_to_color(apage, bg);
		
		draw_trans_sprite(apage, title, title_x, title_y);
		//blit(title, apage, 0, 0, title_x, title_y, title->w, title->h);
		//blit(bg, apage, 0, 0, 0, 0, bg->w, bg->h);


		int tx=15;
		int ty=30;
		int ta=text_height(big_font)+text_height(big_font)/2;

		textprintf_centre(apage, big_font, 319, ty, WHITE, "-- %s --", txt[lang][22]); ty+=ta+(ta/2); //controls

		int clr;
		int c2,c3;
		clr=c2=c3=DK_WHITE;		

		if (mouse_y>ty && mouse_y<(ty+ta))
		{
			if (mouse_x<260)
			{
				c2=WHITE;
				if (mouse_b & 1)
				{
					selected--;
					if (selected<0){selected=3;}
					while (mouse_b & 1);
				}

			}
			else
			if (mouse_x>379 && mouse_x<430)
			{
				c3=WHITE;
				if (mouse_b & 1)
				{
					selected++;
					if (selected==4){selected=0;}
					while (mouse_b & 1);
				}
			
			}
			else if (mouse_x<380)
			{
				clr=WHITE;
				if (mouse_b & 1)
				{
					selected++;
					if (selected==4){selected=0;}
					while (mouse_b & 1);
				}
			}
		}
		else {clr=DK_WHITE;}
		textprintf_centre(apage, big_font, 319, ty, clr, "%s %d", txt[lang][23], selected+1); //player
		textprintf_right(apage, big_font, 259, ty, c2, "<<<<");
		textprintf(apage, big_font, 380, ty, c3, ">>>>");

		if (mouse_y>ty && mouse_y<(ty+ta) && mouse_x>450)
		{
			clr=WHITE;

			if (mouse_b & 1)
			{
				while (mouse_b & 1);
				ok=FALSE;
			}
		}
		else {clr=DK_WHITE;}
		textprintf_right(apage, big_font, 615, ty, clr, "[%s]", txt[lang][20]); //back

		
		ty+=ta; 

		int clr1=DK_WHITE;
		int clr2=DK_WHITE;
		int clr3=DK_WHITE;
		int clr4=DK_WHITE;
		int clr5=DK_WHITE;
		int clr6=DK_WHITE;

		if (mouse_y>ty && mouse_y<(ty+ta))
		{
			if (mouse_x<107)
			{
				clr1=WHITE;

				if (mouse_b & 1)
				{
					while (mouse_b &1);
					BTN[selected][0][9]=get_new_key(txt[lang][25]);
					sort_keys();
				}

			}
			else
			if (mouse_x<214)
			{
				clr2=WHITE;

				if (mouse_b & 1)
				{
					while (mouse_b &1);
					BTN[selected][1][9]=get_new_key(txt[lang][26]);
					sort_keys();
				}
			}
			else
			if (mouse_x<321)
			{
				clr3=WHITE;
				if (mouse_b & 1)
				{
					while (mouse_b &1);
					BTN[selected][2][9]=get_new_key(txt[lang][27]);
					sort_keys();
				}
			}
			else
			if (mouse_x<428)
			{
				clr4=WHITE;
				if (mouse_b & 1)
				{
					while (mouse_b &1);
					BTN[selected][3][9]=get_new_key(txt[lang][28]);
					sort_keys();
				}

			}
			else
			if (mouse_x<535)
			{
				clr5=WHITE;
				if (mouse_b & 1)
				{
					while (mouse_b &1);
					BTN[selected][4][9]=get_new_key(txt[lang][29]);
					sort_keys();
				}

			}
			else
			{
				clr6=WHITE;
				if (mouse_b & 1)
				{
					while (mouse_b &1);
					BTN[selected][5][9]=get_new_key(txt[lang][72]);
					sort_keys();
				}
			}


		}

		update_local_ctrl_flags();
		

		if (ctrl_flag[selected] & FUP){text_mode(RED);} else {text_mode(-1);}
		textprintf_centre(apage, big_font, 53, ty, clr1, "[%s]", txt[lang][25]); //accelerate

		if (ctrl_flag[selected] & FDN){text_mode(RED);} else {text_mode(-1);}
		textprintf_centre(apage, big_font, 160, ty, clr2, "[%s]", txt[lang][26]); //break

		if (ctrl_flag[selected] & FLF){text_mode(RED);} else {text_mode(-1);}
		textprintf_centre(apage, big_font, 267, ty, clr3, "[%s]", txt[lang][27]); //left

		if (ctrl_flag[selected] & FRT){text_mode(RED);} else {text_mode(-1);}
		textprintf_centre(apage, big_font, 374, ty, clr4, "[%s]", txt[lang][28]); //right

		if (ctrl_flag[selected] & FFR){text_mode(RED);} else {text_mode(-1);}
		textprintf_centre(apage, big_font, 481, ty, clr5, "[%s]", txt[lang][29]); //fire

		if (ctrl_flag[selected] & FSCR){text_mode(RED);} else {text_mode(-1);}
		textprintf_centre(apage, big_font, 588, ty, clr6, "[%s]", txt[lang][72]); //zoom
		ty+=ta;

		if (control(1006)){text_mode(BLACK);}
		if (control(1005)){text_mode(WHITE);}

		text_mode(-1);

		for (int i=0; i<10; i++)
		{

			clr1=clr2=clr3=clr4=clr5=clr6=DK_WHITE;

			if (mouse_y>ty && mouse_y<(ty+ta))
			{
				if (mouse_x<107)
				{
					clr1=WHITE;
					if (mouse_b & 1)
					{
						BTN[selected][0][i]=-1;
						sort_keys();
						while(mouse_b & 1);
					}

				}
				else
				if (mouse_x<214)
				{
					clr2=WHITE;
					if (mouse_b & 1)
					{
						BTN[selected][1][i]=-1;
						sort_keys();
						while(mouse_b & 1);
					}
				}
				else
				if (mouse_x<321)
				{
					clr3=WHITE;
					if (mouse_b & 1)
					{
						BTN[selected][2][i]=-1;
						sort_keys();
						while(mouse_b & 1);
					}

				}
				else
				if (mouse_x<428)
				{
					clr4=WHITE;
					if (mouse_b & 1)
					{
						BTN[selected][3][i]=-1;
						sort_keys();
						while(mouse_b & 1);
					}

				}
				else
				if (mouse_x<535)
				{
					clr5=WHITE;
					if (mouse_b & 1)
					{
						BTN[selected][4][i]=-1;
						sort_keys();
						while(mouse_b & 1);
					}
	
				}
				else
				{
					clr6=WHITE;
					if (mouse_b & 1)
					{
						BTN[selected][5][i]=-1;
						sort_keys();
						while(mouse_b & 1);
					}
				}
			}


			if (BTN[selected][0][i]>-1)
			{
				textprintf_centre(apage, big_font, 53, ty, clr1, "%s", what_char(BTN[selected][0][i])); //accelerate controls
			}

			if (BTN[selected][1][i]>-1)
			{
				textprintf_centre(apage, big_font, 160, ty, clr2, "%s", what_char(BTN[selected][1][i])); //brake controls
			}

			if (BTN[selected][2][i]>-1)
			{
				textprintf_centre(apage, big_font, 267, ty, clr3, "%s", what_char(BTN[selected][2][i])); //left controls
			}

			if (BTN[selected][3][i]>-1)
			{
				textprintf_centre(apage, big_font, 374, ty, clr4, "%s", what_char(BTN[selected][3][i])); //right controls
			}

			if (BTN[selected][4][i]>-1)
			{
				textprintf_centre(apage, big_font, 481, ty, clr5, "%s", what_char(BTN[selected][4][i])); //fire controls
			}

			if (BTN[selected][5][i]>-1)
			{
				textprintf_centre(apage, big_font, 588, ty, clr6, "%s", what_char(BTN[selected][5][i])); //fire controls
			}

			ty+=ta;
		}


		/*
		if (use_joy)
		{
			if (num_joysticks>=selected)
			{
				rect(apage, 480, 100, 580, 200, WHITE);
				int x=480+50;
				int y=100+50;
				int filled=FALSE;

				poll_joystick();
				if (get_joy_up(selected)){y-=35;}
				if (get_joy_dn(selected)){y+=35;}
				if (get_joy_lf(selected)){x-=35;}
				if (get_joy_rt(selected)){x+=35;}

				if (get_joy_fire(selected)){filled=TRUE;}

				if (filled)
				{
					circlefill(apage, x,y, 10, WHITE);
				}
				else
				{
					circle(apage, x, y, 10, WHITE);
				}


			}
		}*/

		draw_sprite(apage, mouse_sprite, mouse_x, mouse_y);
		vsync();
		blit(apage,screen,0,0,0,0,VIDEO_WIDTH, VIDEO_HEIGHT);
		while(!timer_var);
		timer_var=FALSE;
	}
	save_keys();
	return;
}

int get_new_key(char * t)
{
	rectfill(screen, 200, 200, 440, 280, bg);
	rect(screen, 200, 200, 440, 280, WHITE);
	textprintf(screen, big_font, 215, 215, WHITE, t);
	textprintf_centre(screen, big_font, 320, 265-text_height(big_font), WHITE, txt[lang][30]);

	while(TRUE)
	{
		for (int i=0; i<KEY_MAX; i++)
		{
			if (key[i])
			{
				while(key[i]);
				return(i);
			}
		}

		if (use_joy)
		{
			poll_joystick();
			for (int i=0; i<num_joysticks; i++)
			{
				for (int j=0; j<joy[i].num_sticks; j++)
				{
					for (int k=0; k<joy[i].stick[j].num_axis; k++)
					{

						if (joy[i].stick[j].axis[k].d1)
						{
							return(1000+(i*100)+(j*10)+k);
						}

						if (joy[i].stick[j].axis[k].d2)
						{
							return(1000+(i*100)+(j*10)+k+5);
						}					
					}
				}

				for (int j=0; j<joy[i].num_buttons; j++)
				{
					if (joy[i].button[j].b)
					{
						return(1000+(i*100)+50+j);
					}
				}
			}
		}
	}
	return(0);
}

int setup_game(void)
{
	load_gen_settings();
	int ok=TRUE;
	int selected=0;
	while(ok)
	{
		handle_music();
		clear_to_color(apage, bg);
		blit(title, apage, 0, 0, title_x, title_y, title->w, title->h);
		//blit(bg, apage, 0, 0, 0, 0, bg->w, bg->h);
		
		int tx=15;
		int ty=30;
		int ta=text_height(big_font)+text_height(big_font)/2;
		textprintf_centre(apage, big_font, 319, ty, WHITE, "-- %s --", txt[lang][9]); ty+=ta*2;

		int clr=DK_WHITE;
		
		if (mouse_y>ty && mouse_y<(ty+ta))
		{
			clr=WHITE;
			if (mouse_b & 1)
			{
				while (mouse_b & 1);
				map_size++;
				if (map_size==3){map_size=0;}
			}
		}
		else {clr=DK_WHITE;}
		textprintf(apage, big_font, tx, ty, clr, "%s %s", txt[lang][32], txt[lang][35+map_size]); ty+=ta; //map size

		if (mouse_y>ty && mouse_y<(ty+ta))
		{
			clr=WHITE;
			if (mouse_b & 1)
			{
				while (mouse_b & 1);
				reproduc++;
				if (reproduc==3){reproduc=0;}
			}
		}
		else {clr=DK_WHITE;}
		textprintf(apage, big_font, tx, ty, clr, "%s %s", txt[lang][33], txt[lang][38+reproduc]); ty+=ta; //Reproducers

		if (mouse_y>ty && mouse_y<(ty+ta))
		{
			clr=WHITE;
			if (mouse_b & 1)
			{
				while (mouse_b & 1);
				powerups++;
				if (powerups==3){powerups=0;}
			}
		}
		else {clr=DK_WHITE;}
		textprintf(apage, big_font, tx, ty, clr, "%s %s", txt[lang][34], txt[lang][38+powerups]); ty+=ta; //power ups


		if (mouse_y>ty && mouse_y<(ty+ta))
		{
			clr=WHITE;
			if (mouse_b & 1)
			{
				while (mouse_b & 1);
				time_limit++;
				if (time_limit==11)
				{time_limit=1;}
			}

			if (mouse_b & 2)
			{
				while (mouse_b & 2);
				time_limit--;
				if (time_limit==0)
				{time_limit=10;}
			}
		}
		else {clr=DK_WHITE;}
		textprintf(apage, big_font, tx, ty, clr, "%s %d:00", txt[lang][41], time_limit); ty+=ta; //Time Limit

		if (mouse_y>ty && mouse_y<(ty+ta))
		{
			clr=WHITE;
			if (mouse_b & 1)
			{
				while (mouse_b & 1);
				check_points+=5;
				if (check_points>100)
				{
					check_points=100;
				}
			}

			if (mouse_b & 2)
			{
				while (mouse_b & 2);
				check_points-=5;
				if (check_points<5)
				{
					check_points=5;
				}
			}
		}
		else {clr=DK_WHITE;}

		if (check_points<5 || check_points>100){check_points=5;}
		textprintf(apage, big_font, tx, ty, clr, "%s %d", txt[lang][42], check_points); ty+=ta; //Check Points

		if (mouse_y>ty && mouse_y<(ty+ta))
		{
			clr=WHITE;
			if (mouse_b & 1)
			{
				while (mouse_b & 1);
				{
					save_gen_settings();
					return(0);
				}
			}
		}
		else {clr=DK_WHITE;}
		textprintf(apage, big_font, tx, ty, clr, txt[lang][20]); ty+=ta; //back

		if (mouse_y>ty && mouse_y<(ty+ta))
		{
			clr=WHITE;
			if (mouse_b & 1)
			{
				while (mouse_b & 1);
				{
					save_gen_settings();
					return(1);
				}
			}
		}
		else {clr=DK_WHITE;}
		textprintf(apage, big_font, tx, ty, clr, txt[lang][9]); ty+=ta; //start

		draw_sprite(apage, mouse_sprite, mouse_x, mouse_y);
		vsync();
		blit(apage,screen,0,0,0,0,VIDEO_WIDTH, VIDEO_HEIGHT);
		while(!timer_var);
		timer_var=FALSE;
	}

}

void save_gen_settings(void)
{
	set_config_file("settings.cfg");

	set_config_int("GENERAL", "sound_on", sound);
	set_config_int("GENERAL", "music_on", music);
	set_config_int("GENERAL", "map_size", map_size);
	set_config_int("GENERAL", "reproduc", reproduc);
	set_config_int("GENERAL", "powerups", powerups);
	set_config_int("GENERAL", "time_limit", time_limit);
	set_config_int("GENERAL", "check_points", check_points);

	int card=0;
	if (VIDEO_CARD==VIDEO_CARD2){card=1;}
	else if (VIDEO_CARD==VIDEO_CARD3){card=2;}
	set_config_int("GENERAL", "GFX_PROBLEMS", card);


	flush_config_file();
}

void load_gen_settings(void)
{
	set_config_file("settings.cfg");
	sound=get_config_int("GENERAL", "sound_on", TRUE);
	music=get_config_int("GENERAL", "music_on", TRUE);
	map_size=get_config_int("GENERAL", "map_size", 1);
	reproduc=get_config_int("GENERAL", "reproduc", 1);
	powerups=get_config_int("GENERAL", "powerups", 1);
	time_limit=get_config_int("GENERAL", "time_limit", 5);
	check_points=get_config_int("GENERAL", "check_points", 15);
	int card=get_config_int("GENERAL", "GFX_PROBLEMS", 0);

	if (has_sound==FALSE)
	{
		music=FALSE;
		sound=FALSE;
	}

	if (card==0)
	{
		VIDEO_CARD=VIDEO_CARD1;
	}
	else
	if (card==1)
	{
		VIDEO_CARD=VIDEO_CARD2;
	}
	else
	if (card==2)
	{
		VIDEO_CARD=VIDEO_CARD2;
	}

	save_gen_settings();
}

///////  ///////  ///////

void import_tileset(char * filename)
{
	tileset=load_bitmap2(filename);
	if (!tileset){return;}

	int x=0;
	int y=0;
	for (int i=0; i<MAX_TILES; i++)
	{
		x=i*32;
		while (x>tileset->w)
		{
			x-=tileset->w;
			y+=32;
		}

		if (y<tileset->h)
		{
			btiles[i]=create_bitmap(32,32);
			if (btiles[i])
			{
				blit(tileset, btiles[i], x, y, 0, 0, 32, 32);
				mtiles[i]=create_allegro_pmask(btiles[i]);
			}

		}

	}
	destroy_bitmap(tileset);
	tileset=NULL;

	return;
}

///////  ///////  ///////


int map_width;
int map_height;
int map[200][200];

#define room_width	15
#define room_height	15

int world[3000][3000];
int wflag[3000][3000];
int values[3000][3000];

int world_width;
int world_height;

int gwx;
int gwy;

///////  ///////  ///////

void build_map(void)
{
	for (int i=0; i<map_width; i++)
	{
		memset(&map[i],0,map_height*sizeof(int));
	}

	int x=0;
	int y=0;


	while (x<4 || y<4 || x>(map_width-5) || y>(map_height-5))
	{
		x=rand()%map_width;
		y=rand()%map_height;
	}

	map[x][y]=1;

	int dx[4];	//dirs x offset
	int dy[4];	//dirs y offset
	int pr[4];	//type of connector used for passage connected rooms
	int cr[4];	//type of connector used for connected roooms

	dx[0]=-1;
	dy[0]=0;
	dx[1]=1;
	dy[1]=0;
	dx[2]=0;
	dy[2]=-1;
	dx[3]=0;
	dy[3]=1;
	
	pr[0]=5;
	pr[1]=5;
	pr[2]=3;
	pr[3]=3;
	cr[0]=4;
	cr[1]=4;
	cr[2]=2;
	cr[3]=2;

	int rooms=50;
	int added=1;

	while (added<rooms)
	{
		x=rand()%map_width;
		y=rand()%map_height;

		if (map[x][y]==1)
		{
			int dir=rand()%4;
			if (get_map(x+(dx[dir]*2), y+(dy[dir]*2))==0)
			{
				added++;
				if (rand()%4)
				{
					set_map(x+dx[dir],y+dy[dir], pr[dir]);
				}
				else
				{
					set_map(x+dx[dir],y+dy[dir], cr[dir]);
				}
				set_map(x+(dx[dir]*2),y+(dy[dir]*2),1);
			}

		}
		if (key[KEY_ESC])
		{return;}
	}

	int extra_connectors=(3+rand()%(1+(rooms/10)));
	added=0;

	while (added<extra_connectors)
	{
		for (x=0; x<map_width; x++)
		{
			for(y=0; y<map_height; y++)
			{
		
				if ((get_map(x, y)==0) && (rand()%2))
				{
					int r=rand()%2;
					r*=2;
			
					if (get_map(x+dx[r], y+dy[r])==1 && get_map(x+dx[r+1], y+dy[r+1])==1)
					{
						added++;
						if (rand()%4)
						{
							set_map(x,y, cr[r]);
						}
						else
						{
							set_map(x,y, pr[r]);
						}

						if (added>=extra_connectors)
						{
							x=map_width;
							y=map_height;
						}
					}
				}
			}
		}
	}
	center_map();
}

void center_map(void)
{
	int map2[map_width][map_height];
	int x1=map_width;
	int x2=0;
	int y1=map_height;
	int y2=0;

	for (int i=0; i<map_width; i++)	
	{
		for (int j=0; j<map_height; j++)
		{
			if (get_map(i,j)==1)
			{
				if (x1>i){x1=i;}
				if (y1>j){y1=j;}
				if (x2<i){x2=i;}
				if (y2<j){y2=j;}
			}
			map2[i][j]=0;
		}
	}

	
	
	for(int i=x1; i<=x2; i++)
	{
		for (int j=y1; j<=y2; j++)
		{
			map2[i-x1][j-y1]=map[i][j];
		}
	}

	for (int i=0; i<map_width; i++)	
	{
		for (int j=0; j<map_height; j++)
		{
			map[i][j]=0;
		}
	}

	int w=(x2-x1);
	int h=(y2-y1);

	//centered
	/*int ax=(map_width/2)-(w/2);
	int ay=(map_height/2)-(h/2);

	for (int i=0; i<=w; i++)
	{
		for (int j=0; j<=h; j++)
		{
			map[i+ax][j+ay]=map2[i][j];
		}
	}*/

	//uper left justified
	for (int i=0; i<w; i++)
	{
		for (int j=0; j<h; j++)
		{
			map[i][j]=map2[i][j];
		}
	}
}

int get_map(int x, int y)
{
	if (x>0 && y>0 && x<map_width && y<map_height)
	{
		return(map[x][y]);
	}
	return(-1);
}

void set_map(int x, int y, int c)
{
	if (x>0 && y>0 && x<map_width && y<map_height)
	{
		map[x][y]=c;
	}
}

///////  ///////  ///////

void make_map(void)
{
	clear_to_color(screen, bg);
	blit(title, apage, 0, 0, title_x, title_y, title->w, title->h);
	//blit(bg, apage, 0, 0, 0, 0, bg->w, bg->h);
	textprintf(screen, big_font, 15, 15, WHITE, txt[lang][44]);

	do_map_work();

	while (map_is_bad())
	{
		do_map_work();
	}
}

int map_is_bad(void)
{
	int x=0;
	int y=0;
	

	while (wflag[x][y]!=0)
	{
		x=rand()%world_width;
		y=rand()%world_height;
	}

	FLOOD_FILL(x,y,7);

	for (int i=0; i<world_width; i++)
	{
		for (int j=0; j<world_height; j++)
		{
			if (wflag[i][j]==0)
			{
				return(TRUE);
			}
			else if (wflag[i][j]==7)
			{
				wflag[i][j]=0;
				world[i][j]=0;
			}
		}
	}
	return(FALSE);
}

void do_map_work(void)
{
	map_width=25+(25*map_size);
	map_height=25+(25*map_size);

	world_width=map_width*room_width;
	world_height=map_height*room_height;

	gwx=0;
	gwy=0;

	build_map();
	build_room_borders();

	for (int i=0; i<world_width; i++)
	{
		for (int j=0; j<world_height; j++)
		{
			if (world[i][j]){wflag[i][j]=1;}
		}
	}

	
	for (int i=0; i<world_width; i++)
	{
		if (wflag[i][0]==0)
		{
			world[i][0]=1;
			wflag[i][0]=1;

			//FLOOD_FILL(i, 0, 1);
		}

		if (wflag[i][world_height-1]==0)
		{
			world[i][world_height-1]=1;
			wflag[i][world_height-1]=1;

			//FLOOD_FILL(i, world_height-1, 1);
		}
	}



	for (int i=0; i<world_height; i++)
	{
		if (wflag[0][i]==0)
		{
			world[0][i]=1;
			wflag[0][i]=1;

			//FLOOD_FILL(0, i, 1);
		}

		if (wflag[world_width-1][i]==0)
		{
			world[world_width-1][i]=1;
			wflag[world_width-1][i]=1;

			//FLOOD_FILL(world_width-1, i, 1);
		}
	}

}

int get_world_tile(int x, int y)
{
	if (x>=0 && y>=0 && x<world_width && y<world_height)
	{
		return(world[x][y]);
	}
	return(0);
}

void set_world_tile(int x, int y, int t)
{
	if (x>=0 && y>=0 && x<world_width && y<world_height)
	{
		world[x][y]=t;
	}
}

int get_wflag_tile(int x, int y)
{
	if (x>=0 && y>=0 && x<world_width && y<world_height)
	{
		return(wflag[x][y]);
	}
	return(0);
}

void set_wflag_tile(int x, int y, int t)
{
	if (x>=0 && y>=0 && x<world_width && y<world_height)
	{
		wflag[x][y]=t;
	}
}

int peek_values(int x, int y)
{
	if (x>=0 && y>=0 && x<world_width && y<world_height)
	{
		return(values[x][y]);
	}
	return(0);
}

void poke_values(int x, int y, int t)
{
	if (x>=0 && y>=0 && x<world_width && y<world_height)
	{
		values[x][y]=t;
	}
}

int peek_map(int x, int y)
{
	return(get_wflag_tile(x, y));
}

void poke_map(int x, int y, int c)
{
	set_wflag_tile(x,y,c);
	set_world_tile(x,y,c);
}

void FLOOD_FILL(int x, int y, int c)
{
	int t=peek_map(x,y);
	poke_map(x, y, c);
	if (c==t){return;}

	int fx1=x-1;
	int fy1=y-1;
	int fx2=x+1;
	int fy2=y+1;

	for (int i=0; i<world_width; i++)
	{
		for (int j=0; j<world_height; j++)
		{
			values[i][j]=0;
		}
	}
	//values:
	//0=old value
	//1=new value

	values[x][y]=1;

	int counter=1;
	int e;
	while(counter>0)
	{
		counter=0;
		for (int x=fx1; x<=fx2; x++)
		{
			for (int y=fy1; y<=fy2; y++)
			{
				e=peek_map(x,y);
				if (e!=-1)
				{
					if (e==t)
					{
						int can_change=FALSE;
						for (int i=-1; i<2; i++)
						{
							for (int j=-1; j<2; j++)
							{
								if (peek_values(i+x,j+y)==1)
								{
									can_change=TRUE;
									i=2;
									j=2;
								}
							}
						}


						if (can_change)
						{
							poke_map(x,y,c);
							poke_values(x,y,1);
							counter++;

							if (fx1>(x-1))
							{fx1=x-1;}

							if (fy1>(y-1))
							{fy1=y-1;}

							if (fx2<(x+1))
							{fx2=x+1;}

							if (fy2<(y+1))
							{fy2=y+1;}

							if (fx1<0){fx1=0;}
							if (fy1>=world_width){fy1=world_width-1;}
							if (fx2<0){fx2=0;}
							if (fy2>=world_height){fy2=world_height-1;}
						}
					}
				}
			}
		}
	}

}

void build_room_borders(void)
{
	for (int i=0; i<world_width; i++)
	{
		memset(world[i], 0, world_height*sizeof(int));
		memset(wflag[i], 1, world_height*sizeof(int));
	}

	int first=TRUE;
	int l1=TRUE;
	int l2=TRUE;
	for (int i=0; i<map_width; i++)
	{
		for (int j=0; j<map_height; j++)
		{
			if (map[i][j]==1)
			{
				int xo=((i/2)*room_width);
				int yo=((j/2)*room_height);

				for (int x=xo; x<xo+room_width; x++)
				{
					for (int y=yo; y<yo+room_height; y++)
					{
						wflag[x][y]=0;
					}
				}

				if (first){gwx=(xo-2)*32; gwy=(yo-2)*32; first=FALSE;}

				l1=l2=TRUE;
				if (get_map(i,j-1)==2){l1=FALSE;}
				if (get_map(i,j+1)==2){l2=FALSE;}
				for (int x=0; x<room_width; x++)
				{
					if (l1){world[xo+x][yo]=1;}
					if (l2){world[xo+x][yo+room_height-1]=1;}
				}

				l1=l2=FALSE;
				if (get_map(i,j-1)==3){l1=TRUE;}
				if (get_map(i,j+1)==3){l2=TRUE;}
				if (l1 || l2)
				{
					for (int x=5; x<11; x++)
					{
						if (l1){world[xo+x][yo]=0;wflag[xo+x][yo]=0;}
						if (l2){world[xo+x][yo+room_height-1]=0;wflag[xo+x][yo+room_height-1]=0;}
					}
				}

				l1=l2=TRUE;
				if (get_map(i-1,j)==4){l1=FALSE;}
				if (get_map(i+1,j)==4){l2=FALSE;}
				for (int y=0; y<room_height; y++)
				{
					if (l1){world[xo][yo+y]=1;}
					if (l2){world[xo+room_width-1][yo+y]=1;}
				}

				l1=l2=FALSE;
				if (get_map(i-1,j)==5){l1=TRUE;}
				if (get_map(i+1,j)==5){l2=TRUE;}
				if (l1 || l2)
				{
					for (int y=5; y<11; y++)
					{
						if (l1){world[xo][yo+y]=0;wflag[xo][yo+y]=0;}
						if (l2){world[xo+room_width-1][yo+y]=0;wflag[xo+room_width-1][yo+y]=0;}
					}
				}

			}

		}
	}

	int w=0;
	int h=0;

	for (int i=0; i<world_width; i++)
	{
		for (int j=0; j<world_height; j++)
		{

			if (world[i][j]!=0)
			{
				if (i>w){w=i;}
				if (j>h){h=j;}
			}
		}
	}

	world_width=w+1;
	world_height=h+1;

	if (world_bmp){destroy_bitmap(world_bmp);}

	world_bmp=create_bitmap(world_width, world_height);
}

void draw_room2(BITMAP * bmp, int pos_x, int pos_y, int x1, int y1, int w, int h)
{


	int x=x1/32;
	int y=y1/32;


	int vx=x1%32;
	int vy=y1%32;
	int tw=(w/32)+2;
	int th=(h/32)+2;

	int t=0;
	int px=-vx;
	int py=-vy;

	for (int i=0; i<tw; i++)
	{
		py=-vy;
		for (int j=0; j<th; j++)
		{
			t=get_world_tile(i+x, j+y);

			if (t>0)
			{
				blit(btiles[t], bmp, 0, 0, px+pos_x, py+pos_y, 32, 32);
			}
				py+=32;
		}
		px+=32;
	}

}




void draw_room(BITMAP * bmp, int pos_x, int pos_y, int x1, int y1, int w, int h)
{
	static int half_text=text_height(big_font)/2;

	int x=x1/32;
	int y=y1/32;
	int vx=x1%32;
	int vy=y1%32;

	int tw=(w/32)+2;
	int th=(h/32)+2;

	int t=0;
	int px=-vx;
	int py=-vy;
	for (int i=0; i<tw; i++)
	{
		py=-vy;
		for (int j=0; j<th; j++)
		{
			t=get_world_tile(i+x, j+y);

			if (t>0)
			{
				masked_blit(btiles[t], bmp, 0, 0, px+pos_x, py+pos_y, 32, 32);
			}

			py+=32;
		}
		px+=32;
	}


	for (int i=0; i<max_powerups+4; i++)
	{
		if (pwr[i].life>0)
		{
			if (pwr[i].life<powerup_danger)
			{
				if ((pwr[i].life/10)%2)//((blinky/15)%2)
				{
					draw_trans_sprite(bmp, btiles[pwr[i].type], pos_x+(pwr[i].x-x1), pos_y+(pwr[i].y-y1));
				}
			}
			else
			{
				draw_sprite(bmp, btiles[pwr[i].type], pos_x+(pwr[i].x-x1), pos_y+(pwr[i].y-y1));
			}
		}
	}

	for (int i=0; i<max_cows; i++)
	{
		if (cows[i].life>0)
		{
			rotate_sprite(bmp, cow, (int)(pos_x+(cows[i].x-x1)), (int)(pos_y+(cows[i].y-y1)), ftofix(cows[i].d));
		}
	}

	for (int i=0; i<max_bubbles; i++)
	{
		if (bubs[i].life>0)
		{
			draw_sprite(bmp, bub_bmp[bubs[i].type], pos_x+(int)(bubs[i].x)-x1, pos_y+(int)(bubs[i].y)-y1);

			/*int sz=5;
			if (bubs[i].type){sz=10;}
			circle(bmp, pos_x+(int)(bubs[i].x)-x1, pos_y+(int)(bubs[i].y)-y1, sz, WHITE);*/
		}
	}


	for (int i=0; i<4; i++)
	{
		if (p[i].playing)
		{
			if (draw_hud==i)
			{
				float x=(pos_x+(p[i].x-x1));
				float y=(pos_y+(p[i].y-y1));
				rotate_sprite(bmp, p[i].bmp, (int)x, (int)y, ftofix(p[i].dir));
	
				if ((blinky/15)%2)
				{
					x+=(p[i].bmp->w/2)+X_LOOK[(int)p[i].dir]*32;
					y+=(p[i].bmp->h/2)+Y_LOOK[(int)p[i].dir]*32;

					rotate_sprite(bmp, arrow, (int)x-(arrow->w/2), (int)y-(arrow->h/2), ftofix(p[i].dir));
				}

				//if (p[i].checks>0)
				//{
					draw_trans_sprite(bmp, btiles[3+i], pos_x+5, pos_y+p[i].stats_y);
					textprintf(bmp, big_font, pos_x+42, pos_y+p[i].stats_y+2, WHITE, "x %d", check_points-p[i].checks);
				//}
		
				if (p[i].confused>0)
				{
					for (int xyz=0; xyz<3; xyz++)
					{
						textout_centre_bold(bmp, font, "?", (int)(pos_x+(p[i].x-x1))+(-20+(rand()%40))+p[i].bmp->w/2, (int)((pos_y+(p[i].y-y1))-(20+half_text))+(rand()%40)+p[i].bmp->h/2, BLUE, WHITE);
					}

					p[i].item=0;
					p[i].item_amt=0;

					draw_trans_sprite(bmp, btiles[7], (pos_x+(w/2))-btiles[7]->w/2, pos_y+p[i].stats_y);
					textprintf(bmp, big_font, ((pos_x+(w/2))-btiles[7]->w/2)+37, pos_y+p[i].stats_y+2, WHITE, ": %d", p[i].confused/DESIRED_FPS);

					p[i].confused--;

					if (p[i].confused>300)
					{
						float ax, ay, ad;
						ax=(rand()%5)/2;
						ay=(rand()%5)/2;
						ad=(rand()%5)/10;

						if (rand()%2){ax*=-1;}
						if (rand()%2){ay*=-1;}

						p[i].vx+=ax;
						p[i].vy+=ay;
						p[i].vdir+=ad;

						while (p[i].dir>256)
						{
							p[i].dir-=256;
						}

						while (p[i].dir<0)
						{
							p[i].dir+=256;
						}

					}
				}
				else if (p[i].item>1)
				{
					draw_trans_sprite(bmp, btiles[p[i].item], (pos_x+(w/2))-btiles[p[i].item]->w/2, pos_y+p[i].stats_y);
					if (p[i].item_amt>0)
					{
						textprintf(bmp, big_font, ((pos_x+(w/2))-btiles[p[i].item]->w/2)+37, pos_y+p[i].stats_y+2, WHITE, "x %d", p[i].item_amt/10);
					}
				}

				if (p[i].speed_ups>0)
				{
					int x=(pos_x+w)-(5+32);
					for (int k=0; k<p[i].speed_ups; k++)
					{
						draw_trans_sprite(bmp, btiles[12], x, pos_y+p[i].stats_y);
						x-=32;
					}
				}
			
			}
			else
			{
				rotate_sprite(bmp, p[i].bmp, (int)(pos_x+(p[i].x-x1)), (int)(pos_y+(p[i].y-y1)), ftofix(p[i].dir));
				if (p[i].confused)
				{
					for (int xyz=0; xyz<3; xyz++)
					{
						textout_centre_bold(bmp, font, "?", (int)(pos_x+(p[i].x-x1))+(-20+(rand()%40))+p[i].bmp->w/2, (int)((pos_y+(p[i].y-y1))-(20+half_text))+(rand()%40)+p[i].bmp->h/2, BLUE, WHITE);
					}
				}
			}
		}
	}

}

///////  ///////  ///////
int dm2_ft=TRUE;
int dm2_y1;
int dm2_y2;
int dm2_x1;
int dm2_x2;
void draw_map2(BITMAP * bmp)
{

	clear_to_color(world_bmp, PURPLE);
	//rect(world_bmp, 0, 0, world_bmp->w-1, world_bmp->h-1, WHITE);

	int t=0;
	int half=world_bmp->w/2;
	int halfy=world_bmp->h/2;

	int x_pos=MAP_CENTER_X-(half);
	int y_pos=MAP_CENTER_Y-(halfy);

	for (int i=0; i<world_width; i++)
	{
		for (int j=0; j<world_height; j++)
		{
			t=world[i][j];
			if (t==1)
			{
				putpixel(world_bmp, i, j, WHITE);
			}
			else if (wflag[i][j]==0)
			{
				putpixel(world_bmp, i,j, DK_WHITE);
			}
			else if ((MAP_VBAR) && (i==half || i==(half-1)))
			{
				putpixel(bmp,i+x_pos,j+y_pos,WHITE);
			}
			else if ((MAP_HBAR) && (j==halfy || j==(halfy-1)))
			{
				putpixel(bmp,i+x_pos,j+y_pos,WHITE);
			}
		}
	}


	for (int i=0; i<max_powerups+4; i++)
	{
		if (pwr[i].life>0)
		{
			if (pwr[i].life<powerup_danger)
			{
				if ((pwr[i].life/10)%2)
				{
					//circlefill(world_bmp, pwr[i].x>>5, pwr[i].y>>5, 1, BLUE);
					circle(world_bmp, pwr[i].x>>5, pwr[i].y>>5, 1, DK_BLUE);
				}
			}
			else
			{
				//circlefill(world_bmp, pwr[i].x>>5, pwr[i].y>>5, 1, BLUE);
				circle(world_bmp, pwr[i].x>>5, pwr[i].y>>5, 1, DK_BLUE);
			}

			pwr[i].life--;



			for (int j=0; j<4; j++)
			{
				if (p[j].playing)
				{
					if  (check_pmask_collision(p[j].mask, mtiles[pwr[i].type], (int)p[j].x, (int)p[j].y, pwr[i].x, pwr[i].y))
					{
						give_powerup(j, i);
						j=4;		//hahahaha this was causing the crash it was set to j=2 from the old 2 plr release!!! -- PRAISE GOD 
					}
				}
			}

		}
	}

	for (int i=0; i<4; i++)
	{
		if (p[i].playing)
		{
			int clr=WHITE;
			if (i==0){clr=GREEN;}
			else
			if (i==1){clr=YELLOW;}
			else
			if (i==2){clr=BLUE;}
			else
			if (i==3){clr=RED;}

			//circlefill(world_bmp, pwr[i].x>>5, pwr[i].y>>5, (blinky/10)+1, clr);
	
			rectfill(world_bmp, (pwr[i].x>>5)-2, (pwr[i].y>>5)-2, (pwr[i].x>>5)+2, (pwr[i].y>>5)+2, clr);
			rect(world_bmp, (pwr[i].x>>5)-3, (pwr[i].y>>5)-3, (pwr[i].x>>5)+3, (pwr[i].y>>5)+3, WHITE);
		}
	}

	for (int i=0; i<max_cows; i++)
	{
		if (cows[i].life>0)
		{
			putpixel(world_bmp, (int)(cows[i].x/32), (int)(cows[i].y/32), RED);
		}
	}

	if (p[0].playing)
	{
		circlefill(world_bmp, (int)(p[0].x/32), (int)(p[0].y/32), 3, DK_GREEN);
		circlefill(world_bmp, (int)(p[0].x/32), (int)(p[0].y/32), 2, GREEN);
	}

	if (p[1].playing)
	{
		circlefill(world_bmp, (int)(p[1].x/32), (int)(p[1].y/32), 3, DK_YELLOW);
		circlefill(world_bmp, (int)(p[1].x/32), (int)(p[1].y/32), 2, YELLOW);
	}

	if (p[2].playing)
	{
		circlefill(world_bmp, (int)(p[2].x/32), (int)(p[2].y/32), 3, DK_BLUE);
		circlefill(world_bmp, (int)(p[2].x/32), (int)(p[2].y/32), 2, BLUE);
	}

	if (p[3].playing)
	{
		circlefill(world_bmp, (int)(p[3].x/32), (int)(p[3].y/32), 3, DK_RED);
		circlefill(world_bmp, (int)(p[3].x/32), (int)(p[3].y/32), 2, RED);
	}


	draw_trans_sprite(bmp, world_bmp, x_pos, y_pos);

	

	if (dm2_ft)
	{
		dm2_y1=MAP_CENTER_Y-(world_bmp->h/2);
		dm2_y2=world_bmp->h+MAP_CENTER_Y-(world_bmp->h/2);
		dm2_x1=MAP_CENTER_X-(world_bmp->w/2);
		dm2_x2=world_bmp->w+MAP_CENTER_X-(world_bmp->w/2);

		dm2_y2--;
		dm2_x2--;
		dm2_ft=FALSE;
	}


}

///////  ///////  ///////

void play_game(void)
{
	ticks=60*DESIRED_FPS*time_limit;

	if (p[0].bmp)
	{destroy_bitmap(p[0].bmp);}

	if (p[1].bmp)
	{destroy_bitmap(p[1].bmp);}

	if (p[2].bmp)
	{destroy_bitmap(p[2].bmp);}

	if (p[3].bmp)
	{destroy_bitmap(p[3].bmp);}

	if (p[0].mask)
	{destroy_pmask(p[0].mask);}

	if (p[1].mask)
	{destroy_pmask(p[1].mask);}

	if (p[2].mask)
	{destroy_pmask(p[2].mask);}

	if (p[3].mask)
	{destroy_pmask(p[3].mask);}

	for (int i=0; i<4; i++)
	{
		memset(&p[i], 0, sizeof(player));
	}

	p[0].bmp=load_bitmap2("gfx\\p1.pcx");
	p[0].mask=create_allegro_pmask(p[0].bmp);

	p[1].bmp=load_bitmap2("gfx\\p2.pcx");
	p[1].mask=create_allegro_pmask(p[1].bmp);

	p[2].bmp=load_bitmap2("gfx\\p3.pcx");
	p[2].mask=create_allegro_pmask(p[2].bmp);

	p[3].bmp=load_bitmap2("gfx\\p4.pcx");
	p[3].mask=create_allegro_pmask(p[3].bmp);




	assign_joy_ptr();

	if (whos_playing()){return;}
	viewport_setup();

	make_map();
	set_trans_blender(0, 0, 0, 192);


	for (int i=0; i<4; i++)
	{
		if (p[i].playing)
		{

		
			while (wflag[(int)p[i].x][(int)p[i].y]!=0)
			{
				p[i].x=rand()%world_width;
				p[i].y=rand()%world_height;
			}

			p[i].x*=32;
			p[i].y*=32;

			p[i].shoot_rate=7;
		}
	}

	arrow=load_bitmap2("gfx\\arrow.pcx");
	cow=load_bitmap2("gfx\\cow1.pcx");
	clear_to_color(cow, RED);
	cow_mask=create_allegro_pmask(cow);
	destroy_bitmap(cow);
	cow=load_bitmap2("gfx\\cow1.pcx");

	bub_bmp[0]=load_bitmap2("gfx\\bubble1.pcx");
	bub_bmp[1]=load_bitmap2("gfx\\bubble2.pcx");
	bub_mask[0]=create_allegro_pmask(bub_bmp[0]);
	bub_mask[1]=create_allegro_pmask(bub_bmp[1]);


	max_powerups=10+(powerups*15)+(map_size*3);
	for (int i=0; i<300; i++)
	{
		memset(&pwr[i],0, sizeof(power_type));
	}

	max_bubbles=300;
	for (int i=0; i<300; i++)
	{
		memset(&bubs[i],0, sizeof(bubble_type));
	}

	max_cows=10;
	if (reproduc==1){max_cows=25;}
	else if (reproduc==2){max_cows=50;}

	for (int i=0; i<150; i++)
	{
		memset(&cows[i], 0, sizeof(cow_type));
	}





	for (int j=0; j<4; j++)
	{
		if (p[j].playing)
		{
			spawn_flag(j);
		}
	}



	play_sound(3);

	dm2_ft=TRUE;	//reset a variable used for drawing the overlaid mini map...



	int ok=TRUE;
	while (ok)
	{
		if (CHAIN_DEBUGGER){debug_msg("1");}
		handle_music();

		if (CHAIN_DEBUGGER){debug_msg("2");}
		handle_powerups();

		if (CHAIN_DEBUGGER){debug_msg("3");}
		handle_cows();

		if (CHAIN_DEBUGGER){debug_msg("4");}
		handle_bubbles();

		if (CHAIN_DEBUGGER){debug_msg("5");}
		update_local_ctrl_flags();

		if (CHAIN_DEBUGGER){debug_msg("6");}

		clear_to_color(apage, bg);
		//blit(bg, apage, 0, 0, 0, 0, bg->w, bg->h);


		for (int s=0; s<4; s++)
		{
			if (p[s].playing)
			{

				//handle zoom status
				if (!can_zoom)
				{
					p[s].zoom=0;
					p[s].zoom_press=FALSE;
				}
				else
				{
					if (!p[s].zoom_press)
					{
						if (ctrl_flag[s] & FSCR)
						{
							p[s].zoom++;
							if (p[s].zoom>1)
							{
								p[s].zoom=0;
							}
							p[s].zoom_press=TRUE;
						}
					}
					else
					{
						if (!(ctrl_flag[s] & FSCR))
						{
							p[s].zoom_press=FALSE;
						}
					}
				}
				//done handling zoom status


				if (p[s].zoom && can_zoom)
				{

					gwx=((int)p[s].x)-ZHWIDTH;
					gwy=((int)p[s].y)-ZHHEIGHT;


					draw_hud=s;	//player "s"
					set_clip(apage, p[s].view_x, p[s].view_y, p[s].view_x+p[s].view_w, p[s].view_y+p[s].view_h);
		
					draw_room_zoomed(apage, p[s].view_x, p[s].view_y, gwx, gwy, p[s].view_w, p[s].view_h);
					rect(apage, p[s].view_x, p[s].view_y, p[s].view_x+p[s].view_w, p[s].view_y+p[s].view_h, WHITE);




					//clear_to_color(zpage, bg);
					//
					//gwx=((int)p[s].x)-ZHWIDTH;
					//gwy=((int)p[s].y)-ZHHEIGHT;
					//
					//draw_hud=s;	//player "s"
					//draw_room(zpage, 0, 0, gwx, gwy, ZWIDTH, ZHEIGHT);
					//
					//
					//set_clip(apage, p[s].view_x, p[s].view_y, p[s].view_x+p[s].view_w, p[s].view_y+p[s].view_h);					
					//stretch_blit(zpage, apage, 0, 0, ZWIDTH, ZHEIGHT, p[s].view_x, p[s].view_y, p[s].view_w, p[s].view_h);
					//rect(apage, p[s].view_x, p[s].view_y, p[s].view_x+p[s].view_w, p[s].view_y+p[s].view_h, WHITE);
				}
				else
				{
					gwx=((int)p[s].x)-p[s].view_wh;
					gwy=((int)p[s].y)-p[s].view_hh;


					draw_hud=s;	//player "s"
					set_clip(apage, p[s].view_x, p[s].view_y, p[s].view_x+p[s].view_w, p[s].view_y+p[s].view_h);
		
					draw_room(apage, p[s].view_x, p[s].view_y, gwx, gwy, p[s].view_w, p[s].view_h);
					rect(apage, p[s].view_x, p[s].view_y, p[s].view_x+p[s].view_w, p[s].view_y+p[s].view_h, WHITE);
				}

			}
		}
		set_clip(apage, 0, 0, 639, 479);

		if (PLAYING==3)
		{
			rect(apage, 320, 240, 639, 479, WHITE);
		}

		if (MAP_VBAR)
		{
			vline(apage, 319, dm2_y1, dm2_y2, bg);
			vline(apage, 320, dm2_y1, dm2_y2, bg);
		}

		if (MAP_HBAR)
		{
			hline(apage, dm2_x1, 239, dm2_x2, bg);
			hline(apage, dm2_x1, 240, dm2_x2, bg);
		}


		if (CHAIN_DEBUGGER){debug_msg("7");}
		draw_map2(apage);

		if (CHAIN_DEBUGGER){debug_msg("8");}

		//if (PLAYING==1)
		//{
		//	display_time(apage, 320, 50, ticks);
		//}
		//else

		if (PLAYING==3)
		{
			display_time(apage, 480, 250, ticks);
		}
		else
		{
			//display_time(apage, 320, 10, ticks);
			display_time(apage, 320, 50, ticks);
		}

		if (CHAIN_DEBUGGER){debug_msg("9");}

		for (int i=0; i<4; i++)
		{
			if (p[i].playing)
			{
				physics(i);
			}
		}

		if (CHAIN_DEBUGGER){debug_msg("A");}

		if (VSYNC)
		{
			vsync();
		}
		blit(apage,screen,0,0,0,0,VIDEO_WIDTH, VIDEO_HEIGHT);
		if (LIMIT_FPS)
		{
			while(!timer_var);
			timer_var=FALSE;
		}		
		frames++;
		blinky++;
		if (blinky>30){blinky=0;}
		ticks--;

		if (ticks<0)
		{
			ok=FALSE;
		}

		for (int i=0; i<4; i++)
		{
			if (p[i].playing)
			{
				if (p[i].checks>=check_points)
				{
					ok=FALSE;
				}
			}
		}
		

		if (key[KEY_ESC])
		{
			while (key[KEY_ESC]);
			if (game_paused())
			{
				ok=FALSE;
			}
			while (key[KEY_ESC]);
		}
	}
	play_sound(9);


	show_endgame_screen();

	jp_enabled=FALSE;
}

void physics(int i)
{
	int bump_sound=FALSE;

	p[i].speed=.5+(p[i].speed_ups*.1);

	float old=p[i].x;

	p[i].x+=p[i].vx;
	if (map_collision(p[i].mask, (int)p[i].x, (int)p[i].y))
	{
		p[i].x=old;

		float c=1;
		if (p[i].vx<0){c=-1;}
		
		while (!(map_collision(p[i].mask, (int)p[i].x, (int)p[i].y)))
		{
			old=p[i].x;
			p[i].x+=c;
		}
		p[i].x=old;
		p[i].vx*=-.9;

		bump_sound=TRUE;
	}

	old=p[i].y;

	p[i].y+=p[i].vy;
	if (map_collision(p[i].mask, (int)p[i].x, (int)p[i].y))
	{
		p[i].y=old;

		float c=1;
		if (p[i].vy<0){c=-1;}
		
		while (!(map_collision(p[i].mask, (int)p[i].x, (int)p[i].y)))
		{
			old=p[i].y;
			p[i].y+=c;
		}
		p[i].y=old;
		p[i].vy*=-.9;
		bump_sound=TRUE;
	}

	if (bump_sound)
	{play_sound(0);}

	p[i].dir+=p[i].vdir;

	while (p[i].dir>256)
	{
		p[i].dir-=256;
	}

	while (p[i].dir<0)
	{
		p[i].dir+=256;
	}

	p[i].vx*=.97;
	p[i].vy*=.97;
	p[i].vdir*=.83;

	if (ctrl_flag[i] & FFR)
	{
		if (p[i].item==9)
		{
			p[i].shoot_rate=2;
		}
		else
		{
			p[i].shoot_rate=7;
		}

		if (p[i].shoot_cntr>p[i].shoot_rate)
		{

			if (p[i].item==10)
			{
				for (float a=0; a<256; a+=10)
				{
					add_bubble(i, (p[i].x+(p[i].bmp->w/2))-(bub_bmp[0]->w/2), (p[i].y+(p[i].bmp->h/2))-(bub_bmp[0]->h/2), a, 0);
				}

				for (float a=0; a<256; a+=48)
				{
					add_bubble(i, (p[i].x+(p[i].bmp->w/2))-(bub_bmp[0]->w/2), (p[i].y+(p[i].bmp->h/2))-(bub_bmp[0]->h/2), a, 1);
				}

				p[i].item_amt-=10;
				if (p[i].item_amt<10)
				{
					p[i].item_amt=0;
					p[i].item=0;
				}
			}
			else if (p[i].item==8)
			{
				for (int m=0; m<5; m++)
				{
					float d=rand()%10;
					float x=rand()%10;
					float y=rand()%10;
					if (rand()%2){d*=-1;}
					if (rand()%2){x*=-1;}
					if (rand()%2){y*=-1;}

					add_bubble(i, x+(p[i].x+(p[i].bmp->w/2))-(bub_bmp[0]->w/2), y+(p[i].y+(p[i].bmp->h/2))-(bub_bmp[0]->h/2), p[i].dir+d, 1);
				}

				for (int m=0; m<7; m++)
				{
					float d=rand()%10;
					float x=rand()%10;
					float y=rand()%10;
					if (rand()%2){d*=-1;}
					if (rand()%2){x*=-1;}
					if (rand()%2){y*=-1;}
					if (rand()%2){d*=-1;}

					add_bubble(i, x+(p[i].x+(p[i].bmp->w/2))-(bub_bmp[0]->w/2), y+(p[i].y+(p[i].bmp->h/2))-(bub_bmp[0]->h/2), p[i].dir+d, 0);
				}

				p[i].item_amt-=10;
				if (p[i].item_amt<10)
				{
					p[i].item_amt=0;
					p[i].item=0;
				}
			}
			else
			{

				add_bubble(i, (p[i].x+(p[i].bmp->w/2))-(bub_bmp[0]->w/2), (p[i].y+(p[i].bmp->h/2))-(bub_bmp[0]->h/2), p[i].dir, 0);


				if (p[i].item==9)
				{
					p[i].item_amt--;
					if (p[i].item_amt<1)
					{
						p[i].item_amt=0;
						p[i].item=0;
					}
				}
			}
			p[i].shoot_cntr=0;
		}
	}
	p[i].shoot_cntr++;

	if (ctrl_flag[i] & FUP)
	{
		p[i].vx+=X_LOOK[(int)(p[i].dir)]*p[i].speed;
		p[i].vy+=Y_LOOK[(int)(p[i].dir)]*p[i].speed;
	}

	if (ctrl_flag[i] & FLF)
	{
		p[i].vdir-=.35;
		p[i].vdir-=p[i].speed_ups*.15;
	}

	if (ctrl_flag[i] & FRT)
	{
		p[i].vdir+=.35;
		p[i].vdir+=p[i].speed_ups*.15;
	}

	if (ctrl_flag[i] & FDN)
	{
		p[i].vx*=.7;
		p[i].vy*=.7;
		p[i].vdir*=.7;
	}

	for (int xyz=0; xyz<4; xyz++)
	{
		if (xyz!=i && p[xyz].playing)
		{
			if (check_pmask_collision(p[i].mask, p[xyz].mask, (int)p[i].x, (int)p[i].y, (int)p[xyz].x, (int)p[xyz].y))
			{
				float x=p[xyz].x-p[i].x;
				float y=p[xyz].y-p[i].y;

				x*=.1;
				y*=.1;

				p[i].vx-=x;
				p[i].vy-=y;

				p[xyz].vx+=x;
				p[xyz].vy+=y;

				float z=.33+((rand()%3)/2);
				if (rand()%2){z*=-1;}
		
				p[i].vdir+=z;
				p[xyz].vdir+=z;

				play_sound(0);
			}
		}
	}

}

int get_wflag(int x, int y)
{
	if (x>0 && y>0 && x<world_width && y<world_height)
	{
		return(wflag[x][y]);
	}
	return(0);
}

int get_world(int x, int y)
{
	if (x>0 && y>0 && x<world_width && y<world_height)
	{
		return(world[x][y]);
	}
	return(0);
}

///////  ///////  ///////

char map_collision(PMASK * p, int x, int y)
{
	int tx=x/32;
	int ty=y/32;
	int x1=0;
	int y1=0;
	int t=0;


	for (int i=-1; i<3; i++)
	{
		for (int j=-1; j<3; j++)
		{
			x1=(tx+i);
			y1=(ty+j);
			t=get_wflag_tile(x1,y1);

			if (t!=0)
			{
				t=get_world_tile(x1,y1);
				x1*=32;
				y1*=32;

				if (bound_coll(x1,y1,x1+31, y1+31, x, y, x+p->w, y+p->h))
				{
					if (check_pmask_collision(p, mtiles[t], x, y, x1,y1))
					{
						return(TRUE);
					}
				}
			}

		}
	}

	return(FALSE);
}

///////  ///////  ///////

char map_collision2(int x, int y, int aw, int ah)
{
	int tx=x/32;
	int ty=y/32;
	int x1=0;
	int y1=0;
	int t=0;


	for (int i=-1; i<3; i++)
	{
		for (int j=-1; j<3; j++)
		{
			x1=(tx+i);
			y1=(ty+j);
			t=get_wflag_tile(x1,y1);

			if (t!=0)
			{
				t=get_world_tile(x1,y1);
				x1*=32;
				y1*=32;

				if (bound_coll(x1,y1,x1+31, y1+31, x, y, x+aw, y+ah))
				{
					return(TRUE);
				}
			}

		}
	}

	return(FALSE);
}

///////  ///////  ///////
	
char bound_coll(int ax1, int ay1, int ax2, int ay2,
		int bx1, int by1, int bx2, int by2)
{
	if (ax2<bx1){return(FALSE);}
	if (bx2<ax1){return(FALSE);}
	if (ay2<by1){return(FALSE);}
	if (by2<ay1){return(FALSE);}	

	return(TRUE);
}

///////  ///////  ///////

void display_time(BITMAP * bmp, int x, int y, int t)
{
	static int md=DESIRED_FPS*60;	//minute divisor
	static int danger=DESIRED_FPS*30;
	
	int minutes=t/md;
	float seconds=(t%md);
	seconds/=md;
	seconds*=60;
	char buffer[20];

	sprintf(buffer,"%d:%0.2d",minutes, (int)seconds);

	int clr=WHITE;
	if (t==danger)
	{
		play_sound(7);
	}

	if (t<danger)
	{
		if ((blinky/15)%2)
		{
			clr=RED;
			//probably play a beep sound here too
		}

		if (blinky==17){play_sound(6);}
	}


	for (int i=-1; i<2; i++)
	{
		for (int j=-1; j<2; j++)
		{
			if (i || j)
			{
				textout_centre(bmp, big_font, buffer, x+i, y+j, BLACK);
			}
		}
	}

	textout_centre(bmp, big_font, buffer, x, y, clr);
}

///////  ///////  ///////

void handle_powerups(void)
{
	int amt=0;

	for (int i=4; i<max_powerups+4; i++)
	{
		if (pwr[i].life>0)
		{
			amt++;
		}
	}
	
	while (amt<max_powerups)
	{
		add_powerup();
		amt++;			//add 1 to amt even if add_powerup fails... otherwise infinite loop...
	}

	for (int i=0; i<4; i++)
	{
		if (p[i].playing)
		{
			pwr[i].life=powerup_danger+10;
		}
		else
		{
			pwr[i].life=0;
		}
	}

}

///////  ///////  ///////

void add_powerup(void)
{
	int p=-1;
	for (int i=4; i<max_powerups+4; i++)
	{
		if (pwr[i].life<1)
		{
			p=i;
			i=max_powerups+4;
		}
	}

	if (p==-1){return;}

	pwr[p].x=rand()%world_width;
	pwr[p].y=rand()%world_height;
	while (wflag[pwr[p].x][pwr[p].y]!=0)
	{
		pwr[p].x=rand()%world_width;
		pwr[p].y=rand()%world_height;
	}
	pwr[p].x *= 32;
	pwr[p].y *= 32;

	pwr[p].type=7+rand()%8;

	pwr[p].life=10+(rand()%50);
	pwr[p].life *= DESIRED_FPS;
}

///////  ///////  ///////

void give_powerup(int plr, int n)
{
	if (n<4)
	{
		if (n!=plr){return;}
		spawn_flag(n);
		p[n].checks++;
		play_sound(4);
	}
	else
	{
		pwr[n].life=0;

		if (pwr[n].type==7)
		{
			for (int xyz=0; xyz<4; xyz++)
			{
				if (xyz!=plr && p[xyz].playing)
				{
					p[xyz].confused+=450;
					if (p[xyz].confused>900)
					{
						p[xyz].confused=900;
					}
				}
			}

			play_sound(2);
		}
		else if (pwr[n].type==11)
		{
			for (int xyz=0; xyz<4; xyz++)
			{
				if (xyz!=plr && p[xyz].playing)
				{
					p[xyz].speed_ups--;
					if (p[xyz].speed_ups<0)
					{
						p[xyz].speed_ups=0;
					}
				}
			}
			play_sound(4);
		}
		else if (pwr[n].type==12)
		{
			p[plr].speed_ups++;
			if (p[plr].speed_ups>3)
			{
				p[plr].speed_ups=3;
			}
			play_sound(4);
		}
		else if (pwr[n].type==13)
		{
			if (PLAYING<2){return;}

			int j=get_next_player(TRUE);
			for (int i=1; i<PLAYING;i++)
			{
				int k=get_next_player(FALSE);
				SWAP(p[j].x, p[k].x);
				SWAP(p[j].y, p[k].y);
				SWAP(p[j].dir, p[k].dir);

				SWAP(p[j].vx, p[k].vx);
				SWAP(p[j].vy, p[k].vy);
				SWAP(p[j].vdir, p[k].vdir);

				j=k;
			}
			play_sound(5);
		}
		else if (pwr[n].type==14)
		{
			play_sound(8);	//cow.wav

			attack_with_cows(plr);
		}
		else
		{
			p[plr].item=pwr[n].type;
			play_sound(4);

			if (pwr[n].type==8)
			{
				p[plr].item_amt=50;
			}

			if (pwr[n].type==9)
			{
				p[plr].item_amt=90;
			}

			if (pwr[n].type==10)
			{
				p[plr].item_amt=50;
			}
		}
	}
}

///////  ///////  ///////

void spawn_flag(int n)
{
	pwr[n].x=rand()%world_width;
	pwr[n].y=rand()%world_height;

	while (wflag[pwr[n].x][pwr[n].y]!=0)
	{
		pwr[n].x=rand()%world_width;
		pwr[n].y=rand()%world_height;
	}
	pwr[n].x *= 32;
	pwr[n].y *= 32;

	pwr[n].type=3+n;
	pwr[n].life=powerup_danger+10;
}

///////  ///////  ///////

void handle_cows(void)
{
	int amt=0;

	for (int i=0; i<max_cows; i++)
	{
		if (cows[i].life>0)	
		{

			//now they dont get stuck in the walls...
			if (map_collision(cow_mask, (int)cows[i].x, (int)cows[i].y))
			{
				cows[i].life=0;
			}


			if (cows[i].life>0)
			{

				amt++;
	
				float old=cows[i].x;

				cows[i].x+=cows[i].vx;
				if (map_collision(cow_mask, (int)cows[i].x, (int)cows[i].y))
				{
					cows[i].x=old;

					float c=1;
					if (cows[i].vx<0){c=-1;}
		
					while (!(map_collision(cow_mask, (int)cows[i].x, (int)cows[i].y)))
					{
						old=cows[i].x;
						cows[i].x+=c;
					}
					cows[i].x=old;
					cows[i].vx*=-1;
				}

				old=cows[i].y;

				cows[i].y+=cows[i].vy;
				if (map_collision(cow_mask, (int)cows[i].x, (int)cows[i].y))
				{
					cows[i].y=old;

					float c=1;
					if (cows[i].vy<0){c=-1;}
		
					while (!(map_collision(cow_mask, (int)cows[i].x, (int)cows[i].y)))
					{
						old=cows[i].y;
						cows[i].y+=c;
					}
					cows[i].y=old;
					cows[i].vy*=-.9;
				}

				cows[i].d+=cows[i].vd;
				while (cows[i].d>256)
				{
					cows[i].d-=256;
				}

				while (cows[i].d<0)
				{
					cows[i].d+=256;
				}

			
				for (int j=0; j<4; j++)
				{
					if (p[j].playing)
					{
						if (check_pmask_collision(p[j].mask, cow_mask, (int)p[j].x, (int)p[j].y, (int)cows[i].x, (int)cows[i].y))
						{
							float x=cows[i].x-p[j].x;
							float y=cows[i].y-p[j].y;
	
							x*=.1;
							y*=.1;

							cows[i].vx+=x;
							cows[i].vy+=y;

							p[j].vx-=(x*2);
							p[j].vy-=(y*2);

							float z=.33+((rand()%3)/2);
							if (rand()%2){z*=-1;}
		
							cows[i].vd+=z;
							p[j].vdir+=z;

							play_sound(0);
						}
					}
				}
			}
		}
	}
	
	while (amt<max_cows)
	{
		add_cow();
		amt++;		//add 1 to amt even if add_cow() fails otherwise infinite loop...
	}
}

///////  ///////  ///////

void add_cow(void)
{
	int p=-1;
	for (int i=0; i<max_cows; i++)
	{
		if (cows[i].life<1)
		{
			p=i;
			i=max_cows;
		}
	}
	if (p==-1){return;}	//out of cows

	cows[p].x=rand()%world_width;
	cows[p].y=rand()%world_height;
	while (wflag[(int)(cows[p].x)][(int)(cows[p].y)]!=0)
	{
		cows[p].x=rand()%world_width;
		cows[p].y=rand()%world_height;
	}
	cows[p].x *= 32;
	cows[p].y *= 32;
	cows[p].d=rand()%256;

	cows[p].vx = 1+rand()%10;
	cows[p].vx/=2;
	if (rand()%2){cows[p].vx*=-1;}

	cows[p].vy = 1+rand()%10;
	cows[p].vy/=2;
	if (rand()%2){cows[p].vy*=-1;}

	cows[p].vd = 1+rand()%15;
	cows[p].vd/=2;

	cows[p].life = 3;	
}

///////  ///////  ///////

void handle_bubbles(void)
{
	for (int i=0; i<max_bubbles; i++)
	{
		if (bubs[i].life>0)
		{
			bubs[i].x+=bubs[i].vx;
			bubs[i].y+=bubs[i].vy;
			bubs[i].life--;
			
			if (bubs[i].life<1 && bubs[i].type==1){break_bub(i);}

			if (map_collision(bub_mask[bubs[i].type], (int)bubs[i].x, (int)bubs[i].y))
			{
				bubs[i].life=0;
				if (bubs[i].type==1){break_bub(i);}
			}


			if (bubs[i].life)
			{
				//int j=1-bubs[i].owner;


				for (int j=0; j<4; j++)
				{
					if (p[j].playing && bubs[i].owner!=j)
					{
						if (check_pmask_collision(p[j].mask, bub_mask[bubs[i].type], (int)p[j].x, (int)p[j].y, (int)bubs[i].x, (int)bubs[i].y))
						{
							//float x=(bubs[i].x+bub_mask[bubs[i].type]->w/2)-(p[j].x+p[j].mask->w/2);
							//float y=(bubs[i].y+bub_mask[bubs[i].type]->h/2)-(p[j].y+p[j].mask->h/2);
							float x=bubs[i].vx;
							float y=bubs[i].vy;

							if (bubs[i].type)
							{	
								x*=.4;
								y*=.4;
							}
							else
							{
								x*=.2;
								y*=.2;
							}
							p[j].vx+=x;
							p[j].vy+=y;
							play_sound(0);

							float z=.33+((rand()%5)/2);
							if (rand()%2){z*=-1;}		
							p[j].vdir+=z;

							bubs[i].life=0;
							if (bubs[i].type==1){break_bub(i);}
						}
					}
				}
			}


			if (bubs[i].life)
			{
				for (int j=0; j<max_cows; j++)
				{
					if (cows[j].life>0)
					{
						if (check_pmask_collision(cow_mask, bub_mask[bubs[i].type], (int)cows[j].x, (int)cows[j].y, (int)bubs[i].x, (int)bubs[i].y))
						{
							//float x=(bubs[i].x+bub_mask[bubs[i].type]->w/2)-(cows[j].x+cow_mask->w/2);
							//float y=(bubs[i].y+bub_mask[bubs[i].type]->h/2)-(cows[j].y+cow_mask->h/2);
							float x=bubs[i].vx;
							float y=bubs[i].vy;

							if (bubs[i].type)
							{
								x*=.4;
								y*=.4;
							}
							else
							{
								x*=.2;
								y*=.2;
							}

							cows[j].vx+=x;
							cows[j].vy+=y;

							float z=.33+((rand()%5)/2);
							if (rand()%2){z*=-1;}		
							cows[j].vd+=z;

							bubs[i].life=0;
							if (bubs[i].type==1){break_bub(i);}
							cows[j].life--;
							if (cows[j].life<1)
							{play_sound(2);}
							else
							{play_sound(0);}
							j=max_cows;
						}
					}
				}
			}

		}
	}
}

///////  ///////  ///////

void add_bubble(int owner, float x, float y, float d, int type)
{
	int n=-1;
	for (int i=0; i<max_bubbles; i++)
	{
		if (bubs[i].life<1)
		{
			n=i;
			i=max_bubbles;
		}
	}

	if (n==-1){return;} //out of bubbles

	bubs[n].life=150;
	bubs[n].type=type;
	bubs[n].x=x;
	bubs[n].y=y;
	

	float d2=rand()%3;
	if (rand()%2){d2*=-1;}
	d+=d2;

	bubs[n].vx=X_LOOK[(int)d]*7;
	bubs[n].vy=Y_LOOK[(int)d]*7;
	bubs[n].owner=owner;
}

///////  ///////  ///////

void break_bub(int i)
{
	for (float a=rand()%32; a<256; a+=36)
	{
		add_bubble(1000, bubs[i].x+10-(bub_bmp[0]->w/2), bubs[i].y+10-(bub_bmp[0]->h/2), a, 0);
	}
}

///////  ///////  ///////

int game_paused(void)
{
	int l1=text_length(big_font, txt[lang][52]);
	int l2=text_length(big_font, txt[lang][53]);
	int l=l1;
	if (l<l2){l=l2;}

	l/=2;
	l+=10;
	int h=text_height(big_font)+10;

	rectfill(screen, 320-l, 240-h, 320+l, 230+(h*2), bg);
	rect(screen, 320-l, 240-h, 320+l, 230+(h*2), WHITE);

	textout_centre(screen, big_font, txt[lang][52], 320, (250-h), WHITE);
	textout_centre(screen, big_font, txt[lang][51], 320, 240, WHITE);
	textout_centre(screen, big_font, txt[lang][53], 320, 230+h, WHITE);

	while (key[KEY_ENTER]);
	while (key[KEY_ESC]);

	while (TRUE)
	{

		if (key[KEY_ENTER])
		{
			while (key[KEY_ENTER]);
			return(0);
		}

		if (key[KEY_ESC])
		{
			while (key[KEY_ESC]);
			return(1);
		}


	}

	return(0);
}

///////  ///////  ///////

void show_endgame_screen(void)
{
	play_midi(midi[0], TRUE);


	//54=winner, 55=loser
	
	int wx=160;
	int lx=480;
	int wc=BLUE;
	int lc=RED;

	int wait=DESIRED_FPS*3;

	if (p[1].checks>p[0].checks)
	{
		wx=480;
		lx=160;
	}

	//if (p[1].checks==p[0].checks)
	//{
	//	textout_centre_bold(apage, big_font, txt[lang][56], wx, 100-text_height(big_font)/2, wc, BLACK);
	//	textout_centre_bold(apage, big_font, txt[lang][56], lx, 100-text_height(big_font)/2, wc, BLACK);
	//
	//}
	//else
	//{
	//	textout_centre_bold(apage, big_font, txt[lang][54], wx, 100-text_height(big_font)/2, wc, BLACK);
	//	textout_centre_bold(apage, big_font, txt[lang][55], lx, 100-text_height(big_font)/2, lc, BLACK);
	//}


	for (int i=0; i<4; i++)
	{
		if (p[i].playing)
		{

			draw_sprite(apage, btiles[3+i], p[i].view_x+(p[i].view_w/2)-50, p[i].view_y+(p[i].view_h/2)-20);
			textprintf(apage, big_font, p[i].view_x+(p[i].view_w/2)-13, p[i].view_y+(p[i].view_h/2)-20, WHITE, "x %d", p[i].checks);
		}
	}

	while ((!key[KEY_ENTER] && !key[KEY_ESC]) || (wait>0))
	{
		wait--;
		if (wait<0)
		{
			textout_centre_bold(apage, big_font, txt[lang][51], 320, 400, WHITE, BLACK);
		}

		vsync();
		blit(apage,screen,0,0,0,0,VIDEO_WIDTH, VIDEO_HEIGHT);
		while(!timer_var);
		timer_var=FALSE;
		blinky++;
		if (blinky>30){blinky=0;}
	}

	while (key[KEY_ENTER]);
	while (key[KEY_ESC]);

	int m=1+(rand()%5);
	play_midi(midi[m], FALSE);
	cur_music=m;

}

///////  ///////  ///////

void textout_centre_bold(BITMAP * bmp, FONT * f, char * m, int x, int y, int tc, int bc)
{

	for (int i=-1; i<2; i++)
	{
		for (int j=-1; j<2; j++)
		{
			if (i || j)
			{
				textout_centre(bmp, f, m, x+i, y+j, bc);
			}
		}
	}

	textout_centre(bmp, f, m, x, y, tc);
}

///////  ///////  ///////

void audio_init(void)
{
	has_sound=!install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);

	if (!has_sound)
	{
		allegro_message(allegro_error);
		sound=FALSE;
		music=FALSE;
		return;
	}
	
	max_music=0;
	max_sound=0;
	cur_music=-1;;

	for (int i=0; i<300; i++)
	{
		midi[i]=NULL;
	}
	for (int i=0; i<30; i++)
	{
		sfx[i]=NULL;
	}


	midi[0]=load_midi("midi\\hero1.mid");
	midi[1]=load_midi("midi\\calm.mid");
	midi[2]=load_midi("midi\\social.mid");
	midi[3]=load_midi("midi\\astaroth.mid");
        midi[4]=load_midi("midi\\adv.mid");
	midi[5]=load_midi("midi\\familiar.mid");
	max_music=6;

	sprintf(sfx_name[0], "sfx\\bump.wav");
	sprintf(sfx_name[1], "sfx\\confused.wav");
	sprintf(sfx_name[2], "sfx\\cow_pop.wav");
	sprintf(sfx_name[3], "sfx\\go.wav");
	sprintf(sfx_name[4], "sfx\\item.wav");
	sprintf(sfx_name[5], "sfx\\swap.wav");
	sprintf(sfx_name[6], "sfx\\tick.wav");
	sprintf(sfx_name[7], "sfx\\uh-oh.wav");
	sprintf(sfx_name[8], "sfx\\cow.wav");
	sprintf(sfx_name[9], "sfx\\alarm.wav");
	max_sound=10;

	for (int i=0; i<max_sound; i++)
	{
		sfx[i]=load_sample(sfx_name[i]);
	}

}

/////// /////// ///////

void stop_music()
{
	cur_music=-1;
	stop_midi();
	midi_pos=-1;
}

void play_music(int m)
{
	if (!(music && has_sound))
	{
		return;
	}

	if (cur_music!=m)
	{
		play_midi(midi[m], FALSE);
		cur_music=m;
	}
}

void handle_music()
{
	if (!music){return;}
	if (midi_pos>-1){return;}

	int m=1+(rand()%5);
	play_music(m);

	return;
}

/////// /////// ///////

void play_sound(int s)
{
	if (sound && has_sound)
	{
		if (sfx[s])
		{
			play_sample(sfx[s], 255, 128, 1000, FALSE);
		}
	}
}

/////// /////// ///////

char * what_char(int kp)
{
	if (kp==-1){return(" ");}

	static char this_key[20];

	for (int i=0; i<20; i++)
	{this_key[i]=0;}


	if (kp==KEY_LEFT){sprintf(this_key,"LF");return(this_key);}
	if (kp==KEY_RIGHT){sprintf(this_key,"RT");return(this_key);}
	if (kp==KEY_UP){sprintf(this_key,"UP");return(this_key);}
	if (kp==KEY_DOWN){sprintf(this_key,"DN");return(this_key);}


	if (kp==KEY_LSHIFT){sprintf(this_key,"LSHIFT");return(this_key);}
	if (kp==KEY_RSHIFT){sprintf(this_key,"RSHIFT");return(this_key);}
	if (kp==KEY_LCONTROL){sprintf(this_key,"LCTRL");return(this_key);}
	if (kp==KEY_RCONTROL){sprintf(this_key,"RCTRL");return(this_key);}
	if (kp==KEY_ALT){sprintf(this_key,"LALT");return(this_key);}
	if (kp==KEY_ALTGR){sprintf(this_key,"RALT");return(this_key);}

	if (kp==KEY_LWIN){sprintf(this_key,"LWIN");return(this_key);}
	if (kp==KEY_RWIN){sprintf(this_key,"RWIN");return(this_key);}
	if (kp==KEY_MENU){sprintf(this_key,"MENU");return(this_key);}

	if (kp==KEY_0_PAD){sprintf(this_key,"PAD0");return(this_key);}
	if (kp==KEY_1_PAD){sprintf(this_key,"PAD1");return(this_key);}
	if (kp==KEY_2_PAD){sprintf(this_key,"PAD2");return(this_key);}
	if (kp==KEY_3_PAD){sprintf(this_key,"PAD3");return(this_key);}
	if (kp==KEY_4_PAD){sprintf(this_key,"PAD4");return(this_key);}
	if (kp==KEY_5_PAD){sprintf(this_key,"PAD5");return(this_key);}
	if (kp==KEY_6_PAD){sprintf(this_key,"PAD6");return(this_key);}
	if (kp==KEY_7_PAD){sprintf(this_key,"PAD7");return(this_key);}
	if (kp==KEY_8_PAD){sprintf(this_key,"PAD8");return(this_key);}
	if (kp==KEY_9_PAD){sprintf(this_key,"PAD9");return(this_key);}

	if (kp==KEY_0){sprintf(this_key,"0");return(this_key);}
	if (kp==KEY_1){sprintf(this_key,"1");return(this_key);}
	if (kp==KEY_2){sprintf(this_key,"2");return(this_key);}
	if (kp==KEY_3){sprintf(this_key,"3");return(this_key);}
	if (kp==KEY_4){sprintf(this_key,"4");return(this_key);}
	if (kp==KEY_5){sprintf(this_key,"5");return(this_key);}
	if (kp==KEY_6){sprintf(this_key,"6");return(this_key);}
	if (kp==KEY_7){sprintf(this_key,"7");return(this_key);}
	if (kp==KEY_8){sprintf(this_key,"8");return(this_key);}
	if (kp==KEY_9){sprintf(this_key,"9");return(this_key);}

	if (kp==KEY_A){sprintf(this_key,"A");return(this_key);}
	if (kp==KEY_B){sprintf(this_key,"B");return(this_key);}
	if (kp==KEY_C){sprintf(this_key,"C");return(this_key);}
	if (kp==KEY_D){sprintf(this_key,"D");return(this_key);}
	if (kp==KEY_E){sprintf(this_key,"E");return(this_key);}
	if (kp==KEY_F){sprintf(this_key,"F");return(this_key);}
	if (kp==KEY_G){sprintf(this_key,"G");return(this_key);}
	if (kp==KEY_H){sprintf(this_key,"H");return(this_key);}
	if (kp==KEY_I){sprintf(this_key,"I");return(this_key);}
	if (kp==KEY_J){sprintf(this_key,"J");return(this_key);}
	if (kp==KEY_K){sprintf(this_key,"K");return(this_key);}
	if (kp==KEY_L){sprintf(this_key,"L");return(this_key);}
	if (kp==KEY_M){sprintf(this_key,"M");return(this_key);}
	if (kp==KEY_N){sprintf(this_key,"N");return(this_key);}
	if (kp==KEY_O){sprintf(this_key,"O");return(this_key);}
	if (kp==KEY_P){sprintf(this_key,"P");return(this_key);}
	if (kp==KEY_Q){sprintf(this_key,"Q");return(this_key);}
	if (kp==KEY_R){sprintf(this_key,"R");return(this_key);}
	if (kp==KEY_S){sprintf(this_key,"S");return(this_key);}
	if (kp==KEY_T){sprintf(this_key,"T");return(this_key);}
	if (kp==KEY_U){sprintf(this_key,"U");return(this_key);}
	if (kp==KEY_V){sprintf(this_key,"V");return(this_key);}
	if (kp==KEY_W){sprintf(this_key,"W");return(this_key);}
	if (kp==KEY_X){sprintf(this_key,"X");return(this_key);}
	if (kp==KEY_Y){sprintf(this_key,"Y");return(this_key);}
	if (kp==KEY_Z){sprintf(this_key,"Z");return(this_key);}

	if (kp==KEY_F1){sprintf(this_key,"F1");return(this_key);}
	if (kp==KEY_F2){sprintf(this_key,"F2");return(this_key);}
	if (kp==KEY_F3){sprintf(this_key,"F3");return(this_key);}
	if (kp==KEY_F4){sprintf(this_key,"F4");return(this_key);}
	if (kp==KEY_F5){sprintf(this_key,"F5");return(this_key);}
	if (kp==KEY_F6){sprintf(this_key,"F6");return(this_key);}
	if (kp==KEY_F7){sprintf(this_key,"F7");return(this_key);}
	if (kp==KEY_F8){sprintf(this_key,"F8");return(this_key);}
	if (kp==KEY_F9){sprintf(this_key,"F9");return(this_key);}
	if (kp==KEY_F10){sprintf(this_key,"F10");return(this_key);}
	if (kp==KEY_F11){sprintf(this_key,"F11");return(this_key);}
	if (kp==KEY_F12){sprintf(this_key,"F12");return(this_key);}

	if (kp==KEY_TILDE){sprintf(this_key,"~");return(this_key);}
	if (kp==KEY_MINUS){sprintf(this_key,"-");return(this_key);}
	if (kp==KEY_EQUALS){sprintf(this_key,"+");return(this_key);}
	if (kp==KEY_BACKSPACE){sprintf(this_key,"BKSP");return(this_key);}
	if (kp==KEY_TAB){sprintf(this_key,"TAB");return(this_key);}
	if (kp==KEY_OPENBRACE){sprintf(this_key,"[");return(this_key);}
	if (kp==KEY_CLOSEBRACE){sprintf(this_key,"]");return(this_key);}
	if (kp==KEY_COLON){sprintf(this_key,":");return(this_key);}
	if (kp==KEY_QUOTE){sprintf(this_key,"%c",34);return(this_key);}
	if (kp==KEY_BACKSLASH){sprintf(this_key,"\\");return(this_key);}
	if (kp==KEY_BACKSLASH2){sprintf(this_key,"(\\)");return(this_key);}
	if (kp==KEY_COMMA){sprintf(this_key,",");return(this_key);}
	if (kp==KEY_STOP){sprintf(this_key,".");return(this_key);}
	if (kp==KEY_SLASH){sprintf(this_key,"/");return(this_key);}
	if (kp==KEY_SPACE){sprintf(this_key,"SP");return(this_key);}
	if (kp==KEY_INSERT){sprintf(this_key,"INS");return(this_key);}
	if (kp==KEY_DEL){sprintf(this_key,"DEL");return(this_key);}
	if (kp==KEY_HOME){sprintf(this_key,"HOME");return(this_key);}
	if (kp==KEY_END){sprintf(this_key,"END");return(this_key);}
	if (kp==KEY_PGUP){sprintf(this_key,"PGUP");return(this_key);}
	if (kp==KEY_PGDN){sprintf(this_key,"PGDN");return(this_key);}
	if (kp==KEY_SLASH_PAD){sprintf(this_key,"(/)");return(this_key);}
	if (kp==KEY_ASTERISK){sprintf(this_key,"(*)");return(this_key);}
	if (kp==KEY_MINUS_PAD){sprintf(this_key,"(-)");return(this_key);}
	if (kp==KEY_PLUS_PAD){sprintf(this_key,"(+)");return(this_key);}
	if (kp==KEY_DEL_PAD){sprintf(this_key,"(DEL)");return(this_key);}
	if (kp==KEY_ENTER_PAD){sprintf(this_key,"(ENTER)");return(this_key);}
	if (kp==KEY_PRTSCR){sprintf(this_key,"PTSC");return(this_key);}
	if (kp==KEY_PAUSE){sprintf(this_key,"BRK");return(this_key);}

	//strange non english windows keys?
	if (kp==KEY_ABNT_C1){sprintf(this_key,"ABNT_C1");return(this_key);}
	if (kp==KEY_YEN){sprintf(this_key,"YEN");return(this_key);}
	if (kp==KEY_KANA){sprintf(this_key,"KANA");return(this_key);}
	if (kp==KEY_CONVERT){sprintf(this_key,"CONV");return(this_key);}
	if (kp==KEY_NOCONVERT){sprintf(this_key,"NCONV");return(this_key);}
	if (kp==KEY_AT){sprintf(this_key,"@");return(this_key);}	//?
	if (kp==KEY_CIRCUMFLEX){sprintf(this_key,"CFLEX");return(this_key);}
	if (kp==KEY_COLON2){sprintf(this_key,"(:)");return(this_key);}
	if (kp==KEY_KANJI){sprintf(this_key,"KANJI");return(this_key);}


	if (kp==KEY_ESC){sprintf(this_key,"ESC");return(this_key);}
	if (kp==KEY_ENTER){sprintf(this_key,"ENTER");return(this_key);}

	if (kp==KEY_SCRLOCK){sprintf(this_key,"SCRLCK");return(this_key);}
	if (kp==KEY_NUMLOCK){sprintf(this_key,"NUMLCK");return(this_key);}
	if (kp==KEY_CAPSLOCK){sprintf(this_key,"CAPLCK");return(this_key);}

	if (kp>999)
	{
		int x=kp-1000;
		int js=x/100;
		int y=x%100;
		
		if (y<50)
		{
			int stick=y/10;

			int axis=y%10;
			
			if (axis<5)	//check for pulled low
			{
				sprintf(this_key,"J%dS%dA%d-L", js, stick, axis);
				return(this_key);

			}
			else	//check for pushed high
			{
				axis-=5;
				sprintf(this_key,"J%dS%dA%d-H", js, stick, axis);
				return(this_key);
			}

		}
		else
		{
			int btn=y-50;
			sprintf(this_key,"J%dB%d", js, btn);
			return(this_key);
		}	
	}



	return(this_key);
}

/////// /////// ///////

void install_mikes_joystick(void)
{
	if (!use_joy)
	{
		use_joy=TRUE;
		if (install_joystick(JOY_TYPE_AUTODETECT)!=0){use_joy=FALSE;}
	}
}

///////  ///////  ///////

int get_joy_fire(int p)
{
	if (!use_joy){return(FALSE);}

	if (num_joysticks<p){return(FALSE);}

	for (int i=0; i<joy[p].num_buttons; i++)
	{
		if (joy[p].button[i].b)
		{
			return(TRUE);
		}
	}
	return(FALSE);
}

int get_joy_up(int p)
{
	if (!use_joy){return(FALSE);}

	if (num_joysticks<p){return(FALSE);}

	if (joy[p].stick[0].axis[1].d1){return(TRUE);}

	return(FALSE);
}

int get_joy_dn(int p)
{
	if (!use_joy){return(FALSE);}

	if (num_joysticks<p){return(FALSE);}

	if (joy[p].stick[0].axis[1].d2){return(TRUE);}

	return(FALSE);
}

int get_joy_lf(int p)
{
	if (!use_joy){return(FALSE);}

	if (num_joysticks<p){return(FALSE);}

	if (joy[p].stick[0].axis[0].d1){return(TRUE);}

	return(FALSE);
}

int get_joy_rt(int p)
{
	if (!use_joy){return(FALSE);}

	if (num_joysticks<p){return(FALSE);}

	if (joy[p].stick[0].axis[0].d2){return(TRUE);}

	return(FALSE);
}

///////  ///////  ///////

void attack_with_cows(int nplr)
{
	int plr=get_next_player(TRUE);
	for (int i=0; i<max_cows; i++)
	{
		cows[i].x=rand()%10;
		cows[i].y=rand()%10;
		cows[i].x+=((p[plr].x/32)-5);
		cows[i].y+=((p[plr].y/32)-5);

		while (wflag[(int)(cows[i].x)][(int)(cows[i].y)]!=0)
		{
			cows[i].x=rand()%10;
			cows[i].y=rand()%10;
			cows[i].x+=((p[plr].x/32)-5);
			cows[i].y+=((p[plr].y/32)-5);
		}

		cows[i].x *= 32;
		cows[i].y *= 32;

		//end cruelty to cows and quit putting them inside concrete walls...
		/*cows[i].x-=32;
		cows[i].y-=32;
		cows[i].x+=rand()%64;
		cows[i].y+=rand()%64;*/

		cows[i].d=rand()%256;

		int d=find_angle(cows[i].x, cows[i].y, p[plr].x, p[plr].y);
		float sz=1+rand()%7;

		cows[i].vx = X_LOOK[d]*sz;
		cows[i].vy = Y_LOOK[d]*sz;

		cows[i].vd = 1+rand()%15;
		cows[i].vd/=2;

		cows[i].life = 3;


		plr=get_next_player(FALSE);
		if (plr==nplr){plr=get_next_player(FALSE);}
	}
}

///////  ///////  ///////

int find_angle(float x1, float y1, float x2, float y2)
{
  int ang=-1; //return value
  float m; //slope
   

  if (x1==x2) 
  {
	if (y1<y2) return 64; //90 degrees
	if (y2<y1) return 192; //270 degrees
        if (y2==y1) return -1; //no angle, same position
  }

  if ((y1==y2) && (x1>x2)) return 128; //180 degrees
 
  m=(y2 - y1) / (x2 - x1); //slope
  ang=round(atan(m) * PI128);
  
  if ((y1<y2) //bottom half
     && (ang<0)) {ang += 128;}
  else
  if (y1>y2) //top half
  {
	if (ang>0) {ang +=128;}
        else
	if (ang<0) {ang +=256;}
  }

  if ((ang==0) && (x2<x1)) {ang=128;}

  return ang;

}

/////// /////// ///////

void update_local_ctrl_flags(void)
{
	if (use_joy){poll_joystick();}
	short bv=0;

	for (int i=0; i<4; i++)
	{
		ctrl_flag[i]=0;

		for (int j=0; j<6; j++)
		{
			for (int k=0; k<10; k++)
			{
				if (BTN[i][j][k]<0)
				{k=10;}
				else
				{

					int bv=BTN[i][j][k];

					if (bv>999)
					{

						if (jp_enabled)
						{
							if ((joy_ptr[i][j][k]!=NULL) && (*joy_ptr[i][j][k]))
							{
								ctrl_flag[i] |=(1<<j);
								k=11;
							}
							bv=-1;
						}
					}


					if (bv !=-1 && control(bv))
					{
						ctrl_flag[i] |=(1<<j);
						k=11;
					}
				}
			}
		}
	}

	return;

}

char control(short bv)
{
	if (bv<0){return(FALSE);}

	if (bv<1000)
	{
		if (bv>KEY_MAX){return(FALSE);}
		return(key[bv]);
	}
	else if (use_joy && bv>999)
	{
		int x=bv-1000;
		int js=x/100;
		int y=x%100;
		
		if (num_joysticks<js){return(FALSE);}

		//5 sticks per pad
		//5 axes per stick
		//that can be digitally pulled low or pushed high
		if (y<50)
		{
			int stick=y/10;
			if (stick>joy[js].num_sticks){return(FALSE);}

			int axis=y%10;
			int high=FALSE;

			if (axis>4){axis-=5; high=TRUE;}
			if (axis>joy[js].stick[stick].num_axis){return(FALSE);}

			if (high)
			{
				return (joy[js].stick[stick].axis[axis].d2);

			}
			else
			{
				return (joy[js].stick[stick].axis[axis].d1);
			}


		}
		else
		{
			int btn=y-50;
			if (btn>joy[js].num_buttons){return(FALSE);}
			return (joy[js].button[btn].b);
		}
	}

	return(FALSE);
}

/////// /////// ///////

void sort_keys(void)
{
	//check for duplicates
	for (int i=0; i<4; i++)
	{
		for (int j=0; j<6; j++)
		{
			for (int k=0; k<10; k++)
			{
				for (int l=0; l<10; l++)
				{
					if (k!=l)
					{
						if (BTN[i][j][l]==BTN[i][j][k])
						{
							BTN[i][j][l]=-1;
						}
					}
				}
			}
		}

	}




	//move all keys up
	for (int i=0; i<4; i++)
	{
		for (int j=0; j<6; j++)
		{
			for (int k=0; k<10; k++)
			{
				if (BTN[i][j][k]<0)
				{
					for (int l=(k+1); l<10; l++)
					{
						if (BTN[i][j][l]>=0)
						{
							BTN[i][j][k]=BTN[i][j][l];
							BTN[i][j][l]=-1;

							l=10;
						}
					}
				}

			}
		}
	}

	return;
}

/////// /////// ///////

int whos_playing(void)
{
	set_trans_blender(0,0,0, 128);
	int pressing[4];
	for (int i=0; i<4; i++)
	{
		p[i].playing=FALSE;
		pressing[i]=FALSE;
	}


	int old_playing=0;
	PLAYING=0;
	int timer=-1000;

	while(TRUE)
	{
		clear_to_color(apage, bg);

		textout_centre(apage, big_font, txt[lang][73], 319, 50, WHITE);

		for (int i=0; i<4; i++)
		{
			int x=(128*(i+1));	//640/5=128

			if (p[i].playing)
			{
				textprintf_centre(apage, big_font, x, 145, WHITE, "[%s]", txt[lang][75]);
				rotate_sprite(apage, p[i].bmp, x-(p[i].bmp->w/2), 170, ftofix(p[i].dir));
				p[i].dir++;

				if (p[i].dir>255){p[i].dir-=255;}
				if (p[i].dir<0){p[i].dir+=255;}
			}
			else
			{
				draw_trans_sprite(apage, p[i].bmp, x-(p[i].bmp->w/2), 170);
			}
		}

		update_local_ctrl_flags();

		for (int i=0; i<4; i++)
		{
			if (!pressing[i])
			{
				if (ctrl_flag[i] & FFR)
				{
					pressing[i]=TRUE;
					p[i].playing=!p[i].playing;
				}
			}
			else
			{
				if (!(ctrl_flag[i] & FFR))
				{
					pressing[i]=FALSE;
				}
			}
		}



		if (PLAYING>0)
		{
			display_time(apage, 319, 250, timer);
			timer--;
			blinky++;
			if (blinky>30){blinky=0;}

			if (timer<1)
			{
				return(0);
			}
		}
		else
		{
			timer=(DESIRED_FPS*10)+(DESIRED_FPS/2);
		}

		textout_centre(apage, big_font, txt[lang][74], 319, 400, WHITE);
		vsync();
		blit(apage,screen,0,0,0,0,VIDEO_WIDTH, VIDEO_HEIGHT);
		while(!timer_var);
		timer_var=FALSE;


		PLAYING=0;
		for (int i=0; i<4; i++)
		{
			if (p[i].playing)
			{
				PLAYING++;
			}
		}

		if (old_playing!=PLAYING)
		{
			if (PLAYING>0)
			{
				timer=(DESIRED_FPS*10)+(DESIRED_FPS/2);
				old_playing=PLAYING;
			}

		}


		if (key[KEY_ESC]){while(key[KEY_ESC]);return(1);}

	}
}

/////// /////// ///////

void viewport_setup(void)
{
	PLAYING=0;
	for (int i=0; i<4; i++)
	{
		if (p[i].playing)
		{
			PLAYING++;
		}
	}

	
	if (PLAYING==1)
	{
		int i=get_next_player(TRUE);

		p[i].zoom=0;
		p[i].zoom_press=0;

		p[i].view_x=0;
		p[i].view_y=0;

		p[i].view_w=639;
		p[i].view_h=479;

		p[i].stats_y=5;

		//BOTTOM RIGHT
		MAP_CENTER_X=480;
		MAP_CENTER_Y=360;

		MAP_VBAR=MAP_HBAR=FALSE;


		ZWIDTH=640*2;
		ZHEIGHT=480*2;
		ZHWIDTH=640;
		ZHHEIGHT=480;
	}
	else
	if (PLAYING==2)
	{
		int i=get_next_player(TRUE);

		p[i].zoom=FALSE;
		p[i].zoom_press=FALSE;

		p[i].view_x=0;
		p[i].view_y=0;

		p[i].view_w=319;
		p[i].view_h=479;

		p[i].stats_y=5;


		i=get_next_player(FALSE);

		p[i].zoom=FALSE;
		p[i].zoom_press=FALSE;

		p[i].view_x=320;
		p[i].view_y=0;

		p[i].view_w=319;
		p[i].view_h=479;

		p[i].stats_y=5;

		//MIDDLE
		MAP_CENTER_X=320;
		MAP_CENTER_Y=240;

		MAP_VBAR=TRUE;
		MAP_HBAR=FALSE;


		ZWIDTH=640;
		ZHEIGHT=480*2;

		ZHWIDTH=320;
		ZHHEIGHT=480;

	}
	else
	if (PLAYING==3)
	{
		int i=get_next_player(TRUE);

		p[i].zoom=FALSE;
		p[i].zoom_press=FALSE;

		p[i].view_x=0;
		p[i].view_y=0;

		p[i].view_w=319;
		p[i].view_h=239;

		p[i].stats_y=5;

		i=get_next_player(FALSE);

		p[i].zoom=FALSE;
		p[i].zoom_press=FALSE;

		p[i].view_x=320;
		p[i].view_y=0;

		p[i].view_w=319;
		p[i].view_h=239;

		p[i].stats_y=5;

		i=get_next_player(FALSE);

		p[i].zoom=FALSE;
		p[i].zoom_press=FALSE;

		p[i].view_x=0;
		p[i].view_y=240;

		p[i].view_w=319;
		p[i].view_h=239;

		p[i].stats_y=p[i].view_h-(32+5);

		//BOTTOM RIGHT
		MAP_CENTER_X=480;
		MAP_CENTER_Y=360;

		MAP_VBAR=MAP_HBAR=FALSE;

		ZWIDTH=640;
		ZHEIGHT=480;

		ZHWIDTH=320;
		ZHHEIGHT=240;

	}
	else
	if (PLAYING==4)
	{
		int i=get_next_player(TRUE);

		p[i].zoom=FALSE;
		p[i].zoom_press=FALSE;

		p[i].view_x=0;
		p[i].view_y=0;

		p[i].view_w=319;
		p[i].view_h=239;

		p[i].stats_y=5;

		i=get_next_player(FALSE);

		p[i].zoom=FALSE;
		p[i].zoom_press=FALSE;

		p[i].view_x=320;
		p[i].view_y=0;

		p[i].view_w=319;
		p[i].view_h=239;

		p[i].stats_y=5;

		i=get_next_player(FALSE);

		p[i].zoom=FALSE;
		p[i].zoom_press=FALSE;

		p[i].view_x=0;
		p[i].view_y=240;

		p[i].view_w=319;
		p[i].view_h=239;

		p[i].stats_y=p[i].view_h-(32+5);

		i=get_next_player(FALSE);

		p[i].zoom=FALSE;
		p[i].zoom_press=FALSE;

		p[i].view_x=320;
		p[i].view_y=240;

		p[i].view_w=319;
		p[i].view_h=239;

		p[i].stats_y=p[i].view_h-(32+5);

		//MIDDLE
		MAP_CENTER_X=320;
		MAP_CENTER_Y=240;

		MAP_VBAR=MAP_HBAR=TRUE;

		ZWIDTH=640;
		ZHEIGHT=480;

		ZHWIDTH=320;
		ZHHEIGHT=240;
	}


	for (int i=0; i<4; i++)
	{
		if (p[i].playing)
		{
			p[i].view_wh=p[i].view_w/2;
			p[i].view_hh=p[i].view_h/2;
		}
	}

	load_halves();


}

int get_next_player(int RESET)
{
	static int y=-1;
	if (RESET){y=-1;}
	//if (RESET==2){return;}


	for (int j=0; j<2; j++)
	{
		for (int i=y+1; i<4; i++)
		{
			if (p[i].playing)
			{
				y=i;
				return(y);
			}
		}
		y=-1;
	}

	return(-1);
}

/////// /////// ///////

void assign_joy_ptr(void)
{
	jp_enabled=TRUE;

	for (int i=0; i<4; i++)
	{
		for (int j=0; j<6; j++)
		{
			for (int k=0; k<10; k++)
			{
				joy_ptr[i][j][k]=NULL;

				if (BTN[i][j][k]>999)
				{
					int x=BTN[i][j][k]-1000;
					int js=x/100;
					int y=x%100;
		
					if (y<50)
					{
						int stick=y/10;
			
						int axis=y%10;
			
						if (axis<5)	//check for pulled low
						{
							joy_ptr[i][j][k]=&joy[js].stick[stick].axis[axis].d1;

						}
						else	//check for pushed high
						{
							axis-=5;
							joy_ptr[i][j][k]=&joy[js].stick[stick].axis[axis].d2;
						}

					}
					else
					{
						int btn=y-50;
						joy_ptr[i][j][k]=&joy[js].button[btn].b;
					}	



				}
			}
		}
	}

}

/////// /////// ///////

void nullify_halves(void)
{
	for (int i=0; i<4; i++)
	{
		half_bumper_bmp[i]=NULL;
	}


	for (int i=0; i<2; i++)
	{
		half_bub_bmp[i]=NULL;
	}

	half_cow=NULL;
	half_arrow=NULL;

	for (int i=0; i<MAX_TILES; i++)
	{
		half_btiles[i]=NULL;
	}

	half_tileset=NULL;

	return;
}

/////// /////// ///////

void load_halves(void)
{

	if (half_bumper_bmp[0]==NULL)
	{half_bumper_bmp[0]=load_bitmap2("gfx\\p1h.pcx");}

	if (half_bumper_bmp[1]==NULL)
	{half_bumper_bmp[1]=load_bitmap2("gfx\\p2h.pcx");}

	if (half_bumper_bmp[2]==NULL)
	{half_bumper_bmp[2]=load_bitmap2("gfx\\p3h.pcx");}

	if (half_bumper_bmp[3]==NULL)
	{half_bumper_bmp[3]=load_bitmap2("gfx\\p4h.pcx");}



	if (half_bub_bmp[0]==NULL)
	{half_bub_bmp[0]=load_bitmap2("gfx\\bub1h.pcx");}

	if (half_bub_bmp[1]==NULL)
	{half_bub_bmp[1]=load_bitmap2("gfx\\bubble1.pcx");}


	if (half_cow==NULL)
	{half_cow=load_bitmap2("gfx\\cow1h.pcx");}

	if (half_arrow==NULL)
	{half_arrow=load_bitmap2("gfx\\arrow1h.pcx");}

	if (half_tileset==NULL)
	{
		half_tileset=load_bitmap2("gfx\\tilesh.pcx");
		import_tileset2(half_tileset, 16, 16);
	}

	return;
}

/////// /////// ///////

void import_tileset2(BITMAP * in, int sz_x, int sz_y)
{
	if (!in){return;}

	int x=0;
	int y=0;
	for (int i=0; i<MAX_TILES; i++)
	{
		x=i*sz_x;
		while (x>in->w)
		{
			x-=in->w;
			y+=sz_y;
		}

		if (y<in->h)
		{
			half_btiles[i]=create_bitmap(sz_x,sz_y);
			if (btiles[i])
			{
				blit(in, half_btiles[i], x, y, 0, 0, sz_x, sz_y);
			}

		}

	}
	return;
}

///////  ///////  ///////

void draw_room_zoomed(BITMAP * bmp, int pos_x, int pos_y, int x1, int y1, int w, int h)
{
	static int half_text=text_height(big_font)/2;

	int x=x1/32;
	int y=y1/32;
	int vx=x1%32;
	int vy=y1%32;

	vx/=2;
	vy/=2;

	int tw=(w/16)+2;
	int th=(h/16)+2;

	int t=0;
	int px=-vx;
	int py=-vy;
	for (int i=0; i<tw; i++)
	{
		py=-vy;
		for (int j=0; j<th; j++)
		{
			t=get_world_tile(i+x, j+y);

			if (t>0)
			{
				masked_blit(half_btiles[t], bmp, 0, 0, px+pos_x, py+pos_y, 16, 16);
			}

			py+=16;
		}
		px+=16;
	}


	for (int i=0; i<max_powerups+4; i++)
	{
		if (pwr[i].life>0)
		{
			if (pwr[i].life<powerup_danger)
			{
				if ((pwr[i].life/10)%2)//((blinky/15)%2)
				{
					draw_trans_sprite(bmp, half_btiles[pwr[i].type], pos_x+(pwr[i].x-x1)/2, pos_y+(pwr[i].y-y1)/2);
				}
			}
			else
			{
				draw_sprite(bmp, half_btiles[pwr[i].type], pos_x+(pwr[i].x-x1)/2, pos_y+(pwr[i].y-y1)/2);
			}
		}
	}

	for (int i=0; i<max_cows; i++)
	{
		if (cows[i].life>0)
		{
			rotate_sprite(bmp, half_cow, (int)(pos_x+(cows[i].x-x1)/2), (int)(pos_y+(cows[i].y-y1)/2), ftofix(cows[i].d));
		}
	}

	for (int i=0; i<max_bubbles; i++)
	{
		if (bubs[i].life>0)
		{
			draw_sprite(bmp, half_bub_bmp[bubs[i].type], pos_x+(int)(bubs[i].x-x1)/2, pos_y+(int)(bubs[i].y-y1)/2);
		}
	}


	for (int i=0; i<4; i++)
	{
		if (p[i].playing)
		{
			if (draw_hud==i)
			{
				float x=(pos_x+(p[i].x-x1)/2);
				float y=(pos_y+(p[i].y-y1)/2);
				rotate_sprite(bmp, half_bumper_bmp[i], (int)x, (int)y, ftofix(p[i].dir));
	
				if ((blinky/15)%2)
				{
					x+=(half_bumper_bmp[i]->w/2)+X_LOOK[(int)p[i].dir]*16;
					y+=(half_bumper_bmp[i]->h/2)+Y_LOOK[(int)p[i].dir]*16;

					rotate_sprite(bmp, half_arrow, (int)x-(arrow->w/2), (int)y-(arrow->h/2), ftofix(p[i].dir));
				}

				//if (p[i].checks>0)
				//{
					draw_trans_sprite(bmp, btiles[3+i], pos_x+5, pos_y+p[i].stats_y);
					textprintf(bmp, big_font, pos_x+42, pos_y+p[i].stats_y+2, WHITE, "x %d", check_points-p[i].checks);
				//}
		
				if (p[i].confused>0)
				{
					for (int xyz=0; xyz<3; xyz++)
					{
						textout_centre_bold(bmp, font, "?", (int)(pos_x+(p[i].x-x1)/2)+(-10+(rand()%20))+half_bumper_bmp[i]->w/2, (int)((pos_y+(p[i].y-y1)/2)-(10+half_text))+(rand()%20)+half_bumper_bmp[i]->h/2, BLUE, WHITE);
					}

					p[i].item=0;
					p[i].item_amt=0;

					draw_trans_sprite(bmp, btiles[7], (pos_x+(w/2))-btiles[7]->w/2, pos_y+p[i].stats_y);
					textprintf(bmp, big_font, ((pos_x+(w/2))-btiles[7]->w/2)+37, pos_y+p[i].stats_y+2, WHITE, ": %d", p[i].confused/DESIRED_FPS);

					p[i].confused--;

					if (p[i].confused>300)
					{
						float ax, ay, ad;
						ax=(rand()%5)/2;
						ay=(rand()%5)/2;
						ad=(rand()%5)/10;

						if (rand()%2){ax*=-1;}
						if (rand()%2){ay*=-1;}

						p[i].vx+=ax;
						p[i].vy+=ay;
						p[i].vdir+=ad;

						while (p[i].dir>256)
						{
							p[i].dir-=256;
						}

						while (p[i].dir<0)
						{
							p[i].dir+=256;
						}

					}
				}
				else if (p[i].item>1)
				{
					draw_trans_sprite(bmp, btiles[p[i].item], (pos_x+(w/2))-btiles[p[i].item]->w/2, pos_y+p[i].stats_y);
					if (p[i].item_amt>0)
					{
						textprintf(bmp, big_font, ((pos_x+(w/2))-btiles[p[i].item]->w/2)+37, pos_y+p[i].stats_y+2, WHITE, "x %d", p[i].item_amt/10);
					}
				}

				if (p[i].speed_ups>0)
				{
					int x=(pos_x+w)-(5+32);
					for (int k=0; k<p[i].speed_ups; k++)
					{
						draw_trans_sprite(bmp, btiles[12], x, pos_y+p[i].stats_y);
						x-=32;
					}
				}
			
			}
			else
			{
				rotate_sprite(bmp, half_bumper_bmp[i], (int)(pos_x+(p[i].x-x1)/2), (int)(pos_y+(p[i].y-y1)/2), ftofix(p[i].dir));
				if (p[i].confused)
				{
					for (int xyz=0; xyz<3; xyz++)
					{
						textout_centre_bold(bmp, font, "?", (int)(pos_x+(p[i].x-x1)/2)+(-10+(rand()%20))+half_bumper_bmp[i]->w/2, (int)((pos_y+(p[i].y-y1)/2)-(10+half_text))+(rand()%20)+half_bumper_bmp[i]->h/2, BLUE, WHITE);
					}
				}
			}
		}
	}

}

///////  ///////  ///////
