// variable.h - Global variables
#include "list.h"
#include <fstream.h>

// Useful piece of code to avoid redefining variables
#ifdef local
#define DECLARE
#else 
#define DECLARE extern
#endif

#define DOUBLE_BUFFER 0
#define PAGE_FLIP 1

DECLARE int depth; // Choose colour depth

DECLARE char path[255]; // Path for user datafile
DECLARE char level_name[255]; // Level name
DECLARE int no_of_balls; // No of active on-screen balls
DECLARE int no_of_powerups; // Powerups on-screen

// Read from datafile
DECLARE int no_of_lives; 
DECLARE int paddle_x,paddle_y,paddle_speed;
DECLARE int ball_speed_x,ball_speed_y;
DECLARE int paddle_size,ball_size;
DECLARE int no_of_bricks;
DECLARE int break_bricks;

DECLARE char levelname[30];
DECLARE char level_list[10][50];
	
// Temp. info about bricks (from *.brk)
DECLARE struct Temp
{
	int x,y;
	int w,h;
	int pos,score;
	int powerup;
	int hits;
	char name[20];
}temp;

// Info about each powerup - used to apply powerups
DECLARE struct POWERUP_INFO
{
	int datafile; // User datafile(1) / Default(0)
	char name[30]; // Name of powerup bitmap in datafile
	int no;		   // Number assigned to powerup
	int time;	   // Time limit for the powerup
	char text[30];	// Text info for powerup
	int paddle_size; // Effect of powerup
	int paddle_speed;
	int ball_size;
	int ball_speed;
	int no_of_balls;

	int extra_life; // Certain settings which are On/off
	int next_level;
	int invert_keys; // Doubtful - highly annoying
	int laser;
	int sticky_ball;
	int power_ball;
}powerup_info[99];

// Game bitmaps (can be replaced by user bitmaps using the level editor)
DECLARE BITMAP *ball_small,*ball_medium,*ball_large;
DECLARE BITMAP *paddle_small,*paddle_medium,*paddle_large;
DECLARE BITMAP *background;
DECLARE BITMAP *ui;
DECLARE BITMAP *brick_bitmap;
DECLARE MIDI *music;
DECLARE BITMAP *laser_bmp;

DECLARE BITMAP *buffer;
DECLARE BITMAP *page1;
DECLARE BITMAP *page2;

DECLARE DATAFILE *user_datafile;
DECLARE DATAFILE *def;
DECLARE DATAFILE *data;

// Iterator,lists for the sprites
DECLARE list<Brick *> spr_list;
DECLARE list<Brick *>::iterator spr;
DECLARE list<Ball *> ball_list;
DECLARE list<Ball *>::iterator ball_spr;
DECLARE list<Ball *>::iterator ball_spr1;
DECLARE Paddle *paddle;
DECLARE Powerup *current;
DECLARE list<Powerup *> powerup_list;
DECLARE list<Powerup *>::iterator powerup_spr;
DECLARE Laser *laser;
DECLARE list<FadeBrick *> fade_list;
DECLARE list<FadeBrick *>::iterator fade_spr;

// Game State flags
DECLARE bool remove_flag;
DECLARE bool current_flag;
DECLARE bool quitit;
DECLARE int i;
DECLARE int result;
DECLARE bool life_lost;
DECLARE bool level_flag;
DECLARE bool laser_flag;
DECLARE bool sticky_ball_flag;
DECLARE bool active_laser;
DECLARE bool power_ball_flag;
DECLARE int gametype;
DECLARE bool quitmenu;
DECLARE bool page_flip;
DECLARE int bg_flag;
DECLARE int page_flip_flag;
DECLARE int vsync_flag;
DECLARE int controller;
DECLARE bool right,left;
DECLARE	int mx;	


// Used for maintaining game time
DECLARE unsigned int score1;
DECLARE volatile int game_time;
DECLARE volatile int intro_time;
DECLARE volatile int last_time;
DECLARE volatile int speed_counter;
DECLARE volatile int temp_counter;
DECLARE volatile int temp_game;
DECLARE volatile int frame_count;
DECLARE volatile int fps;
DECLARE volatile int powerup_time;

// Loader variables
DECLARE fstream level;
DECLARE int ball_datafile,paddle_datafile,bg_datafile,ui_datafile,music_datafile;
DECLARE char ball_small_n[30],ball_medium_n[30],ball_large_n[30];
DECLARE char paddle_small_n[30],paddle_medium_n[30],paddle_large_n[30];
DECLARE char bg_name[30], ui_name[30], music_name[30];

//High Score Structure (Top 10 scores)
DECLARE struct SCORES
{
	char name[30];
	int score;
}scores[11];

DECLARE fstream high;
DECLARE char name_s[30];
DECLARE bool last_level,lose;