// sprite.h - defines classes for each type of game object

#include "game.h"

class Sprite
{
public:
	Sprite () {};
	Sprite (const Sprite&) {};
	virtual void HandleSprite() = 0;
	virtual void DrawSprite() = 0;
	virtual ~Sprite() {};

protected:
};

class Powerup
{
friend class Brick;
friend void DrawUI();
public:
	Powerup(DATAFILE *d,int type1,int powerupx,int powerupy);
	Powerup (const Powerup &) {};
        ~Powerup() {TRACE("\nPowerup:%d",type); destroy_bitmap (bmp); TRACE("\nPowerup Destructor invoked");};

	void HandleSprite();
	void DrawSprite();
	friend void InactivatePowerups();
	friend void ActivatePowerups(int index);

protected:
	UINT type;
	int x,y,w,h;
	int speedx,speedy;
	BITMAP *bmp;
	volatile int time;
	char text[30];
};

class Brick: public Sprite
{
	friend class Powerup;
	friend class Ball;
	friend class Laser;
	friend void RandomGame();
public:
	Brick(int ,int ,int ,int ,int ,int ,int , BITMAP *);
	Brick (const Brick&) {};
	~Brick() { destroy_bitmap (bmp); TRACE("\nBrick destructor invoked");};

	void HandleSprite();
	void DrawSprite();
	
protected:
	int x,y,hits,w,h;
	BITMAP *bmp;
	int type;
	int collide;
	int score;
	bool unbreak;
};

class Ball: public Sprite
{
friend class Paddle;
friend class Powerup;
friend class Brick;

public:
	Ball (int ballx,int bally,int ballspeed);
	
	Ball (const Ball &);
	virtual ~Ball() { destroy_bitmap(bmp); 	TRACE("\nBall destructor invoked");};

	void HandleSprite();
	void DrawSprite();
	friend void InactivatePowerups();
	friend void ActivatePowerups(int index);
	friend void HandleBalls();

protected:
	int speedx,speedy;
	int x,y,w,h;
	BITMAP *bmp;
};

class Paddle: public Sprite
{
	friend class Powerup;
	friend class Ball;
	friend void InactivatePowerups();
	friend void ActivatePowerups(int index);
	friend void HandleBalls();

public:
	Paddle(int paddlex,int paddley,int padspeed);
	Paddle (const Paddle &);
	virtual ~Paddle() { if (bmp) destroy_bitmap(bmp); 	TRACE("\nPaddle Destructor invoked"); };

	void GetInput();
	void HandleSprite();
	void DrawSprite();
	
protected:
	int size;
	int x,y,w,h;
	BITMAP *bmp;
	int speedx;
};

class Laser
{
friend void InactivatePowerups();
friend void ActivatePowerups(int index);

public:
	Laser(int laser_x,int laser_y);
	virtual ~Laser() { destroy_bitmap(bmp); TRACE("\nLaser destructor invoked"); };

	void HandleSprite();
	void DrawSprite();

protected:
	int x,y;
	int w,h;
	BITMAP *bmp;
	int speed;
};

// The fading bricks
class FadeBrick
{
public:
	FadeBrick(BITMAP *bmp1,int x1,int y1,int w1, int h1)
	{
		x=x1;
		y=y1;
		w=w1;
		h=h1;
		count=1;
		step=30;
		bmp=create_bitmap(w,h);
		blit (bmp1,bmp,0,0,0,0,w,h);
	}
	void Fade();
	
	~FadeBrick()
	{
		destroy_bitmap(bmp);
	}

private:
	BITMAP *bmp;
	int x,y,w,h;
	int count,r,g,b;
	int colour;
	int step;
};
