// powerup.cpp - controls all powerups

#include "list.h"
#include "game.h"
#include "sprite.h"
#include "variable.h"

// Handles each powerup
void Powerup::HandleSprite()
{
	y+=speedy;
	if (y+h>Y_LIMIT) { remove_flag=true; return; }
	result=CheckCollision(bmp,x,y,paddle->bmp,paddle->x,paddle->y);
	
	if (result==1)
	{ 
		if (type==8 || type==7) TRACE("Small Paddle");
		current_flag=true;
		current=new Powerup (def,type,x,y);
		last_time=game_time;
		ActivatePowerups(type);
		remove_flag=true;
	}
}

// Draw powerup
void Powerup::DrawSprite()
{
	masked_blit (bmp,buffer,0,0,x,y,w,h);
}

Powerup::Powerup(DATAFILE *d,int index,int powerupx,int powerupy)
{
	x=powerupx;
	y=powerupy;
	type=index;
	if (powerup_info[index].datafile==0) data=def;
	else data=user_datafile;
	bmp=(BITMAP *)(find_datafile_object(data,powerup_info[index].name)->dat);
	w=bmp->w;
	h=bmp->h;
	this->bmp=NULL;
	this->bmp=create_bitmap(w,h);
	blit((BITMAP *)(find_datafile_object(data,powerup_info[index].name)->dat),this->bmp,0,0,0,0,w,h);
	speedy=5;
	TRACE("Small Paddle");
}

// Main powerup loop
void HandlePowerups()
{
	powerup_spr=powerup_list.begin();
	do
	{
		(*powerup_spr)->HandleSprite();
		if (remove_flag==true)
		{ 
			delete *powerup_spr;
			powerup_spr=powerup_list.erase(powerup_spr); 
			no_of_powerups--; 
			remove_flag=false;
		}
		if (no_of_powerups>0) powerup_spr++;
		else break;
	} while (powerup_spr!=powerup_list.end()); 
}

// Set the properties of the objects depending on the powerup
void ActivatePowerups(int index)
{
	powerup_time=powerup_info[index].time;
	
// Ball properties
	if (powerup_info[index].no_of_balls>0)
	{
		for (int q=0; q<powerup_info[index].no_of_balls;q++)
		{
			ball_list.push_back(new Ball(rand()%640,30+rand()%450,ball_speed_x));
			no_of_balls++;
		}
	}
	ball_spr=ball_list.begin();
	while (ball_spr!=ball_list.end())
	{
		switch (powerup_info[index].ball_size)
		{
		case 0:
			clear_to_color((*ball_spr)->bmp,makecol(255,0,255));
			blit (ball_small,(*ball_spr)->bmp,0,0,0,0,ball_small->w,ball_small->h);
			break;
		case 1:
			clear_to_color((*ball_spr)->bmp,makecol(255,0,255));
			blit (ball_medium,(*ball_spr)->bmp,0,0,0,0,ball_medium->w,ball_medium->h);
			break;
		case 2:
			clear_to_color((*ball_spr)->bmp,makecol(255,0,255));
			blit (ball_large,(*ball_spr)->bmp,0,0,0,0,ball_large->w,ball_large->h);
			break;
		}
		
		if ((*ball_spr)->speedx<0) (*ball_spr)->speedx=-1 * powerup_info[index].ball_speed;
		else (*ball_spr)->speedx=powerup_info[index].ball_speed;
		if ((*ball_spr)->speedy<0) (*ball_spr)->speedy=-1 * powerup_info[index].ball_speed;
		else (*ball_spr)->speedy=powerup_info[index].ball_speed;
		ball_spr++;
	}

// Paddle properties
	switch (powerup_info[index].paddle_size)
	{
	case 0:
		clear_to_color(paddle->bmp,makecol(255,0,255));
		blit (paddle_small,paddle->bmp,0,0,0,0,paddle_small->w,paddle_small->h);
		TRACE("Small Paddle");
		break;
	case 1:
		clear_to_color(paddle->bmp,makecol(255,0,255));
		blit (paddle_medium,paddle->bmp,0,0,0,0,paddle_medium->w,paddle_medium->h);
		break;
	case 2:
		clear_to_color(paddle->bmp,makecol(255,0,255));
		blit (paddle_large,paddle->bmp,0,0,0,0,paddle_large->w,paddle_large->h);
		TRACE("Big Paddle");
		break;
	}
	paddle->speedx=powerup_info[index].paddle_speed;

// Boolean properties
	if (powerup_info[index].extra_life==1 && no_of_lives<5)
		no_of_lives++;

	if (powerup_info[index].laser==1) 
	{
		laser_flag=true;
	}
	if (powerup_info[index].sticky_ball==1) sticky_ball_flag=true;
	if (powerup_info[index].power_ball==1) power_ball_flag=true;
	if (powerup_info[index].next_level==1) 
	{
		level_flag=true;
		quitit=true;
		return;
	}
}

// Reset to default values 
void InactivatePowerups()
{
	ball_spr=ball_list.begin();
	while (ball_spr!=ball_list.end())
	{
		if ((*ball_spr)->speedx<0) (*ball_spr)->speedx=-1 * ball_speed_x;
		else (*ball_spr)->speedx=ball_speed_x;
		if ((*ball_spr)->speedy<0) (*ball_spr)->speedy=-1 * ball_speed_y;
		else (*ball_spr)->speedy=ball_speed_y;
		clear_to_color((*ball_spr)->bmp,makecol(255,0,255));
		blit (ball_medium,(*ball_spr)->bmp,0,0,0,0,ball_medium->w,ball_medium->h);
		ball_spr++;
	}
	paddle->speedx=paddle_speed;
	clear_to_color(paddle->bmp,makecol(255,0,255));
	blit (paddle_medium,paddle->bmp,0,0,0,0,paddle_medium->w,paddle_medium->h);
	laser_flag=false;
	sticky_ball_flag=false;
	power_ball_flag=false;
}

