// paddle.cpp - defines paddle functions and movements

#include "list.h"
#include "game.h"
#include "sprite.h"
#include "variable.h"


// Checks for collisions with ball and walls
void Paddle::HandleSprite()
{
	
	GetInput();
	paddle_x=x;
	paddle_y=y;
	
	ball_spr=ball_list.begin();
	result=0;
	while (ball_spr!=ball_list.end())
	{
		result=CheckCollision(bmp,x,y,(*ball_spr)->bmp,(*ball_spr)->x,(*ball_spr)->y);
	
		if (result==1)
		{
			if ( (*ball_spr)->x +(*ball_spr)->w < x || (*ball_spr)->x > x + w)
			{
				(*ball_spr)->speedx*=-1;
				(*ball_spr)->x+=speedx;
			}
			else (*ball_spr)->speedy=(*ball_spr)->speedy * -1;
			(*ball_spr)->y+=(*ball_spr)->speedy;
			
			if (sticky_ball_flag==true)
			{
				
				ball_spr1=ball_spr;
				temp_counter=speed_counter;
				while (!key[KEY_ENTER])
				{
					paddle->GetInput();
					(*ball_spr1)->x=paddle->x;
					UpdateScreen();
				}
				speed_counter=temp_counter;
				ball_spr=ball_spr1;
			}
			break;
		} 
		++ball_spr;
	}
}

void Paddle::DrawSprite()
{
	masked_blit (bmp,buffer,0,0,x,y,w,h);
}

void Paddle::GetInput()
{
	int my;
	switch (controller)
	{
	case 0:
		if (key[KEY_RIGHT]) right=true;
		if (key[KEY_LEFT]) left=true;
		break;

	case 1:
		get_mouse_mickeys(&mx, &my);
		if (mx < 0)
		left=true;
		else if (mx > 0)
		right=true;
		break;

	case 2:
		break;
	}

	if (right==true)
	{
		x+=speedx;
		if (x+w>630) x=(630 - w);
		right=false;
	}

	if (left==true)
	{
		x-=speedx;
		if (x<10) x=10;
		left=false;
	}
}

// Paddle constructor
Paddle::Paddle(int paddlex,int paddley,int padspeed)
{
	x=paddlex;
	y=paddley;

	speedx=padspeed;
	size=NORMAL;
	
	w=paddle_large->w;
	h=paddle_large->h;
	bmp=create_bitmap(w,h);
	clear(bmp);
	blit (paddle_medium,bmp,0,0,0,0,w,h);
}
	
