// laser.cpp - Handles the rocket laser
#include "list.h"
#include "game.h"
#include "sprite.h"
#include "variable.h"

Laser::Laser(int laser_x,int laser_y)
{
	x=laser_x;
	y=laser_y;
	speed=4;

	w = laser_bmp->w;
	h=laser_bmp->h;
	bmp=create_bitmap(w,h);
	blit (laser_bmp,bmp,0,0,0,0,w,h);

}

void Laser::HandleSprite()
{
	if (y<=30 || y>480) 
	{
		active_laser=false;
		laser_flag=false;
	}
	y-=speed;
	spr=spr_list.begin();
	while (spr!=spr_list.end())
	{
		result=CheckCollision(bmp,x,y,(*spr)->bmp,(*spr)->x,(*spr)->y);
		if (result)
		{
			(*spr)->collide=1;
		}
		spr++;
	}	
}

void Laser::DrawSprite()
{
	masked_blit (bmp,buffer,0,0,x,y,w,h);
}