// Std. includes for the game

#define DEBUGMODE

#include <iostream.h>
#include <allegro.h>
#include <stdio.h>
#include "breakin.h"

typedef unsigned int UINT;

#define FALSE 0
#define MAX_BALL_SPEED 5
#define MIN_BALL_SPEED -3
#define MIN_PADDLE_SPEED -7
#define MAX_PADDLE_SPEED 10
#define NORMAL 0
#define Y_LIMIT 480
#define MIN_Y_LIMIT 30

// General Game Functions
int Init();
void Menu();
void MainLoop();
void QuitLoop();
void QuitGame();
void PauseGame();
void UpdateScreen();
void LoadLevel(char *levelname);
UINT CheckCollision(BITMAP *bmp1,int x1,int y1,BITMAP *bmp2,int x2,int y2);
void HandleBricks();
void HandleBalls();
void HandlePowerups();
void DrawUI();
void Intro();
void StartMusic();
void StopMusic();
void increment_game_time();
void Print(char * ,...);
void InactivatePowerups();
void ActivatePowerups(int);
void LoadPowerups();
void LoadEpisode(char *);
void RandomGame();

bool SetAnimationMode(int mode);
int SetupGame();
void Win();
void Lose();


// Menu Functions
void MenuLoop();
void Draw(DIALOG *,bool);
int NewGame(int,DIALOG*,int );
int QuitGame(int,DIALOG *,int );
int Episode1(int,DIALOG *,int );
int Episode2(int,DIALOG *,int );
int Episode3(int,DIALOG *,int );
int Back1(int,DIALOG *,int );
int OptionsBack(int,DIALOG *,int );
int Back3(int,DIALOG *,int );
int Bg(int,DIALOG *,int );
int Random(int,DIALOG *,int );
int Custom(int,DIALOG *,int );
int Options(int,DIALOG *,int );
int VideoOptions(int,DIALOG *,int );
int SoundOptions(int,DIALOG *,int );
int ControllerOptions(int,DIALOG *,int );
int HighScores(int,DIALOG *,int );
int Credits(int,DIALOG *,int );
int CreditsText(int m,DIALOG *d, int c);
int OptionsText(int m,DIALOG *d, int c);
int SoundOptionsText(int m,DIALOG *d, int c);
int VideoOptionsText(int m,DIALOG *d, int c);
int ControllerOptionsText(int m,DIALOG *d, int c);
int d_noesc_proc (int msg, DIALOG *d, int c);
int inc_music(void *dp3,int d2);
int inc_sound(void *dp3,int d2);
char *listbox_yesno(int index, int *list_size);
char *listbox_controller(int index, int *list_size);
void LoadMenu();
void SaveMenu();

//High Scores
void LoadScores();
void SaveScores();
void ShowScores();
void LaunchDialog();