//////////////////////////////////////////////////////////////////////////////////////////////////
// EDITOR.CPP
// 
// Description: Level editor for the Breakin game. Allows the designer to define custom 
//				properties.Please read the EDITOR.TXT file for detailed information.
//
// Author: Karthik Raveendran  
// Email: malli@vsnl.com
//
//////////////////////////////////////////////////////////////////////////////////////////////////

#define DEBUGMODE
#include <string.h>
#include <allegro.h>
#include <iostream.h>
#include "editor.h"
#include <stdio.h>
#include <fstream.h>
#include "list.h"

#define FALSE 0


struct BitmapList 
{
	BITMAP *bmp;
    char name[20];
	int pos;
	int hits;
	int reflect;
	int powerup;
};

struct Brick
{
	int x,y;
	int w,h;
	int pos;
	int hits;
	int powerup;
	int reflect;
	char name[20];
};


// Globals
char level_name[10]="Breakin";
char no_of_lives[3]="5";
char paddle_x[4]="320";
char paddle_y[4]="440";
char ball_speed[2]="4";
char paddle_speed[2]="6";
char hits_string[2]="1";
char reflect_string[10]="100";
char powerup_string[2]="0";
char c_argv[40];
char path1[80];
char path[80];	

char ball_datafile[20]="0",paddle_datafile[20]="0",bg_datafile[20]="0",ui_datafile[20]="0",music_datafile[20]="0";
char ball_small[20]="BALL_SMALL",ball_medium[20]="BALL_MEDIUM",ball_large[20]="BALL_LARGE";
char paddle_small[20]="PADDLE_SMALL",paddle_medium[20]="PADDLE_MEDIUM",paddle_large[20]="PADDLE_LARGE";
char bg_name[20]="MENU_BG", ui_name[20]="UI", music_name[20]="MUSIC";

int c_argc=0;
int WHITE,BLUE;
int showed;
int NoOfBitmaps,count,i;
int UsedBricks=0;

BITMAP *temp_brick;
BITMAP *background;
BITMAP *board_buffer;
BITMAP *board_buffer2;

DATAFILE *data;
DATAFILE *editor;	

BitmapList *Array;
list <Brick *> brick_list;
list <Brick *>::iterator iter;
list <Brick *>::iterator temp;
Brick *current;

// Editor functions
void DrawBrick();
void LoadBitmaps();
void SetCurrentBrick();
void BrickAllowed();
void Init();
void CleanUp();
void Print(char *format, ...);
int Board(int msg,DIALOG *d,int c);

// Editable text box in GUI
int d_myedit_proc(int msg, DIALOG* d, int c)
{
    if(msg == MSG_LOSTFOCUS) return D_O_K;
    return d_edit_proc(msg, d, c);
}

// Draws all static objects ( text label, title bars)
int StaticObjects(int msg, DIALOG *d, int c) 
{
	switch(msg)
	{
	case MSG_DRAW:		
		rectfill (screen,0,0,800,7,BLUE); // Title bar colour
		textout_centre(screen,font,"Breakin Editor",400,0,WHITE); // Title bar text
	
		line (screen,641,7,641,487,BLUE); // Separator bar
		
		// This block draws all the static text fields
		rectfill (screen,0,487,800,494,BLUE); // Level Configuration bar
		textout_centre(screen,font,"Level configuration",400,487,WHITE); // Level configuration

		// Level configuration
		textout (screen,font,"Level name:",40,521,WHITE); 
		textout (screen,font,"No. of lives:",40,541,WHITE); 
		textout (screen,font,"Paddle Position",280,521,WHITE); 
		textout (screen,font,"X:",280,541,WHITE); 
		textout (screen,font,"Y:",360,541,WHITE); 
		textout (screen,font,"Ball speed:",520,521,WHITE); 
		textout (screen,font,"Paddle speed:",520,541,WHITE); 

		// Brick properties
		rectfill (screen,641,260,800,267,BLUE); // Brick Properties Bar
		textout_centre (screen,font,"Brick Properties",725,260,WHITE); // Brick properties text
		textout (screen,font,"No. of hits:", 650,390,WHITE);
		textout (screen,font,"Score:", 660,410,WHITE);
		textout (screen,font,"Power-up:", 660,430,WHITE);		
		break;
	}
	return D_O_K;
}

// Shows the previous button
int PreviousBrickButton(int msg, DIALOG *d, int c)
{ 
	switch (msg)
	{
	case MSG_CLICK:
		if (count>0) 
		{
			count--;
			SetCurrentBrick();
			DrawBrick();
		}
		break;

	case MSG_DRAW:
		masked_blit ((BITMAP *)editor[LEFT].dat,screen,0,0,650,280,40,60);
		break;
	}
	return D_O_K;
}

// Shows the next bitmap in the datafile if it exists
int NextBrickButton(int msg, DIALOG *d, int c)
{ 
	
	switch (msg)
	{	
	case MSG_START:
		count=0;
		SetCurrentBrick();
		DrawBrick();
		break;
	
	case MSG_CLICK:
		if (count<NoOfBitmaps-1) 
		{
			count++;			
			SetCurrentBrick();
			DrawBrick();
		}		
		break;

	case MSG_DRAW:
		masked_blit ((BITMAP *)editor[RIGHT].dat,screen,0,0,750,280,40,60);
		break;
	}
	return D_O_K;
}




DIALOG properties[]=
{
   /* (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1) (d2)  (dp)   (dp2) (dp3) */
   { d_clear_proc,      0,    0,    799,  599,    0,  0,    0,    0,       0,    0,    NULL,  NULL, NULL  },
   { d_text_proc,		10,  50,   100,   10,    255, 0,    0,    0,       0,    0,  (char *)"BALL", NULL , NULL},
   { d_text_proc,       10,  60,   100,   10,    255, 0,    0,    0,       0,    0,  (char *)"Datafile:", NULL , NULL },
   { d_myedit_proc,       110,  60,   100,   10,    255, 0,    0,    0,      10,    0,  ball_datafile, NULL , NULL },
   { d_text_proc,		10,  70,   100,   10,    255, 0,    0,    0,       0,    0,  (char *)"Small:",  NULL , NULL},
   { d_myedit_proc,       110,  70,   200,   10,    255, 0,    0,    0,      20,    0,  ball_small, NULL , NULL },
   { d_text_proc,		10,  80,   100,   10,    255, 0,    0,    0,       0,    0,  (char *)"Medium:",  NULL , NULL},
   { d_myedit_proc,       110,  80,   200,   10,    255, 0,    0,    0,      20,    0,  ball_medium, NULL , NULL },
   { d_text_proc,		10,  90,   100,   10,    255, 0,    0,    0,       0,    0,  (char *)"Large:",  NULL , NULL},
   { d_myedit_proc,       110,  90,   200,   10,    255, 0,    0,    0,      20,    0,  (char *)ball_large, NULL , NULL },
   { d_text_proc,		10,  100,   100,   10,    255, 0,    0,    0,       0,    0,  (char *)"PADDLE", NULL , NULL},
   { d_text_proc,       10,  110,   100,   10,    255, 0,    0,    0,       0,    0,  (char *)"Datafile:", NULL , NULL },
   { d_myedit_proc,       110, 110,   100,   10,    255, 0,    0,    0,      10,    0,  (char *)paddle_datafile, NULL , NULL },
   { d_text_proc,		10,  120,   100,   10,    255, 0,    0,    0,       0,    0,  (char *)"Small:",  NULL , NULL},
   { d_myedit_proc,       110, 120,   200,   10,    255, 0,    0,    0,      20,    0,  (char *)paddle_small, NULL , NULL },
   { d_text_proc,		10,  130,   100,   10,    255, 0,    0,    0,       0,    0,  (char *)"Medium:",  NULL , NULL},
   { d_myedit_proc,       110, 130,   200,   10,    255, 0,    0,    0,      20,    0,  (char *)paddle_medium, NULL , NULL },
   { d_text_proc,		10,  140,   100,   10,    255, 0,    0,    0,       0,    0,  (char *)"Large:",  NULL , NULL},
   { d_myedit_proc,       110, 140,   200,   10,    255, 0,    0,    0,      20,    0,  (char *)paddle_large, NULL , NULL },
   { d_text_proc,		10,  160,   100,   10,    255, 0,    0,    0,       0,    0,  (char *)"MUSIC:",  NULL , NULL},
   { d_myedit_proc,       110, 170,   100,   10,    255, 0,    0,    0,      10,    0,  (char *)music_datafile, NULL , NULL },
   { d_text_proc,		10,  170,   100,   10,    255, 0,    0,    0,       0,    0,  (char *)"Datafile:",  NULL , NULL},
   { d_text_proc,		10,  180,   100,   10,    255, 0,    0,    0,       0,    0,  (char *)"Name:",  NULL , NULL},
   { d_myedit_proc,       110, 180,   200,   10,    255, 0,    0,    0,      20,    0,  (char *)music_name, NULL , NULL },
   { d_text_proc,		10,  200,   100,   10,    255, 0,    0,    0,       0,    0,  (char *)"BACKGROUND:",  NULL , NULL},
   { d_text_proc,		10,  210,   100,   10,    255, 0,    0,    0,       0,    0,  (char *)"Datafile:",  NULL , NULL},
   { d_myedit_proc,       110, 210,   100,   10,    255, 0,    0,    0,      10,    0,  (char *)bg_datafile, NULL , NULL },
   { d_text_proc,		10,  220,   100,   10,    255, 0,    0,    0,       0,    0,  (char *)"Name:",  NULL , NULL},
   { d_myedit_proc,       110, 220,   200,   10,    255, 0,    0,    0,      20,    0,  (char *)bg_name, NULL , NULL },
   { d_text_proc,		10,  240,   100,   10,    255, 0,    0,    0,       0,    0,  (char *)"UI:",  NULL , NULL},
   { d_text_proc,		10,  250,   100,   10,    255, 0,    0,    0,       0,    0,  (char *)"Datafile:",  NULL , NULL},
   { d_myedit_proc,       110, 250,   100,   10,    255, 0,    0,    0,      10,    0,  (char *)ui_datafile, NULL , NULL },
   { d_text_proc,		10,  260,   100,   10,    255, 0,    0,    0,       0,    0,  (char *)"Name:",  NULL , NULL},
   { d_myedit_proc,       110, 260,   200,   10,    255, 0,    0,    0,      20,    0,  (char *)ui_name, NULL , NULL },
   { d_button_proc,		700,  500,  100,  30,   255,  0 , 0,    D_EXIT,  0,    0,    (char *)"Back", NULL, NULL  },
   { NULL,				0,    0,    0,    0,    0  ,  0,    0,    0,       0,    0,    NULL,  NULL, NULL  }	
};

int Properties(int msg, DIALOG *d, int c)
{ 
	switch (msg)
	{
	case MSG_DRAW:
		rectfill (screen,660,100,760,130,BLUE);
		textout (screen, font, "Properties",670,110,WHITE);
		break;
	
	case MSG_CLICK:
		popup_dialog(properties, -1);
		break;
	}
	return D_O_K;
}

// Procedure for the Save button
int Save(int msg, DIALOG *d, int c)
{ 
	switch (msg)
	{
	case MSG_DRAW:
		rectfill (screen,660,150,760,180,BLUE);
		textout (screen, font, "Save",700,160,WHITE);
		break;

	case MSG_CLICK:
		file_select ("Save as:",path,NULL);
		fstream level;
		level.open(path, ios::out);
	    
		level<<path1<<endl;		
		level<<"\n"<<level_name<<"\n"<<no_of_lives<<"\n"<<paddle_x<<"\n"<<paddle_y<<"\n"<<ball_speed<<"\n"<<paddle_speed<<"\n";
		level<<UsedBricks<<"\n";

		iter=brick_list.begin();
		while (iter!=brick_list.end())
		{
			level<<(*iter)->x<<" "<<(*iter)->y<<" "<<(*iter)->w<<" "<<(*iter)->h<<" "<<(*iter)->name<<" "<<(*iter)->hits<<" "<<(*iter)->reflect<<" "<<(*iter)->powerup<<" ";
			level<<"\n";
			iter++;
		}
		
		level<<ball_datafile<<"\n"<<ball_small<<"\n"<<ball_medium<<"\n"<<ball_large<<"\n";
		level<<paddle_datafile<<"\n"<<paddle_small<<"\n"<<paddle_medium<<"\n"<<paddle_large<<"\n";
		level<<music_datafile<<"\n"<<music_name<<"\n";
		level<<bg_datafile<<"\n"<<bg_name<<"\n";
		level<<ui_datafile<<"\n"<<ui_name<<"\n";

		level.close();
		break;
	}
	return D_O_K;
}



// Procedure for the Exit button
int Exit(int msg, DIALOG *d, int c)
{ 
	switch (msg)
	{
	case MSG_DRAW:
		rectfill (screen,660,200,760,230,BLUE);
		textout (screen, font, "Exit",700,210,WHITE);
		break;
	
	case MSG_CLICK:
		return D_EXIT;
	}
	return D_O_K;
}


// The Dialog which handles all the events
DIALOG the_dialog[] =
{
   /* (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1) (d2)  (dp)   (dp2) (dp3) */
   { d_clear_proc,      0,    0,    0,    0,    255,  0,    0,    0,       0,    0,    NULL,  NULL, NULL  },
   { d_myedit_proc,		130, 521,  100,   8,	255,  0,	0,	  0,	   10,   0,    level_name, NULL, NULL },   
   { d_myedit_proc,		145, 541,  16,	  8,    255,  0,	0,	  0,	   2,	 0,    no_of_lives, NULL, NULL }, 
   { d_myedit_proc,		298, 541,  70,    8,    255,  0,    0,    0,       3,    0,    paddle_x,    NULL, NULL },
   { d_myedit_proc,		378, 541,  70,    8,    255,  0,    0,    0,       3,    0,    paddle_y,    NULL, NULL },
   { d_myedit_proc,		610, 521,  16,    8,    255,  0,    0,    0,       2,    0,    ball_speed,    NULL, NULL },
   { d_myedit_proc,		630, 541,  16,    8,    255,  0,    0,    0,       2,    0,    paddle_speed,    NULL, NULL },
   { d_myedit_proc,       750, 390,  30,    8,    255,  0,    0,    0,       3,    0,    hits_string, NULL, NULL }, 
   { d_myedit_proc,       750, 410,  40,    8,    255,  0,    0,    0,       4,    0,    reflect_string, NULL, NULL }, 
   { d_myedit_proc,       760, 430,  16,    8,    255,  0,    0,    0,       2,    0,    powerup_string, NULL, NULL }, 
   { NextBrickButton,	750, 280,   40,   60,	0,	  0,    0,	  0,       0,    0,    NULL,  NULL, NULL  },
   { PreviousBrickButton, 650, 280,   40,   60,	0,	  0,    0,    0,       0,    0,    NULL,  NULL, NULL  },
   { Board,				0,    0,    640,  480, 0,    0,     'x',    0,       0,    0,    NULL,  NULL, NULL  }, 
   { StaticObjects,		0,	  0,	0,	  0,	255,  0,	0,	  0,	   0, 	 0,	   NULL,  NULL, NULL  },             
   { Save,				660,  150,  100,  30,   255,  0,    0,    0,       0,    0,    NULL,  NULL, NULL  },
   { Properties,		660,  100,  100,  30,   255,  0,    0,    0,       0,    0,    NULL,  NULL, NULL  },
   { Exit,				660,  200,  100,  30,   255,  0,    0,    0,       0,    0,    NULL,  NULL, NULL  },
   { NULL,				0,    0,    0,    0,    0  ,  0,    0,    0,       0,    0,    NULL,  NULL, NULL  }
};




// Initializes all required stuff 
void Init()
{
	allegro_init();
	install_timer();
	install_keyboard();
	install_mouse();
	set_color_depth(16);
	set_gfx_mode (GFX_AUTODETECT,800,600,0,0);
	
	WHITE=makecol16(255,255,0);
	BLUE=makecol16(0,0,255);
	
	background=create_bitmap(640,480);
	clear (background);
	temp_brick=create_bitmap(60,60);
	clear(temp_brick);
	board_buffer=create_bitmap (640,480);
	clear(board_buffer);
	board_buffer2=create_bitmap (640,480);
	clear(board_buffer2);
	current=new Brick;
	editor=load_datafile("editor.dat");
	
	if (c_argc==1) 
	{
		
		if (file_select("Select a datafile", path1, "DAT;dat")==0)
		{		
			CleanUp();
			exit(0);
		}
		else 
		{
			data=load_datafile(path1);
		}
	}
	else 
	{
		fstream load;
		load.open(c_argv,ios::in);
		
		load>>path1>>level_name>>no_of_lives>>paddle_x>>paddle_y>>ball_speed>>paddle_speed>>UsedBricks;
		data=load_datafile(path1);
		for (i=0;i<UsedBricks;i++)
		{
            brick_list.push_back(new Brick);
            if (i!=0) temp++;
            else temp = brick_list.begin();
			load>>(*temp)->x>>(*temp)->y>>(*temp)->w>>(*temp)->h>>(*temp)->name>>(*temp)->hits>>(*temp)->reflect>>(*temp)->powerup;
			for (int j=0; data[j].type != DAT_END; j++) 
			{
				if (stricmp(get_datafile_property(data+j, DAT_ID('N','A','M','E')), (*temp)->name) == 0) 
					(*temp)->pos=j;
			}
   		}
		
		load>>ball_datafile>>ball_small>>ball_medium>>ball_large;
		load>>paddle_datafile>>paddle_small>>paddle_medium>>paddle_large;
		load>>music_datafile>>music_name;
		load>>bg_datafile>>bg_name;
		load>>ui_datafile>>ui_name;
		load.close();
	}

	LoadBitmaps();
	gui_mouse_focus=1;
}

// Clean up and exit gracefully
void CleanUp()
{
	unload_datafile(data);
	unload_datafile(editor);
	destroy_bitmap(temp_brick);
	destroy_bitmap(background);
	destroy_bitmap(board_buffer);
	destroy_bitmap(board_buffer2);        
	delete current;
	brick_list.clear();
	delete [] Array;
	allegro_exit();
}

// Draws a brick onto the screen
void DrawBrick()
{	
	clear(temp_brick);
	masked_stretch_blit(Array[count].bmp, temp_brick, 0, 0, Array[count].bmp->w, Array[count].bmp->h, 0,0, 60, 60);
	blit (temp_brick,screen,0,0,690,280,60,60);
}

// Scan the datafile for bitmaps and load them into the bitmap array
void LoadBitmaps()
{
	for (i=0; data[i].type != DAT_END; i++)
	{
        if (data[i].type==DAT_BITMAP) 
		{
			NoOfBitmaps++;
		}
	}
	
    Array= new BitmapList[NoOfBitmaps];
	count=0;
    for (i=0; data[i].type!= DAT_END; i++)
	{
		if (data[i].type==DAT_BITMAP) 
		{
			Array[count].hits=1;
			Array[count].powerup=0;
			Array[count].reflect=0;
			Array[count].pos=i;
			Array[count].bmp=(BITMAP *)data[i].dat;
			strcpy(Array[count].name,get_datafile_property(data+i, DAT_ID('N','A','M','E')));
         	if (stricmp(Array[count].name,"BACKGROUND")==0) 
				blit (Array[count].bmp,background,0,0,0,0,640,480);
			count++;
			TRACE("%d",count);
        }

	}
}


// Set the properties of the selected brick
void SetCurrentBrick()
{
	current->hits=atoi(hits_string);
	current->reflect=atoi(reflect_string);
	current->powerup=atoi(powerup_string);
	current->pos=Array[count].pos;
	strcpy(current->name,Array[count].name);
	current->w=Array[count].bmp->w;
	current->h=Array[count].bmp->h;
}

int Board(int msg, DIALOG *d, int c)
{
// Draws the grid lines to make it easier to draw	
	if (mouse_x < 640 && mouse_y <487 && mouse_y > 37)
	{
		show_mouse(NULL);
		blit (board_buffer,board_buffer2,0,0,0,0,640,480);
		line (board_buffer2,mouse_x,0,mouse_x,487,255);
		line (board_buffer2,0,mouse_y,640,mouse_y,255);
		rect (board_buffer2,mouse_x,mouse_y,mouse_x+current->w,mouse_y+current->h,255);
		textprintf (board_buffer2,font,0,7,BLUE,"(%d,%d)",mouse_x,mouse_y);
		masked_blit (board_buffer2,screen,0,0,0,7,640,480);		
		showed=FALSE;
	}
	else 
	{
		if (showed==FALSE)
		{
			show_mouse(screen);
			showed=TRUE;
		}
	}

	switch (msg)
	{
// Draws a brick when the mouse is clicked over the board
	case MSG_CLICK:
	if ((mouse_x + current->w <= 640) && (mouse_y + current->h <= 487))
	{
		brick_list.push_back(new Brick);
        if (UsedBricks==0) temp = brick_list.begin();
        else temp=--brick_list.end();
		SetCurrentBrick();
        (*temp)->x=mouse_x;
		(*temp)->y=mouse_y;
		(*temp)->w=current->w;
		(*temp)->h=current->h;
		(*temp)->hits=current->hits;
		(*temp)->pos=current->pos;
		strcpy ((*temp)->name,current->name);
		(*temp)->powerup=current->powerup;
		(*temp)->reflect=current->reflect;
		UsedBricks+=1;
		SEND_MESSAGE(d, MSG_DRAW, 0);
	}
	break;


	case MSG_KEY:
	if (UsedBricks!=0)
	{
		temp = brick_list.begin();
		
		while (temp!=brick_list.end())
		{
			if ((mouse_x > (*temp)->x) && (mouse_x < (*temp)->x + (*temp)->w) && (mouse_y>(*temp)->y + 7) && (mouse_y>(*temp)->y + (*temp)->h) + 7)			
			{
				if(alert("Delete Brick?", NULL, NULL , "Ok", "Cancel", NULL, NULL) == 1)
				{					
					brick_list.erase(temp);
					UsedBricks--;
					SEND_MESSAGE(&the_dialog[12], MSG_DRAW, 0);
					break;
				}
			}
			temp++;
		}
	}
	return D_USED_CHAR;


// Redraws the board in response to MSG_DRAW message
	case MSG_DRAW:
		clear(board_buffer);
		blit (background,board_buffer,0,0,0,0,640,480);
		
		if (UsedBricks!=0)
		{
			iter=brick_list.begin();
			while (iter!=brick_list.end())
			{
				masked_blit((BITMAP *)data[(*iter)->pos].dat,board_buffer,0,0,(*iter)->x,(*iter)->y,(*iter)->w,(*iter)->h);
				iter++;
			}	
		}
     
		masked_blit (board_buffer,screen,0,0,0,7,640,480);
		break;

	}
	if (msg==MSG_LOSTFOCUS) return MSG_WANTFOCUS;
	else return D_O_K;
} 

// Debugging function
void Print(char *format, ...)
{
	char buffer[1024];
	va_list arglist;

	va_start (arglist,format);
	vsprintf (buffer,format, arglist);

	textout (screen,font,buffer,0,0,255);
}

// entry point for application
void main(int argc,char *argv[])
{
	c_argc=argc;
	if (argc>1) strcpy (c_argv,argv[1]);
	Init();
	do_dialog (the_dialog,10);
	CleanUp();
}
END_OF_MAIN();
