// brick.cpp - defines behaviour for each brick on screen

#include "list.h"
#include "game.h"
#include "sprite.h"
#include "variable.h"

// Handle events for each instance of a brick
void Brick::HandleSprite()
{
	// Ball has collided 
	if (collide==1) 
	{	
		score1+=score; // Increase score
		if (unbreak==false) hits=hits-1;
		collide=0;
	}
		
	// Brick should be removed 
	if (hits==0)
	{			
		remove_flag=true;
		// Fade the brick into oblivion
		fade_list.push_back(new FadeBrick(this->bmp,this->x,this->y,this->w,this->h)); 
		if (type!=0) 
		{
			no_of_powerups++;
			powerup_list.push_back(new Powerup(def,type,x,y));		
		}
	} 
		
}

void Brick::DrawSprite()
{
	masked_blit (bmp,buffer,0,0,x,y,w,h);	
	// Indestructible brick
	if (hits!=99)
		textprintf_centre(buffer,font,x+(w/2),y+(h/2),makecol(255,255,255),"%d",hits);
}

Brick::Brick(int x1,int y1,int w1, int h1, int hits1,int score1, int powerup1 , BITMAP *bmp1)
{
	x=x1;
	y=y1;
	w=w1;
	h=h1;
	hits=hits1;
	score=score1;
	if (hits==99)
		unbreak=true;
	else 
	{
		break_bricks++;
		unbreak=false;
	}
	type=powerup1; // Set the powerup which should appear from it
	
	bmp=create_bitmap(w,h);
	clear(bmp);
	blit(bmp1,bmp,0,0,0,0,w,h);
}

void HandleBricks()
{
	spr=spr_list.begin();		
	while (spr!=spr_list.end())
	{
		(*spr)->HandleSprite();
		if (remove_flag==true) 
		{
			delete *spr;
			spr=spr_list.erase(spr);
			remove_flag=false;
			break_bricks--;
			if (break_bricks==0) 
			{ 
				level_flag=true; // Level completed
				quitit=true;
				return; 
			}
		}
		else ++spr;
	}
}

	
// Fade away into oblivion ;-)
void FadeBrick::Fade()
	{
		if (count<=step)
		{
			for (int i=0;i<w;i++)
			{
				for (int j=0;j<h;j++)
				{					 
					colour=getpixel(bmp,i,j);
					r=getr(colour);
					g=getg(colour);
					b=getb(colour);
					
					r = r + (255-r)/step;
					g = g - (g/step);
					b = b + (255-b)/step;
					putpixel(bmp,i,j,makecol(r,g,b));
				}
			}
			masked_blit (bmp,buffer,0,0,x,y,w,h);
			count+=1;
		}
	}

