// ball.cpp - defines functions for each ball on screen

#include "list.h"
#include "game.h"
#include "sprite.h"
#include "variable.h"

// Handles events for each instance of the ball
void Ball::HandleSprite()
{
	if (speedy==0) speedy=3;
	// Check if ball collides with walls
	if (x<10 || x+w>630) speedx*=-1;
	if (y<MIN_Y_LIMIT) { speedy*=-1; }
	if (y+h>=Y_LIMIT) { paddle->speedx=paddle_speed; life_lost=true; return; }
	
	y+=speedy; //Increment y and then check for collisions
	result=0;
	spr=spr_list.begin();
	
	while (spr!=spr_list.end())
	{
		result=CheckCollision(bmp,x,y,(*spr)->bmp,(*spr)->x,(*spr)->y);
		if (result)
		{
			if (power_ball_flag==false) speedy*=-1;
			(*spr)->collide=1;
			y+=speedy;
		}
		spr++;
	}	
	
	x+=speedx; // Increment x and then check for collisions
	result=0;
	spr=spr_list.begin();
	
	while (spr!=spr_list.end())
	{
		result=CheckCollision(bmp,x,y,(*spr)->bmp,(*spr)->x,(*spr)->y);
		if (result)
		{
			if (power_ball_flag==false) speedx*=-1;
			(*spr)->collide=1;
			x+=speedx;
		}
		spr++;
	}
}

void Ball::DrawSprite()
{
	masked_blit (bmp,buffer,0,0,x,y,w,h);
}

// Constructor which initializes variables
Ball::Ball(int ballx, int bally,int ballspeed)
{
	x=ballx;
	y=bally;
	
	speedx=speedy=ballspeed;
	speedy=speedy * -1;
	
	w=ball_large->w;
	h=ball_large->h;
	bmp=create_bitmap(w,h);
	clear_to_color(bmp,makecol(255,0,255));
	blit (ball_medium,bmp,0,0,0,0,w,h);

}

