// random.cpp - generates random levels

#include "game.h"  
#include "sprite.h"
#include "list.h"
#include "variable.h"
#include "breakin.h"

#include <stdlib.h>
#include <time.h>

// List of bricks from which level is generated
int brick_list[9]=
{
	BRICK1,
	BRICK2,
	BRICK3,
	BRICK4,
	BRICK5,
	BRICK6,
	BRICK7,
	BRICK8,
	BRICK9
};

// Random Game procedure
// It basically sets bricks randomly on the screen and then sets up the req variables

void RandomGame()
{
	int x=-1,y=-1;
	int hits=1,power=0,temp=-1;
	BITMAP *brick;
	bool repeat=true;
	int w=0,h=0;
    no_of_lives=0;
    no_of_bricks=0;
	strcpy(path,"C:\breakin\breakin.dat");

	srand( (unsigned)time(NULL) );

	// Set the required variables
	while (no_of_bricks<4 || no_of_bricks>20) no_of_bricks=rand()%20;
	paddle_x=320;
	paddle_y=440;
	break_bricks=0;
	while (no_of_lives==0) no_of_lives=rand()%5;
	strcpy (level_name,"Random Game");
	ball_speed_x=ball_speed_y=3;
	paddle_speed=7;
		
	for (i=1;i<=no_of_bricks;i++)
	{
		while (repeat==true)
		{
			x=y=-1;
			repeat=false;
			
			while (x<=0 || x>620 || y<30 || y>paddle_x)
			{
				x=rand()%640;
				y=rand()%480;
			}
			while (hits<=0 || hits>5) hits=rand()%6;			
			while (power>11 || power<0) power=rand()%11;
			while (temp < 0 || temp>9) temp=rand()%9;
			brick=(BITMAP *)def[brick_list[temp]].dat;
			w=brick->w;
			h=brick->h;

			spr=spr_list.begin();
			while (spr!=spr_list.end())
			{
				if (x>(*spr)->x && x<(*spr)->x + (*spr)->w) { repeat=true; break; }
				else if (y>(*spr)->y && y< (*spr)->y + (*spr)->h) { repeat=true; break; }
				else if (x + w > (*spr)->x && x + w < (*spr)->x + (*spr)->w) { repeat=true; break; }
				else if (y + h > (*spr)->y && y + h < (*spr)->y + (*spr)->h) { repeat=true; break; }
				spr++;
			}
		}
	
		spr_list.push_back(new Brick(x,y,brick->w,brick->h, hits,100, power ,brick));
		power=-1;
		hits=-1;
		temp=-1;
		repeat=true;
	}
    
	brick=NULL;
    ball_small=(BITMAP *)def[BALL_SMALL].dat;
	ball_medium=(BITMAP *)def[BALL_MEDIUM].dat;
	ball_large=(BITMAP *)def[BALL_LARGE].dat;
	paddle_small=(BITMAP *)def[PADDLE_SMALL].dat;
	paddle_medium=(BITMAP *)def[PADDLE_MEDIUM].dat;
	paddle_large=(BITMAP *)def[PADDLE_LARGE].dat;
	ui=(BITMAP *)def[UI].dat;
	background=(BITMAP *)def[MENU_BG].dat;
	music=(MIDI *)def[MUSIC].dat;
	laser_bmp=(BITMAP *)def[LASER].dat;


	// Load powerups	
	LoadPowerups();

// Add ball ( the game allows more than one ball )	
	no_of_balls=0;
	ball_list.push_back(new Ball(paddle_x,paddle_y-60,ball_speed_x));
	no_of_balls++;
	
// Add paddle
	paddle = new Paddle(paddle_x,paddle_y-(ball_medium->h),paddle_speed);

// Set misc flags
	quitit=false;
	level_flag=false;
	laser_flag=false;
	sticky_ball_flag=false;

}

	
