// Menu.cpp 
// Allegro does not support nested dialogs, so you have to create a different type
// of menu system - i.e close one before launching another screen
// All functions refer to the various buttons on the menu screen
// and define their actions. 
 
#include "breakin.h"
#include "sprite.h"
#include "variable.h"
#include "game.h"
#include "menu.h"

#define BACK 0
#define NEXT 1


DIALOG *prev=NULL;
DIALOG *cur=NULL;

int msg=-1;

void LaunchDialog()
{
	do_dialog(enter_name,1);
}

int NewGame(int m, DIALOG *d, int c)
{
	switch (m)
	{
	case MSG_CLICK:
		while (gui_mouse_b());
		msg=NEXT;
		cur=(DIALOG *)new_game;
		return D_CLOSE;
		break;
	
	case MSG_DRAW:
		Draw(d,false);
		break;	
	}
	return D_O_K;
}

int QuitGame(int m, DIALOG *d, int c)
{
	switch (m)
	{
	case MSG_CLICK:
		while (gui_mouse_b());
		msg=BACK;
		quitmenu=true;
		return D_CLOSE;
		break;
	case MSG_DRAW:
		Draw(d,false);
		break;
	}
	return D_O_K;

}

int Bg(int m,DIALOG *d,int c)
{
	switch (m)
	{
	case MSG_DRAW:
		blit ((BITMAP*)def[MENU_BG].dat,screen,0,0,0,0,640,480);
		textout (screen,(FONT *)def[LARGE_FONT].dat,"Breakin",220,20,makecol(255,255,255));
		break;
	}
	return D_O_K;
}

int Options(int m, DIALOG *d, int c)
{
	switch (m)
	{
	case MSG_CLICK:
		while (gui_mouse_b());
		msg=NEXT;
		cur=(DIALOG *)options;
		return D_CLOSE;
		break;
	
	case MSG_DRAW:
		Draw(d,false);
		break;
	
	}
	return D_O_K;
}

int Credits(int m, DIALOG *d, int c)
{
	switch (m)
	{
	case MSG_CLICK:
		while (gui_mouse_b());
		msg=NEXT;
		cur=(DIALOG *)credits;
		return D_CLOSE;
		break;
	
	case MSG_DRAW:
		Draw(d,false);
		break;
	
	}
	return D_O_K;
}

int HighScores(int m, DIALOG *d, int c)
{
	switch (m)
	{
	case MSG_CLICK:
		ShowScores();
		msg=BACK;
		cur=(DIALOG *)main_menu;
		return D_CLOSE;
		break;
	
	case MSG_DRAW:
		Draw(d,false);
		break;
	}
	return D_O_K;
}

int Episode1(int m, DIALOG *d, int c)
{
	switch (m)
	{
	case MSG_CLICK:
		while (gui_mouse_b());
		msg=BACK;
		gametype=1;
		quitmenu=true;
		return D_CLOSE;
		break;
	
	case MSG_DRAW:
		Draw(d,false);
		break;
	}
	return D_O_K;
}

int Episode2(int m, DIALOG *d, int c)
{
	switch (m)
	{
	case MSG_CLICK:
		while (gui_mouse_b());
		msg=BACK;
		gametype=2;
		quitmenu=true;
		return D_CLOSE;
		break;
	
	case MSG_DRAW:
		Draw(d,false);
		break;
	}
	return D_O_K;
}


int Episode3(int m, DIALOG *d, int c)
{
	switch (m)
	{
	case MSG_CLICK:
		while (gui_mouse_b());
		msg=BACK;
		gametype=3;
		quitmenu=true;
		return D_CLOSE;
		break;
	
	case MSG_DRAW:
		Draw(d,false);
		break;
	}
	return D_O_K;
}

int Custom(int m, DIALOG *d, int c)
{
	switch (m)
	{
	case MSG_CLICK:
		while (gui_mouse_b());
		msg=BACK;
		gametype=4;
		quitmenu=true;
		return D_CLOSE;
		break;
	
	case MSG_DRAW:
		Draw(d,false);
		break;
	}
	return D_O_K;
}

int Random(int m, DIALOG *d, int c)
{
	switch (m)
	{
	case MSG_CLICK:
		while (gui_mouse_b());
		msg=BACK;
		gametype=5;
		quitmenu=true;
		return D_CLOSE;
		break;
	
	case MSG_DRAW:
		Draw(d,false);
		break;
	}
	return D_O_K;
}


int Back1(int m, DIALOG *d, int c)
{
	switch (m)
	{
	case MSG_CLICK:
		while (gui_mouse_b());
		msg=BACK;
		cur=(DIALOG *)main_menu;
		return D_CLOSE;
		break;
	case MSG_DRAW:
		Draw(d,false);
		break;
	}
	return D_O_K;
}

int OptionsBack(int m, DIALOG *d, int c)
{
	switch (m)
	{
	case MSG_CLICK:
		while (gui_mouse_b());
		msg=BACK;
		cur=(DIALOG *)options;
		return D_CLOSE;
		break;
	case MSG_DRAW:
		Draw(d,false);
		break;
	}
	return D_O_K;
}

int VideoOptions(int m,DIALOG *d,int c)
{
	switch (m)
	{
	case MSG_CLICK:
		msg=NEXT;
		cur=(DIALOG *)video_options;
		return D_CLOSE;
		break;
	
	case MSG_DRAW:
		Draw(d,false);
		break;
	}
	return D_O_K;
}

int SoundOptions(int m,DIALOG *d,int c)
{
	switch (m)
	{
	case MSG_CLICK:
		msg=NEXT;
		cur=(DIALOG *)sound_options;
		return D_CLOSE;
		break;
	
	case MSG_DRAW:
		Draw(d,false);
		break;
	}
	return D_O_K;
}

int ControllerOptions(int m,DIALOG *d,int c)
{
	switch (m)
	{
	case MSG_CLICK:
		msg=NEXT;
		cur=(DIALOG *)controller_options;
		return D_CLOSE;
		break;
	
	case MSG_DRAW:
		Draw(d,false);
		break;
	}
	return D_O_K;
}

int CreditsText(int m,DIALOG *d, int c)
{
	switch(m)
	{
	case MSG_DRAW:
		blit ((BITMAP *)def[MENU_BG].dat,screen,0,0,70,0,640,480);
		textout_centre (screen,(FONT *)def[LARGE_FONT].dat,"CREDITS",350,20,makecol(255,255,255));
		textout_centre (screen,(FONT *)def[MED_FONT].dat,"Programming:",350,100,makecol(167,209,207));
		textout_centre (screen,(FONT *)def[MED_FONT].dat,"Karthik Raveendran",350,140,makecol(167,209,207));
		textout_centre (screen,(FONT *)def[MED_FONT].dat,"Artwork:",350,200,makecol(167,209,207));
		textout_centre (screen,(FONT *)def[MED_FONT].dat,"Bjorn Hannibal Madsen",350,240,makecol(167,209,207));
		break;

	}
	return D_O_K;
}

int SoundOptionsText(int m,DIALOG *d, int c)
{
	switch(m)
	{
	case MSG_DRAW:
		blit ((BITMAP *)def[MENU_BG].dat,screen,0,0,70,0,640,480);
		textout_centre (screen,(FONT *)def[LARGE_FONT].dat,"Sound Options",350,0,makecol(255,255,255));
		textout_centre (screen,(FONT *)def[MED_FONT].dat,"Music Volume",100,100,makecol(167,209,207));
		textout_centre (screen,(FONT *)def[MED_FONT].dat,"Sound Volume",100,200,makecol(167,209,207));
		break;
	}
	return D_O_K;
}

int VideoOptionsText(int m,DIALOG *d,int c)
{
	switch (m)
	{
	case MSG_DRAW:
		blit ((BITMAP *)def[MENU_BG].dat,screen,0,0,70,0,640,480);
		textout_centre (screen,(FONT *)def[LARGE_FONT].dat,"Video Options",350,20,makecol(255,255,255));
		textout_centre (screen,(FONT *)def[MED_FONT].dat,"Page Flipping",250,150,makecol(167,209,207));
		textout_centre (screen,(FONT *)def[MED_FONT].dat,"Vsync",250,200,makecol(167,209,207));
		textout_centre (screen,(FONT *)def[MED_FONT].dat,"Disable backgrounds",250,250,makecol(167,209,207));
		break;
	}
	return D_O_K;
}

int ControllerOptionsText(int m,DIALOG *d,int c)
{
	switch (m)
	{
	case MSG_DRAW:
		blit ((BITMAP *)def[MENU_BG].dat,screen,0,0,70,0,640,480);
		textout_centre (screen,(FONT *)def[LARGE_FONT].dat,"Controller",350,20,makecol(255,255,255));
		textout_centre (screen,(FONT *)def[MED_FONT].dat,"Controller:",250,150,makecol(167,209,207));
		break;
	}
	return D_O_K;
}

int OptionsText(int m,DIALOG *d,int c)
{
	switch (m)
	{
	case MSG_DRAW:
		blit ((BITMAP *)def[MENU_BG].dat,screen,0,0,70,0,640,480);
		textout_centre (screen,(FONT *)def[LARGE_FONT].dat,"OPTIONS",350,20,makecol(255,255,255));
		break;
	}
	return D_O_K;
}

void Draw(DIALOG *k,bool focus)
{
	textout_justify(screen,(FONT *)def[MED_FONT].dat,(char*)k->dp,k->x,(k->x + k->w), k->y + 15, 15, makecol(167,209,207));
}

// Handles the menu system
void MenuLoop()
{
	show_mouse(screen);
	cur=NULL;
	prev=NULL;
	while (quitmenu==false)
	{
		if (cur==NULL) 
		{
			cur=(DIALOG *)main_menu;
			prev=NULL;
			do_dialog(cur,-1);
		}
		if (msg==BACK) 
		{
			msg=-1;
			clear(screen);
			if (quitmenu==false)
			{
				do_dialog(cur,-1);
			}
		}
		else if (msg==NEXT)
		{
			msg=-1;
			clear(screen);
			do_dialog(cur,-1);
		}
	}
	page_flip_flag=video_options[2].d1;
	vsync_flag=video_options[3].d1;
	bg_flag=video_options[4].d1;
	controller=controller_options[2].d1;
	set_volume(sound_options[2].d2,sound_options[3].d2);
}

// Thanks to George Foot for this neat procedure
int d_noesc_proc (int msg, DIALOG *d, int c)
{
	if ((msg == MSG_XCHAR) && ((c >> 8) == KEY_ESC)) return D_USED_CHAR;
    return D_O_K;
}

int inc_music(void *dp3,int d2)
{
	if (d2>0 && d2<255) set_volume(-1,d2);
	return D_O_K;
}

int inc_sound(void *dp3,int d2)
{
	if (d2>0 && d2<255) set_volume(d2,-1);
	return D_O_K;
}


char *listbox_yesno(int index, int *list_size)
{
   static char *strings[] =
   {
      "No","Yes"
   };

   if (index < 0) {
      *list_size = 2;
      return NULL;
   }
   else
      return strings[index]; 
}

char *listbox_controller(int index, int *list_size)
{
   static char *strings[] =
   {
      "Keyboard","Mouse","Joystick"
   };

   if (index < 0) {
      *list_size = 3;
      return NULL;
   }
   else
      return strings[index]; 
}

// Load previously saved menu options
void LoadMenu()
{
	fstream menu;
	menu.open("menu.dat",ios::in);
	menu>>video_options[2].d1;
	menu>>video_options[3].d1;
	menu>>video_options[4].d1;
	menu>>sound_options[2].d2;
	menu>>sound_options[3].d2;
	menu>>controller_options[2].d1;
	menu.close();
	page_flip_flag=video_options[2].d1;
	vsync_flag=video_options[3].d1;
	bg_flag=video_options[4].d1;
}

// Save the menu options
void SaveMenu()
{
	fstream menu;
	menu.open("menu.dat",ios::out);
	menu<<video_options[2].d1<<" ";
	menu<<video_options[3].d1<<" ";
	menu<<video_options[4].d1<<" ";
	menu<<"\n"<<sound_options[2].d2<<" ";
	menu<<sound_options[3].d2;
	menu<<"\n"<<controller_options[2].d1;
	menu.close();
}