// main.cpp

#include "breakin.h"
#include "game.h"  
#include "sprite.h"
#include "list.h"
#include "variable.h"

// The entry point of the game
int main(int argc,char *argv[])
{
	if (argc>1) depth=32;
	else depth=16;
	gametype=0;
	
	LoadScores();
	LoadMenu();
	if (Init()==1) 
	{
		allegro_exit();
		return 1;
	}
	
	Intro(); 
	while (gametype==0 && quitmenu==false)
	{
		MenuLoop();	
		score1=0;
		frame_count=fps=0;
		if (gametype!=0)
		{
			show_mouse(NULL);
			char episode[255]="";
			
			switch (gametype)
			{
			// Episode 1
			case 1:
				LoadEpisode("ep1.epi");
				break;

			// Episode 2
			case 2:
				LoadEpisode("ep2.epi");
				break;
			
			// Episode 3
			case 3:
				LoadEpisode("ep3.epi");
				break;
			
			// Load a custom episode
			case 4:
				if (file_select("Select an episode file(*.EPI)",episode,"epi;")!=0)
				{
					LoadEpisode(episode);
				}  
				quitmenu=false;
				gametype=0;
				break;
			
			// Random level
			case 5:
				last_level=true; // Only one level
				RandomGame();
				if (SetupGame()==1) { allegro_exit(); exit(1); } ;
				MainLoop();
				break;
			}
			show_mouse(screen);
		}
	}
	SaveMenu();
	SaveScores();
	QuitGame();
	return 0;
}END_OF_MAIN(); // A macro to avoid Win32 WinMain()


