// load.cpp - Loads levels/episodes

#include "list.h"
#include "game.h"
#include "sprite.h"
#include "variable.h"

// If the order of variables is changed, then do the same in the editor and recompile
void LoadLevel(char *levelname)
{	
	no_of_bricks=0;
	break_bricks=0;
	level.open(levelname, ios::in);
	level>>path>>level_name>>no_of_lives>>paddle_x>>paddle_y>>ball_speed_x>>paddle_speed>>no_of_bricks;
	if (stricmp(path,"breakin.dat")!=0) user_datafile=load_datafile(path);
	

// Read data for all the bricks	
	for (i=0;i<no_of_bricks;i++)
	{
		level>>temp.x>>temp.y>>temp.w>>temp.h>>temp.name>>temp.hits>>temp.score>>temp.powerup;			
		for (int j=0; user_datafile[j].type != DAT_END; j++) 
		{
			if (stricmp(get_datafile_property(user_datafile+j, DAT_ID('N','A','M','E')),temp.name) == 0) 
			{
					brick_bitmap=(BITMAP *)user_datafile[j].dat;
			}
		}	
		spr_list.push_back(new Brick(temp.x,temp.y,temp.w,temp.h,temp.hits,temp.score,temp.powerup,brick_bitmap));
	}	
	
// Read preferences
	
	level>>ball_datafile;
	level>>ball_small_n>>ball_medium_n>>ball_large_n;
	level>>paddle_datafile;
	level>>paddle_small_n>>paddle_medium_n>>paddle_large_n;
	level>>music_datafile>>music_name;
	level>>bg_datafile>>bg_name;
	level>>ui_datafile>>ui_name;
	level.close();
	
// Set the corresponding bitmaps
	if (ball_datafile==1) data=user_datafile;
	else data=def;
	
	ball_small=(BITMAP *)(find_datafile_object(data, ball_small_n))->dat;
	ball_medium=(BITMAP *)(find_datafile_object(data, ball_medium_n))->dat;
	ball_large=(BITMAP *)(find_datafile_object(data, ball_large_n))->dat;
	
	if (paddle_datafile==1) data=user_datafile;
	else data=def;

	paddle_small=(BITMAP *)(find_datafile_object(data, paddle_small_n))->dat;
	paddle_medium=(BITMAP *)(find_datafile_object(data, paddle_medium_n))->dat;
	paddle_large=(BITMAP *)(find_datafile_object(data, paddle_large_n))->dat;
	
	if (music_datafile==1) data=user_datafile;
	else data=def;

	music=(MIDI *)(find_datafile_object(data, music_name))->dat;
	
	if (bg_datafile==1) data=user_datafile;
	else data=def;
	background=(BITMAP *)(find_datafile_object(data, bg_name))->dat;
	
	if (ui_datafile==1) data=user_datafile;
	else data=def;
	ui=(BITMAP *)(find_datafile_object(data, ui_name))->dat;

	laser_bmp=(BITMAP *)def[LASER].dat;
	

// Add ball ( the game allows more than one ball )	
	no_of_balls=0;
	ball_list.push_back(new Ball(paddle_x,paddle_y-60,ball_speed_x));
	no_of_balls++;
	
// Add paddle
	paddle = new Paddle(paddle_x,paddle_y-(ball_medium->h),paddle_speed);

// Set misc flags
	quitit=false;
	level_flag=false;
	laser_flag=false;
	sticky_ball_flag=false;
}  

// Loads an episode
void LoadEpisode(char *filename)
{
	fstream episode;
	int count=0;
	int k=0;
	level_flag=false;

	episode.open(filename,ios::in);
	while (!episode.eof())
	{
		episode>>level_list[count];
		count++;
	}
	episode.close();

	do
	{
		if (k==count-2) last_level=true;
		LoadLevel(level_list[k]);
		if (SetupGame()==1) { allegro_exit(); exit(1); } ;
		LoadPowerups();
		MainLoop();
		k++;			
	}while (k<count-1 && lose==false);
}

// Read powerups from file
void LoadPowerups()
{
	fstream p;
	int n=1;

	p.open("powerups.dat",ios::in);
	while (!p.eof())
	{
		p>>powerup_info[n].datafile;
		p>>powerup_info[n].name;
		p>>powerup_info[n].no;
		p>>powerup_info[n].time;		
		p>>powerup_info[n].paddle_size;
		p>>powerup_info[n].paddle_speed;
		p>>powerup_info[n].ball_size;
		p>>powerup_info[n].ball_speed;
		p>>powerup_info[n].no_of_balls;
		p>>powerup_info[n].extra_life;
		p>>powerup_info[n].next_level;
		p>>powerup_info[n].laser;
		p>>powerup_info[n].sticky_ball;
		p>>powerup_info[n].power_ball; 
		n++;
	}
	p.close(); 
}