// hiscores.cpp - deals with hiscores of the player

#include "game.h"  
#include "sprite.h"
#include "variable.h"

// Displays top 10 scores
void ShowScores()
{
	show_mouse(NULL);
	clear(screen);
	textout (screen,(FONT *)def[LARGE_FONT].dat,"High Scores",130,20,makecol(255,255,255));
	for (i=0;i<10;i++)
	{
		textprintf(screen, (FONT *)def[MED_FONT].dat, 80,100+ 30*i, makecol(255,255,255),"%s",scores[i].name);
		textprintf(screen, (FONT *)def[MED_FONT].dat, 480,100+ 30*i, makecol(255,255,255),"%d",scores[i].score);
	}
	readkey();
	show_mouse(screen);
}

// Save scores to file
void SaveScores()
{
	high.open("scores.dat",ios::out);
	for (i=0;i<10;i++)
	{
		high<<scores[i].name<<" ";
		high<<scores[i].score<<"\n";
	}
	high.close();
}

// Load high scores from file
void LoadScores()
{
	high.open("scores.dat",ios::in);
	for (i=0;i<10;i++)
	{
		high>>scores[i].name;
		high>>scores[i].score;
	}
	high.close();
}