// g_funcs.cpp - The main game functions

#define local

#include "game.h"  
#include "sprite.h"
#include "list.h"
#include "variable.h"
#include <string.h>
#include <stdlib.h>

// Needed to handle time and manage screen updates
void increment_game_time()
{
	game_time++;
}
END_OF_FUNCTION(increment_game_time);

void increment_speed_counter()
{
	speed_counter++;
}
END_OF_FUNCTION(increment_speed_counter);

void intro_timer()
{
	intro_time++;
}
END_OF_FUNCTION(intro_timer);


void fps_proc(void)
{
   fps = frame_count;
   frame_count = 0;
}
END_OF_FUNCTION(fps_proc);


// Initialize game lib. and misc stuff
int Init()
{
 	allegro_init();
	install_timer();
	install_keyboard();
	install_mouse();
	set_color_depth(depth);
	if (set_gfx_mode(GFX_AUTODETECT,640,480,0,0)!=0) return 1;
	install_sound(DIGI_AUTODETECT,MIDI_AUTODETECT,NULL);
	set_trans_blender(255,255,255,0);
	
	return 0;
}

// Set animation mode
// Note: You can do this only once in the game 
// i.e restart game if options are changed
bool SetAnimationMode(int mode)
{
	switch (mode)
	{
	case DOUBLE_BUFFER:
		buffer=create_bitmap(640,480);
		if (buffer==NULL) return false;
		clear(buffer);
		return true;

	case PAGE_FLIP:
		page1=create_video_bitmap (640,480);
		page2=create_video_bitmap (640,480);
		buffer=page2;
		
		if ((!page1) || (!page2)) return false;
		page_flip=true;

		clear(page1); 
		clear(page2);
		return true;
	}
	return false;
}

// Sets up the parameters for the game
int SetupGame()
{
	if (page_flip_flag==1)
	{
		if (SetAnimationMode(PAGE_FLIP)==true) return 0;
	}
	if (SetAnimationMode(DOUBLE_BUFFER)==false) return 1;
	
	if (page_flip==true) buffer=page2;
	clear_keybuf();
	UpdateScreen();
	last_level=false;
	lose=false;
	textprintf_centre(screen,(FONT*)def[MED_FONT].dat, 320, 200, makecol(255,255,255) , "Level name:%s",level_name);
	readkey();
	return 0;
}

// The 'fancy' intro :)
void Intro()
{
	scare_mouse();
	def=load_datafile ("breakin.dat");
	LOCK_VARIABLE(intro_time);
    LOCK_FUNCTION(intro_timer);

	install_int_ex(intro_timer,SECS_TO_TIMER(1));
	clear(screen);
	BITMAP *logo=(BITMAP *)def[LOGO].dat;
	blit (logo,screen,0,0,0,0,640,480);
	while (!keypressed() && intro_time<4);
	clear_keybuf();
	intro_time=0;
	clear_to_color(screen,makecol(255,255,255));
	blit ((BITMAP *)def[GAMELOGO].dat,screen,0,0,200,200,640,480);
	while (!keypressed() && intro_time<4);
	clear(screen);

	logo=NULL;
	remove_int(intro_timer);
}

// The main events loop
void MainLoop()
{
	LOCK_VARIABLE(speed_counter);
    LOCK_FUNCTION(increment_speed_counter);
	LOCK_VARIABLE(game_time);
	LOCK_FUNCTION(increment_game_time);
    
	install_int_ex (increment_speed_counter,BPS_TO_TIMER(60)); // Setup timers
	install_int (fps_proc,1000);
	install_int_ex(increment_game_time, MSEC_TO_TIMER(1));		
	StartMusic();
	
	gametype=0;
	quitmenu=false;
	while (quitit!=true)
	{
        UpdateScreen();
		while (speed_counter > 0) 
		{
			if (key[KEY_P]) PauseGame();
			if (key[KEY_ESC]) quitit=true;
			if ((key[KEY_SPACE] || mouse_b & 1) && laser_flag==true) // Missile has been launched
			{
				laser = new Laser(paddle_x,paddle_y);
				active_laser=true;
			}
			if (key[KEY_X]) life_lost=true; // Aargh - commit suicide!
			if (key[KEY_F1]) // Screen shots
			{
				fstream shot;
				int no;
				char no1[4];
				char filename[15]="screen";

				shot.open("screenshots.dat",ios::in);
				shot>>no;
				shot.close();
				
				no+=1;
				itoa(no,no1,10);
				
				strcat(filename,no1);
				strcat (filename,".tga");
				save_bitmap(filename,screen,NULL);
				
				shot.open("screenshots.dat",ios::out);
				shot<<no;
				shot.close();
			}
			if (no_of_powerups>0) HandlePowerups(); // Powerups are active
			if (current_flag==true)
			{
				if (game_time > last_time + powerup_time) 
				{
					current_flag=false;
					InactivatePowerups();
				}
			}		
			
			if (active_laser==true) laser->HandleSprite();
			paddle->HandleSprite();
			HandleBalls();
			HandleBricks();
			if (quitit==true) break;
			speed_counter--;
			
		}
		frame_count++;
		
	}
	QuitLoop();	

	if (no_of_lives==0 || break_bricks!=0) Lose();
	else Win();
		
	if (last_level==true)
	{
	// Did the player get a high score?
	for (i=0;i<10;i++)
	{
		if (score1 >scores[i].score) 
		{
			char temp[20];
			int temp1;
			
			LaunchDialog();
			
			strcpy(scores[10].name,name_s);
			scores[10].score=score1;
			
			for (i=10;i>=0;i--)
			{
				for (int j=10;j>=0;j--)
				{
					if (scores[j].score>scores[i].score)
					{
						strcpy(temp,scores[j].name);
						temp1=scores[j].score;
						
						scores[j].score=scores[i].score;
						strcpy(scores[j].name,scores[i].name);

						scores[i].score=temp1;
						strcpy(scores[i].name,temp);
					}
				}
			}

			ShowScores();
			break;
		
		}
	}
	}
}

// Plays the game MIDI
void StartMusic()
{
	play_midi(music,1);
}

void StopMusic()
{
	stop_midi();
}

// Redraw objects
void UpdateScreen()
{
	acquire_bitmap(buffer);
	clear(buffer);

	// Draw background 
	if (bg_flag==0)
		blit (background,buffer,0,0,0,30,640,450);
	
	// Draw bricks
	spr=spr_list.begin();
	while (spr!=spr_list.end()) 
	{ 		
		(*spr)->DrawSprite(); 
		spr++; 
	}
	
	// Fade bricks
	fade_spr=fade_list.begin();
	while (fade_spr!=fade_list.end()) 
	{ 
		
		(*fade_spr)->Fade(); 
		fade_spr++; 
	} 

	// Draw balls
	ball_spr=ball_list.begin();
	while (ball_spr!=ball_list.end()) 
	{ 
		(*ball_spr)->DrawSprite(); 
		ball_spr++; 
	}

	// Draw powerups (if any)
	if (no_of_powerups>0)
	{
		powerup_spr=powerup_list.begin();
		while (powerup_spr!=powerup_list.end()) 
		{
			(*powerup_spr)->DrawSprite(); 
			powerup_spr++; 
		} 
	} 

	paddle->DrawSprite();
	
	if (active_laser==true) laser->DrawSprite();

	// Draw User Interface
	DrawUI();

	textprintf(buffer, font, 0, 35, makecol(255,255,255), "FPS=%d",fps);
	release_bitmap(buffer);
		
	if (page_flip==true)
	{
		if (vsync_flag==1) vsync();
		show_video_bitmap(buffer);
		if (buffer==page1) buffer = page2;
		else buffer = page1;
	}
	else 
	{
		if (vsync_flag==1) vsync();
		acquire_screen();
		blit (buffer,screen,0,0,0,0,640,480);
		release_screen();
	}
}

// Draws the User Interface
void DrawUI()
{
	blit ((BITMAP *)def[UI].dat,buffer,0,0,0,0,640,30);
	
	// Draw number of lives
	for (i=0;i<no_of_lives;i++) 
		masked_blit ((BITMAP *)def[BALL_MEDIUM].dat,buffer,0,0,515 + (i*20),2,((BITMAP*)(def[BALL_MEDIUM].dat))->w,((BITMAP*)(def[BALL_MEDIUM].dat))->h);
	
	// Score
	textprintf_right(buffer,font, 83, 10, makecol(255,0,0), "%d", score1);
	
	// Bricks remaining
	textprintf_right(buffer,font, 163, 10, makecol(255,0,0), "%d",break_bricks);
	
	if (current_flag==true && sticky_ball_flag==false)
	{
		masked_blit (current->bmp,buffer,0,0,269,0,(current->bmp)->w,(current->bmp)->h);
		// 100 x 13 , 312 ,450 -  The powerup bar  
		rectfill (buffer,312,0,412 - (((game_time - last_time)* 100)/powerup_time),13,makecol(255,0,0));
	}
	
	blit ((BITMAP *)def[LEFT_WALL].dat,buffer,0,0,0,30,((BITMAP*)(def[LEFT_WALL].dat))->w,((BITMAP*)(def[LEFT_WALL].dat))->h);
	blit ((BITMAP *)def[RIGHT_WALL].dat,buffer,0,0,632,30,((BITMAP*)(def[LEFT_WALL].dat))->w,((BITMAP*)(def[LEFT_WALL].dat))->h);
}	

// Collision detection routine
UINT CheckCollision(BITMAP *bmp1,int x1,int y1,BITMAP *bmp2,int x2,int y2)
{
	int left1, left2;
    int right1, right2;
    int top1, top2;
    int bottom1, bottom2;
    int w1,w2,h1,h2;
    
	w1=bmp1->w;
	w2=bmp2->w;
	h1=bmp1->h;
	h2=bmp2->h;
	
    left1 = x1;
    left2 = x2;
    right1 = x1 + w1;
    right2 = x2 + w2;
    top1 = y1;
    top2 = y2;
    bottom1 = y1 + h1;
    bottom2 = y2 + h2;
	
	// Trivial rejections:
    if (bottom1 < top2) return(0);
    if (top1 > bottom2) return(0);
	
    if (right1 < left2) return(0);
    if (left1 > right2) return(0);
	
	return (1);
}

// Handle game pauses
void PauseGame()
{
	temp_counter=speed_counter;
	readkey();
	speed_counter=temp_counter;
}

// Quit game loop
void QuitLoop()
{
	
    if (page_flip==false) destroy_bitmap(buffer);
	else { destroy_bitmap(page1); destroy_bitmap(page2); }

	clear(screen);

	delete paddle;

	spr=spr_list.begin();
	while (spr!=spr_list.end()) 
	{ 		
		delete *spr;
		spr++; 
	}
	
	fade_spr=fade_list.begin();
	while (fade_spr!=fade_list.end()) 
	{ 
		
		delete *fade_spr; 
		fade_spr++; 
	} 

	ball_spr=ball_list.begin();
	while (ball_spr!=ball_list.end()) 
	{ 
		delete *ball_spr;
		ball_spr++; 
	}

	if (no_of_powerups>0)
	{
		powerup_spr=powerup_list.begin();
		while (powerup_spr!=powerup_list.end()) 
		{
			delete *powerup_spr; 
			powerup_spr++; 
		} 
	}

	ball_list.clear();
	spr_list.clear();
	powerup_list.clear();
	fade_list.clear();
	StopMusic();

	data=NULL;
	ui=NULL;
	background=NULL;
	music=NULL;
	ball_small=NULL;
	ball_medium=NULL;
	ball_large=NULL;
	paddle_small=NULL;
	paddle_medium=NULL;
	paddle_large=NULL;
	laser_bmp=NULL;
	brick_bitmap=NULL;
		
	if (strcmp(path,"C:\breakin\breakin.dat")!=0) 
	{
		unload_datafile(user_datafile);		
	}
	remove_int(increment_speed_counter);
	remove_int(increment_game_time);
	remove_int(fps_proc);
	
	no_of_powerups=0;
	quitit=false;
	level_flag=false;
	laser_flag=false;
	sticky_ball_flag=false;
	current_flag=false;

	show_mouse(screen);
}

// Exit Breakin completely
void QuitGame()
{

	unload_datafile(def);
	clear(screen);
	allegro_exit();
}

// Called from the MainLoop to handle ball events
void HandleBalls()
{
	ball_spr=ball_list.begin();
    while (ball_spr!=ball_list.end())
	{
		(*ball_spr)->HandleSprite();
		if (life_lost==true)
		{
			delete *ball_spr;
			ball_spr=ball_list.erase(ball_spr);
			no_of_balls-=1;
			life_lost=false;
			if (no_of_balls == 0)
			{
				no_of_lives-=1;
				if (no_of_lives==0) 
				{ 
					quitit=true; 
					return; 
				}
				else
				{
					no_of_balls++;
					ball_list.push_back(new Ball(paddle_x,paddle_y-(ball_large->h),ball_speed_x));
					
					ball_spr=ball_list.begin();
					temp_counter=speed_counter;
					ball_spr1=ball_spr;
					while (1==1)
					{						
						if (mouse_b & 1) break;
						if (key[KEY_SPACE]) break;
						paddle->GetInput();
						(*ball_spr1)->x=paddle->x;
						game_time=last_time;
						UpdateScreen();
					}
					speed_counter=temp_counter;
					ball_spr=ball_spr1;					
					// Waits till user releases ball
					
				}
			}
		}
		else ++ball_spr;
	}
}


// Useful for debugging
void Print(char *format, ...)
{
	char buffer[1024];
	va_list arglist;
	
	va_start (arglist,format);
	vsprintf (buffer,format, arglist);
	
	textout (screen,font,buffer,0,0,255);
}

void Win()
{
	blit((BITMAP*)def[WIN].dat,screen, 0, 0, 110, 33, 419, 414);
	clear_keybuf();
	readkey();
}

void Lose()
{
	lose=true;
	blit((BITMAP*)def[LOSE].dat,screen, 0, 0, 110, 33, 419, 414);
	clear_keybuf();
	readkey();
}

