#include "BPlayersList.h"


BPlayersList::BPlayersList(const char *file) {
	ustrcpy(this->file, file);
	Load();
}


BPlayersList::~BPlayersList() {
	Save();

	while (!list.Empty())
		Remove(0);
}


void BPlayersList::Load() {
	PACKFILE *f = pack_fopen(file, "r");
	if (!f) return;

	list.Reset();

	int n;
	char buf[4];
	pack_fread(buf, 4, f);
	if (ustrncmp(buf, "BWPL", 4) == 0) {
		n = pack_getc(f);

		for (int i=0; i<n; i++) {
			BPlayer *player = new BPlayer;
			player->Load(f);
			list.Add(player, i);
		}
	}

	pack_fclose(f);
}


void BPlayersList::Save() {
	PACKFILE *f = pack_fopen(file, "w");

	int n = list.Size();
	pack_fwrite("BWPL", 4, f);
	pack_putc(n, f);
	for (int i=0; i<n; i++) {
		list.Get(i)->Data()->Save(f);
	}

	pack_fclose(f);
}


void BPlayersList::Add(BPlayer *p) {
	BPlayer *player = new BPlayer;

	player->SetText(p->GetText());
	int l,r,j,s;
	p->GetKeys(l,r,j,s);
	player->SetKeys(l,r,j,s);
	player->Type(p->Type());
	player->Color(p->Red(), p->Green(), p->Blue());
	player->games_played = p->games_played;
	player->games_won = p->games_won;
	player->points_plus = p->points_plus;
	player->points_minus = p->points_minus;

	list.Add(player, list.Size());
}


void BPlayersList::Remove(int i) {
	BPlayer *player = list.Get(i)->Data();
	list.Remove(i);
	delete player;
}


void BPlayersList::Update(BPlayer *p, int i) {
}


BPlayer* BPlayersList::Get(int i) {
	return list.Get(i)->Data();
}

