#ifndef		BOBILLY_MAIN_DIALOG
#define		BOBILLY_MAIN_DIALOG


#include <MASkinG.h>
#include "BSettings.h"
#include "BPlayersList.h"
#include "BPlayerEdit.h"
#include "defines.h"
#include "BDumbPlayer.h"


class BGameSettingsDlg : public MASDialog {
	protected:
		MASBox panel;
		MASText tGameName, tHostIP, tPlayer1, tPlayer2, tSingleplayer, tMultiplayer;
		MASEditText eGameName, eHostIP;
		MASWinButton bHost, bJoin, bPractise;
		MASHiddenList lPlayer1, lPlayer2;

		BSettings *settings;
		BPlayersList *pList;

	public:
		BGameSettingsDlg();
		~BGameSettingsDlg();

		void Settings(BSettings *s, BPlayersList *pList);
		friend class BMainDlg;
		friend class BGame;
};


class BGraphicsSettingsDlg : public MASDialog {
	protected:
		MASBox panel;
		MASCheckBox cFullscreen, cHardware;
		MASText tColorDepth, tSkin, tRefresh;
		MASHiddenList lColorDepth, lSkin;
		MASEditText eRefresh;
		MASWinButton bProfile, bApply;

		BSettings *settings;
		void FillSkinList();
		void SaveSettings();

	public:
		BGraphicsSettingsDlg();
		~BGraphicsSettingsDlg();

		void Settings(BSettings *s);
		friend class BMainDlg;
};


class BSoundSettingsDlg : public MASDialog {
	protected:
		MASBox panel;
		MASCheckBox cSound, cMusic;
		MASSlider sSoundVolume, sMusicVolume;
		MASText tSoundVolume, tMusicVolume;

		BSettings *settings;

	public:
		BSoundSettingsDlg();
		~BSoundSettingsDlg();

		virtual void InitSkin(MASkin *s = NULL);
		void Settings(BSettings *s);
		friend class BMainDlg;
		friend class BGame;
};


class BPlayersSettingsDlg : public MASDialog {
	protected:
		MASBox panel;
		MASText tListTitle;
		MASList lPlayers;
		MASWinButton bAdd, bRemove, bEdit;

		BPlayersList *pList;

	public:
		BPlayersSettingsDlg();
		~BPlayersSettingsDlg();

		virtual void InitSkin(MASkin *s = NULL);
		void SetList(BPlayersList *pList);
		void AddPlayer(MASDialog *parent);
		void RemovePlayer(MASDialog *parent);
		void EditPlayer(MASDialog *parent);
		friend class BMainDlg;
};


class BMainDlg : public MASDialog {
	protected:
		MASClearScreen desktop;
		MASPanelRaised panel;
		BGameSettingsDlg gameDlg;
		BGraphicsSettingsDlg graphicsDlg;
		BSoundSettingsDlg soundDlg;
		BPlayersSettingsDlg playersDlg;
		DumbPlayer mPlayer;

		MASWinButton bExit;
		MASText lProgramming, lGraphics, lSound, lBuildDate, lAllegro, lOS, lCPU;
		MASText tGameTitle, tGameVersion, tProgramming, tGraphics, tSound, tBuildDate, tSystem, tAllegro, tOS, tCPU;

		int ret;
		BPlayersList *pList;

	public:
		BMainDlg(BSettings *settings, BPlayersList *pList);
		~BMainDlg();

		enum { PRACTISE, HOST, JOIN, EXIT, PROFILE, APPLY };
		int Execute();

		virtual void HandleEvent(MASDialogObject& obj, int msg, int arg=0);
		virtual void InitSkin(MASkin *s = NULL);

		friend class BGame;
};


#endif		//BOBILLY_MAIN_DIALOG
