#include "BGameDlg.h"
#include "defines.h"
#include <time.h>


// constructor
BGameDlg::BGameDlg(BPlayer *p1, BPlayer *p2, BBall *ball) : MASDialog() {
	this->p1 = p1;
	this->p2 = p2;
	this->ball = ball;

	// setup the GUI objects
	tP1Name.Setup (   0, 8, 200, 32, 0, 0, p1->GetText(), 1);
	tP2Name.Setup (-200, 8, 200, 32, 0, 0, p2->GetText(), 0);
	tP1Score.Setup( 220, 8, 100, 32, 0, 0, "0", 0);
	tP2Score.Setup(-320, 8, 100, 32, 0, 0, "0", 1);
	p1->Place(100, 300);
	p2->Place(700, 300);
	ball->Place(100, 100);
	
	mPlayer.AddFile("music/Maya.s3m");

	// add the GUI objects to the dialog
	Add(background);
	Add(tP1Name);
	Add(tP2Name);
	Add(tP1Score);
	Add(tP2Score);
	Add(*p1);
	Add(*p2);
	Add(*ball);
	Add(mPlayer);
	Add(*(MASDialogObject *)this);

	LoadSamples();
	_escape_exits = false;
	ret = true;
	paused = true;
}


// destructor
BGameDlg::~BGameDlg() {
}

void BGameDlg::InitSkin(MASkin *s) {
	tP1Name.SetFont(BOBILLY_FONT1, MASkin::NORMAL);	tP1Name.SetFontColor(-1, -1, MASkin::NORMAL);
	tP2Name.SetFont(BOBILLY_FONT1, MASkin::NORMAL);	tP2Name.SetFontColor(-1, -1, MASkin::NORMAL);
	tP1Score.SetFont(BOBILLY_FONT1, MASkin::NORMAL);	tP1Score.SetFontColor(-1, -1, MASkin::NORMAL);
	tP2Score.SetFont(BOBILLY_FONT1, MASkin::NORMAL);	tP2Score.SetFontColor(-1, -1, MASkin::NORMAL);
}



// message handler
void BGameDlg::HandleEvent(MASDialogObject& obj, int msg, int arg) {
	if (obj == *ball) {
		switch (msg) {
		case BBall::UPDATE_SCORE1:
			background.DrawRect(tP1Score.x(), tP1Score.y(), tP1Score.w(), tP1Score.h());
			tP1Score.SetNumber(p1->Score());
			break;
		case BBall::UPDATE_SCORE2:
			background.DrawRect(tP2Score.x(), tP2Score.y(), tP2Score.w(), tP2Score.h());
			tP2Score.SetNumber(p2->Score());
			break;
		case BBall::GAME_OVER:
			GameOver();
			break;
		case BBall::ESCAPE_GAME:
			Escape();
			break;
		};
	}
	else if (obj == *p1 && msg == MSG_ACTIVATE)  {
		ball->Serve(p1);
		background.DrawRect(ball->OldX()-(ball->w()>>1), ball->OldY()-(ball->h()>>1), ball->w(), ball->h());
		background.DrawRect(ball->OldX()-2, 4, 5, 5);
	}
	else if (obj == *p2 && msg == MSG_ACTIVATE)  {
		ball->Serve(p2);
		background.DrawRect(ball->OldX()-(ball->w()>>1), ball->OldY()-(ball->h()>>1), ball->w(), ball->h());
		background.DrawRect(ball->OldX()-2, 4, 5, 5);
	}
}


int BGameDlg::Execute(int sfxVolume, int musicVolume) {
	tP1Name.SetW(MASStrlen(tP1Name.GetText(), theSkin->GetFont(BOBILLY_FONT1)));
	tP1Name.SetX(tP1Score.x() - tP1Name.w() - 16);
	tP1Name.SetH(theSkin->GetFont(BOBILLY_FONT1)->TextHeight());
	tP1Score.SetW(MASStrlen("29", theSkin->GetFont(BOBILLY_FONT1)));
	tP1Score.SetH(theSkin->GetFont(BOBILLY_FONT1)->TextHeight());
	tP2Name.SetW(MASStrlen(tP2Name.GetText(), theSkin->GetFont(BOBILLY_FONT1)));
	tP2Score.SetW(MASStrlen("29", theSkin->GetFont(BOBILLY_FONT1)));
	tP2Name.SetX(tP2Score.x() + tP2Score.w() + 16);
	tP2Score.SetH(theSkin->GetFont(BOBILLY_FONT1)->TextHeight());
	tP2Score.SetH(theSkin->GetFont(BOBILLY_FONT1)->TextHeight());

	Resume();
	MAS_volume = sfxVolume;
	mPlayer.SetVolume(musicVolume);
	mPlayer.Next();
	mPlayer.Play();
	MASDialog::Execute();
	mPlayer.Stop();
	return ret ? 1 : 0;
}


void BGameDlg::Resume() {
	MASHideMouse();
	paused = false;
}


void BGameDlg::Pause() {
	paused = true;
	MASShowMouse();
}


void BGameDlg::GameOver() {
	MASAlert msg;
	Pause();
	char buf[128];
	if (p1->Score() > p2->Score()) {
		usprintf(buf, "%s wins!", p1->GetText());
		p1->games_won++;
	}
	else {
		usprintf(buf, "%s wins!", p2->GetText());
		p2->games_won++;
	}
	p1->games_played++;
	p1->points_plus += p1->Score();
	p1->points_minus += p2->Score();
	p2->games_played++;
	p2->points_plus += p2->Score();
	p2->points_minus += p1->Score();
	msg.SetType(MASAlert::OK);
	msg.Popup(buf, this, "Game over");
	ret = true;
	Close();
}


void BGameDlg::Escape() {
	MASAlert msg;
	Pause();
	if (msg.Popup("Really exit?", this, "Exit")) {
		ret = false;
		Close();
	}
	else
		Resume();
}


void BGameDlg::MsgTick() {
	if (paused) return;

	// update objects
	p1->GetInput(400-p1->x(), p1->y(), p2->x()-400, p2->y(), ball->x()-p1->x(), ball->y(), ball->Speed(), ball->Angle());
	p1->Update();
	float bd = DTOR(180) - ball->Angle();
	bd = bd < 0 ? bd + DTOR(360) : bd;
	p2->GetInput(p2->x()-400, p2->y(), 400-p1->x(), p1->y(), p2->x()-ball->x(), ball->y(), ball->Speed(), bd);
	p2->Update();
	int update = ball->Update(p1, p2);

	// replace the background (DRS) and redraw the object
	int dw = (ball->w())>>1;
	int dh = (p1->h())>>1;
	background.DrawRect(ball->OldX()-dw, ball->OldY()-dw, ball->w(), ball->h());
	if (update >= 0) background.DrawRect(  p1->OldX()-dw,   p1->OldY()-dh, p1->w(), p1->h());
	if (update >= 1) background.DrawRect(  p2->OldX()-dw,   p2->OldY()-dh, p2->w(), p2->h());

	background.DrawRect(ball->OldX()-2, 4, 5, 5);
	rectfill(dscreen, ball->x()-2, 4, ball->x()+2, 8, makecol(255,255,255));
	DRSAddRect(ball->x()-2, 4, ball->x()+2, 8);

	if (MASIsInRect(ball->OldX(), ball->OldY(), tP1Name.x()-dw, tP1Name.y()-dw, tP1Score.x2()+dw, tP1Score.y2()+dw)) {
		background.DrawRect(tP1Score.x(), tP1Score.y(), tP1Score.w(), tP1Score.h());
		background.DrawRect(tP1Name.x(), tP1Name.y(), tP1Name.w(), tP1Name.h());
		tP1Score.MsgDraw();
		tP1Name.MsgDraw();
	}
	if (MASIsInRect(ball->OldX(), ball->OldY(), tP2Score.x()-dw, tP2Score.y()-dw, tP2Name.x2()+dw, tP2Name.y2()+dw)) {
		background.DrawRect(tP2Score.x(), tP2Score.y(), tP2Score.w(), tP2Score.h());
		background.DrawRect(tP2Name.x(), tP2Name.y(), tP2Name.w(), tP2Name.h());
		tP2Score.MsgDraw();
		tP2Name.MsgDraw();
	}

	ball->MsgDraw();
	if (update >= 0) p1->MsgDraw();
	if (update >= 1) p2->MsgDraw();
}

void BGameDlg::LoadSamples() {
	DATAFILE *samples = load_datafile("sfx.dat");
	if (!samples) return;

	DATAFILE *d;
	int i;
	char *sampleName[] = { 	"HIT",
						"JUMP",
						"NET",
						"WHISTLE"};


	// Look for each sample inside the dat file and load it if it exists
	for (i=0; i<4; i++) {
		d = find_datafile_object(samples, sampleName[i]);
		if (d != NULL) {
			theSkin->SetSample((SAMPLE *)d->dat, SAMPLE_HIT+i, true);
		}
	}

	unload_datafile(samples);
}
