#include "BGame.h"

// Constructor
BGame::BGame(BSettings *settings) {
	this->settings = settings;
}


// Destructor
BGame::~BGame() {
}


// The main loop
bool BGame::Run() {
	bool done = false;
	int mode = BMainDlg::EXIT;
	bool ret = false;

	// initialize
	Initialize();

	mainDlg = new BMainDlg(settings, pList);

	while (!done) {
		mode = mainDlg->Execute();

		// look at what the main dialog returned and run the corresponding
		// dialog or exit
		switch (mode) {
			case BMainDlg::PRACTISE:	OnPractise();			break;
			case BMainDlg::HOST:								break;
			case BMainDlg::JOIN:								break;
			case BMainDlg::EXIT:		done = true;			break;
			case BMainDlg::PROFILE:		OnProfile();			break;
			case BMainDlg::APPLY:
				ret = true;
				done = true;
				break;
		};
	}

	delete mainDlg;
	CleanUp();
	return ret;
}


// Initialize the graphics
void BGame::Initialize() {
    DATAFILE *bmps;
	DATAFILE *d;
	int i;
	char bitmapName[8];

	pList = new BPlayersList("Bobilly.plr");

	// Load the font
	PALETTE pal;
	load_bitmap("font1.pcx", pal);
	set_palette(pal);
	theSkin->LoadFont("font1.pcx", BOBILLY_FONT1);
	theSkin->LoadFont("font2.pcx", BOBILLY_FONT2);

	// load a set of source bitmaps for the players
	bmps = load_datafile("bobilly.dat");
    for (i=0; i<BOBILLY_FRAMES; i++) {
		usprintf(bitmapName, "FRAME%02d", i);
        d = find_datafile_object(bmps, bitmapName);
        theSkin->SetBitmap((BITMAP *)d->dat, i+BOBILLY_BITMAP, true);
    }

	// make 2 copies of the player bitmaps
	for (i=0; i<BOBILLY_FRAMES; i++) {
		theSkin->SetBitmap(theSkin->GetBitmap(BOBILLY_BITMAP+i), BOBILLY_BITMAP+BOBILLY_FRAMES+i, true);
		theSkin->SetBitmap(theSkin->GetBitmap(BOBILLY_BITMAP+i), BOBILLY_BITMAP+2*BOBILLY_FRAMES+i, true);
	}

	player1 = pList->Get(settings->player1);
	player2 = pList->Get(settings->player2);

	// load the ball bitmaps
	ball.N_OF_FRAMES = 12;

    unload_datafile(bmps);
	bmps = load_datafile("ball.dat");
	int j=0,k;
	BITMAP *src;
    for (i=0; i<ball.N_OF_FRAMES; i++) {
		usprintf(bitmapName, "FRAME%02d", i);
        d = find_datafile_object(bmps, bitmapName);
		src = (BITMAP *)d->dat;
        theSkin->SetBitmap(src, j+BOBILLY_BITMAP+3*BOBILLY_FRAMES, true);

		for (k=0; k<3; k++) {
			if (MAS_hw_acceleration)
				tmp[i+k] = create_video_bitmap(src->w, src->h);
			else
				tmp[i+k] = create_bitmap(src->w, src->h);
			clear_to_color(tmp[i+k], makecol(255,0,255));
			rotate_sprite(tmp[i+k], src, 0, 0, ftofix(256-(k+1)*5.333));
			theSkin->SetBitmap(tmp[i+k], j+BOBILLY_BITMAP+3*BOBILLY_FRAMES+1+k, true);
		}
		j += 4;
    }
    unload_datafile(bmps);
	ball.N_OF_FRAMES *= 4;

	ball.SetBitmap(BOBILLY_BITMAP + 3*BOBILLY_FRAMES);
	ball.SetArea(-28, SCREEN_W+28, 480);
}


void BGame::CleanUp() {
	/*
	int i;

	for (i=0; i<ball.N_OF_FRAMES; i+=2) {
		ball.Frame(i+1);
		destroy_bitmap(ball.GetBitmap());
	}
	*/

	delete pList;
}


void BGame::OnPractise() {
	if (mainDlg->gameDlg.lPlayer1.Selection() == mainDlg->gameDlg.lPlayer2.Selection()) {
		return;
	}

	player1 = pList->Get(mainDlg->gameDlg.lPlayer1.Selection());
	player2 = pList->Get(mainDlg->gameDlg.lPlayer2.Selection());
	int w = theSkin->GetBitmap(BOBILLY_BITMAP)->w;
	player1->N_OF_FRAMES = BOBILLY_FRAMES;
	player1->SetBitmap(BOBILLY_BITMAP+BOBILLY_FRAMES);
	player1->SetArea(0, SCREEN_W/2-w/2-8, 450);
	player2->N_OF_FRAMES = BOBILLY_FRAMES;
	player2->SetBitmap(BOBILLY_BITMAP+2*BOBILLY_FRAMES);
	player2->SetArea(SCREEN_W/2+w/2+8, SCREEN_W, 450);
	gameDlg = new BGameDlg(player1, player2, &ball);
	gameDlg->Execute(mainDlg->soundDlg.sSoundVolume.Position(), mainDlg->soundDlg.sMusicVolume.Position());
	delete gameDlg;
}


void BGame::OnProfile() {
	if (mainDlg->gameDlg.lPlayer1.Selection() == mainDlg->gameDlg.lPlayer2.Selection()) {
		return;
	}

	int p1OldType, p2OldType;

	player1 = pList->Get(mainDlg->gameDlg.lPlayer1.Selection());
	player2 = pList->Get(mainDlg->gameDlg.lPlayer2.Selection());
	int w = theSkin->GetBitmap(BOBILLY_BITMAP)->w;
	player1->N_OF_FRAMES = BOBILLY_FRAMES;
	player1->SetBitmap(BOBILLY_BITMAP+BOBILLY_FRAMES);
	player1->SetArea(0, SCREEN_W/2-w/2-8, 450);
	p1OldType = player1->Type();
	player1->Type(BPlayer::PROFILE);
	player2->N_OF_FRAMES = BOBILLY_FRAMES;
	player2->SetBitmap(BOBILLY_BITMAP+2*BOBILLY_FRAMES);
	player2->SetArea(SCREEN_W/2+w/2+8, SCREEN_W, 450);
	p2OldType = player2->Type();
	player2->Type(BPlayer::PROFILE);
	gameDlg = new BGameDlg(player1, player2, &ball);
	//int frames = gameDlg->Profile();
	int frames = 100;
	delete gameDlg;


	MASDialog *win = new MASDialog(5);
	char buf[40];
	usprintf(buf, "Measured %d FPS!", frames);
	MASText line(buf,2);
	win->Shape(300,285,200, 30);
	MASPanel box;
	win->SetKey(KEY_M);
	win->MakeExit();
	//win->Add(*(MASDialogObject *)win);
	win->Add(box,0,0,200,30);
	win->Add(line,10,10,180,15);
	win->Popup();
	delete win;

	player1->Type(p1OldType);
	player2->Type(p2OldType);
}
