#include "BDumbPlayer.h"


DumbPlayer::DumbPlayer() 
	:MASMusicPlayer(),
	song(NULL),
	dp(NULL),
	length(0),
	volume(1.0f)
{
}


DumbPlayer::~DumbPlayer() {
	if (song) {
		unload_duh(song);
		song = NULL;
		dp = NULL;
	}
}


void DumbPlayer::Load() {
	if (song) {
		if (dp) {
			al_stop_duh(dp);
			dp = NULL;
		}
		unload_duh(song);
		song = NULL;
	}

	char *filename = GetSelectedFilename();
	char *ext = get_extension(filename);
	if (ustrcmp(ext, "s3m") == 0) {
		song = dumb_load_s3m(GetSelectedFilename());
	}
	else if (ustrcmp(ext, "it") == 0) {
		song = dumb_load_it(GetSelectedFilename());
	}

	if (!song) {
		length = 0;
	}
	else {
		length = duh_get_length(song);
	}
}


void DumbPlayer::Play(int i) {
	MASMusicPlayer::Play(i);
	dp = al_start_duh(song, 2, 0, volume, 2048, 22050);
}


void DumbPlayer::Pause() {
	MASMusicPlayer::Pause();
	al_pause_duh(dp);
}


void DumbPlayer::Resume() {
	MASMusicPlayer::Resume();
	al_resume_duh(dp);
}


void DumbPlayer::Stop() {
	MASMusicPlayer::Stop();
	al_stop_duh(dp);
	dp = NULL;
}


void DumbPlayer::MsgIdle() {
	if (IsPlaying() && al_duh_get_position(dp) >= length)
		Next();
	else
		al_poll_duh(dp);
}


void DumbPlayer::SetVolume(int vol) {
	volume = (float)vol / 256.0f;
	if (dp) {
		al_duh_set_volume(dp, volume);
	}
}
