#include <MASkinG.h>
#include <aldumb.h>
#include "BGame.h"
#include "BSettings.h"

////////////////////////////////////////////////////////////////////////////////
// Initializes Allegro and MASkinG. If there is an error it exits the
// program with an error message.
int Init(int w, int h, int depth, int fullscreen, int hw, int refresh, const char *skin) {
	if (refresh > 0) request_refresh_rate(refresh);
	int gfx_mode = fullscreen ? GFX_AUTODETECT_FULLSCREEN : GFX_AUTODETECT_WINDOWED;
	int bpp = fullscreen ? depth : desktop_color_depth();
	bool hardware = hw > 0 ? true : false;
	
    set_mouse_speed(1, 1);
	return MASInstall(skin, bpp, w, h, gfx_mode, hardware);
}


////////////////////////////////////////////////////////////////////////////////
// The main function takes one or two arguments: the first one can be "-w" to
// select windowed mode and the other cna be the path to a skin file
int main(int argc, char *argv[]) {
	set_uformat(U_ASCII);
	allegro_init();
	install_keyboard(); 
	install_mouse();
	install_timer();
	install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);

	atexit(&dumb_exit);
	dumb_register_stdfiles();

	BSettings s("Bobilly.cfg");
	int err = Init(800, 600, s.bpp, s.fullscreen, s.hw, s.refresh, s.skin);
    if (err != MASkin::ERR_SKIN_NONE)
	   MASError(err);
    
	BGame game(&s);
	while (game.Run() == true) {
		if (Init(800, 600, s.bpp, s.fullscreen, s.hw, s.refresh, s.skin) != MASkin::ERR_SKIN_NONE) {
			s.Load();
			Init(800, 600, s.bpp, s.fullscreen, s.hw, s.refresh, s.skin);
		}
		else {
			s.Save();
		}
	}

	MASExit();
	allegro_exit();
	return 0;
}
END_OF_MAIN();
