#include "BSettings.h"


BSettings::BSettings(const char *file) {
	ustrcpy(this->file, file);
	Load();
}


BSettings::~BSettings() {
	Save();
}


void BSettings::Load() {
	set_config_file(file);

	ustrncpy(skin, get_config_string("GRAPHICS", "skin", "skins/QNXAmiga.ini"), 255);
	fullscreen = get_config_int("GRAPHICS", "fullscreen", 1);
	hw = get_config_int("GRAPHICS", "hw", 0);
	refresh = get_config_int("GRAPHICS", "refresh", 60);
	bpp = get_config_int("GRAPHICS", "color_depth", 32);

	player1 = get_config_int("PLAYERS", "player1", 0);
	player2 = get_config_int("PLAYERS", "player2", 1);

	sound_volume = get_config_int("SOUND", "sound_volume", 200);
	music_volume = get_config_int("SOUND", "music_volume", 200);
}


void BSettings::Save() {
	set_config_file(file);

	set_config_string("GRAPHICS", "skin", skin);
	set_config_int("GRAPHICS", "fullscreen", fullscreen);
	set_config_int("GRAPHICS", "hw", hw);
	set_config_int("GRAPHICS", "refresh", refresh);
	set_config_int("GRAPHICS", "color_depth", bpp);

	set_config_int("PLAYERS", "player1", player1);
	set_config_int("PLAYERS", "player2", player2);

	set_config_int("SOUND", "sound_volume", sound_volume);
	set_config_int("SOUND", "music_volume", music_volume);

	flush_config_file();
}
