#include "BPlayerEdit.h"


BPlayerEditor::BPlayerEditor() : MASWindow("Player editor", 30) {
	player = NULL;

	boxName.SetText("Name and type");
	tName.SetText("Player name");
	eName.SetText("New player", 32);
	tType.SetText("Type");
	rHuman.Setup(0,0,0,0, KEY_H, D_SELECTED, "&Human", 0);
	rAI.Setup(   0,0,0,0, KEY_A, 0,          "&AI", 0);
	bAI.Setup(   0,0,0,0, KEY_S, D_DISABLED, "&Settings");

	boxKeys.SetText("Keys");
	tKeyLeft.SetText("Left");
	tKeyRight.SetText("Right");
	tKeyJump.SetText("Jump");
	tKeyServe.SetText("Serve");

	char *key_desc[] = {
        "KEY_A",
        "KEY_B",
        "KEY_C",
        "KEY_D",
        "KEY_E",
        "KEY_F",
        "KEY_G",
        "KEY_H",
        "KEY_I",
        "KEY_J",
        "KEY_K",
        "KEY_L",
        "KEY_M",
        "KEY_N",
        "KEY_O",
        "KEY_P",
        "KEY_Q",
        "KEY_R",
        "KEY_S",
        "KEY_T",
        "KEY_U",
        "KEY_V",
        "KEY_W",
        "KEY_X",
        "KEY_Y",
        "KEY_Z",
        "KEY_0",
        "KEY_1",
        "KEY_2",
        "KEY_3",
        "KEY_4",
        "KEY_5",
        "KEY_6",
        "KEY_7",
        "KEY_8",
        "KEY_9",
        "KEY_0_PAD",
        "KEY_1_PAD",
        "KEY_2_PAD",
        "KEY_3_PAD",
        "KEY_4_PAD",
        "KEY_5_PAD",
        "KEY_6_PAD",
        "KEY_7_PAD",
        "KEY_8_PAD",
        "KEY_9_PAD",
        "KEY_F1",
        "KEY_F2",
        "KEY_F3",
        "KEY_F4",
        "KEY_F5",
        "KEY_F6",
        "KEY_F7",
        "KEY_F8",
        "KEY_F9",
        "KEY_F10",
        "KEY_F11",
        "KEY_F12",
        "KEY_ESC",
        "KEY_TILDE",
        "KEY_MINUS",
        "KEY_EQUALS",
        "KEY_BACKSPACE",
        "KEY_TAB",
        "KEY_OPENBRACE",
        "KEY_CLOSEBRACE",
        "KEY_ENTER",
        "KEY_COLON",
        "KEY_QUOTE",
        "KEY_BACKSLASH",
        "KEY_BACKSLASH2",
        "KEY_COMMA",
        "KEY_STOP",
        "KEY_SLASH",
        "KEY_SPACE",
        "KEY_INSERT",
        "KEY_DEL",
        "KEY_HOME",
        "KEY_END",
        "KEY_PGUP",
        "KEY_PGDN",
        "KEY_LEFT",
        "KEY_RIGHT",
        "KEY_UP",
        "KEY_DOWN",
        "KEY_SLASH_PAD",
        "KEY_ASTERISK",
        "KEY_MINUS_PAD",
        "KEY_PLUS_PAD",
        "KEY_DEL_PAD",
        "KEY_ENTER_PAD",
        "KEY_PRTSCR",
        "KEY_PAUSE",
        "KEY_ABNT_C1",
        "KEY_YEN",
        "KEY_KANA",
        "KEY_CONVERT",
        "KEY_NOCONVERT",
        "KEY_AT",
        "KEY_CIRCUMFLEX",
        "KEY_COLON2",
        "KEY_KANJI",
        "KEY_LSHIFT",
        "KEY_RSHIFT",
        "KEY_LCONTROL",
        "KEY_RCONTROL",
        "KEY_ALT",
        "KEY_ALTGR",
        "KEY_LWIN",
        "KEY_RWIN",
        "KEY_MENU",
        "KEY_SCRLOCK",
        "KEY_NUMLOCK",
        "KEY_CAPSLOCK" };
	int n_of_keys = 114;

	for (int i=0; i<n_of_keys; i++) {
		lKeyLeft.InsertItem(key_desc[i], i);
		lKeyRight.InsertItem(key_desc[i], i);
		lKeyJump.InsertItem(key_desc[i], i);
		lKeyServe.InsertItem(key_desc[i], i);
	}
	lKeyLeft.Selection(KEY_LEFT-1);
	lKeyRight.Selection(KEY_RIGHT-1);
	lKeyJump.Selection(KEY_UP-1);
	lKeyServe.Selection(KEY_SPACE-1);

	boxColor.SetText("Player color");
	sR.Setup(0,0,0,0, 0,0, 0,255,255,1);
	sG.Setup(0,0,0,0, 0,0, 0,255,255,1);
	sB.Setup(0,0,0,0, 0,0, 0,255,255,1);
	tR.SetNumber(255);	tR.Disable();
	tG.SetNumber(255);	tG.Disable();
	tB.SetNumber(255);	tB.Disable();
	bitPlayer.SetBitmap(BOBILLY_BITMAP+BOBILLY_FRAMES);
	bitPlayer.SetMasked(true);
	ColorBitmap();

	bOK.Setup(0,0,0,0, KEY_O, D_EXIT, "&OK");
	bCancel.Setup(0,0,0,0, KEY_C, D_EXIT, "&Cancel");

	Add(boxName);
	Add(tName);
	Add(tType);
	Add(eName);
	Add(rHuman);
	Add(rAI);
	Add(bAI);
	Add(boxKeys);
	Add(tKeyLeft);
	Add(tKeyRight);
	Add(tKeyJump);
	Add(tKeyServe);
	Add(lKeyLeft);
	Add(lKeyRight);
	Add(lKeyJump);
	Add(lKeyServe);
	Add(boxColor);
	Add(sR);
	Add(sG);
	Add(sB);
	Add(tR);
	Add(tG);
	Add(tB);
	Add(bitPlayer);
	Add(bOK);
	Add(bCancel);

	MsgResize(386, 336);
	_escape_exits = false;
}


BPlayerEditor::~BPlayerEditor() {
}


void BPlayerEditor::InitSkin(MASkin *s) {
	tR.SetTextMode(theSkin->c_face);
	tG.SetTextMode(theSkin->c_face);
	tB.SetTextMode(theSkin->c_face);
}


void BPlayerEditor::MsgResize(int nw, int nh) {
	MASWindow::MsgResize(nw,nh);

	ShapeObject(&boxName,     6,   6, 200, 138);
	ShapeObject(&tName,      12,  42,  72,  16);
	ShapeObject(&eName,      88,  36, 112,  22);
	ShapeObject(&tType,      12,  88,  60,  16);
	ShapeObject(&rHuman,     48,  84, 116,  22);
	ShapeObject(&rAI,        48, 108,  48,  22);
	ShapeObject(&bAI,        96, 108, 100,  22);

	ShapeObject(&boxKeys,   212,   6, 168, 138);
	ShapeObject(&tKeyLeft,  218,  42,  36,  16);
	ShapeObject(&tKeyRight, 218,  66,  36,  16);
	ShapeObject(&tKeyJump,  218,  90,  36,  16);
	ShapeObject(&tKeyServe, 218, 114,  36,  16);
	ShapeObject(&lKeyLeft,  254,  36, 120,  22);
	ShapeObject(&lKeyRight, 254,  60, 120,  22);
	ShapeObject(&lKeyJump,  254,  84, 120,  22);
	ShapeObject(&lKeyServe, 254, 108, 120,  22);

	ShapeObject(&boxColor,    6, 150, 374, 152);
	ShapeObject(&sR,         12, 212, 256,  28);
	ShapeObject(&sG,         12, 242, 256,  28);
	ShapeObject(&sB,         12, 272, 256,  28);
	ShapeObject(&tR,        272, 214,  24,  16);
	ShapeObject(&tG,        272, 244,  24,  16);
	ShapeObject(&tB,        272, 274,  24,  16);
	ShapeObject(&bitPlayer, 295, 178,  75, 116);


	int dw = 20;
	ShapeObject(&bOK, dw, nh-28, (nw-3*dw)/2, 22);
	ShapeObject(&bCancel, (nw+dw)/2, nh-28, (nw-3*dw)/2, 22);
}


void BPlayerEditor::HandleEvent(MASDialogObject& obj, int msg, int arg) {
	MASWindow::HandleEvent(obj,msg,arg);
	switch (msg) {
		case MSG_SCROLL:
			if (obj == sR) {
				tR.SetNumber(sR.Position());
				tR.RedrawNow();
				ColorBitmap();
				bitPlayer.RedrawNow();
			} else
			if (obj == sG) {
				tG.SetNumber(sG.Position());
				tG.RedrawNow();
				ColorBitmap();
				bitPlayer.RedrawNow();
			} else
			if (obj == sB) {
				tB.SetNumber(sB.Position());
				tB.RedrawNow();
				ColorBitmap();
				bitPlayer.RedrawNow();
			}
			break;
		case MSG_ACTIVATE:
			if (obj == rHuman) {
				boxKeys.Enable();
				tKeyLeft.Enable();	lKeyLeft.Enable();
				tKeyRight.Enable();	lKeyRight.Enable();
				tKeyJump.Enable();	lKeyJump.Enable();
				tKeyServe.Enable();	lKeyServe.Enable();
				bAI.Disable();
			} else
			if (obj == rAI) {
				boxKeys.Disable();
				tKeyLeft.Disable();	lKeyLeft.Disable();
				tKeyRight.Disable();	lKeyRight.Disable();
				tKeyJump.Disable();	lKeyJump.Disable();
				tKeyServe.Disable();	lKeyServe.Disable();
				bAI.Enable();
			}
	};
}


BPlayer *BPlayerEditor::Popup(BPlayer *p) {
	bool allocated = false;
	if (!p) {
		player = new BPlayer;
		player->SetText("New player");
		player->Color(255,255,255);
		player->SetKeys(KEY_LEFT, KEY_RIGHT, KEY_UP, KEY_SPACE);
		player->games_played = 0;
		player->games_won = 0;
		player->points_plus = 0;
		player->points_minus = 0;
		allocated = true;
	}
	else {
		player = p;
	}

	eName.SetText(player->GetText());
	if (player->Type() == BPlayer::HUMAN) {
		rHuman.Select();
		rAI.Deselect();
	}
	else {
		rAI.Select();
		rHuman.Deselect();
		bAI.Enable();
	}
	int l,r,j,s;
	player->GetKeys(l,r,j,s);
	lKeyLeft.Selection(l-1);
	lKeyRight.Selection(r-1);
	lKeyJump.Selection(j-1);
	lKeyServe.Selection(s-1);
	sR.Position(player->Red());
	sG.Position(player->Green());
	sB.Position(player->Blue());
	tR.SetNumber(player->Red());
	tG.SetNumber(player->Green());
	tB.SetNumber(player->Blue());
	ColorBitmap();

	if (MASWindow::Popup(&bCancel) == &bOK) {
		player->SetText(eName.GetText());
		if (rHuman.Selected())
			player->Type(BPlayer::HUMAN);
		else
			player->Type(BPlayer::AI);
		player->SetKeys(lKeyLeft.Selection()+1, lKeyRight.Selection()+1, lKeyJump.Selection()+1, lKeyServe.Selection()+1);
		player->Color(sR.Position(), sG.Position(), sB.Position());
		return player;
	}
	else {
		if (allocated) delete player;
		return NULL;
	}
}


void BPlayerEditor::ColorBitmap() {
	int r = sR.Position();
	int g = sG.Position();
	int b = sB.Position();


	BITMAP *src = theSkin->GetBitmap(BOBILLY_BITMAP);
	BITMAP *dest = bitPlayer.GetBitmap();

	int PINK = makecol(255,0,255);
	clear_to_color(dest, PINK);

	int x,y,pix;
	int sr,sg,sb;
	for (y=0; y<src->h; y++) {
		for (x=0; x<src->w; x++) {
			pix = getpixel(src, x,y);
			if (pix != PINK) {
				sr = getr(pix);
				sg = getg(pix);
				sb = getb(pix);
				sr = ((r*sr)>>8);
				sg = ((g*sg)>>8);
				sb = ((b*sb)>>8);
				putpixel(dest, x,y, makecol(sr,sg,sb));
			}
		}
	}
}
