#ifndef			BOBILLY_PLAYER
#define			BOBILLY_PLAYER


#include "BObject.h"
#include "defines.h"

class BPlayer : public BObject {
	protected:
		int score;				// number of points
		int dy;					// how much to move on the y axis
		int jump_strength;		// how much can we jump
		void ColorBitmaps();
		int r,g,b;
		int type;

		// the keys
		int B_KEY_LEFT;
		int B_KEY_RIGHT;
		int B_KEY_JUMP;
		int B_KEY_SERVE;
		enum { LEFT, RIGHT, JUMP, SERVE };
		bool key_pressed[4];

	public:
		int moved_x, moved_y;	// how much the player moved since the last time

		// statistics
		int games_played;
		int games_won;
		int points_plus;
		int points_minus;


	public:
		BPlayer();
		~BPlayer();

		virtual void MsgStart();

		void SetKeys(int l, int r, int j, int s) {
			B_KEY_LEFT = l;
			B_KEY_RIGHT = r;
			B_KEY_JUMP = j;
			B_KEY_SERVE = s;
		}
		void GetKeys(int& l, int& r, int& j, int& s) {
			l = B_KEY_LEFT;
			r = B_KEY_RIGHT;
			j = B_KEY_JUMP;
			s = B_KEY_SERVE;
		}
		void Update();
		void GetInput(float x1, float y1, float x2, float y2, float bx, float by, float bv, float bdir);
		int Score() { return score; }
		void operator++() { score++; }
		void Color(int rr, int gg, int bb) { r = rr; g = gg; b = bb; }
		int Color() { return makecol(r,g,b); }
		int Red() { return r; }
		int Green() { return g; }
		int Blue() { return b; }
		void Type(int t) { type = t; }
		int Type() { return type; }
		void Load(PACKFILE *file);
		void Save(PACKFILE *file);

		enum { HUMAN, AI, REMOTE, PROFILE };
};


#endif			//BOBILLY_PLAYER
