#include "BPlayer.h"
#include <stdlib.h>


// constructor
BPlayer::BPlayer() : BObject() {
	SetKeys(KEY_LEFT, KEY_RIGHT, KEY_UP, KEY_SPACE);
	dy = 0;
	jump_strength = 90;
	type = HUMAN;
	games_played = 0;
	games_won = 0;
	points_plus = 0;
	points_minus = 0;
}


// destructor
BPlayer::~BPlayer() {
}


// initialize the player on MSG_START
void BPlayer::MsgStart() {
	BObject::MsgStart();
	score = 0;
	moved_x = 0;
	moved_y = 0;
	ColorBitmaps();
	key_pressed[LEFT] = false;
	key_pressed[RIGHT] = false;
	key_pressed[JUMP] = false;
	key_pressed[SERVE] = false;
}


// update the state and position of the player and redraw
void BPlayer::Update() {
	int newx = x();
	int newy = y();
	int oldf = frame;
	bool movef = frame != 0 ? true : false;
	oldx = x();
	oldy = y();

	// do we serve?
	if (key_pressed[SERVE]) {
		Parent()->HandleEvent(*this, MSG_ACTIVATE);
	}

	// do we move left?
	if (key_pressed[LEFT]) {
		newx -= 6;
		if (newy == miny)
			movef = true;
	}

	// do we move right?
	if (key_pressed[RIGHT]) {
		newx += 6;
		if (newy == miny)
			movef = true;
	}

	// do we jump?
	if (key_pressed[JUMP] && dy<=0) {
		if (y() == miny) {
			theSkin->PlaySample(SAMPLE_JUMP);
		}
		
		if (miny-y() < jump_strength/4) {
			dy -= 4;
			movef = true;
			df = 1;
		}
		else if (miny-y() < jump_strength/2) {
			dy -= 3;
			movef = true;
			df = 1;
		}
		else if (miny-y() < jump_strength) {
			dy -= 2;
			movef = true;
			df = 1;
		}
	}
	newy += dy;
	dy++;

	// are we still inside the area?
	if (newx < minx)
		newx = minx;
	else if (newx > maxx)
		newx = maxx;
	if (newy > miny) {
		newy = miny;
		dy = 0;
	}

	// do we have to change the frame?
	if (movef) {
		frame += df;
		if (frame >= N_OF_FRAMES) {
			df = -1;
			frame = N_OF_FRAMES - 1;
		}
		else if (frame < 0) {
			df = 1;
			frame = 0;
		}
	}

	// do we have to redraw?
	if (movef || newx != oldx || newy != oldy) {
		moved_x = newx - oldx;
		moved_y = newy - oldy;
		Place(newx, newy);
	}
	else {
		moved_x = 0;
		moved_y = 0;
	}

	// Prevent unnecessary redraw
	MakeClean();
}


void BPlayer::ColorBitmaps() {
	for (int i=0; i<N_OF_FRAMES; i++) {
		BITMAP *src = theSkin->GetBitmap(BOBILLY_BITMAP+i);
		Frame(i);
		BITMAP *dest = GetBitmap();

		int PINK = makecol(255,0,255);
		clear_to_color(dest, PINK);

		int x,y,pix;
		int sr,sg,sb;
		for (y=0; y<src->h; y++) {
			for (x=0; x<src->w; x++) {
				pix = getpixel(src, x,y);
				if (pix != PINK) {
					sr = getr(pix);
					sg = getg(pix);
					sb = getb(pix);
					sr = ((r*sr)>>8);
					sg = ((g*sg)>>8);
					sb = ((b*sb)>>8);
					putpixel(dest, x,y, makecol(sr,sg,sb));
				}
			}
		}
	}
}


void BPlayer::Load(PACKFILE *file) {
	char buf[36];
	buf[32] = 0;
	pack_fread(buf, 32, file);
	SetText(buf);
	B_KEY_LEFT = pack_getc(file);
	B_KEY_RIGHT = pack_getc(file);
	B_KEY_JUMP = pack_getc(file);
	B_KEY_SERVE = pack_getc(file);
	Type(pack_getc(file));
	r = pack_getc(file);
	g = pack_getc(file);
	b = pack_getc(file);
	pack_getc(file);
	games_played = pack_igetw(file);
	games_won = pack_igetw(file);
	points_plus = pack_igetw(file);
	points_minus = pack_igetw(file);
}


void BPlayer::Save(PACKFILE *file) {
	char buf[32];
	for (int i=0;i<32;i++) buf[i] = 0;
	ustrcpy(buf, GetText());
	pack_fwrite(buf, 32, file);
	pack_putc(B_KEY_LEFT, file);
	pack_putc(B_KEY_RIGHT, file);
	pack_putc(B_KEY_JUMP, file);
	pack_putc(B_KEY_SERVE, file);
	pack_putc(type, file);
	pack_putc(r, file);
	pack_putc(g, file);
	pack_putc(b, file);
	pack_putc(0, file);
	pack_iputw(games_played, file);
	pack_iputw(games_won, file);
	pack_iputw(points_plus, file);
	pack_iputw(points_minus, file);
}


void BPlayer::GetInput(float x1, float y1, float x2, float y2, float bx, float by, float bv, float bdir) {
	switch (type) {
		case HUMAN:
			key_pressed[LEFT] = key[B_KEY_LEFT] ? true : false;
			key_pressed[RIGHT] = key[B_KEY_RIGHT] ? true : false;
			key_pressed[JUMP] = key[B_KEY_JUMP] ? true : false;
			key_pressed[SERVE] = key[B_KEY_SERVE] ? true : false;
			break;
		case AI:
			break;
		case REMOTE:
			// read input from network
			break;
		case PROFILE:
			// generate random input
			key_pressed[LEFT] = rand() > (RAND_MAX>>1) ? true : false;
			key_pressed[RIGHT] = rand() > (RAND_MAX>>1) ? true : false;
			key_pressed[JUMP] = rand() > (RAND_MAX>>1) ? true : false;
			key_pressed[SERVE] = rand() > (RAND_MAX>>1) ? true : false;
			break;
	};
}
