#include "BObject.h"


// constructor
BObject::BObject() : MASText() {
	df = 1.0;
}


// destructor
BObject::~BObject() {
}


// initialize the Object on MSG_START
void BObject::MsgStart() {
	frame = 0.0;
	oldx = x();
	oldy = y();

	BITMAP *b = theSkin->GetBitmap(bitmap);
	Resize(b->w, b->h);
}


// draw the Object
void BObject::MsgDraw() {
	BITMAP *canvas = Parent()->dscreen;
	if (!canvas) return;

	// draw the object in the new position
	masked_blit(theSkin->GetBitmap((int)(bitmap+frame)), canvas, 0, 0, x()-(w()>>1), y()-(h()>>1), w(), h());

	// update the parent dialogs DRS
	InvalidateRect(x()-(w()>>1), y()-(h()>>1), x()+(w()>>1)+1, y()+(h()>>1));

	// make sure we don't move too much
	oldx = x();
	oldy = y();
}
