#include "BMainDlg.h"


BGameSettingsDlg::BGameSettingsDlg() : MASDialog(15) {
	settings = NULL;
	panel.Setup(0,0,385,285, 0,0, "Game");
	tSingleplayer.Setup(6,32,373,18, 0,0, "Select singleplayer options", 2);
	tPlayer1.Setup(6,68,64,22, 0,0, "Player 1", 1);
	lPlayer1.Setup(76,62,105,22, 0,0, 4);
	tPlayer2.Setup(187,68,64,22, 0,0, "Player 2", 1);
	lPlayer2.Setup(257,62,105,22, 0,0, 4);
	bPractise.Setup(101,100,184,22, KEY_P,D_EXIT, "&Practise");

	tMultiplayer.Setup(6,138,373,18, 0,0, "Select multiplayer options", 2);
	tGameName.Setup(6,172,120,22, 0,0, "Hosted game name", 1);
	eGameName.Setup(132,172,160,22, 0,0, "", 32);
	bHost.Setup(200,198,170,22, KEY_H,D_EXIT, "&Host network game");
	tHostIP.Setup(6,230,120,22, 0,0, "Remote host IP", 1);
	eHostIP.Setup(132,230,160,22, 0,0, "", 32);
	bJoin.Setup(200,256,170,22, KEY_J,D_EXIT, "&Join network game");

	bHost.Disable();
	bJoin.Disable();
	
	Resize(385,285);
	Add(panel);
	Add(tSingleplayer);
	Add(tPlayer1);
	Add(lPlayer1);
	Add(tPlayer2);
	Add(lPlayer2);
	Add(bPractise);
	Add(tMultiplayer);
	Add(tGameName);
	Add(eGameName);
	Add(bHost);
	Add(tHostIP);
	Add(eHostIP);
	Add(bJoin);
};


BGameSettingsDlg::~BGameSettingsDlg() {
	settings->player1 = lPlayer1.Selection();
	settings->player2 = lPlayer2.Selection();
}


void BGameSettingsDlg::Settings(BSettings *s, BPlayersList *pList) {
	settings = s;
	this->pList = pList;

	lPlayer1.DeleteAllItems();
	lPlayer2.DeleteAllItems();
	int n = pList->Size();
	for (int i=0; i<n; i++) {
		lPlayer1.InsertItem(pList->Get(i)->GetText(), i);
		lPlayer2.InsertItem(pList->Get(i)->GetText(), i);
	}

	lPlayer1.Selection(s->player1);
	lPlayer2.Selection(s->player2);
}


BGraphicsSettingsDlg::BGraphicsSettingsDlg() : MASDialog(12) {
	settings = NULL;
	panel.Setup(0,0,385,168, 0,0, "Graphics Settings");
	cFullscreen.Setup(32,28,140,22, KEY_F,D_SELECTED, "&Fullscreen");
	cHardware.Setup(152,28,140,22, KEY_H,D_SELECTED, "&HW acceleration");
	tColorDepth.Setup(9,64,120,22, 0,0, "Select color depth:", 0);
	lColorDepth.Setup(132,60,80,22, 0,0, 4);
	tSkin.Setup(9,90,120,22, 0,0, "Select GUI skin:", 0);
	lSkin.Setup(112,86,100,22, 0,0, 6);
	tRefresh.Setup(9,114,280,22, 0,0, "Enter the refresh rate of your monitor in Hz", 0);
	eRefresh.Setup(294,108,32,22, 0,0, "", 3);
	bProfile.Setup(232, 60, 120, 22, KEY_L, D_DISABLED | D_EXIT, "Profi&le");
	bApply.Setup(32,138,240,22, KEY_Y, D_EXIT, "Appl&y changes");

	lColorDepth.InsertItem("15 bpp", 0);
	lColorDepth.InsertItem("16 bpp", 1);
	lColorDepth.InsertItem("24 bpp", 2);
	lColorDepth.InsertItem("32 bpp", 3);

	FillSkinList();
	if (lSkin.Size() == 0)	lSkin.InsertItem("", 0);

	Resize(385,168);
	Add(panel);
	Add(cFullscreen);
	Add(cHardware);
	Add(tColorDepth);
	Add(lColorDepth);
	Add(tSkin);
	Add(lSkin);
	Add(tRefresh);
	Add(eRefresh);
	Add(bApply);
	Add(bProfile);
};


BGraphicsSettingsDlg::~BGraphicsSettingsDlg() {
	SaveSettings();
}


void BGraphicsSettingsDlg::SaveSettings() {
	settings->fullscreen = cFullscreen.Selected() ? 1 : 0;
	settings->hw = cHardware.Selected() ? 1 : 0;
	switch (lColorDepth.Selection()) {
		case 0:		settings->bpp = 15;		break;
		case 1:		settings->bpp = 16;		break;
		case 2:		settings->bpp = 24;		break;
		case 3:		settings->bpp = 32;		break;
	};
	settings->refresh = (int)(uatof(eRefresh.GetText()));
	ustrcpy(settings->skin, "skins/\0");
	ustrcat(settings->skin, lSkin.GetSelectedText());
	ustrcat(settings->skin, ".ini");
}


void BGraphicsSettingsDlg::Settings(BSettings *s) {
	settings = s;
	if (!s->fullscreen)		cFullscreen.Deselect();
	if (!s->hw)				cHardware.Deselect();
	switch (s->bpp) {
		case 15:	lColorDepth.Selection(0);		break;
		case 16:	lColorDepth.Selection(1);		break;
		case 24:	lColorDepth.Selection(2);		break;
		case 32:	lColorDepth.Selection(3);		break;
	};
	char buf[256];
	usprintf(buf, "%d", s->refresh);
	eRefresh.SetText(buf, 3);

	char *tmp = get_filename(s->skin);
	ustrcpy(buf, tmp);
	tmp = buf;
	while (tmp[0] != '.') tmp++;
	tmp[0] = 0;

	int i;
	for (i=0; i<lSkin.Size(); i++) {
		if (ustrcmp(buf, lSkin.GetItemText(i)) == 0)
			break;
	}
	lSkin.Selection(i);
}


void BGraphicsSettingsDlg::FillSkinList() {
	lSkin.DeleteAllItems();

	struct al_ffblk info;
	int done = al_findfirst("skins/*.ini", &info, FA_ARCH);
	int i=0;
	char *tmp;

	while (!done) {
		tmp = info.name;
		while (tmp[0] != '.') tmp++;
		tmp[0] = 0;
		lSkin.InsertItem(info.name, i);
		done = al_findnext(&info);
		i++;
	}

	al_findclose(&info);
}


BSoundSettingsDlg::BSoundSettingsDlg() : MASDialog(10) {
	settings = NULL;
	panel.Setup(0,0,385,111, 0,0, "Sound && Music");
	cSound.Setup(6,32,72,22, KEY_S,D_SELECTED, "&Sound");
	cMusic.Setup(6,64,72,22, KEY_C,D_SELECTED, "Musi&c");
	sSoundVolume.Setup(84,36,256,22, 0,0, 0,255,0,1);
	sMusicVolume.Setup(84,68,256,22, 0,0, 0,255,0,1);
	tSoundVolume.Setup(342,38,32,22, 0,D_DISABLED, "", 2);
	tMusicVolume.Setup(342,70,32,22, 0,D_DISABLED, "", 2);
	tSoundVolume.SetTextMode(theSkin->c_face);
	tMusicVolume.SetTextMode(theSkin->c_face);

	Resize(385,111);
	Add(panel);
	Add(cSound);
	Add(cMusic);
	Add(sSoundVolume);
	Add(sMusicVolume);
	Add(tSoundVolume);
	Add(tMusicVolume);
};


BSoundSettingsDlg::~BSoundSettingsDlg() {
	settings->sound_volume = sSoundVolume.Position();
	settings->music_volume = sMusicVolume.Position();
}


void BSoundSettingsDlg::Settings(BSettings *s) {
	settings = s;
	sSoundVolume.Setup(84,36,256,22, 0,0, 0,255,s->sound_volume,1);
	sMusicVolume.Setup(84,68,256,22, 0,0, 0,255,s->music_volume,1);
	tSoundVolume.SetNumber(s->sound_volume);
	tMusicVolume.SetNumber(s->music_volume);
}

void BSoundSettingsDlg::InitSkin(MASkin *s) {
	MASDialog::InitSkin(s);

	tMusicVolume.SetTextMode(theSkin->c_face);
	tSoundVolume.SetTextMode(theSkin->c_face);
}


BPlayersSettingsDlg::BPlayersSettingsDlg() : MASDialog(10) {
	pList = NULL;
	panel.Setup(0,0,496,285, 0,0, "Player Settings && Statistics");
	tListTitle.Setup(10,28,484,16, 0,0, "Player                           type  gms wns pts+  pts-",0);
	lPlayers.Setup(6,44,484,207, 0,0);
	bAdd.Setup(6,257,157,22, KEY_A,0, "&Add");
	bRemove.Setup(169,257,157,22, KEY_D,0, "&Delete");
	bEdit.Setup(332,257,158,22, KEY_E,0, "&Edit");

	Resize(496,285);
	Add(panel);
	Add(tListTitle);
	Add(lPlayers);
	Add(bAdd);
	Add(bRemove);
	Add(bEdit);
}

void BPlayersSettingsDlg::InitSkin(MASkin *s) {
	tListTitle.SetFont(BOBILLY_FONT2, MASkin::NORMAL);
	tListTitle.SetFont(BOBILLY_FONT2, MASkin::SELECT);
	tListTitle.SetFont(BOBILLY_FONT2, MASkin::DISABLE);
	tListTitle.SetFont(BOBILLY_FONT2, MASkin::FOCUS);
	lPlayers.SetFont(BOBILLY_FONT2, MASkin::NORMAL);
	lPlayers.SetFont(BOBILLY_FONT2, MASkin::SELECT);
	lPlayers.SetFont(BOBILLY_FONT2, MASkin::DISABLE);
	lPlayers.SetFont(BOBILLY_FONT2, MASkin::FOCUS);
	lPlayers.SetRowHeight(theSkin->GetFont(BOBILLY_FONT2)->TextHeight());
}


void BPlayersSettingsDlg::SetList(BPlayersList *pList) {
	this->pList = pList;

	int n = pList->Size();
	char buf[59]; buf[58]=0;
	char *str = buf;
	BPlayer *p;

	lPlayers.DeleteAllItems();
	for (int i=0; i<n; i++) {
		str = buf;
		p = pList->Get(i);
		ustrncpy(str, p->GetText(), 32);
		str += 32;
		if (p->Type() == BPlayer::HUMAN)
			ustrncpy(str, "\xB3HUMAN", 6);
		else
			ustrncpy(str, "\xB3 AI  ", 6);
		str += 6;
		usprintf(str, "\xB3%03d\xB3%03d\xB3%05d\xB3%05d", p->games_played, p->games_won, p->points_plus, p->points_minus);

		for (int j=0; j<32; j++)
			if (buf[j] == 0)
				buf[j] = 0x20;

		lPlayers.InsertItem(buf, i);
	}
}


BPlayersSettingsDlg::~BPlayersSettingsDlg() {
}


void BPlayersSettingsDlg::AddPlayer(MASDialog *parent) {
	BPlayerEditor dlg;
	dlg.SetParent(parent);
	dlg.Centre();

	BPlayer *p = dlg.Popup();
	if (!p) return;

	pList->Add(p);
	SetList(pList);
	lPlayers.Selection(lPlayers.Size()-1);
	delete p;
}


void BPlayersSettingsDlg::RemovePlayer(MASDialog *parent) {
	MASAlert msg;
	msg.SetType(MASAlert::YES_NO);
	if (msg.Popup("Are you sure?", parent, "Remove")) {
		int sel = lPlayers.Selection();
		pList->Remove(sel);
		SetList(pList);
		if (sel >= lPlayers.Size()) sel = lPlayers.Size()-1;
		lPlayers.Selection(sel);
	}
}


void BPlayersSettingsDlg::EditPlayer(MASDialog *parent) {
	BPlayerEditor dlg;
	dlg.SetParent(parent);
	dlg.Centre();

	int sel = lPlayers.Selection();
	BPlayer *p = dlg.Popup(pList->Get(sel));
	if (!p) return;

	//pList->Update(p, sel);
	SetList(pList);
	lPlayers.Selection(sel);
}


// constructor
BMainDlg::BMainDlg(BSettings *s, BPlayersList *pList) : MASDialog(100) {
	this->pList = pList;
	// initialize return value
	ret = EXIT;

	// setup GUI objects
	panel.Setup(         6,   6, 788, 588, 0,     0);
	bExit.Setup(        12, 560, 272,  22, KEY_X, 0,	  "E&xit");
	tGameTitle.Setup(   12, 320, 272,  18, 0,     0,      "Bobilly-Wobilly", 2);
	tGameVersion.Setup( 12, 338, 272,  18, 0,     0,      "v0.14", 2);
	lBuildDate.Setup(   12, 372, 120,  18, 0, D_DISABLED, "Build date: ", 1);
	lProgramming.Setup( 12, 390, 120,  18, 0, D_DISABLED, "Programming: ", 1);
	lGraphics.Setup(    12, 408, 120,  18, 0, D_DISABLED, "Graphics: ", 1);
	lSound.Setup(       12, 426, 120,  18, 0, D_DISABLED, "Sound: ", 1);
	tSystem.Setup(      12, 464, 150,  18, 0, D_DISABLED, "System information", 2);
	lAllegro.Setup(     12, 482,  80,  18, 0, D_DISABLED, "Allegro: ", 1);
	lOS.Setup(          12, 500,  80,  18, 0, D_DISABLED, "OS: ", 1);
	lCPU.Setup(         12, 518,  80,  18, 0, D_DISABLED, "CPU: ", 1);

	tBuildDate.Setup(  132, 372, 152,  18, 0, D_DISABLED, "18. November 2002", 0);
	tProgramming.Setup(132, 390, 152,  18, 0, D_DISABLED, "Miran Amon", 0);
	tGraphics.Setup(   132, 408, 152,  18, 0, D_DISABLED, "Miran Amon", 0);
	tSound.Setup(      132, 426, 152,  18, 0, D_DISABLED, "Miran Amon", 0);
	tAllegro.Setup(     92, 482, 152,  18, 0, D_DISABLED, allegro_id, 0);

    char* OS[] = { "unknown, or regular MSDOS", "Windows 3.1 or earlier", "Windows 95", "Windows 98", "Windows ME", "Windows NT", "Windows 2000", "Windows XP", "OS/2", "OS/2 Warp 3", "Linux DOSEMU", "Caldera OpenDOS", "Linux", "FreeBSD", "Unknown Unix variant", "BeOS", "QNX", "MacOS" };
	int array_offset = 0;
	switch (os_type) {
		case OSTYPE_UNKNOWN:	array_offset = 0;		break;
		case OSTYPE_WIN3:		array_offset = 1;		break;
		case OSTYPE_WIN95:		array_offset = 2;		break;
		case OSTYPE_WIN98:		array_offset = 3;		break;
		case OSTYPE_WINME:		array_offset = 4;		break;
		case OSTYPE_WINNT:		array_offset = 5;		break;
		case OSTYPE_WIN2000:	array_offset = 6;		break;
		case OSTYPE_WINXP:		array_offset = 7;		break;
		case OSTYPE_OS2:		array_offset = 8;		break;
		case OSTYPE_WARP:		array_offset = 9;		break;
		case OSTYPE_DOSEMU:	array_offset = 10;		break;
		case OSTYPE_OPENDOS:	array_offset = 11;		break;
		case OSTYPE_LINUX:		array_offset = 12;		break;
		case OSTYPE_FREEBSD:	array_offset = 13;		break;
		case OSTYPE_UNIX:		array_offset = 14;		break;
		case OSTYPE_BEOS:		array_offset = 15;		break;
		case OSTYPE_QNX:		array_offset = 16;		break;
		case OSTYPE_MACOS:		array_offset = 17;		break;
	};
	char buf[255];
	usprintf(buf, "%s, v%d.%d", OS[array_offset], os_version, os_revision);
	tOS.Setup(          92, 500, 152,  18, 0,D_DISABLED, buf, 0);
	tCPU.Setup(         92, 518, 152,  18, 0, D_DISABLED, cpu_vendor, 0);

	// subdialogs
	gameDlg.Settings(s, pList);
	graphicsDlg.Settings(s);
	soundDlg.Settings(s);
	playersDlg.SetList(pList);

	gameDlg.Place(12,12);
	graphicsDlg.Place(403,12);
	soundDlg.Place(403,186);
	playersDlg.Place(291,303);

	mPlayer.SetVolume(s->music_volume);
	mPlayer.AddFile("music/Menu001.it");

	// add GUI objects to the dialog
	Add(desktop);
	Add(panel);
	Add(gameDlg);
	Add(graphicsDlg);
	Add(soundDlg);
	Add(playersDlg);
	Add(bExit);
	Add(tGameTitle);	Add(tGameVersion);
	Add(tBuildDate);	Add(lBuildDate);
	Add(tProgramming);	Add(lProgramming);
	Add(tGraphics);		Add(lGraphics);
	Add(tSound);		Add(lSound);
	Add(tSystem);
	Add(tAllegro);		Add(lAllegro);
	Add(tOS);			Add(lOS);
	Add(tCPU);			Add(lCPU);
	Add(mPlayer);

	// make sure pressing ESC won't exit the game
	_escape_exits = false;
}


// destructor
BMainDlg::~BMainDlg() {
}


void BMainDlg::InitSkin(MASkin *s) {
	playersDlg.InitSkin(s);
	soundDlg.InitSkin(s);
	tGameTitle.SetFontColor(makecol(120,120,255), -1, MASkin::NORMAL);
	tGameVersion.SetFontColor(makecol(120,120,180), -1, MASkin::NORMAL);
}

// event handler
void BMainDlg::HandleEvent(MASDialogObject& obj, int msg, int arg) {
	MASDialog::HandleEvent(obj, msg, arg);

	// only handle MSG_ACTIVATE (when a button is pressed)
	if (msg == MSG_ACTIVATE) {
		// see which button was pressed
		if (obj == gameDlg.bPractise)	ret = PRACTISE;		else
		if (obj == gameDlg.bHost)		ret = HOST;			else
		if (obj == gameDlg.bJoin)		ret = JOIN;			else
		if (obj == bExit) {
			ret = EXIT;
			MASAlert msg;
			if (msg.Popup("Really exit?", this, "Exit"))
				Close();
		} else
		if (obj == graphicsDlg.bProfile) ret = PROFILE;		else
		if (obj == graphicsDlg.bApply) {
			ret = APPLY;
			graphicsDlg.SaveSettings();
		} else
		if (obj == playersDlg.bAdd) {
			playersDlg.AddPlayer(this);
			gameDlg.Settings(gameDlg.settings, pList);
		} else
		if (obj == playersDlg.bRemove) {
			playersDlg.RemovePlayer(this);
			gameDlg.Settings(gameDlg.settings, pList);
		} else
		if (obj == playersDlg.bEdit || obj == playersDlg.lPlayers) {
			playersDlg.EditPlayer(this);
			gameDlg.Settings(gameDlg.settings, pList);
		} else;
	} else
	if (msg == MSG_SCROLL) {
		if (obj == soundDlg.sSoundVolume) {
			soundDlg.tSoundVolume.SetNumber(soundDlg.sSoundVolume.Position());
			soundDlg.tSoundVolume.RedrawNow();
		} else
		if (obj == soundDlg.sMusicVolume) {
			soundDlg.tMusicVolume.SetNumber(soundDlg.sMusicVolume.Position());
			soundDlg.tMusicVolume.RedrawNow();
			mPlayer.SetVolume(soundDlg.sMusicVolume.Position());
		}
	}
}


// the main loop
int BMainDlg::Execute() {
	playersDlg.SetList(pList);
	MASDialog::Execute(&gameDlg.bPractise);
	return ret;
}
